/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java.mappings;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.core.internal.IPersistentType;
import org.eclipse.jpt.core.internal.ITypeMapping;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaAttributeMapping;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaCascade;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsFactory;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsPackage;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.Attribute;
import org.eclipse.jpt.core.internal.jdtutility.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.EnumArrayDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.ExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.JDTTools;
import org.eclipse.jpt.core.internal.jdtutility.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.StringExpressionConverter;
import org.eclipse.jpt.core.internal.mappings.ICascade;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.IRelationshipMapping;
import org.eclipse.jpt.core.internal.mappings.RelationshipMappingTools;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaRelationshipMapping
extends JavaAttributeMapping
implements IRelationshipMapping {
    private AnnotationElementAdapter<String> targetEntityAdapter;
    private AnnotationElementAdapter<String> fetchAdapter;
    protected static final String TARGET_ENTITY_EDEFAULT = null;
    protected static final String SPECIFIED_TARGET_ENTITY_EDEFAULT = null;
    protected String specifiedTargetEntity = SPECIFIED_TARGET_ENTITY_EDEFAULT;
    protected static final String DEFAULT_TARGET_ENTITY_EDEFAULT = null;
    protected String defaultTargetEntity = DEFAULT_TARGET_ENTITY_EDEFAULT;
    protected IEntity resolvedTargetEntity;
    protected ICascade cascade;
    private static final String[] CONTAINER_TYPE_NAMES = new String[]{Collection.class.getName(), Set.class.getName(), List.class.getName(), Map.class.getName()};

    protected JavaRelationshipMapping() {
        throw new UnsupportedOperationException("Use JavaRelationshipMapping(Attribute) instead");
    }

    protected JavaRelationshipMapping(Attribute attribute) {
        super(attribute);
        this.targetEntityAdapter = this.buildAnnotationElementAdapter(this.targetEntityAdapter());
        this.fetchAdapter = this.buildAnnotationElementAdapter(this.fetchAdapter());
    }

    protected AnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter<String>(this.getAttribute(), daea);
    }

    protected abstract DeclarationAnnotationElementAdapter<String> targetEntityAdapter();

    protected abstract DeclarationAnnotationElementAdapter<String[]> cascadeAdapter();

    protected abstract DeclarationAnnotationElementAdapter<String> fetchAdapter();

    @Override
    protected void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        switch (notification.getFeatureID(IRelationshipMapping.class)) {
            case 1: {
                this.targetEntityAdapter.setValue((String)notification.getNewValue());
                break;
            }
            case 4: {
                if (notification.getNewValue() != null || notification.getOldValue() == null) break;
                ((JavaCascade)notification.getOldValue()).getCascadeAdapter().setValue(null);
                break;
            }
        }
    }

    @Override
    protected EClass eStaticClass() {
        return JpaJavaMappingsPackage.Literals.JAVA_RELATIONSHIP_MAPPING;
    }

    @Override
    public String getTargetEntity() {
        return this.getSpecifiedTargetEntity() == null ? this.getDefaultTargetEntity() : this.getSpecifiedTargetEntity();
    }

    @Override
    public String getSpecifiedTargetEntity() {
        return this.specifiedTargetEntity;
    }

    @Override
    public void setSpecifiedTargetEntity(String newSpecifiedTargetEntity) {
        String oldSpecifiedTargetEntity = this.specifiedTargetEntity;
        this.specifiedTargetEntity = newSpecifiedTargetEntity;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldSpecifiedTargetEntity, (Object)this.specifiedTargetEntity));
        }
    }

    @Override
    public String getDefaultTargetEntity() {
        return this.defaultTargetEntity;
    }

    protected void setDefaultTargetEntity(String newDefaultTargetEntity) {
        String oldDefaultTargetEntity = this.defaultTargetEntity;
        this.defaultTargetEntity = newDefaultTargetEntity;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldDefaultTargetEntity, (Object)this.defaultTargetEntity));
        }
    }

    @Override
    public IEntity getResolvedTargetEntity() {
        if (this.resolvedTargetEntity != null && this.resolvedTargetEntity.eIsProxy()) {
            InternalEObject oldResolvedTargetEntity = (InternalEObject)this.resolvedTargetEntity;
            this.resolvedTargetEntity = (IEntity)this.eResolveProxy(oldResolvedTargetEntity);
            if (this.resolvedTargetEntity != oldResolvedTargetEntity && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)oldResolvedTargetEntity, (Object)this.resolvedTargetEntity));
            }
        }
        return this.resolvedTargetEntity;
    }

    public IEntity basicGetResolvedTargetEntity() {
        return this.resolvedTargetEntity;
    }

    @Override
    public void setResolvedTargetEntity(IEntity newResolvedTargetEntity) {
        IEntity oldResolvedTargetEntity = this.resolvedTargetEntity;
        this.resolvedTargetEntity = newResolvedTargetEntity;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldResolvedTargetEntity, (Object)this.resolvedTargetEntity));
        }
    }

    @Override
    public ICascade getCascade() {
        return this.cascade;
    }

    public NotificationChain basicSetCascade(ICascade newCascade, NotificationChain msgs) {
        ICascade oldCascade = this.cascade;
        this.cascade = newCascade;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldCascade, (Object)newCascade);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setCascade(ICascade newCascade) {
        if (newCascade != this.cascade) {
            NotificationChain msgs = null;
            if (this.cascade != null) {
                msgs = ((InternalEObject)this.cascade).eInverseRemove((InternalEObject)this, -5, null, msgs);
            }
            if (newCascade != null) {
                msgs = ((InternalEObject)newCascade).eInverseAdd((InternalEObject)this, -5, null, msgs);
            }
            if ((msgs = this.basicSetCascade(newCascade, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)newCascade, (Object)newCascade));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return this.basicSetCascade(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getTargetEntity();
            }
            case 1: {
                return this.getSpecifiedTargetEntity();
            }
            case 2: {
                return this.getDefaultTargetEntity();
            }
            case 3: {
                if (resolve) {
                    return this.getResolvedTargetEntity();
                }
                return this.basicGetResolvedTargetEntity();
            }
            case 4: {
                return this.getCascade();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setSpecifiedTargetEntity((String)newValue);
                return;
            }
            case 3: {
                this.setResolvedTargetEntity((IEntity)newValue);
                return;
            }
            case 4: {
                this.setCascade((ICascade)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setSpecifiedTargetEntity(SPECIFIED_TARGET_ENTITY_EDEFAULT);
                return;
            }
            case 3: {
                this.setResolvedTargetEntity(null);
                return;
            }
            case 4: {
                this.setCascade(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return TARGET_ENTITY_EDEFAULT == null ? this.getTargetEntity() != null : !TARGET_ENTITY_EDEFAULT.equals(this.getTargetEntity());
            }
            case 1: {
                return SPECIFIED_TARGET_ENTITY_EDEFAULT == null ? this.specifiedTargetEntity != null : !SPECIFIED_TARGET_ENTITY_EDEFAULT.equals(this.specifiedTargetEntity);
            }
            case 2: {
                return DEFAULT_TARGET_ENTITY_EDEFAULT == null ? this.defaultTargetEntity != null : !DEFAULT_TARGET_ENTITY_EDEFAULT.equals(this.defaultTargetEntity);
            }
            case 3: {
                return this.resolvedTargetEntity != null;
            }
            case 4: {
                return this.cascade != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IRelationshipMapping.class) {
            switch (derivedFeatureID) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IRelationshipMapping.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (specifiedTargetEntity: ");
        result.append(this.specifiedTargetEntity);
        result.append(", defaultTargetEntity: ");
        result.append(this.defaultTargetEntity);
        result.append(')');
        return result.toString();
    }

    @Override
    public String fullyQualifiedTargetEntity() {
        return this.getTargetEntity() == null ? null : JDTTools.resolve(this.getTargetEntity(), this.jdtType());
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        super.updateFromJava(astRoot);
        this.setDefaultTargetEntity(this.javaDefaultTargetEntity());
        this.setSpecifiedTargetEntity(this.targetEntityAdapter.getValue(astRoot));
        this.updateFetchFromJava(astRoot);
        if (this.cascade != null) {
            ((JavaCascade)this.cascade).updateFromJava(astRoot);
        } else if (this.cascadeAdapter().expression(this.getAttribute().modifiedDeclaration()) != null) {
            this.setCascade(this.createCascade());
            ((JavaCascade)this.cascade).updateFromJava(astRoot);
        }
    }

    protected abstract void updateFetchFromJava(CompilationUnit var1);

    protected String javaDefaultTargetEntity() {
        return this.javaDefaultTargetEntity(this.getAttribute().typeSignature());
    }

    protected String javaDefaultTargetEntity(String signature) {
        return JavaRelationshipMapping.buildReferenceEntityTypeName(signature, this.jdtType());
    }

    public static String buildReferenceEntityTypeName(String signature, IType jdtType) {
        if (Signature.getArrayCount((String)signature) > 0) {
            return null;
        }
        return JDTTools.resolve(Signature.toString((String)signature), jdtType);
    }

    @Override
    public IEntity getEntity() {
        ITypeMapping typeMapping = this.typeMapping();
        if (typeMapping instanceof IEntity) {
            return (IEntity)typeMapping;
        }
        return null;
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext) {
        IPersistentType persistentType;
        super.refreshDefaults(defaultsContext);
        String targetEntityName = this.fullyQualifiedTargetEntity();
        if (targetEntityName != null && (persistentType = defaultsContext.persistentType(targetEntityName)) != null && persistentType.getMapping() instanceof IEntity) {
            this.setResolvedTargetEntity((IEntity)persistentType.getMapping());
            return;
        }
        this.setResolvedTargetEntity(null);
    }

    public Iterator<String> allTargetEntityAttributeNames() {
        IEntity targetEntity = this.getResolvedTargetEntity();
        return targetEntity == null ? EmptyIterator.instance() : targetEntity.getPersistentType().allAttributeNames();
    }

    public Iterator<String> candidateMappedByAttributeNames() {
        return this.allTargetEntityAttributeNames();
    }

    protected Iterator<String> candidateMappedByAttributeNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateMappedByAttributeNames(), filter);
    }

    protected Iterator<String> quotedCandidateMappedByAttributeNames(Filter<String> filter) {
        return StringTools.quote(this.candidateMappedByAttributeNames(filter));
    }

    @Override
    public ICascade createCascade() {
        return JpaJavaMappingsFactory.eINSTANCE.createJavaCascade(this.getAttribute(), this.cascadeAdapter());
    }

    protected AnnotationElementAdapter<String> getFetchAdapter() {
        return this.fetchAdapter;
    }

    protected static DeclarationAnnotationElementAdapter<String> buildTargetEntityAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return JavaRelationshipMapping.buildAnnotationElementAdapter(annotationAdapter, elementName, SimpleTypeStringExpressionConverter.instance());
    }

    protected static DeclarationAnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return JavaRelationshipMapping.buildAnnotationElementAdapter(annotationAdapter, elementName, StringExpressionConverter.instance());
    }

    protected static <T extends Expression> DeclarationAnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String, T> converter) {
        return new ConversionDeclarationAnnotationElementAdapter<String, T>(annotationAdapter, elementName, false, converter);
    }

    protected static DeclarationAnnotationElementAdapter<String> buildEnumAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new EnumDeclarationAnnotationElementAdapter(annotationAdapter, elementName, false);
    }

    protected static DeclarationAnnotationElementAdapter<String[]> buildEnumArrayAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new EnumArrayDeclarationAnnotationElementAdapter(annotationAdapter, elementName, false);
    }

    @Override
    public boolean targetEntityIsValid(String targetEntity) {
        return RelationshipMappingTools.targetEntityIsValid(targetEntity);
    }

    protected static boolean typeNamedIsContainer(String typeName) {
        return CollectionTools.contains((Object[])CONTAINER_TYPE_NAMES, (Object)typeName);
    }
}

