/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.persistence;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.core.internal.JptCorePlugin;
import org.eclipse.jpt.core.internal.XmlEObject;
import org.eclipse.jpt.core.internal.content.persistence.PersistencePackage;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.wst.common.internal.emf.utilities.DOMUtilities;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class MappingFileRef
extends XmlEObject {
    protected static final String FILE_NAME_EDEFAULT = null;
    protected String fileName = FILE_NAME_EDEFAULT;

    protected MappingFileRef() {
    }

    protected EClass eStaticClass() {
        return PersistencePackage.Literals.MAPPING_FILE_REF;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String newFileName) {
        String oldFileName = this.fileName;
        this.fileName = newFileName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldFileName, (Object)this.fileName));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getFileName();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setFileName((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setFileName(FILE_NAME_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return FILE_NAME_EDEFAULT == null ? this.fileName != null : !FILE_NAME_EDEFAULT.equals(this.fileName);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (fileName: ");
        result.append(this.fileName);
        result.append(')');
        return result.toString();
    }

    public ITextRange validationTextRange() {
        IDOMNode textNode = (IDOMNode)DOMUtilities.getChildTextNode((Node)this.node);
        return textNode == null ? this.buildTextRange(this.node) : this.buildTextRange(textNode);
    }

    public IJpaFile getMappingFile() {
        IJpaFile mappingFile = null;
        Iterator stream = this.javaSourceFolders();
        while (stream.hasNext()) {
            IFolder sourceFolder = (IFolder)((IPackageFragmentRoot)stream.next()).getResource();
            IFile file = sourceFolder.getFile(this.fileName);
            IJpaFile jpaFile = JptCorePlugin.getJpaFile(file);
            if (mappingFile != null && jpaFile != null) {
                return null;
            }
            mappingFile = jpaFile;
        }
        return mappingFile;
    }

    private Iterator javaSourceFolders() {
        Iterator nestedIterator = EmptyIterator.instance();
        try {
            nestedIterator = CollectionTools.iterator((Object[])this.getJpaProject().getJavaProject().getPackageFragmentRoots());
        }
        catch (JavaModelException javaModelException) {}
        return new FilteringIterator(nestedIterator){

            protected boolean accept(Object o) {
                try {
                    return ((IPackageFragmentRoot)o).getKind() == 1;
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
            }
        };
    }
}

