/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.mappings;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jpt.core.internal.IAttributeMapping;
import org.eclipse.jpt.core.internal.IPersistentAttribute;
import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.core.internal.ITypeMapping;
import org.eclipse.jpt.core.internal.mappings.IAttributeOverride;
import org.eclipse.jpt.core.internal.mappings.IColumnMapping;
import org.eclipse.jpt.core.internal.mappings.IEmbeddable;
import org.eclipse.jpt.core.internal.mappings.IOverride;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IEmbedded
extends IAttributeMapping {
    public EList<IAttributeOverride> getAttributeOverrides();

    public EList<IAttributeOverride> getSpecifiedAttributeOverrides();

    public EList<IAttributeOverride> getDefaultAttributeOverrides();

    public IEmbeddable embeddable();

    public IAttributeOverride createAttributeOverride(int var1);

    public Iterator<String> allOverridableAttributeNames();

    public boolean containsAttributeOverride(String var1);

    public boolean containsSpecifiedAttributeOverride(String var1);

    public static class AttributeOverrideOwner
    implements IOverride.Owner {
        private IEmbedded embedded;

        public AttributeOverrideOwner(IEmbedded embedded) {
            this.embedded = embedded;
        }

        public ITypeMapping getTypeMapping() {
            return this.embedded.typeMapping();
        }

        public IAttributeMapping attributeMapping(String attributeName) {
            return (IAttributeMapping)((Object)this.columnMapping(attributeName));
        }

        private IColumnMapping columnMapping(String name) {
            IEmbeddable embeddable = this.embedded.embeddable();
            if (embeddable != null) {
                Iterator<IPersistentAttribute> stream = embeddable.getPersistentType().allAttributes();
                while (stream.hasNext()) {
                    IPersistentAttribute persAttribute = stream.next();
                    if (!persAttribute.getName().equals(name) || !(persAttribute.getMapping() instanceof IColumnMapping)) continue;
                    return (IColumnMapping)((Object)persAttribute.getMapping());
                }
            }
            return null;
        }

        public boolean isVirtual(IOverride override) {
            return this.embedded.getDefaultAttributeOverrides().contains((Object)override);
        }

        public ITextRange validationTextRange() {
            return this.embedded.validationTextRange();
        }
    }
}

