/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.mappings;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jpt.core.internal.IAttributeMapping;
import org.eclipse.jpt.core.internal.IPersistentAttribute;
import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.core.internal.ITypeMapping;
import org.eclipse.jpt.core.internal.mappings.IAbstractJoinColumn;
import org.eclipse.jpt.core.internal.mappings.IAssociationOverride;
import org.eclipse.jpt.core.internal.mappings.IAttributeOverride;
import org.eclipse.jpt.core.internal.mappings.IColumnMapping;
import org.eclipse.jpt.core.internal.mappings.IDiscriminatorColumn;
import org.eclipse.jpt.core.internal.mappings.INamedNativeQuery;
import org.eclipse.jpt.core.internal.mappings.INamedQuery;
import org.eclipse.jpt.core.internal.mappings.IOverride;
import org.eclipse.jpt.core.internal.mappings.IPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.internal.mappings.ISecondaryTable;
import org.eclipse.jpt.core.internal.mappings.ISequenceGenerator;
import org.eclipse.jpt.core.internal.mappings.ITable;
import org.eclipse.jpt.core.internal.mappings.ITableGenerator;
import org.eclipse.jpt.core.internal.mappings.InheritanceType;
import org.eclipse.jpt.db.internal.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IEntity
extends ITypeMapping {
    public String getSpecifiedName();

    public void setSpecifiedName(String var1);

    public String getDefaultName();

    public ITable getTable();

    public EList<ISecondaryTable> getSpecifiedSecondaryTables();

    public EList<ISecondaryTable> getSecondaryTables();

    public InheritanceType getInheritanceStrategy();

    public void setInheritanceStrategy(InheritanceType var1);

    public IDiscriminatorColumn getDiscriminatorColumn();

    public ISequenceGenerator getSequenceGenerator();

    public void setSequenceGenerator(ISequenceGenerator var1);

    public ITableGenerator getTableGenerator();

    public void setTableGenerator(ITableGenerator var1);

    public String getDefaultDiscriminatorValue();

    public void setDefaultDiscriminatorValue(String var1);

    public String getSpecifiedDiscriminatorValue();

    public void setSpecifiedDiscriminatorValue(String var1);

    public String getDiscriminatorValue();

    public EList<IPrimaryKeyJoinColumn> getPrimaryKeyJoinColumns();

    public EList<IPrimaryKeyJoinColumn> getSpecifiedPrimaryKeyJoinColumns();

    public EList<IPrimaryKeyJoinColumn> getDefaultPrimaryKeyJoinColumns();

    public EList<IAttributeOverride> getAttributeOverrides();

    public EList<IAttributeOverride> getSpecifiedAttributeOverrides();

    public EList<IAttributeOverride> getDefaultAttributeOverrides();

    public EList<IAssociationOverride> getAssociationOverrides();

    public EList<IAssociationOverride> getSpecifiedAssociationOverrides();

    public EList<IAssociationOverride> getDefaultAssociationOverrides();

    public EList<INamedQuery> getNamedQueries();

    public EList<INamedNativeQuery> getNamedNativeQueries();

    public String getIdClass();

    public void setIdClass(String var1);

    public boolean discriminatorValueIsAllowed();

    public IEntity rootEntity();

    public IEntity parentEntity();

    public String primaryKeyColumnName();

    public String primaryKeyAttributeName();

    public IAttributeOverride createAttributeOverride(int var1);

    public IAssociationOverride createAssociationOverride(int var1);

    public boolean containsAttributeOverride(String var1);

    public boolean containsSpecifiedAttributeOverride(String var1);

    public boolean containsAssociationOverride(String var1);

    public boolean containsSpecifiedAssociationOverride(String var1);

    public boolean containsSecondaryTable(String var1);

    public boolean containsSpecifiedSecondaryTable(String var1);

    public ISecondaryTable createSecondaryTable(int var1);

    public boolean containsSpecifiedPrimaryKeyJoinColumns();

    public IPrimaryKeyJoinColumn createPrimaryKeyJoinColumn(int var1);

    public INamedQuery createNamedQuery(int var1);

    public INamedNativeQuery createNamedNativeQuery(int var1);

    public static class AssociationOverrideOwner
    extends OverrideOwner {
        public AssociationOverrideOwner(IEntity entity) {
            super(entity);
        }

        public IAttributeMapping attributeMapping(String attributeName) {
            Iterator<IPersistentAttribute> stream = this.entity.getPersistentType().allAttributes();
            while (stream.hasNext()) {
                IPersistentAttribute persAttribute = stream.next();
                if (!attributeName.equals(persAttribute.getName())) continue;
                return persAttribute.getMapping();
            }
            return null;
        }

        public boolean isVirtual(IOverride override) {
            return this.entity.getDefaultAssociationOverrides().contains((Object)override);
        }
    }

    public static class AttributeOverrideOwner
    extends OverrideOwner {
        public AttributeOverrideOwner(IEntity entity) {
            super(entity);
        }

        public IAttributeMapping attributeMapping(String attributeName) {
            return (IAttributeMapping)((Object)this.columnMapping(attributeName));
        }

        private IColumnMapping columnMapping(String attributeName) {
            if (attributeName == null) {
                return null;
            }
            Iterator<IPersistentAttribute> stream = this.entity.getPersistentType().allAttributes();
            while (stream.hasNext()) {
                IPersistentAttribute persAttribute = stream.next();
                if (!attributeName.equals(persAttribute.getName()) || !(persAttribute.getMapping() instanceof IColumnMapping)) continue;
                return (IColumnMapping)((Object)persAttribute.getMapping());
            }
            return null;
        }

        public boolean isVirtual(IOverride override) {
            return this.entity.getDefaultAttributeOverrides().contains((Object)override);
        }
    }

    public static abstract class OverrideOwner
    implements IOverride.Owner {
        protected IEntity entity;

        public OverrideOwner(IEntity entity) {
            this.entity = entity;
        }

        public ITypeMapping getTypeMapping() {
            return this.entity;
        }

        public ITextRange validationTextRange() {
            return this.entity.validationTextRange();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PrimaryKeyJoinColumnOwner
    implements IAbstractJoinColumn.Owner {
        private IEntity entity;

        public PrimaryKeyJoinColumnOwner(IEntity entity) {
            this.entity = entity;
        }

        @Override
        public ITextRange validationTextRange() {
            return this.entity.validationTextRange();
        }

        @Override
        public ITypeMapping getTypeMapping() {
            return this.entity;
        }

        @Override
        public Table dbTable(String tableName) {
            return this.entity.dbTable(tableName);
        }

        @Override
        public Table dbReferencedColumnTable() {
            IEntity parentEntity = this.entity.parentEntity();
            return parentEntity == null ? null : parentEntity.primaryDbTable();
        }

        public List<IPrimaryKeyJoinColumn> joinColumns() {
            return this.entity.getPrimaryKeyJoinColumns();
        }
    }
}

