/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.core.internal.IPersistentType;
import org.eclipse.jpt.core.internal.content.java.IJavaTypeMapping;
import org.eclipse.jpt.core.internal.content.orm.XmlEmbeddable;
import org.eclipse.jpt.core.internal.content.orm.XmlEntity;
import org.eclipse.jpt.core.internal.content.orm.XmlMappedSuperclass;
import org.eclipse.jpt.core.internal.content.orm.XmlRootContentNode;
import org.eclipse.jpt.core.internal.content.orm.XmlTypeMapping;
import org.eclipse.jpt.core.internal.mappings.IGenerator;
import org.eclipse.jpt.core.internal.platform.BaseContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.GeneratorRepository;
import org.eclipse.jpt.core.internal.platform.PersistenceUnitContext;
import org.eclipse.jpt.core.internal.platform.XmlEmbeddableContext;
import org.eclipse.jpt.core.internal.platform.XmlEntityContext;
import org.eclipse.jpt.core.internal.platform.XmlMappedSuperclassContext;
import org.eclipse.jpt.core.internal.platform.XmlTypeContext;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingFileContext
extends BaseContext {
    private XmlRootContentNode ormRoot;
    private List<XmlTypeContext> xmlTypeContexts;

    public MappingFileContext(PersistenceUnitContext parentContext, XmlRootContentNode xmlRootContentNode) {
        super(parentContext);
        this.ormRoot = xmlRootContentNode;
        this.xmlTypeContexts = this.buildXmlTypeContexts();
    }

    protected List<XmlTypeContext> buildXmlTypeContexts() {
        ArrayList<XmlTypeContext> contexts = new ArrayList<XmlTypeContext>();
        for (XmlTypeMapping typeMapping : this.ormRoot.getEntityMappings().getTypeMappings()) {
            XmlTypeContext xmlTypeContext = this.buildContext(typeMapping);
            contexts.add(xmlTypeContext);
        }
        return contexts;
    }

    protected void populateGeneratorRepository(GeneratorRepository generatorRepository) {
        for (IGenerator generator : this.ormRoot.getEntityMappings().getSequenceGenerators()) {
            generatorRepository.addGenerator(generator);
        }
        for (IGenerator generator : this.ormRoot.getEntityMappings().getTableGenerators()) {
            generatorRepository.addGenerator(generator);
        }
        for (XmlTypeContext context : this.xmlTypeContexts) {
            context.populateGeneratorRepository(generatorRepository);
        }
    }

    @Override
    protected void initialize() {
    }

    protected XmlTypeContext buildContext(XmlTypeMapping typeMapping) {
        String key = typeMapping.getKey();
        if (key == "entity") {
            return new XmlEntityContext(this, (XmlEntity)((Object)typeMapping));
        }
        if (key == "embeddable") {
            return new XmlEmbeddableContext(this, (XmlEmbeddable)typeMapping);
        }
        if (key == "mappedSuperclass") {
            return new XmlMappedSuperclassContext(this, (XmlMappedSuperclass)typeMapping);
        }
        throw new IllegalArgumentException(typeMapping.toString());
    }

    protected XmlTypeContext xmlTypeMappingContextFor(IJavaTypeMapping javaTypeMapping) {
        for (XmlTypeContext context : this.xmlTypeContexts) {
            if (javaTypeMapping != context.getJavaTypeMapping()) continue;
            return context;
        }
        return null;
    }

    @Override
    public void refreshDefaults(DefaultsContext parentDefaults) {
        super.refreshDefaults(parentDefaults);
        this.ormRoot.getEntityMappings().refreshDefaults(parentDefaults);
        DefaultsContext wrappedDefaultsContext = this.wrapDefaultsContext(parentDefaults);
        for (XmlTypeContext context : this.xmlTypeContexts) {
            if (context.isRefreshed()) continue;
            context.refreshDefaults(wrappedDefaultsContext);
        }
    }

    private DefaultsContext wrapDefaultsContext(final DefaultsContext defaultsContext) {
        return new DefaultsContext(){

            public Object getDefault(String key) {
                String catalog;
                String schema;
                if ((key.equals("table.schema") || key.equals("tableGenerator.schema")) && (schema = MappingFileContext.this.ormRoot.getEntityMappings().getSchema()) != null) {
                    return schema;
                }
                if (key.equals("table.catalog") && (catalog = MappingFileContext.this.ormRoot.getEntityMappings().getCatalog()) != null) {
                    return catalog;
                }
                return defaultsContext.getDefault(key);
            }

            public IPersistentType persistentType(String fullyQualifiedTypeName) {
                return defaultsContext.persistentType(fullyQualifiedTypeName);
            }
        };
    }

    public XmlRootContentNode getXmlRootContentNode() {
        return this.ormRoot;
    }

    public PersistenceUnitContext getPersistenceUnitContext() {
        return (PersistenceUnitContext)this.getParentContext();
    }

    public Iterator<XmlTypeContext> typeContexts() {
        return this.xmlTypeContexts.iterator();
    }

    public boolean contains(IPersistentType persistentType) {
        for (XmlTypeContext context : this.xmlTypeContexts) {
            if (persistentType == context.getPersistentType()) {
                return true;
            }
            if (persistentType != context.javaPersistentType()) continue;
            return true;
        }
        return false;
    }

    Iterator<IPersistentType> persistentTypes() {
        return new TransformationIterator<XmlTypeContext, IPersistentType>(this.xmlTypeContexts.iterator()){

            protected IPersistentType transform(XmlTypeContext next) {
                return next.getPersistentType();
            }
        };
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        for (XmlTypeContext typeMappingContext : this.xmlTypeContexts) {
            typeMappingContext.addToMessages(messages);
        }
    }
}

