/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis2.consumption.ui.preferences;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jst.ws.axis2.core.context.Axis2EmitterContext;
import org.eclipse.jst.ws.axis2.core.plugin.WebServiceAxis2CorePlugin;
import org.eclipse.jst.ws.axis2.core.plugin.messages.Axis2CoreUIMessages;
import org.eclipse.jst.ws.axis2.core.utils.Axis2CoreUtils;
import org.eclipse.jst.ws.axis2.core.utils.RuntimePropertyUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class Axis2RuntimePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button browseButton;
    private Text axis2Path;
    private Text statusLabel;
    private IStatus status = Status.OK_STATUS;
    private boolean webappExist = false;
    private boolean isWar = false;
    private String statusBanner = null;
    Axis2EmitterContext context;

    protected Control createContents(Composite superparent) {
        this.context = WebServiceAxis2CorePlugin.getDefault().getAxisEmitterContext();
        this.status = Status.OK_STATUS;
        final Composite mainComp = new Composite(superparent, 0);
        TabFolder axis2PreferenceTab = new TabFolder(mainComp, 0);
        TabItem runtimeInstalLocationItem = new TabItem(axis2PreferenceTab, 0);
        runtimeInstalLocationItem.setText(Axis2CoreUIMessages.AXIS2_RUNTIME);
        runtimeInstalLocationItem.setToolTipText(Axis2CoreUIMessages.AXIS2_RUNTIME_TOOLTIP);
        Group runtimeGroup = new Group((Composite)axis2PreferenceTab, 0);
        runtimeGroup.setText(Axis2CoreUIMessages.AXIS2_RUNTIME_LOCATION);
        runtimeInstalLocationItem.setControl((Control)runtimeGroup);
        runtimeGroup.setToolTipText(Axis2CoreUIMessages.AXIS2_RUNTIME_TOOLTIP);
        Label label = new Label((Composite)runtimeGroup, 0);
        label.setText(Axis2CoreUIMessages.AXIS2_LOCATION);
        label.setLocation(10, 30);
        label.setSize(100, 20);
        this.axis2Path = new Text((Composite)runtimeGroup, 2048);
        String serverPath = null;
        if (this.context.getAxis2RuntimeLocation() != null) {
            serverPath = this.context.getAxis2RuntimeLocation();
            this.axis2Path.setText(serverPath);
        }
        this.webappExist = this.runtimeExist(serverPath);
        if (this.isWar) {
            this.updateWarStatus(true);
        } else {
            this.updateWarStatus(false);
        }
        this.axis2Path.setLocation(110, 30);
        this.axis2Path.setSize(400, 20);
        this.axis2Path.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Axis2RuntimePreferencePage.this.context.setAxis2RuntimeLocation(Axis2RuntimePreferencePage.this.axis2Path.getText());
                Axis2RuntimePreferencePage.this.webappExist = Axis2RuntimePreferencePage.this.runtimeExist(Axis2RuntimePreferencePage.this.axis2Path.getText());
                Axis2RuntimePreferencePage.this.storeValues();
                Axis2RuntimePreferencePage.this.status = RuntimePropertyUtils.writeServerPathToPropertiesFile((String)Axis2RuntimePreferencePage.this.axis2Path.getText());
                if (Axis2RuntimePreferencePage.this.webappExist) {
                    Axis2RuntimePreferencePage.this.status = Status.OK_STATUS;
                    Axis2RuntimePreferencePage.this.statusUpdate(true);
                } else {
                    Axis2RuntimePreferencePage.this.status = Status.CANCEL_STATUS;
                    Axis2RuntimePreferencePage.this.statusUpdate(false);
                }
            }
        });
        this.browseButton = new Button((Composite)runtimeGroup, 0);
        this.browseButton.setText(Axis2CoreUIMessages.LABEL_BROUSE);
        this.browseButton.setLocation(520, 30);
        this.browseButton.setSize(70, 20);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Axis2RuntimePreferencePage.this.handleBrowse(mainComp.getShell());
            }
        });
        if (this.axis2Path.getText().equals("")) {
            this.status = new Status(4, "id", 0, Axis2CoreUIMessages.ERROR_INVALID_AXIS2_SERVER_LOCATION, null);
        }
        this.statusLabel = new Text((Composite)runtimeGroup, 0x1000008);
        this.statusLabel.setLocation(20, 100);
        this.statusLabel.setSize(560, 40);
        this.statusBanner = this.axis2Path.getText().equals("") ? Axis2CoreUIMessages.LABEL_AXIS2_RUNTIME_NOT_EXIT : (!this.axis2Path.getText().equals("") && !this.webappExist ? Axis2CoreUIMessages.LABEL_AXIS2_RUNTIME_LOAD_ERROR : Axis2CoreUIMessages.LABEL_AXIS2_RUNTIME_LOAD);
        this.statusLabel.setText(this.statusBanner);
        this.webappExist = this.runtimeExist(this.axis2Path.getText());
        TabItem codegenPreferencesItem = new TabItem(axis2PreferenceTab, 0);
        codegenPreferencesItem.setText(Axis2CoreUIMessages.AXIS2_PREFERENCES);
        codegenPreferencesItem.setToolTipText(Axis2CoreUIMessages.AXIS2_PREFERENCES_TOOLTIP);
        Group codegenGroup = new Group((Composite)axis2PreferenceTab, 0);
        codegenGroup.setText(Axis2CoreUIMessages.AXIS2_RUNTIME_PREFERENCES);
        codegenPreferencesItem.setControl((Control)codegenGroup);
        codegenGroup.setToolTipText(Axis2CoreUIMessages.AXIS2_PREFERENCES_TOOLTIP);
        Text serviceCodegenLabel = new Text((Composite)codegenGroup, 8);
        serviceCodegenLabel.setText(Axis2CoreUIMessages.LABEL_WEB_SERVICE_CODEGEN);
        serviceCodegenLabel.setLocation(10, 30);
        serviceCodegenLabel.setSize(220, 20);
        Label databindingLabel = new Label((Composite)codegenGroup, 0);
        databindingLabel.setText(Axis2CoreUIMessages.LABEL_DATABINDING);
        databindingLabel.setLocation(10, 60);
        databindingLabel.setSize(200, 20);
        final Text databindingText = new Text((Composite)codegenGroup, 2048);
        databindingText.setText(this.context.getServiceDatabinding());
        databindingText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Axis2RuntimePreferencePage.this.context.setServiceDatabinding(databindingText.getText());
            }
        });
        databindingText.setLocation(220, 60);
        databindingText.setSize(100, 20);
        final Button generateServerSideInterfaceCheckBoxButton = new Button((Composite)codegenGroup, 32);
        generateServerSideInterfaceCheckBoxButton.setText(Axis2CoreUIMessages.LABEL_GENERATE_SERVERSIDE_INTERFACE);
        generateServerSideInterfaceCheckBoxButton.setSelection(this.context.isServiceInterfaceSkeleton());
        generateServerSideInterfaceCheckBoxButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2RuntimePreferencePage.this.context.setServiceInterfaceSkeleton(generateServerSideInterfaceCheckBoxButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        generateServerSideInterfaceCheckBoxButton.setLocation(10, 90);
        generateServerSideInterfaceCheckBoxButton.setSize(300, 15);
        final Button generateAllCheckBoxButton = new Button((Composite)codegenGroup, 32);
        generateAllCheckBoxButton.setSelection(this.context.isServiceGenerateAll());
        generateAllCheckBoxButton.setText(Axis2CoreUIMessages.LABEL_GENERATE_ALL);
        generateAllCheckBoxButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2RuntimePreferencePage.this.context.setServiceGenerateAll(generateAllCheckBoxButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        generateAllCheckBoxButton.setLocation(10, 120);
        generateAllCheckBoxButton.setSize(350, 15);
        Label seperatorLabel0 = new Label((Composite)codegenGroup, 2050);
        seperatorLabel0.setLocation(10, 155);
        seperatorLabel0.setSize(570, 1);
        Text clientCodegenLabel = new Text((Composite)codegenGroup, 8);
        clientCodegenLabel.setText(Axis2CoreUIMessages.LABEL_WEB_SERVICE_CLIENT_CODEGEN);
        clientCodegenLabel.setLocation(10, 170);
        clientCodegenLabel.setSize(220, 20);
        Label clientLabel = new Label((Composite)codegenGroup, 256);
        clientLabel.setText(Axis2CoreUIMessages.LABEL_CLIENT_SIDE);
        clientLabel.setLocation(10, 210);
        clientLabel.setSize(70, 20);
        final Button syncAndAsyncRadioButton = new Button((Composite)codegenGroup, 16);
        syncAndAsyncRadioButton.setText(Axis2CoreUIMessages.LABEL_SYNC_AND_ASYNC);
        syncAndAsyncRadioButton.setVisible(true);
        syncAndAsyncRadioButton.setSelection(!this.context.isSync() && !this.context.isAsync() ? true : this.context.isSync() && this.context.isAsync());
        syncAndAsyncRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2RuntimePreferencePage.this.context.setAsync(syncAndAsyncRadioButton.getSelection());
                Axis2RuntimePreferencePage.this.context.setSync(syncAndAsyncRadioButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        syncAndAsyncRadioButton.setLocation(80, 210);
        syncAndAsyncRadioButton.setSize(190, 20);
        final Button syncOnlyRadioButton = new Button((Composite)codegenGroup, 16);
        syncOnlyRadioButton.setText(Axis2CoreUIMessages.LABEL_SYNC);
        syncOnlyRadioButton.setSelection(this.context.isSync() && !this.context.isAsync());
        syncOnlyRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2RuntimePreferencePage.this.context.setAsync(!syncOnlyRadioButton.getSelection());
                Axis2RuntimePreferencePage.this.context.setSync(syncOnlyRadioButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        syncOnlyRadioButton.setLocation(280, 210);
        syncOnlyRadioButton.setSize(170, 20);
        final Button asyncOnlyRadioButton = new Button((Composite)codegenGroup, 16);
        asyncOnlyRadioButton.setText(Axis2CoreUIMessages.LABEL_ASYNC);
        asyncOnlyRadioButton.setSelection(this.context.isAsync() && !this.context.isSync());
        asyncOnlyRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2RuntimePreferencePage.this.context.setAsync(asyncOnlyRadioButton.getSelection());
                Axis2RuntimePreferencePage.this.context.setSync(!asyncOnlyRadioButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        asyncOnlyRadioButton.setLocation(460, 210);
        asyncOnlyRadioButton.setSize(170, 20);
        Label clientDatabindingLabel = new Label((Composite)codegenGroup, 0);
        clientDatabindingLabel.setText(Axis2CoreUIMessages.LABEL_DATABINDING);
        clientDatabindingLabel.setLocation(10, 240);
        clientDatabindingLabel.setSize(200, 20);
        final Text databindingText1 = new Text((Composite)codegenGroup, 2048);
        databindingText1.setText(this.context.getClientDatabinding());
        databindingText1.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Axis2RuntimePreferencePage.this.context.setClientDatabinding(databindingText1.getText());
            }
        });
        databindingText1.setLocation(220, 240);
        databindingText1.setSize(100, 20);
        final Button clientTestCaseCheckBoxButton = new Button((Composite)codegenGroup, 32);
        clientTestCaseCheckBoxButton.setText(Axis2CoreUIMessages.LABEL_GENERATE_TESTCASE_CAPTION);
        clientTestCaseCheckBoxButton.setSelection(this.context.isClientTestCase());
        clientTestCaseCheckBoxButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2RuntimePreferencePage.this.context.setClientTestCase(clientTestCaseCheckBoxButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        clientTestCaseCheckBoxButton.setLocation(10, 270);
        clientTestCaseCheckBoxButton.setSize(300, 15);
        final Button clientGenerateAllCheckBoxButton = new Button((Composite)codegenGroup, 32);
        clientGenerateAllCheckBoxButton.setSelection(this.context.isClientGenerateAll());
        clientGenerateAllCheckBoxButton.setText(Axis2CoreUIMessages.LABEL_GENERATE_ALL);
        clientGenerateAllCheckBoxButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2RuntimePreferencePage.this.context.setClientGenerateAll(clientGenerateAllCheckBoxButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        clientGenerateAllCheckBoxButton.setLocation(10, 300);
        clientGenerateAllCheckBoxButton.setSize(400, 15);
        Label seperatorLabel1 = new Label((Composite)codegenGroup, 2050);
        seperatorLabel1.setLocation(10, 335);
        seperatorLabel1.setSize(570, 1);
        Text aarLabel = new Text((Composite)codegenGroup, 8);
        aarLabel.setText(Axis2CoreUIMessages.LABEL_WEB_SERVICE_AAR);
        aarLabel.setLocation(10, 350);
        aarLabel.setSize(220, 20);
        Label aarExtentionLabel = new Label((Composite)codegenGroup, 0);
        aarExtentionLabel.setText(Axis2CoreUIMessages.LABEL_AAR_EXTENTION);
        aarExtentionLabel.setLocation(10, 390);
        aarExtentionLabel.setSize(200, 20);
        final Text aarExtentionText = new Text((Composite)codegenGroup, 2048);
        aarExtentionText.setText(this.context.getAarExtention());
        aarExtentionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Axis2RuntimePreferencePage.this.context.setAarExtention(aarExtentionText.getText());
            }
        });
        aarExtentionText.setLocation(220, 390);
        aarExtentionText.setSize(100, 20);
        axis2PreferenceTab.setSize(640, 500);
        return mainComp;
    }

    public void init(IWorkbench workbench) {
    }

    private void handleBrowse(Shell parent) {
        DirectoryDialog fileDialog = new DirectoryDialog(parent);
        String fileName = fileDialog.open();
        if (fileName != null) {
            this.axis2Path.setText(fileName);
            this.context.setAxis2RuntimeLocation(this.axis2Path.getText());
            if (this.isWar) {
                this.updateWarStatus(true);
            } else {
                this.updateWarStatus(false);
            }
        }
    }

    private void statusUpdate(boolean status) {
        if (this.statusLabel != null) {
            if (!this.axis2Path.getText().equals("")) {
                if (status) {
                    this.statusLabel.setText(Axis2CoreUIMessages.LABEL_AXIS2_RUNTIME_LOAD);
                    this.setErrorMessage(null);
                } else {
                    this.statusLabel.setText(Axis2CoreUIMessages.LABEL_AXIS2_RUNTIME_LOAD_ERROR);
                }
            } else {
                this.statusLabel.setText(Axis2CoreUIMessages.LABEL_AXIS2_RUNTIME_NOT_EXIT);
            }
        }
    }

    private boolean runtimeExist(String path) {
        this.isWar = false;
        File axis2HomeDir = new File(path);
        if (axis2HomeDir.isDirectory()) {
            String axis2LibPath = Axis2CoreUtils.addAnotherNodeToPath((String)axis2HomeDir.getAbsolutePath(), (String)"lib");
            String axis2WebappPath = Axis2CoreUtils.addAnotherNodeToPath((String)axis2HomeDir.getAbsolutePath(), (String)"webapp");
            if (new File(axis2LibPath).isDirectory() && new File(axis2WebappPath).isDirectory()) {
                this.statusUpdate(true);
                return true;
            }
            String axis2WarPath = Axis2CoreUtils.addAnotherNodeToPath((String)path, (String)"axis2.war");
            if (new File(axis2WarPath).isFile()) {
                this.isWar = true;
                this.statusUpdate(true);
                return true;
            }
            this.statusUpdate(false);
            return false;
        }
        this.statusUpdate(false);
        return false;
    }

    private void updateWarStatus(boolean status) {
        RuntimePropertyUtils.writeWarStausToPropertiesFile((boolean)status);
    }

    private void storeValues() {
        this.context.setAxis2RuntimeLocation(this.axis2Path.getText());
    }
}

