/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.ui.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.Property;
import org.eclipse.datatools.enablement.oda.ws.soap.SOAPParameter;
import org.eclipse.datatools.enablement.oda.ws.soap.SOAPRequest;
import org.eclipse.datatools.enablement.oda.ws.soap.SOAPResponse;
import org.eclipse.datatools.enablement.oda.ws.ui.util.WSUIUtil;
import org.eclipse.datatools.enablement.oda.ws.util.Java2SOAPManager;
import org.eclipse.datatools.enablement.oda.ws.util.RawMessageSender;
import org.eclipse.datatools.enablement.oda.ws.util.WSDLAdvisor;
import org.eclipse.emf.common.util.EList;

public class WSConsole {
    private static String XML_TEMP_FILE = "xmlTempFile";
    private static WSConsole instance;
    private Properties props;
    private SOAPParameter[] parameters;
    private boolean isSessionOK = false;

    public static synchronized WSConsole getInstance() {
        if (instance == null) {
            instance = new WSConsole();
        }
        return instance;
    }

    public String getPropertyValue(String key) {
        if (this.props == null) {
            return null;
        }
        return this.props.getProperty(key);
    }

    public void setPropertyValue(String key, String value) {
        if (this.props == null) {
            this.props = new Properties();
        }
        if (value != null) {
            this.props.setProperty(key, value);
        }
    }

    public void start(DataSetDesign dataSetDesign) {
        DataSetParameters params;
        if (dataSetDesign == null) {
            return;
        }
        this.isSessionOK = true;
        String queryText = dataSetDesign.getQueryText();
        if (queryText != null && queryText.trim().length() > 0) {
            this.setPropertyValue("wsQueryText", queryText);
        }
        if ((params = dataSetDesign.getParameters()) != null) {
            this.initSOAPParameters(params);
        }
        if (dataSetDesign.getPublicProperties() != null) {
            Property xmlFileURI = dataSetDesign.getPublicProperties().findProperty("xmlFileURI");
            this.setPropertyValue("xmlFileURI", xmlFileURI == null ? "" : xmlFileURI.getValue());
            Property xsdFileURI = dataSetDesign.getPublicProperties().findProperty("xsdFileURI");
            this.setPropertyValue("xsdFileURI", xmlFileURI == null ? "" : xsdFileURI.getValue());
        }
        if (dataSetDesign.getPrivateProperties() != null) {
            Property operationTrace = dataSetDesign.getPrivateProperties().findProperty("operationTrace");
            this.setPropertyValue("operationTrace", operationTrace == null ? "" : operationTrace.getValue());
            Property xmlQueryText = dataSetDesign.getPrivateProperties().findProperty("xmlQueryText");
            this.setPropertyValue("xmlQueryText", xmlQueryText == null ? "" : xmlQueryText.getValue());
        }
        if (dataSetDesign.getDataSourceDesign() != null) {
            DataSourceDesign dataSourceDesign = dataSetDesign.getDataSourceDesign();
            if (dataSourceDesign.getPublicProperties() != null) {
                Property soapEndPoint = dataSourceDesign.getPublicProperties().findProperty("soapEndPoint");
                this.setPropertyValue("soapEndPoint", soapEndPoint == null ? "" : soapEndPoint.getValue());
                Property customConnectionClass = dataSourceDesign.getPublicProperties().findProperty("connectionClass");
                this.setPropertyValue("connectionClass", customConnectionClass == null ? "" : customConnectionClass.getValue());
            }
            if (dataSourceDesign.getPrivateProperties() != null) {
                Property wsdlURI = dataSourceDesign.getPrivateProperties().findProperty("wsdlURI");
                this.setPropertyValue("wsdlURI", wsdlURI == null ? "" : wsdlURI.getValue());
            }
        }
    }

    public void end() {
        instance = null;
    }

    public void terminateSession() {
        this.isSessionOK = false;
        this.props = null;
        this.parameters = null;
    }

    public boolean isSessionOK() {
        return this.isSessionOK;
    }

    public SOAPParameter[] getParameters() {
        return this.parameters;
    }

    public void setParameters(SOAPParameter[] soapParameters) {
        this.parameters = soapParameters;
    }

    public String getTemplate() {
        return WSDLAdvisor.getSOAPRequestTemplate((String)this.getPropertyValue("wsdlURI"), (String)this.getPropertyValue("operationTrace"));
    }

    public String getXMLFileURI() throws OdaException {
        String xmlFileURI = this.getPropertyValue("xmlFileURI");
        if (WSUIUtil.isNull((Object)xmlFileURI)) {
            String xmlTempFileURI = this.getPropertyValue("xmlTempFileURI");
            if (WSUIUtil.isNull((Object)xmlTempFileURI)) {
                this.createXMLTempFileURI();
                xmlTempFileURI = this.getPropertyValue("xmlTempFileURI");
            }
            xmlFileURI = xmlTempFileURI;
        }
        return WSUIUtil.getNonNullString((String)xmlFileURI);
    }

    public void createXMLTempFileURI() throws OdaException {
        File file = this.generateTempXMLFile();
        String xmlTempFileURI = file == null ? "" : file.getAbsolutePath();
        this.setPropertyValue("xmlTempFileURI", xmlTempFileURI);
    }

    private File generateTempXMLFile() throws OdaException {
        File file;
        InputStream in = this.getInputStream();
        if (WSUIUtil.isNull((Object)in)) {
            return null;
        }
        try {
            int abyte;
            file = File.createTempFile(XML_TEMP_FILE, null);
            file.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(file);
            BufferedInputStream bis = new BufferedInputStream(in);
            while ((abyte = bis.read()) != -1) {
                fos.write(abyte);
            }
            fos.close();
            in.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return file;
    }

    private InputStream getInputStream() throws OdaException {
        if (!WSUIUtil.isNull((Object)this.getPropertyValue("connectionClass"))) {
            return this.byCustom();
        }
        SOAPResponse soapResponse = this.connectNow();
        if (soapResponse == null) {
            return null;
        }
        return soapResponse.getInputStream();
    }

    private InputStream byCustom() throws OdaException {
        Java2SOAPManager j2s = new Java2SOAPManager();
        j2s.setConnectionProperties((Map)this.retrieveConnProperties());
        j2s.setQueryText(this.getPropertyValue("wsQueryText"));
        if (!WSUIUtil.isNull((Object)this.parameters)) {
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            int i = 0;
            while (i < this.parameters.length) {
                parameterMap.put(this.parameters[i].getName(), this.parameters[i].getDefaultValue());
                ++i;
            }
            j2s.setParameterValues(parameterMap);
        }
        try {
            j2s.newQuery(this.getPropertyValue("connectionClass"));
            return (InputStream)j2s.executeQuery();
        }
        catch (Exception e) {
            throw new OdaException((Throwable)e);
        }
    }

    private Properties retrieveConnProperties() {
        Properties p = new Properties();
        p.put("soapEndPoint", WSUIUtil.getNonNullString((String)this.getPropertyValue("soapEndPoint")));
        p.put("connectionClass", WSUIUtil.getNonNullString((String)this.getPropertyValue("connectionClass")));
        p.put("connectionTimeOut", WSUIUtil.getNonNullString((String)this.getPropertyValue("connectionTimeOut")));
        return p;
    }

    private SOAPResponse connectNow() {
        String spec = this.getPropertyValue("soapEndPoint");
        if (WSUIUtil.isNull((Object)spec)) {
            spec = WSDLAdvisor.getLocationURI((String)this.getPropertyValue("wsdlURI"), (String)this.getPropertyValue("operationTrace"));
        }
        String query = this.getPropertyValue("wsQueryText");
        if (WSUIUtil.isNull((Object)spec) || WSUIUtil.isNull((Object)query)) {
            return null;
        }
        String soapAction = WSUIUtil.getNonNullString((String)WSDLAdvisor.getSOAPActionURI((String)this.getPropertyValue("wsdlURI"), (String)this.getPropertyValue("operationTrace")));
        SOAPRequest soapRequest = new SOAPRequest();
        soapRequest.setQueryText(query);
        soapRequest.generateTemplate();
        soapRequest.setParameters(this.parameters);
        String message = soapRequest.toXML();
        RawMessageSender rawMessageSender = new RawMessageSender(spec, message, soapAction);
        SOAPResponse soapResponse = rawMessageSender.getSOAPResponse();
        return soapResponse;
    }

    public void initSOAPParameters(DataSetParameters dataSetParams) {
        EList parameterDefinitions = dataSetParams.getParameterDefinitions();
        if (WSUIUtil.isNull((Object)parameterDefinitions) || parameterDefinitions.size() == 0) {
            return;
        }
        this.parameters = new SOAPParameter[parameterDefinitions.size()];
        int i = 0;
        while (i < parameterDefinitions.size()) {
            ParameterDefinition paramDef = (ParameterDefinition)parameterDefinitions.get(i);
            this.parameters[i] = new SOAPParameter(i + 1, paramDef.getAttributes().getName(), paramDef.getDefaultScalarValue());
            ++i;
        }
    }

    public void merge2ParameterDefinitions(EList parameterDefinitions) {
        if (!this.canMerge(this.parameters, parameterDefinitions)) {
            return;
        }
        int i = 0;
        while (i < this.parameters.length) {
            ParameterDefinition paramDef = (ParameterDefinition)parameterDefinitions.get(i);
            paramDef.getAttributes().setName(this.parameters[i].getName());
            paramDef.setDefaultScalarValue(this.parameters[i].getDefaultValue());
            ++i;
        }
    }

    private boolean canMerge(SOAPParameter[] soapParameters, EList parameterDefinitions) {
        if (soapParameters == null || parameterDefinitions == null) {
            return false;
        }
        return soapParameters.length == parameterDefinitions.size();
    }
}

