/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.export;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.export.AbstractOutputter;
import org.eclipse.datatools.sqltools.result.internal.export.OutputterFactory;
import org.eclipse.datatools.sqltools.result.internal.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.internal.ui.export.IResultConstants;
import org.eclipse.datatools.sqltools.result.internal.ui.export.ResultFormatWizardPage;
import org.eclipse.datatools.sqltools.result.internal.utils.Images;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class ResultExportWizard
extends Wizard {
    ResultFormatWizardPage _formatPage;
    IResultSetObject _resultObject;
    IResultInstance _instance;

    public ResultExportWizard(IResultSetObject result) {
        this._resultObject = result;
        this.setWindowTitle(Messages.ResultExportWizard_exportResult_title);
        this._formatPage = new ResultFormatWizardPage(result);
        this._formatPage.setImageDescriptor(Images.DESC_EXPORT_RESULT);
    }

    public ResultExportWizard(IResultInstance result) {
        this._instance = result;
        this.setWindowTitle(Messages.ResultExportWizard_exportAllResults_title);
        this._formatPage = new ResultFormatWizardPage(result);
    }

    public void addPages() {
        this._formatPage.setImageDescriptor(Images.DESC_EXPORT_RESULT);
        this.addPage((IWizardPage)this._formatPage);
    }

    public boolean performFinish() {
        String pathName = this._formatPage.getFileName();
        if (pathName == null || pathName.length() < 1) {
            return false;
        }
        IPath path = new Path(pathName).makeAbsolute();
        if (path.toFile().exists()) {
            String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            String question = NLS.bind((String)Messages.ResultExportWizard_overwrite, (Object[])new Object[]{path.toOSString()});
            MessageDialog d = new MessageDialog(this.getShell(), Messages.ResultExportWizard_question, null, question, 3, buttons, 0);
            int overwrite = d.open();
            switch (overwrite) {
                case 0: {
                    break;
                }
                case 1: {
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        try {
            Properties options = new Properties();
            int format = this._formatPage.getFormatId();
            String encoding = this._formatPage.getEncoding();
            PrintWriter output = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(pathName), encoding));
            AbstractOutputter outputter = OutputterFactory.createOutputter(format);
            if (this._formatPage.getDelimiter().equals(IResultConstants.USER_DEFINED)) {
                options.setProperty("userdefined_delimiter", this._formatPage.getUserDefinedDelimiter());
            }
            options.setProperty("delimiter", this._formatPage.getDelimiter());
            options.setProperty("encoding", this._formatPage.getEncoding());
            if (this._resultObject != null) {
                outputter.output(this._resultObject, options, output);
            }
            if (this._instance != null) {
                outputter.output(this._instance, options, output);
            }
            if (output != null) {
                output.close();
            }
            return true;
        }
        catch (IOException ex) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ResultExportWizard_export_error, (String)Messages.ResultExportWizard_failed_to_export_result_set, (IStatus)new Status(4, ResultsViewPlugin.getPluginId(), 0, ex.getMessage(), (Throwable)ex));
            return false;
        }
    }
}

