/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.IPHPMoveActionDelegator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.MoveFilesAndFoldersOperation;
import org.eclipse.ui.actions.MoveProjectAction;
import org.eclipse.ui.actions.MoveResourceAction;
import org.eclipse.ui.actions.SelectionListenerAction;

public class ReorgMoveAction
extends Action
implements IPHPMoveActionDelegator {
    private IStructuredSelection selectedResources;
    private Shell fShell;
    private IContainer fTarget;
    private IResource[] fSources;

    public ReorgMoveAction() {
        this.init();
    }

    public void init() {
        this.setText(PHPUIMessages.ReorgMoveAction_3);
        this.setDescription(PHPUIMessages.ReorgMoveAction_4);
        this.fShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public void setSelection(IStructuredSelection iStructuredSelection) {
        this.selectedResources = iStructuredSelection;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        if (ActionUtils.containsOnlyProjects(iStructuredSelection.toList())) {
            this.createWorkbenchAction(iStructuredSelection).run();
            return;
        }
        if (this.selectedResources != null) {
            this.createWorkbenchAction(this.selectedResources).run();
        }
    }

    private SelectionListenerAction createWorkbenchAction(IStructuredSelection iStructuredSelection) {
        List list = iStructuredSelection.toList();
        MoveProjectAction moveProjectAction = null;
        if (list.size() == 0 || list.get(0) instanceof IProject) {
            moveProjectAction = new MoveProjectAction(this.fShell);
            moveProjectAction.selectionChanged(iStructuredSelection);
        } else if (this.selectedResources != null) {
            moveProjectAction = new MoveResourceAction(this.fShell);
            moveProjectAction.selectionChanged(iStructuredSelection);
        }
        return moveProjectAction;
    }

    public void runDrop(IStructuredSelection iStructuredSelection) {
        MoveFilesAndFoldersOperation moveFilesAndFoldersOperation = new MoveFilesAndFoldersOperation(this.fShell);
        moveFilesAndFoldersOperation.copyResources(this.fSources, this.fTarget);
    }

    public void setSources(IResource[] iResourceArray) {
        this.fSources = iResourceArray;
    }

    public void setTarget(IContainer iContainer) {
        this.fTarget = iContainer;
    }
}

