/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.compare;

import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.ICompareInputLabelProvider;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.contentmergeviewer.IFlushable;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.internal.ChangePropertyAction;
import org.eclipse.compare.internal.CompareHandlerService;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.ICompareUIConstants;
import org.eclipse.compare.internal.MergeViewerAction;
import org.eclipse.compare.internal.MergeViewerContentProvider;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.ViewerSwitchingCancelled;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;

public abstract class ContentMergeViewer
extends ContentViewer
implements IPropertyChangeNotifier,
IFlushable {
    static final int HORIZONTAL = 1;
    static final int VERTICAL = 2;
    static final double HSPLIT = 0.5;
    static final double VSPLIT = 0.3;
    private int fStyles;
    private ResourceBundle fBundle;
    private final CompareConfiguration fCompareConfiguration;
    private IPropertyChangeListener fPropertyChangeListener;
    private ICompareInputChangeListener fCompareInputChangeListener;
    private ListenerList fListenerList;
    boolean fConfirmSave = true;
    private double fHSplit = -1.0;
    private double fVSplit = 0.3;
    private boolean fIsThreeWay;
    private boolean fAncestorVisible;
    private ActionContributionItem fAncestorItem;
    private Action fCopyLeftToRightAction;
    private Action fCopyRightToLeftAction;
    MergeViewerAction fLeftSaveAction;
    MergeViewerAction fRightSaveAction;
    private CompareHandlerService fHandlerService;
    Composite fComposite;
    private CLabel fAncestorLabel;
    private CLabel fLeftLabel;
    private CLabel fRightLabel;
    CLabel fDirectionLabel;
    Control fCenter;
    private Image fRightArrow;
    private Image fLeftArrow;
    private Image fBothArrow;
    Cursor fNormalCursor;
    private Cursor fHSashCursor;
    private Cursor fVSashCursor;
    private Cursor fHVSashCursor;
    private ILabelProviderListener labelChangeListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent labelProviderChangedEvent) {
            Object[] objectArray = labelProviderChangedEvent.getElements();
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                if (object == ContentMergeViewer.this.getInput()) {
                    ContentMergeViewer.this.updateHeader();
                }
                ++n;
            }
        }
    };

    protected ContentMergeViewer(int n, ResourceBundle resourceBundle, CompareConfiguration compareConfiguration) {
        this.fStyles = n & 0xF9FFFFFF;
        this.fBundle = resourceBundle;
        this.fAncestorVisible = Utilities.getBoolean((CompareConfiguration)compareConfiguration, (String)ICompareUIConstants.PROP_ANCESTOR_VISIBLE, (boolean)this.fAncestorVisible);
        this.fConfirmSave = Utilities.getBoolean((CompareConfiguration)compareConfiguration, (String)"org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY", (boolean)this.fConfirmSave);
        this.setContentProvider((IContentProvider)new MergeViewerContentProvider(compareConfiguration));
        this.fCompareInputChangeListener = new ICompareInputChangeListener(){

            public void compareInputChanged(ICompareInput iCompareInput) {
                if (iCompareInput == ContentMergeViewer.this.getInput()) {
                    ContentMergeViewer.this.handleCompareInputChange();
                }
            }
        };
        this.fCompareConfiguration = compareConfiguration == null ? new CompareConfiguration() : compareConfiguration;
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ContentMergeViewer.this.handlePropertyChangeEvent(propertyChangeEvent);
            }
        };
        this.fCompareConfiguration.addPropertyChangeListener(this.fPropertyChangeListener);
        this.fLeftSaveAction = new SaveAction(true);
        this.fLeftSaveAction.setEnabled(false);
        this.fRightSaveAction = new SaveAction(false);
        this.fRightSaveAction.setEnabled(false);
    }

    public String getTitle() {
        return Utilities.getString((ResourceBundle)this.getResourceBundle(), (String)"title");
    }

    protected abstract void createControls(Composite var1);

    protected abstract void handleResizeAncestor(int var1, int var2, int var3, int var4);

    protected abstract void handleResizeLeftRight(int var1, int var2, int var3, int var4, int var5, int var6);

    protected void createToolItems(ToolBarManager toolBarManager) {
    }

    protected abstract void updateContent(Object var1, Object var2, Object var3);

    protected abstract void copy(boolean var1);

    protected abstract byte[] getContents(boolean var1);

    protected ResourceBundle getResourceBundle() {
        return this.fBundle;
    }

    protected CompareConfiguration getCompareConfiguration() {
        return this.fCompareConfiguration;
    }

    public void setContentProvider(IContentProvider iContentProvider) {
        Assert.isTrue((boolean)(iContentProvider instanceof IMergeViewerContentProvider));
        super.setContentProvider(iContentProvider);
    }

    IMergeViewerContentProvider getMergeContentProvider() {
        return (IMergeViewerContentProvider)this.getContentProvider();
    }

    public ISelection getSelection() {
        return new ISelection(){

            public boolean isEmpty() {
                return true;
            }
        };
    }

    public void setSelection(ISelection iSelection, boolean bl) {
    }

    protected void handlePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (string.equals(ICompareUIConstants.PROP_ANCESTOR_VISIBLE)) {
            this.fAncestorVisible = Utilities.getBoolean((CompareConfiguration)this.getCompareConfiguration(), (String)ICompareUIConstants.PROP_ANCESTOR_VISIBLE, (boolean)this.fAncestorVisible);
            this.fComposite.layout(true);
            this.updateCursor((Control)this.fLeftLabel, 2);
            this.updateCursor((Control)this.fDirectionLabel, 3);
            this.updateCursor((Control)this.fRightLabel, 2);
            return;
        }
        if (string.equals(ICompareUIConstants.PROP_IGNORE_ANCESTOR)) {
            this.setAncestorVisibility(false, !Utilities.getBoolean((CompareConfiguration)this.getCompareConfiguration(), (String)ICompareUIConstants.PROP_IGNORE_ANCESTOR, (boolean)false));
            return;
        }
    }

    void updateCursor(Control control, int n) {
        if (!(control instanceof Sash)) {
            Cursor cursor = null;
            switch (n) {
                case 2: {
                    if (this.fAncestorVisible) {
                        if (this.fVSashCursor == null) {
                            this.fVSashCursor = new Cursor((Device)control.getDisplay(), 7);
                        }
                        cursor = this.fVSashCursor;
                        break;
                    }
                    if (this.fNormalCursor == null) {
                        this.fNormalCursor = new Cursor((Device)control.getDisplay(), 0);
                    }
                    cursor = this.fNormalCursor;
                    break;
                }
                case 1: {
                    if (this.fHSashCursor == null) {
                        this.fHSashCursor = new Cursor((Device)control.getDisplay(), 9);
                    }
                    cursor = this.fHSashCursor;
                    break;
                }
                case 3: {
                    if (this.fAncestorVisible) {
                        if (this.fHVSashCursor == null) {
                            this.fHVSashCursor = new Cursor((Device)control.getDisplay(), 5);
                        }
                        cursor = this.fHVSashCursor;
                        break;
                    }
                    if (this.fHSashCursor == null) {
                        this.fHSashCursor = new Cursor((Device)control.getDisplay(), 9);
                    }
                    cursor = this.fHSashCursor;
                }
            }
            if (cursor != null) {
                control.setCursor(cursor);
            }
        }
    }

    private void setAncestorVisibility(boolean bl, boolean bl2) {
        Action action;
        if (this.fAncestorItem != null && (action = (Action)this.fAncestorItem.getAction()) != null) {
            action.setChecked(bl);
            action.setEnabled(bl2);
        }
        this.getCompareConfiguration().setProperty(ICompareUIConstants.PROP_ANCESTOR_VISIBLE, (Object)new Boolean(bl));
    }

    protected boolean isThreeWay() {
        return this.fIsThreeWay;
    }

    protected final void inputChanged(Object object, Object object2) {
        ICompareContainer iCompareContainer;
        ICompareInputLabelProvider iCompareInputLabelProvider;
        if (object != object2 && object2 != null && (iCompareInputLabelProvider = this.getCompareConfiguration().getLabelProvider()) != null) {
            iCompareInputLabelProvider.removeListener(this.labelChangeListener);
        }
        if (object != object2 && object2 instanceof ICompareInput) {
            iCompareInputLabelProvider = this.getCompareConfiguration().getContainer();
            iCompareInputLabelProvider.removeCompareInputChangeListener((ICompareInput)object2, this.fCompareInputChangeListener);
        }
        boolean bl = this.doSave(object, object2);
        if (object != object2 && object instanceof ICompareInput) {
            iCompareContainer = this.getCompareConfiguration().getContainer();
            iCompareContainer.addCompareInputChangeListener((ICompareInput)object, this.fCompareInputChangeListener);
        }
        if (object != object2 && object != null && (iCompareContainer = this.getCompareConfiguration().getLabelProvider()) != null) {
            iCompareContainer.addListener(this.labelChangeListener);
        }
        if (bl) {
            this.setLeftDirty(false);
            this.setRightDirty(false);
        }
        if (object != object2) {
            this.internalRefresh(object);
        }
    }

    protected boolean doSave(Object object, Object object2) {
        if (this.isLeftDirty() || this.isRightDirty()) {
            if (Utilities.RUNNING_TESTS) {
                if (Utilities.TESTING_FLUSH_ON_COMPARE_INPUT_CHANGE) {
                    this.flushContent(object2, null);
                }
            } else if (this.fConfirmSave) {
                Shell shell = this.fComposite.getShell();
                MessageDialog messageDialog = new MessageDialog(shell, Utilities.getString((ResourceBundle)this.getResourceBundle(), (String)"saveDialog.title"), null, Utilities.getString((ResourceBundle)this.getResourceBundle(), (String)"saveDialog.message"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                switch (messageDialog.open()) {
                    case 0: {
                        this.flushContent(object2, null);
                        break;
                    }
                    case 1: {
                        this.setLeftDirty(false);
                        this.setRightDirty(false);
                        break;
                    }
                    case 2: {
                        throw new ViewerSwitchingCancelled();
                    }
                }
            } else {
                this.flushContent(object2, null);
            }
            return true;
        }
        return false;
    }

    public void setConfirmSave(boolean bl) {
        this.fConfirmSave = bl;
    }

    public void refresh() {
        this.internalRefresh(this.getInput());
    }

    private void internalRefresh(Object object) {
        IMergeViewerContentProvider iMergeViewerContentProvider = this.getMergeContentProvider();
        if (iMergeViewerContentProvider != null) {
            Object object2 = iMergeViewerContentProvider.getAncestorContent(object);
            boolean bl = this.fIsThreeWay;
            if (Utilities.isHunk((Object)object)) {
                this.fIsThreeWay = true;
            } else if (object instanceof ICompareInput) {
                this.fIsThreeWay = (((ICompareInput)object).getKind() & 0xC) != 0;
            } else {
                boolean bl2 = this.fIsThreeWay = object2 != null;
            }
            if (this.fAncestorItem != null) {
                this.fAncestorItem.setVisible(this.fIsThreeWay);
            }
            if (this.fAncestorVisible && bl != this.fIsThreeWay) {
                this.fComposite.layout(true);
            }
            Object object3 = iMergeViewerContentProvider.getLeftContent(object);
            Object object4 = iMergeViewerContentProvider.getRightContent(object);
            this.updateContent(object2, object3, object4);
            this.updateHeader();
            ToolBarManager toolBarManager = CompareViewerPane.getToolBarManager((Composite)this.fComposite.getParent());
            if (toolBarManager != null) {
                this.updateToolItems();
                toolBarManager.update(true);
                toolBarManager.getControl().getParent().layout(true);
            }
        }
    }

    protected final Control buildControl(Composite composite) {
        this.fComposite = new Composite(composite, this.fStyles | 0x2000000){

            public boolean setFocus() {
                return ContentMergeViewer.this.handleSetFocus();
            }
        };
        this.fComposite.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)this.getTitle());
        this.hookControl((Control)this.fComposite);
        this.fComposite.setLayout((Layout)new ContentMergeViewerLayout());
        int n = 8;
        this.fAncestorLabel = new CLabel(this.fComposite, n);
        this.fLeftLabel = new CLabel(this.fComposite, n);
        new Resizer((Control)this.fLeftLabel, 2);
        this.fDirectionLabel = new CLabel(this.fComposite, n);
        this.fDirectionLabel.setAlignment(0x1000000);
        new Resizer((Control)this.fDirectionLabel, 3);
        this.fRightLabel = new CLabel(this.fComposite, n);
        new Resizer((Control)this.fRightLabel, 2);
        if (this.fCenter == null || this.fCenter.isDisposed()) {
            this.fCenter = this.createCenterControl(this.fComposite);
        }
        this.createControls(this.fComposite);
        this.fHandlerService = CompareHandlerService.createFor((ICompareContainer)this.getCompareConfiguration().getContainer(), (Shell)this.fComposite.getShell());
        this.initializeToolbars(composite);
        return this.fComposite;
    }

    private void initializeToolbars(Composite composite) {
        ToolBarManager toolBarManager = CompareViewerPane.getToolBarManager((Composite)composite);
        if (toolBarManager != null) {
            toolBarManager.removeAll();
            toolBarManager.add((IContributionItem)new Separator("modes"));
            toolBarManager.add((IContributionItem)new Separator("merge"));
            toolBarManager.add((IContributionItem)new Separator("navigation"));
            CompareConfiguration compareConfiguration = this.getCompareConfiguration();
            if (compareConfiguration.isRightEditable()) {
                this.fCopyLeftToRightAction = new Action(){

                    public void run() {
                        ContentMergeViewer.this.copy(true);
                    }
                };
                Utilities.initAction((IAction)this.fCopyLeftToRightAction, (ResourceBundle)this.getResourceBundle(), (String)"action.CopyLeftToRight.");
                toolBarManager.appendToGroup("merge", (IAction)this.fCopyLeftToRightAction);
                this.fHandlerService.registerAction((IAction)this.fCopyLeftToRightAction, "org.eclipse.compare.copyAllLeftToRight");
            }
            if (compareConfiguration.isLeftEditable()) {
                this.fCopyRightToLeftAction = new Action(){

                    public void run() {
                        ContentMergeViewer.this.copy(false);
                    }
                };
                Utilities.initAction((IAction)this.fCopyRightToLeftAction, (ResourceBundle)this.getResourceBundle(), (String)"action.CopyRightToLeft.");
                toolBarManager.appendToGroup("merge", (IAction)this.fCopyRightToLeftAction);
                this.fHandlerService.registerAction((IAction)this.fCopyRightToLeftAction, "org.eclipse.compare.copyAllRightToLeft");
            }
            ChangePropertyAction changePropertyAction = new ChangePropertyAction(this.fBundle, this.getCompareConfiguration(), "action.EnableAncestor.", ICompareUIConstants.PROP_ANCESTOR_VISIBLE);
            changePropertyAction.setChecked(this.fAncestorVisible);
            this.fAncestorItem = new ActionContributionItem((IAction)changePropertyAction);
            this.fAncestorItem.setVisible(false);
            toolBarManager.appendToGroup("modes", (IContributionItem)this.fAncestorItem);
            toolBarManager.getControl().addDisposeListener((DisposeListener)changePropertyAction);
            this.createToolItems(toolBarManager);
            this.updateToolItems();
            toolBarManager.update(true);
        }
    }

    protected boolean handleSetFocus() {
        return false;
    }

    protected int getCenterWidth() {
        return 3;
    }

    protected boolean isAncestorVisible() {
        return this.fAncestorVisible;
    }

    protected Control createCenterControl(Composite composite) {
        Sash sash = new Sash(composite, 512);
        new Resizer((Control)sash, 1);
        return sash;
    }

    protected Control getCenterControl() {
        return this.fCenter;
    }

    public Control getControl() {
        return this.fComposite;
    }

    protected void handleDispose(DisposeEvent disposeEvent) {
        ICompareContainer iCompareContainer;
        Object object;
        if (this.fHandlerService != null) {
            this.fHandlerService.dispose();
        }
        if ((object = this.getInput()) instanceof ICompareInput) {
            iCompareContainer = this.getCompareConfiguration().getContainer();
            iCompareContainer.removeCompareInputChangeListener((ICompareInput)object, this.fCompareInputChangeListener);
        }
        if (object != null && (iCompareContainer = this.getCompareConfiguration().getLabelProvider()) != null) {
            iCompareContainer.removeListener(this.labelChangeListener);
        }
        if (this.fPropertyChangeListener != null) {
            this.fCompareConfiguration.removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
        this.fAncestorLabel = null;
        this.fLeftLabel = null;
        this.fDirectionLabel = null;
        this.fRightLabel = null;
        this.fCenter = null;
        if (this.fRightArrow != null) {
            this.fRightArrow.dispose();
            this.fRightArrow = null;
        }
        if (this.fLeftArrow != null) {
            this.fLeftArrow.dispose();
            this.fLeftArrow = null;
        }
        if (this.fBothArrow != null) {
            this.fBothArrow.dispose();
            this.fBothArrow = null;
        }
        if (this.fNormalCursor != null) {
            this.fNormalCursor.dispose();
            this.fNormalCursor = null;
        }
        if (this.fHSashCursor != null) {
            this.fHSashCursor.dispose();
            this.fHSashCursor = null;
        }
        if (this.fVSashCursor != null) {
            this.fVSashCursor.dispose();
            this.fVSashCursor = null;
        }
        if (this.fHVSashCursor != null) {
            this.fHVSashCursor.dispose();
            this.fHVSashCursor = null;
        }
        super.handleDispose(disposeEvent);
    }

    protected void updateToolItems() {
        boolean bl;
        IMergeViewerContentProvider iMergeViewerContentProvider = this.getMergeContentProvider();
        Object object = this.getInput();
        if (this.fCopyLeftToRightAction != null) {
            bl = iMergeViewerContentProvider.isRightEditable(object);
            this.fCopyLeftToRightAction.setEnabled(bl);
        }
        if (this.fCopyRightToLeftAction != null) {
            bl = iMergeViewerContentProvider.isLeftEditable(object);
            this.fCopyRightToLeftAction.setEnabled(bl);
        }
    }

    protected void updateHeader() {
        String string;
        Image image;
        IMergeViewerContentProvider iMergeViewerContentProvider = this.getMergeContentProvider();
        Object object = this.getInput();
        if (this.fAncestorLabel != null) {
            image = iMergeViewerContentProvider.getAncestorImage(object);
            if (image != null) {
                this.fAncestorLabel.setImage(image);
            }
            if ((string = iMergeViewerContentProvider.getAncestorLabel(object)) != null) {
                this.fAncestorLabel.setText(string);
            }
        }
        if (this.fLeftLabel != null) {
            image = iMergeViewerContentProvider.getLeftImage(object);
            if (image != null) {
                this.fLeftLabel.setImage(image);
            }
            if ((string = iMergeViewerContentProvider.getLeftLabel(object)) != null) {
                this.fLeftLabel.setText(string);
            }
        }
        if (this.fRightLabel != null) {
            image = iMergeViewerContentProvider.getRightImage(object);
            if (image != null) {
                this.fRightLabel.setImage(image);
            }
            if ((string = iMergeViewerContentProvider.getRightLabel(object)) != null) {
                this.fRightLabel.setText(string);
            }
        }
    }

    int getHeaderHeight() {
        int n = this.fLeftLabel.computeSize((int)-1, (int)-1, (boolean)true).y;
        n = Math.max(n, this.fDirectionLabel.computeSize((int)-1, (int)-1, (boolean)true).y);
        return n;
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        if (this.fListenerList == null) {
            this.fListenerList = new ListenerList();
        }
        this.fListenerList.add((Object)iPropertyChangeListener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        if (this.fListenerList != null) {
            this.fListenerList.remove((Object)iPropertyChangeListener);
            if (this.fListenerList.isEmpty()) {
                this.fListenerList = null;
            }
        }
    }

    private void fireDirtyState(boolean bl) {
        Utilities.firePropertyChange((ListenerList)this.fListenerList, (Object)((Object)this), (String)"DIRTY_STATE", null, (Object)new Boolean(bl));
    }

    protected void setLeftDirty(boolean bl) {
        if (this.isLeftDirty() != bl) {
            this.fLeftSaveAction.setEnabled(bl);
            if (!this.isRightDirty() && !this.isLeftDirty() || !this.isRightDirty() && this.isLeftDirty()) {
                this.fireDirtyState(bl);
            }
        }
    }

    protected void setRightDirty(boolean bl) {
        if (this.isRightDirty() != bl) {
            this.fRightSaveAction.setEnabled(bl);
            if (!this.isRightDirty() && !this.isLeftDirty() || this.isRightDirty() && !this.isLeftDirty()) {
                this.fireDirtyState(bl);
            }
        }
    }

    public void save(IProgressMonitor iProgressMonitor) throws CoreException {
        this.flush(iProgressMonitor);
    }

    public final void flush(IProgressMonitor iProgressMonitor) {
        this.flushContent(this.getInput(), iProgressMonitor);
    }

    protected void flushContent(Object object, IProgressMonitor iProgressMonitor) {
        byte[] byArray;
        boolean bl;
        IMergeViewerContentProvider iMergeViewerContentProvider = (IMergeViewerContentProvider)this.getContentProvider();
        boolean bl2 = iMergeViewerContentProvider.getLeftContent(object) == null;
        boolean bl3 = bl = iMergeViewerContentProvider.getRightContent(object) == null;
        if (this.getCompareConfiguration().isLeftEditable() && this.isLeftDirty()) {
            byArray = this.getContents(true);
            if (bl && byArray != null && byArray.length == 0) {
                byArray = null;
            }
            this.setLeftDirty(false);
            iMergeViewerContentProvider.saveLeftContent(object, byArray);
        }
        if (this.getCompareConfiguration().isRightEditable() && this.isRightDirty()) {
            byArray = this.getContents(false);
            if (bl2 && byArray != null && byArray.length == 0) {
                byArray = null;
            }
            this.setRightDirty(false);
            iMergeViewerContentProvider.saveRightContent(object, byArray);
        }
    }

    protected boolean isRightDirty() {
        return this.fRightSaveAction.isEnabled();
    }

    protected boolean isLeftDirty() {
        return this.fLeftSaveAction.isEnabled();
    }

    protected void handleCompareInputChange() {
        Object object = this.getInput();
        if (this.isLeftDirty() || this.isRightDirty()) {
            if (Utilities.RUNNING_TESTS) {
                if (Utilities.TESTING_FLUSH_ON_COMPARE_INPUT_CHANGE) {
                    this.flushContent(object, null);
                }
            } else {
                Shell shell = this.fComposite.getShell();
                MessageDialog messageDialog = new MessageDialog(shell, CompareMessages.ContentMergeViewer_resource_changed_title, null, CompareMessages.ContentMergeViewer_resource_changed_description, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                switch (messageDialog.open()) {
                    case 0: {
                        this.flushContent(object, null);
                        break;
                    }
                    case 1: {
                        this.setLeftDirty(false);
                        this.setRightDirty(false);
                    }
                }
            }
        }
        this.refresh();
    }

    private class ContentMergeViewerLayout
    extends Layout {
        private ContentMergeViewerLayout() {
        }

        public Point computeSize(Composite composite, int n, int n2, boolean bl) {
            return new Point(100, 100);
        }

        public void layout(Composite composite, boolean bl) {
            int n = ((ContentMergeViewer)ContentMergeViewer.this).fLeftLabel.computeSize((int)-1, (int)-1, (boolean)true).y;
            Rectangle rectangle = composite.getClientArea();
            int n2 = ContentMergeViewer.this.getCenterWidth();
            int n3 = (int)((double)(rectangle.width - n2) * this.getHorizontalSplitRatio());
            int n4 = rectangle.width - n3 - n2;
            int n5 = 0;
            int n6 = 0;
            if (ContentMergeViewer.this.fIsThreeWay && ContentMergeViewer.this.fAncestorVisible) {
                n5 = (int)((double)(rectangle.height - 2 * n) * ContentMergeViewer.this.fVSplit);
                n6 = rectangle.height - 2 * n - n5;
            } else {
                n5 = 0;
                n6 = rectangle.height - n;
            }
            int n7 = 0;
            if (ContentMergeViewer.this.fIsThreeWay && ContentMergeViewer.this.fAncestorVisible) {
                ContentMergeViewer.this.fAncestorLabel.setBounds(0, n7, rectangle.width, n);
                ContentMergeViewer.this.fAncestorLabel.setVisible(true);
                ContentMergeViewer.this.handleResizeAncestor(0, n7 += n, rectangle.width, n5);
                n7 += n5;
            } else {
                ContentMergeViewer.this.fAncestorLabel.setVisible(false);
                ContentMergeViewer.this.handleResizeAncestor(0, 0, 0, 0);
            }
            ContentMergeViewer.this.fLeftLabel.getSize();
            if (n2 > 3) {
                ContentMergeViewer.this.fLeftLabel.setBounds(0, n7, n3 + 1, n);
                ContentMergeViewer.this.fDirectionLabel.setVisible(true);
                ContentMergeViewer.this.fDirectionLabel.setBounds(n3 + 1, n7, n2 - 1, n);
                ContentMergeViewer.this.fRightLabel.setBounds(n3 + n2, n7, n4, n);
            } else {
                ContentMergeViewer.this.fLeftLabel.setBounds(0, n7, n3, n);
                ContentMergeViewer.this.fDirectionLabel.setVisible(false);
                ContentMergeViewer.this.fRightLabel.setBounds(n3, n7, rectangle.width - n3, n);
            }
            n7 += n;
            if (ContentMergeViewer.this.fCenter != null && !ContentMergeViewer.this.fCenter.isDisposed()) {
                ContentMergeViewer.this.fCenter.setBounds(n3, n7, n2, n6);
            }
            ContentMergeViewer.this.handleResizeLeftRight(0, n7, n3, n2, n4, n6);
        }

        private double getHorizontalSplitRatio() {
            if (ContentMergeViewer.this.fHSplit < 0.0) {
                Object object = ContentMergeViewer.this.getInput();
                if (object instanceof ICompareInput) {
                    ICompareInput iCompareInput = (ICompareInput)object;
                    if (iCompareInput.getLeft() == null) {
                        return 0.1;
                    }
                    if (iCompareInput.getRight() == null) {
                        return 0.9;
                    }
                }
                return 0.5;
            }
            return ContentMergeViewer.this.fHSplit;
        }
    }

    class Resizer
    extends MouseAdapter
    implements MouseMoveListener {
        Control fControl;
        int fX;
        int fY;
        int fWidth1;
        int fWidth2;
        int fHeight1;
        int fHeight2;
        int fDirection;
        boolean fLiveResize;
        boolean fIsDown;

        public Resizer(Control control, int n) {
            this.fDirection = n;
            this.fControl = control;
            this.fLiveResize = !(this.fControl instanceof Sash);
            ContentMergeViewer.this.updateCursor(control, n);
            this.fControl.addMouseListener((MouseListener)this);
            this.fControl.addMouseMoveListener((MouseMoveListener)this);
            this.fControl.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    Resizer.this.fControl = null;
                }
            });
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            if ((this.fDirection & 1) != 0) {
                ContentMergeViewer.this.fHSplit = -1.0;
            }
            if ((this.fDirection & 2) != 0) {
                ContentMergeViewer.this.fVSplit = 0.3;
            }
            ContentMergeViewer.this.fComposite.layout(true);
        }

        public void mouseDown(MouseEvent mouseEvent) {
            Composite composite = this.fControl.getParent();
            Point point = composite.getSize();
            Point point2 = ContentMergeViewer.this.fAncestorLabel.getSize();
            Point point3 = ContentMergeViewer.this.fLeftLabel.getSize();
            Point point4 = ContentMergeViewer.this.fRightLabel.getSize();
            this.fWidth1 = point3.x;
            this.fWidth2 = point4.x;
            this.fHeight1 = ((ContentMergeViewer)ContentMergeViewer.this).fLeftLabel.getLocation().y - point2.y;
            this.fHeight2 = point.y - (((ContentMergeViewer)ContentMergeViewer.this).fLeftLabel.getLocation().y + point3.y);
            this.fX = mouseEvent.x;
            this.fY = mouseEvent.y;
            this.fIsDown = true;
        }

        public void mouseUp(MouseEvent mouseEvent) {
            this.fIsDown = false;
            if (!this.fLiveResize) {
                this.resize(mouseEvent);
            }
        }

        public void mouseMove(MouseEvent mouseEvent) {
            if (this.fIsDown && this.fLiveResize) {
                this.resize(mouseEvent);
            }
        }

        private void resize(MouseEvent mouseEvent) {
            int n = mouseEvent.x - this.fX;
            int n2 = mouseEvent.y - this.fY;
            int n3 = ContentMergeViewer.this.fCenter.getSize().x;
            if (this.fWidth1 + n > n3 && this.fWidth2 - n > n3) {
                this.fWidth1 += n;
                this.fWidth2 -= n;
                if ((this.fDirection & 1) != 0) {
                    ContentMergeViewer.this.fHSplit = (double)this.fWidth1 / (double)(this.fWidth1 + this.fWidth2);
                }
            }
            if (this.fHeight1 + n2 > n3 && this.fHeight2 - n2 > n3) {
                this.fHeight1 += n2;
                this.fHeight2 -= n2;
                if ((this.fDirection & 2) != 0) {
                    ContentMergeViewer.this.fVSplit = (double)this.fHeight1 / (double)(this.fHeight1 + this.fHeight2);
                }
            }
            ContentMergeViewer.this.fComposite.layout(true);
            this.fControl.getDisplay().update();
        }
    }

    class SaveAction
    extends MergeViewerAction {
        SaveAction(boolean bl) {
            super(true, false, false);
            Utilities.initAction((IAction)this, (ResourceBundle)ContentMergeViewer.this.getResourceBundle(), (String)"action.save.");
        }

        public void run() {
            ContentMergeViewer.this.flush(null);
        }
    }
}

