/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.contentassist.el;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jst.jsf.common.internal.types.CompositeType;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.ITaglibContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.ITextRegionContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.symbol.IInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IMethodSymbol;
import org.eclipse.jst.jsf.context.symbol.IObjectSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.provider.IContentProposalProvider;
import org.eclipse.jst.jsf.context.symbol.provider.ProposalCreationFactoryAdapter;
import org.eclipse.jst.jsf.core.internal.contentassist.el.ContentAssistStrategy;
import org.eclipse.jst.jsf.designtime.resolver.ISymbolContextResolver;
import org.eclipse.jst.jsf.designtime.resolver.StructuredDocumentSymbolResolverFactory;
import org.eclipse.jst.jsf.metadataprocessors.MetaDataEnabledProcessingFactory;
import org.eclipse.jst.jsf.metadataprocessors.features.ELIsNotValidException;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidELValues;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FunctionCompletionStrategy
extends ContentAssistStrategy {
    public FunctionCompletionStrategy(String value, String proposalStart) {
        super(0, value, proposalStart);
    }

    public List getProposals(IStructuredDocumentContext context) {
        ArrayList completionList = new ArrayList();
        String[] ids = this.getValue().split("\\.");
        if (ids.length < 1) {
            ids = new String[]{this.getValue()};
        }
        ISymbolContextResolver symbolResolver = StructuredDocumentSymbolResolverFactory.getInstance().getSymbolContextResolver(context);
        ISymbol symbol = null;
        if (symbolResolver != null) {
            symbol = symbolResolver.getVariable(ids[0]);
        }
        if (symbol instanceof IInstanceSymbol && ((IInstanceSymbol)symbol).isTypeResolved()) {
            int curSuffixIdx = 1;
            while (curSuffixIdx < ids.length && symbol != null) {
                ISymbol[] properties = symbolResolver.getProperties(symbol);
                symbol = null;
                int i = 0;
                while (i < properties.length) {
                    ISymbol element = properties[i];
                    if (ids[curSuffixIdx].equals(element.getName())) {
                        symbol = element;
                        break;
                    }
                    ++i;
                }
                ++curSuffixIdx;
            }
            if (symbol instanceof IObjectSymbol) {
                ArrayList expectedMethodBindings = new ArrayList();
                ISymbol[] suffixes = this.getSymbols((IObjectSymbol)symbol, context, symbolResolver, expectedMethodBindings);
                ComposedAdapterFactory factory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
                MyProposalFactory creationInfo = new MyProposalFactory(context, this.getProposalStart().length(), expectedMethodBindings);
                int i = 0;
                while (i < suffixes.length) {
                    ICompletionProposal[] proposal;
                    ISymbol propSymbol = suffixes[i];
                    Adapter provider = factory.adapt((Notifier)propSymbol, IContentProposalProvider.class);
                    if (provider instanceof IContentProposalProvider && (proposal = ((IContentProposalProvider)provider).getProposals((Object)propSymbol, (IContentProposalProvider.IProposalCreationFactory)creationInfo)) != null) {
                        this.addProposalsMatchingProposalStart(completionList, proposal);
                    }
                    ++i;
                }
            }
        }
        return completionList;
    }

    private ISymbol[] getSymbols(IObjectSymbol symbol, IStructuredDocumentContext context, ISymbolContextResolver symbolResolver, List expectedMethodBindings) {
        ArrayList symbols = new ArrayList();
        if (this.isMethodBindingExpected(context, expectedMethodBindings)) {
            symbols.addAll(Arrays.asList(symbolResolver.getMethods(symbol)));
        }
        symbols.addAll(Arrays.asList(symbolResolver.getProperties((ISymbol)symbol)));
        return symbols.toArray(ISymbol.EMPTY_SYMBOL_ARRAY);
    }

    private boolean isMethodBindingExpected(IStructuredDocumentContext context, List expectedBindings) {
        boolean isMBExpected = false;
        IDOMContextResolver domResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context);
        Node curNode = domResolver.getNode();
        if (curNode instanceof Attr) {
            Attr attr = (Attr)curNode;
            Element element = attr.getOwnerElement();
            ITaglibContextResolver taglibResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTaglibContextResolver(context);
            String uri = taglibResolver.getTagURIForNodeName((Node)element);
            List elVals = MetaDataEnabledProcessingFactory.getInstance().getAttributeValueRuntimeTypeFeatureProcessors(IValidELValues.class, context, uri, element.getLocalName(), attr.getLocalName());
            for (IValidELValues validValues : elVals) {
                try {
                    CompositeType type = validValues.getExpectedRuntimeType();
                    if (type == null || type.getAssignmentTypeMask() != 0) continue;
                    isMBExpected = true;
                    expectedBindings.addAll((Collection)Arrays.asList(validValues.getExpectedRuntimeType().getSignatures()));
                }
                catch (ELIsNotValidException eLIsNotValidException) {}
            }
        }
        return isMBExpected;
    }

    private static class MyProposalFactory
    extends ProposalCreationFactoryAdapter {
        private static final int DEFAULT_RELEVANCE = 1;
        private static final int HIGH_RELEVANCE = 2;
        private static final int NORMAL_RELEVANCE = 1;
        private static final int LOW_RELEVANCE = 0;
        private final List _expectedMethodBindings;
        private final IStructuredDocumentContext _context;

        public MyProposalFactory(IStructuredDocumentContext context, int replacementLength, List expectedMethodBindings) {
            super(context.getDocumentPosition() - replacementLength, replacementLength);
            this._context = context;
            this._expectedMethodBindings = expectedMethodBindings;
        }

        public ICompletionProposal createProposal(String replacementText, String displayText, String additionalText, Image displayImage, Object target) {
            int replacementOffset = this._replacementOffset;
            int replacementLength = this._replacementLength;
            if (replacementText.startsWith("[")) {
                int relativeOffset;
                ITextRegionContextResolver textResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTextRegionResolver(this._context);
                if (textResolver.getRegionType().equals("JSP_VBL_CLOSE")) {
                    textResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTextRegionResolver(textResolver.getPreviousContext());
                }
                String regionText = textResolver.getRegionText();
                int regionStart = textResolver.getStartOffset();
                if ("JSP_VBL_CONTENT".equals(textResolver.getRegionType()) && regionText != null && regionStart != -1 && regionStart < this._context.getDocumentPosition() && regionText.charAt(relativeOffset = this._context.getDocumentPosition() - regionStart - 1) == '.') {
                    --replacementOffset;
                    replacementLength = 1;
                }
            }
            return MyProposalFactory.createDefaultProposal((String)replacementText, (int)replacementOffset, (int)replacementLength, (int)replacementText.length(), (Image)displayImage, (String)displayText, null, (String)additionalText, (int)this.getRelevance(target, 1));
        }

        private int getRelevance(Object target, int defaultRelevance) {
            if (this._expectedMethodBindings.size() > 0) {
                if (target instanceof IMethodSymbol) {
                    IMethodSymbol methodSymbol = (IMethodSymbol)target;
                    for (String methodType : this._expectedMethodBindings) {
                        if (!methodType.equals(methodSymbol.getSignature())) continue;
                        return 2;
                    }
                    return 0;
                }
                return 1;
            }
            return defaultRelevance;
        }
    }
}

