/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.resolver;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.symbol.IMethodSymbol;
import org.eclipse.jst.jsf.context.symbol.IObjectSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.resolver.ISymbolContextResolver;

class SymbolContextResolver
implements ISymbolContextResolver {
    private final IStructuredDocumentContext _context;
    private IWorkspaceContextResolver _wkspResolver;

    SymbolContextResolver(IStructuredDocumentContext context) {
        this._context = context;
    }

    public ISymbol getVariable(String name) {
        IFile file = this.getFile();
        if (file != null) {
            DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance(file.getProject());
            DTFacesContext facesContext = manager.getFacesContext(file);
            return manager.getVariableResolver().resolveVariable(facesContext, name, (IAdaptable)file);
        }
        return null;
    }

    public ISymbol[] getAllVariables() {
        DesignTimeApplicationManager manager;
        DTFacesContext facesContext;
        IFile file = this.getFile();
        if (file != null && (facesContext = (manager = DesignTimeApplicationManager.getInstance(file.getProject())).getFacesContext(file)) != null) {
            return manager.getVariableResolver().getAllVariables(facesContext, (IAdaptable)file);
        }
        return ISymbol.EMPTY_SYMBOL_ARRAY;
    }

    public ISymbol getProperty(ISymbol symbol, Object propertyName) {
        IFile file = this.getFile();
        if (file != null) {
            DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance(file.getProject());
            return manager.getPropertyResolver().getProperty(symbol, propertyName);
        }
        return null;
    }

    public ISymbol[] getProperties(ISymbol symbol) {
        IFile file = this.getFile();
        if (file != null) {
            DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance(file.getProject());
            return manager.getPropertyResolver().getAllProperties(symbol);
        }
        return ISymbol.EMPTY_SYMBOL_ARRAY;
    }

    public IMethodSymbol getMethod(IObjectSymbol base, Object methodName) {
        IFile file = this.getFile();
        if (file != null) {
            DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance(file.getProject());
            return manager.getMethodResolver().getMethod(base, methodName);
        }
        return null;
    }

    public ISymbol[] getMethods(IObjectSymbol base) {
        IFile file = this.getFile();
        if (file != null) {
            DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance(file.getProject());
            return manager.getMethodResolver().getMethods(base);
        }
        return new IMethodSymbol[0];
    }

    private IFile getFile() {
        IResource curRes;
        IWorkspaceContextResolver resolver = this.getWorkspaceResolver();
        if (resolver != null && (curRes = resolver.getResource()) instanceof IFile) {
            return (IFile)curRes;
        }
        return null;
    }

    private IWorkspaceContextResolver getWorkspaceResolver() {
        if (this._wkspResolver == null) {
            this._wkspResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(this._context);
        }
        return this._wkspResolver;
    }

    public boolean canResolveContext(IModelContext modelContext) {
        return modelContext.getAdapter(IStructuredDocumentContext.class) != null;
    }
}

