/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jst.jsf.common.internal.types.CompositeType;
import org.eclipse.jst.jsf.common.internal.types.SignatureBasedType;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.validation.internal.el.ASTSemanticValidator;
import org.eclipse.jst.jsf.validation.internal.el.IExpressionSemanticValidator;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.ValidationMessageFactory;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParser;
import org.eclipse.jst.jsp.core.internal.java.jspel.ParseException;
import org.eclipse.jst.jsp.core.internal.java.jspel.Token;
import org.eclipse.jst.jsp.core.internal.java.jspel.TokenMgrError;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class ELExpressionValidator {
    private final IStructuredDocumentContext _context;
    private final String _elText;
    private final IFile _file;
    private final List _syntaxProblems;
    private ASTSemanticValidator _semanticValidator;

    public ELExpressionValidator(IStructuredDocumentContext context, String elText, IFile file) {
        this._context = context;
        this._elText = elText;
        this._file = file;
        this._syntaxProblems = new ArrayList();
    }

    public ASTExpression validateXMLNode() {
        JSPELParser elParser = JSPELParser.createParser((String)this._elText);
        try {
            ASTExpression expr = elParser.Expression();
            this.validateSemantics(expr, this._context);
            if (expr.getLastToken().endColumn < this._elText.trim().length() - 1) {
                int offset = this._context.getDocumentPosition() + expr.getLastToken().endColumn;
                int length = this._elText.trim().length() - expr.getLastToken().endColumn;
                this._syntaxProblems.add(ValidationMessageFactory.createFromDiagnostic(DiagnosticFactory.create_GENERAL_SYNTAX_ERROR(), offset, length, this._file));
            }
            return expr;
        }
        catch (ParseException e) {
            Token curTok = e.currentToken;
            int offset = this._context.getDocumentPosition() + curTok.beginColumn;
            int length = curTok.endColumn - curTok.beginColumn + 1;
            this._syntaxProblems.add(ValidationMessageFactory.createFromDiagnostic(DiagnosticFactory.create_GENERAL_SYNTAX_ERROR(), offset, length, this._file));
            return null;
        }
        catch (TokenMgrError tokenMgrError) {
            int offset = this._context.getDocumentPosition();
            int length = this._elText.length();
            this._syntaxProblems.add(ValidationMessageFactory.createFromDiagnostic(DiagnosticFactory.create_GENERAL_SYNTAX_ERROR(), offset, length, this._file));
            return null;
        }
    }

    public void reportFindings(IValidator validator, IReporter reporter) {
        for (IMessage message : this._syntaxProblems) {
            reporter.addMessage(validator, message);
        }
        if (this._semanticValidator != null) {
            this._semanticValidator.reportFindings(validator, reporter);
        }
    }

    public CompositeType getExpressionType() {
        SignatureBasedType type;
        if (this._semanticValidator != null && (type = this._semanticValidator.getExpressionType()) != null) {
            return type.toCompositeType();
        }
        return null;
    }

    public List getSyntaxProblems() {
        return Collections.unmodifiableList(this._syntaxProblems);
    }

    public IExpressionSemanticValidator getSemanticValidator() {
        return this._semanticValidator;
    }

    private void validateSemantics(ASTExpression expr, IStructuredDocumentContext context) {
        this._semanticValidator = new ASTSemanticValidator(expr, context);
        this._semanticValidator.validate();
    }
}

