/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el.operators;

import java.math.BigDecimal;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.common.internal.types.FloatLiteralType;
import org.eclipse.jst.jsf.common.internal.types.IntegerLiteralType;
import org.eclipse.jst.jsf.common.internal.types.LiteralType;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercer;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercionException;
import org.eclipse.jst.jsf.common.internal.types.TypeTransformer;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.internal.el.operators.ArithmeticBinaryOperator;

class DivArithmeticBinaryOperator
extends ArithmeticBinaryOperator {
    private static final String DIVISION = "division";

    DivArithmeticBinaryOperator() {
    }

    public ValueType performOperation(ValueType firstArg, ValueType secondArg) {
        if (TypeCoercer.typeIsNull((String)firstArg.getSignature()) && TypeCoercer.typeIsNull((String)secondArg.getSignature())) {
            return new IntegerLiteralType(0L);
        }
        String boxedFirstArg = TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature());
        String boxedSecondArg = TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature());
        if ("Ljava.math.BigDecimal;".equals(boxedFirstArg) || "Ljava.math.BigDecimal;".equals(boxedSecondArg) || "Ljava.math.BigInteger;".equals(boxedFirstArg) || "Ljava.math.BigInteger;".equals(boxedSecondArg)) {
            return this.performBigDecimal(firstArg, secondArg);
        }
        return this.performDouble(firstArg, secondArg);
    }

    public Diagnostic validate(ValueType firstArg, ValueType secondArg) {
        if (TypeCoercer.typeIsNull((String)firstArg.getSignature()) && TypeCoercer.typeIsNull((String)secondArg.getSignature())) {
            return DiagnosticFactory.create_BINARY_OP_BOTH_OPERANDS_NULL(DIVISION);
        }
        String boxedFirstArg = TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature());
        String boxedSecondArg = TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature());
        if ("Ljava.math.BigDecimal;".equals(boxedFirstArg) || "Ljava.math.BigDecimal;".equals(boxedSecondArg) || "Ljava.math.BigInteger;".equals(boxedFirstArg) || "Ljava.math.BigInteger;".equals(boxedSecondArg)) {
            return this.validateBigDecimal(firstArg, secondArg);
        }
        return this.validateDouble(firstArg, secondArg);
    }

    private ValueType performBigDecimal(ValueType firstArg, ValueType secondArg) {
        block3: {
            try {
                Number coercedValue;
                TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
                TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature()));
                if (!(secondArg instanceof LiteralType) || !((BigDecimal)(coercedValue = ((LiteralType)secondArg).coerceToNumber(BigDecimal.class))).equals(new BigDecimal(0))) break block3;
                return null;
            }
            catch (TypeCoercionException typeCoercionException) {
                return null;
            }
        }
        return new ValueType("Ljava.math.BigDecimal;", 2);
    }

    private ValueType performDouble(ValueType firstArg, ValueType secondArg) {
        Number secondValue;
        block5: {
            try {
                TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
                TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature()));
                secondValue = null;
                if (!(secondArg instanceof LiteralType) || (secondValue = ((LiteralType)secondArg).coerceToNumber(Double.class)).doubleValue() != 0.0) break block5;
                return null;
            }
            catch (TypeCoercionException typeCoercionException) {
                return null;
            }
        }
        Number firstValue = null;
        if (firstArg instanceof LiteralType) {
            firstValue = ((LiteralType)firstArg).coerceToNumber(Double.class);
        }
        if (firstValue != null && secondValue != null) {
            return new FloatLiteralType(this.doRealOperation(new Double(firstValue.doubleValue()), new Double(secondValue.doubleValue())).doubleValue());
        }
        return new ValueType("D", 2);
    }

    private Diagnostic validateBigDecimal(ValueType firstArg, ValueType secondArg) {
        try {
            Number coercedValue;
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature()));
            if (secondArg instanceof LiteralType && ((BigDecimal)(coercedValue = ((LiteralType)secondArg).coerceToNumber(BigDecimal.class))).equals(new BigDecimal(0))) {
                return DiagnosticFactory.create_BINARY_OP_POSSIBLE_DIVISION_BY_ZERO();
            }
            return Diagnostic.OK_INSTANCE;
        }
        catch (TypeCoercionException typeCoercionException) {
            return DiagnosticFactory.create_BINARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION(DIVISION);
        }
    }

    private Diagnostic validateDouble(ValueType firstArg, ValueType secondArg) {
        try {
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature()));
            Number secondValue = null;
            if (secondArg instanceof LiteralType && (secondValue = ((LiteralType)secondArg).coerceToNumber(Double.class)).doubleValue() == 0.0) {
                return DiagnosticFactory.create_BINARY_OP_POSSIBLE_DIVISION_BY_ZERO();
            }
            Number firstValue = null;
            if (firstArg instanceof LiteralType) {
                firstValue = ((LiteralType)firstArg).coerceToNumber(Double.class);
            }
            if (firstValue != null && secondValue != null) {
                String result = Double.toString(this.doRealOperation(new Double(firstValue.doubleValue()), new Double(secondValue.doubleValue())));
                return DiagnosticFactory.create_BINARY_OP_CONSTANT_EXPRESSION_ALWAYS_EVAL_SAME(DIVISION, result);
            }
            return Diagnostic.OK_INSTANCE;
        }
        catch (TypeCoercionException typeCoercionException) {
            return DiagnosticFactory.create_BINARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION(DIVISION);
        }
    }

    protected BigDecimal doRealOperation(BigDecimal firstArg, BigDecimal secondArg) {
        return firstArg.divide(secondArg, 4);
    }

    protected Double doRealOperation(Double firstArg, Double secondArg) {
        return new Double(firstArg / secondArg);
    }

    protected Long doRealOperation(Long firstArg, Long secondArg) {
        return new Long(firstArg / secondArg);
    }

    protected String getOperatorName() {
        return DIVISION;
    }
}

