/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.preference;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.preference.ColorFontFieldEditor;
import org.eclipse.jst.jsf.facesconfig.ui.preference.ComboFieldEditor;
import org.eclipse.jst.jsf.facesconfig.ui.preference.PreferenceMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GEMPreferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String SHOW_INTRO_EDITOR = "ShowIntroEditor";
    public static final String USE_SYSTEM_COLORS = "UseSystemColors";
    public static final String CANVAS_COLOR = "CanvasColor";
    public static final String FIGURE_LABEL_FONT = "FigureLabelFont";
    public static final String FIGURE_LABEL_FONT_COLOR = "FigureLabelFontColor";
    public static final String LABEL_PLACEMENT = "LabelPlacement";
    public static final String INPUT_PORT_COLOR = "InputPortColor";
    public static final String OUTPUT_PORT_COLOR = "OutputPortColor";
    public static final String SHOW_LINE_LABELS = "ShowLineLabels";
    public static final String LINE_LABEL_FONT = "LineLabelFont";
    public static final String LINE_LABEL_FONT_COLOR = "LineLabelFontColor";
    public static final String LINE_LABEL_COLOR = "LineLabelColor";
    public static final String LINE_WIDTH = "LineWidth";
    public static final String LINE_COLOR = "LineColor";
    public static final String LINE_ROUTING = "LineRouting";
    public static final String SNAP_TO_GRID = "SnapToGrid";
    public static final String SNAP_TO_GEOMETRY = "SnapToGeometry";
    public static final String GRID_WIDTH = "GridWidth";
    public static final String GRID_HEIGHT = "GridHeight";
    public static final String GRID_COLOR = "GridColor";
    public static final String LABEL_PLACEMENT_TOP = "Top";
    public static final String LABEL_PLACEMENT_BOTTOM = "Bottom";
    public static final String LABEL_PLACEMENT_LEFT = "Left";
    public static final String LABEL_PLACEMENT_RIGHT = "Right";
    public static final String LINE_ROUTING_MANHATTAN = "Manhattan";
    public static final String LINE_ROUTING_MANUAL = "Manaul";
    private static final String[][] m_lineRoutingLabels = new String[][]{{PreferenceMessages.CanvasPreferences_LABEL_Manual, "Manaul"}, {PreferenceMessages.CanvasPreferences_LABEL_Manhattan, "Manhattan"}};
    private static final String[][] m_labelPlacementLabels = new String[][]{{PreferenceMessages.CanvasPreferences_LABEL_Top, "Top"}, {PreferenceMessages.CanvasPreferences_LABEL_Bottom, "Bottom"}, {PreferenceMessages.CanvasPreferences_LABEL_Left, "Left"}, {PreferenceMessages.CanvasPreferences_LABEL_Right, "Right"}};
    private Group canvasGroup;
    private Group iconGroup;
    private Group lineGroup;
    private BooleanField useSystemColors;
    private ColorFieldEditor canvasColor;
    private BooleanField snapToGrid;
    private IntegerFieldEditor gridWidth;
    private IntegerFieldEditor gridHeight;
    private ColorFieldEditor gridColor;
    private BooleanField showLineLabels;
    private ColorFieldEditor lineLabelColor;
    private ColorFieldEditor lineColor;
    private ColorFontFieldEditor iconFont;
    private ColorFontFieldEditor lineFont;

    public GEMPreferences() {
        super(1);
        this.setPreferenceStore(EditorPlugin.getDefault().getPreferenceStore());
        this.setDescription("Preferences for the graphical page of FacesConfig editor.");
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        Font f = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        store.setDefault(SHOW_INTRO_EDITOR, true);
        store.setDefault(USE_SYSTEM_COLORS, true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)CANVAS_COLOR, (RGB)new RGB(255, 255, 255));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)FIGURE_LABEL_FONT, (FontData[])f.getFontData());
        store.setDefault(LINE_WIDTH, 1);
        store.setDefault(LINE_ROUTING, GEMPreferences.getLineRoutingLabels()[0][1]);
        store.setDefault(SHOW_LINE_LABELS, true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)LINE_COLOR, (RGB)new RGB(0, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)LINE_LABEL_COLOR, (RGB)new RGB(255, 255, 255));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)LINE_LABEL_FONT, (FontData[])f.getFontData());
        store.setDefault(SNAP_TO_GEOMETRY, true);
        store.setDefault(SNAP_TO_GRID, true);
        store.setDefault(GRID_WIDTH, 12);
        store.setDefault(GRID_HEIGHT, 12);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)GRID_COLOR, (RGB)new RGB(230, 230, 230));
    }

    public void createFieldEditors() {
        this.addBooleanField(SHOW_INTRO_EDITOR, PreferenceMessages.EditorPreferences_LABEL_ShowIntroEditor, this.getFieldEditorParent());
        this.useSystemColors = this.addBooleanField(USE_SYSTEM_COLORS, PreferenceMessages.CanvasPreferenceTab_LABEL_UseSystemColors, this.getFieldEditorParent());
        this.canvasGroup = new Group(this.getFieldEditorParent(), 0);
        this.lineGroup = new Group(this.getFieldEditorParent(), 0);
        this.iconGroup = new Group(this.getFieldEditorParent(), 0);
        this.canvasGroup.setText(PreferenceMessages.CanvasPreferenceTab_LABEL_Canvas);
        this.canvasColor = this.addColorField(CANVAS_COLOR, PreferenceMessages.CanvasPreferenceTab_LABEL_BackgroundColor, (Composite)this.canvasGroup);
        this.addBooleanField(SNAP_TO_GEOMETRY, PreferenceMessages.CanvasPreferenceTab_LABEL_SnapToGeometry, (Composite)this.canvasGroup);
        this.snapToGrid = this.addBooleanField(SNAP_TO_GRID, PreferenceMessages.CanvasPreferenceTab_LABEL_SnapToGrid, (Composite)this.canvasGroup);
        this.gridColor = this.addColorField(GRID_COLOR, PreferenceMessages.CanvasPreferenceTab_LABEL_GridLineColor, (Composite)this.canvasGroup);
        this.gridWidth = this.addIntegerField(GRID_WIDTH, PreferenceMessages.CanvasPreferenceTab_LABEL_GridWidth, (Composite)this.canvasGroup);
        this.gridHeight = this.addIntegerField(GRID_HEIGHT, PreferenceMessages.CanvasPreferenceTab_LABEL_GridHeight, (Composite)this.canvasGroup);
        this.iconGroup.setText(PreferenceMessages.CanvasPreferenceTab_LABEL_IconGroup);
        this.iconFont = this.addFontField(FIGURE_LABEL_FONT, PreferenceMessages.CanvasPreferenceTab_LABEL_IconLabelFont, (Composite)this.iconGroup);
        this.addComboField(LABEL_PLACEMENT, PreferenceMessages.CanvasPreferenceTab_LABEL_LabelPlacement, GEMPreferences.getLabelPlacementLabels(), (Composite)this.iconGroup);
        this.lineGroup.setText(PreferenceMessages.CanvasPreferenceTab_LABEL_LineGroup);
        this.showLineLabels = this.addBooleanField(SHOW_LINE_LABELS, PreferenceMessages.CanvasPreferenceTab_LABEL_ShowLineLabels, (Composite)this.lineGroup);
        this.lineFont = this.addFontField(LINE_LABEL_FONT, PreferenceMessages.CanvasPreferenceTab_LABEL_LineLabelFont, (Composite)this.lineGroup);
        this.lineLabelColor = this.addColorField(LINE_LABEL_COLOR, PreferenceMessages.CanvasPreferenceTab_LABEL_LineLabelColor, (Composite)this.lineGroup);
        this.lineColor = this.addColorField(LINE_COLOR, PreferenceMessages.CanvasPreferenceTab_LABEL_LineColor, (Composite)this.lineGroup);
        this.addIntegerField(LINE_WIDTH, PreferenceMessages.CanvasPreferenceTab_LABEL_LineWidth, (Composite)this.lineGroup);
        this.addComboField(LINE_ROUTING, PreferenceMessages.CanvasPreferenceTab_LABEL_LineRouting, GEMPreferences.getLineRoutingLabels(), (Composite)this.lineGroup);
    }

    protected void initialize() {
        super.initialize();
        ((GridLayout)this.getFieldEditorParent().getLayout()).numColumns = 2;
        this.canvasGroup.setLayout((Layout)new GridLayout(3, false));
        this.canvasGroup.setLayoutData((Object)new GridData(770));
        this.canvasColor.fillIntoGrid((Composite)this.canvasGroup, 3);
        this.gridColor.fillIntoGrid((Composite)this.canvasGroup, 3);
        this.iconGroup.setLayout((Layout)new GridLayout(3, false));
        this.iconGroup.setLayoutData((Object)new GridData(770));
        this.iconFont.fillIntoGrid((Composite)this.iconGroup, 3);
        this.lineGroup.setLayout((Layout)new GridLayout(3, false));
        this.lineGroup.setLayoutData((Object)new GridData(770));
        this.lineColor.fillIntoGrid((Composite)this.lineGroup, 3);
        this.lineLabelColor.fillIntoGrid((Composite)this.lineGroup, 3);
        this.lineFont.fillIntoGrid((Composite)this.lineGroup, 3);
        boolean userColorsValue = !this.useSystemColors.getBooleanValue();
        boolean showLineLabelsValue = this.showLineLabels.getBooleanValue();
        boolean snapToGridValue = this.snapToGrid.getBooleanValue();
        this.canvasColor.setEnabled(userColorsValue, (Composite)this.canvasGroup);
        this.gridColor.setEnabled(snapToGridValue && userColorsValue, (Composite)this.canvasGroup);
        this.iconFont.setEnabled(userColorsValue, (Composite)this.iconGroup);
        this.lineColor.setEnabled(userColorsValue, (Composite)this.lineGroup);
        this.lineLabelColor.setEnabled(showLineLabelsValue && userColorsValue, (Composite)this.lineGroup);
        this.lineFont.setEnabled(showLineLabelsValue && userColorsValue, (Composite)this.lineGroup);
        this.gridWidth.setEnabled(snapToGridValue, (Composite)this.canvasGroup);
        this.gridHeight.setEnabled(snapToGridValue, (Composite)this.canvasGroup);
        this.useSystemColors.getButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean userColorsValue_ = !GEMPreferences.this.useSystemColors.getBooleanValue();
                boolean showLineLabelsValue_ = GEMPreferences.this.showLineLabels.getBooleanValue();
                boolean snapToGridValue_ = GEMPreferences.this.snapToGrid.getBooleanValue();
                GEMPreferences.this.canvasColor.setEnabled(userColorsValue_, (Composite)GEMPreferences.this.canvasGroup);
                GEMPreferences.this.gridColor.setEnabled(snapToGridValue_ && userColorsValue_, (Composite)GEMPreferences.this.canvasGroup);
                GEMPreferences.this.iconFont.setEnabled(userColorsValue_, (Composite)GEMPreferences.this.iconGroup);
                GEMPreferences.this.lineColor.setEnabled(userColorsValue_, (Composite)GEMPreferences.this.lineGroup);
                GEMPreferences.this.lineLabelColor.setEnabled(showLineLabelsValue_ && userColorsValue_, (Composite)GEMPreferences.this.lineGroup);
                GEMPreferences.this.lineFont.setEnabled(showLineLabelsValue_ && userColorsValue_, (Composite)GEMPreferences.this.lineGroup);
            }
        });
        this.showLineLabels.getButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean userColorsValue_ = !GEMPreferences.this.useSystemColors.getBooleanValue();
                boolean showLineLabelsValue_ = GEMPreferences.this.showLineLabels.getBooleanValue();
                GEMPreferences.this.lineLabelColor.setEnabled(showLineLabelsValue_ && userColorsValue_, (Composite)GEMPreferences.this.lineGroup);
                GEMPreferences.this.lineFont.setEnabled(showLineLabelsValue_ && userColorsValue_, (Composite)GEMPreferences.this.lineGroup);
            }
        });
        this.snapToGrid.getButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean userColorsValue_ = !GEMPreferences.this.useSystemColors.getBooleanValue();
                boolean snapToGridValue_ = GEMPreferences.this.snapToGrid.getBooleanValue();
                GEMPreferences.this.gridColor.setEnabled(snapToGridValue_ && userColorsValue_, (Composite)GEMPreferences.this.canvasGroup);
                GEMPreferences.this.gridWidth.setEnabled(snapToGridValue_, (Composite)GEMPreferences.this.canvasGroup);
                GEMPreferences.this.gridHeight.setEnabled(snapToGridValue_, (Composite)GEMPreferences.this.canvasGroup);
            }
        });
    }

    public void init(IWorkbench workbench) {
    }

    private ColorFieldEditor addColorField(String name, String labelText, Composite parent) {
        ColorFieldEditor f = new ColorFieldEditor(name, labelText, parent);
        this.addField((FieldEditor)f);
        return f;
    }

    private ComboFieldEditor addComboField(String name, String labelText, String[][] entryNamesAndValues, Composite parent) {
        ComboFieldEditor f = new ComboFieldEditor(name, labelText, entryNamesAndValues, parent);
        this.addField(f);
        return f;
    }

    private IntegerFieldEditor addIntegerField(String name, String labelText, Composite parent) {
        IntegerFieldEditor f = new IntegerFieldEditor(name, labelText, parent);
        this.addField((FieldEditor)f);
        return f;
    }

    private BooleanField addBooleanField(String name, String labelText, Composite parent) {
        BooleanField f = new BooleanField(name, labelText, parent);
        this.addField((FieldEditor)f);
        return f;
    }

    private ColorFontFieldEditor addFontField(String name, String labelText, Composite parent) {
        ColorFontFieldEditor f = new ColorFontFieldEditor(name, labelText, parent);
        this.addField(f);
        return f;
    }

    private static String[][] getLineRoutingLabels() {
        return m_lineRoutingLabels;
    }

    private static String[][] getLabelPlacementLabels() {
        return m_labelPlacementLabels;
    }

    public static boolean getShowIntroEditor() {
        IPreferenceStore store = EditorPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(SHOW_INTRO_EDITOR);
    }

    public static Color getColor(IPreferenceStore store, String property) {
        boolean useSystemColors = store.getBoolean(USE_SYSTEM_COLORS);
        Color c = ColorConstants.black;
        if (useSystemColors) {
            if (GRID_COLOR.equals(property)) {
                c = ColorConstants.button;
            }
            if (LINE_COLOR.equals(property)) {
                c = ColorConstants.listForeground;
            }
            if (LINE_LABEL_FONT_COLOR.equals(property)) {
                c = ColorConstants.listForeground;
            }
            if (LINE_LABEL_COLOR.equals(property)) {
                c = ColorConstants.listBackground;
            }
            if (CANVAS_COLOR.equals(property)) {
                c = ColorConstants.listBackground;
            }
            if (INPUT_PORT_COLOR.equals(property)) {
                c = ColorConstants.listForeground;
            }
            if (OUTPUT_PORT_COLOR.equals(property)) {
                c = ColorConstants.listForeground;
            }
            if (FIGURE_LABEL_FONT_COLOR.equals(property)) {
                c = ColorConstants.listForeground;
            }
        } else {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)property);
            ColorRegistry registry = JFaceResources.getColorRegistry();
            if (registry.get(rgb.toString()) != null) {
                return registry.get(rgb.toString());
            }
            registry.put(rgb.toString(), rgb);
            c = registry.get(rgb.toString());
        }
        return c;
    }

    private class BooleanField
    extends BooleanFieldEditor {
        private Composite parent;

        public BooleanField(String name, String label, Composite parent) {
            super(name, label, parent);
            this.parent = parent;
        }

        public Button getButton() {
            return this.getChangeControl(this.parent);
        }
    }
}

