/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.drivers;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverMgmtMessages;
import org.eclipse.datatools.connectivity.drivers.DriverValidator;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.PropertySetImpl;
import org.eclipse.datatools.connectivity.drivers.XMLFileManager;
import org.eclipse.datatools.connectivity.drivers.models.OverrideTemplateDescriptor;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;

public class DriverManager {
    private static DriverManager sInstance;
    private HashMap mDriverInstanceMap;

    public static synchronized DriverManager getInstance() {
        if (sInstance == null) {
            sInstance = new DriverManager();
        }
        return sInstance;
    }

    private synchronized void loadAllInstances() {
        XMLFileManager.setFileName("driverStorage.xml");
        try {
            IPropertySet[] psets = XMLFileManager.loadPropertySets();
            if (psets.length > 0) {
                for (int i = 0; i < psets.length; ++i) {
                    IPropertySet pset = psets[i];
                    DriverInstance ndi = new DriverInstance(pset);
                    this.mDriverInstanceMap.put(ndi.getId(), ndi);
                }
                return;
            }
        }
        catch (CoreException e) {
            ConnectivityPlugin.getDefault().log(e);
        }
    }

    private DriverManager() {
        this.resetDefaultInstances();
    }

    private DriverInstance getDriverInstanceFromMapByName(String name) {
        if (this.mDriverInstanceMap.containsKey(name)) {
            return (DriverInstance)this.mDriverInstanceMap.get(name);
        }
        return null;
    }

    private DriverInstance getDriverInstanceFromMapByID(String id) {
        Iterator iter = this.mDriverInstanceMap.values().iterator();
        while (iter.hasNext()) {
            DriverInstance di = (DriverInstance)iter.next();
            if (!di.getId().equals(id)) continue;
            return di;
        }
        return null;
    }

    private DriverInstance[] getDriverInstancesFromMapByCategoryID(String categoryid) {
        Iterator iter = this.mDriverInstanceMap.values().iterator();
        ArrayList<DriverInstance> list = new ArrayList<DriverInstance>();
        while (iter.hasNext()) {
            DriverInstance di = (DriverInstance)iter.next();
            if (!di.getTemplate().getParent().getId().equals(categoryid)) continue;
            list.add(di);
        }
        return list.toArray(new DriverInstance[list.size()]);
    }

    private DriverInstance[] getDriverInstancesFromMapForTemplateID(String templateid) {
        Iterator iter = this.mDriverInstanceMap.values().iterator();
        ArrayList<DriverInstance> list = new ArrayList<DriverInstance>();
        while (iter.hasNext()) {
            DriverInstance di = (DriverInstance)iter.next();
            if (!di.getTemplate().getId().equals(templateid)) continue;
            list.add(di);
        }
        return list.toArray(new DriverInstance[list.size()]);
    }

    public DriverInstance getDriverInstanceByID(String id) {
        DriverInstance di = this.getDriverInstanceFromMapByID(id);
        if (di == null) {
            XMLFileManager.setFileName("driverStorage.xml");
            try {
                IPropertySet[] psets = XMLFileManager.loadPropertySets();
                if (psets.length > 0) {
                    for (int i = 0; i < psets.length; ++i) {
                        IPropertySet pset = psets[i];
                        if (!pset.getID().equals(id)) continue;
                        di = new DriverInstance(pset);
                        this.mDriverInstanceMap.put(di.getId(), di);
                    }
                }
            }
            catch (CoreException e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        return di;
    }

    public DriverInstance[] getDriverInstancesByCategory(String categoryid) {
        return this.getDriverInstancesFromMapByCategoryID(categoryid);
    }

    public DriverInstance[] getDriverInstancesByTemplate(String templateid) {
        return this.getDriverInstancesFromMapForTemplateID(templateid);
    }

    public DriverInstance getDriverInstanceByName(String name) {
        DriverInstance di = this.getDriverInstanceFromMapByName(name);
        if (di == null) {
            XMLFileManager.setFileName("driverStorage.xml");
            try {
                IPropertySet[] psets = XMLFileManager.loadPropertySets();
                if (psets.length > 0) {
                    for (int i = 0; i < psets.length; ++i) {
                        IPropertySet pset = psets[i];
                        if (!pset.getName().equals(name)) continue;
                        di = new DriverInstance(pset);
                        this.mDriverInstanceMap.put(di.getId(), di);
                    }
                }
            }
            catch (CoreException e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        return di;
    }

    public String getFullJarList() {
        Object[] drivers = this.mDriverInstanceMap.values().toArray();
        String fullList = "";
        for (int x = 0; x < drivers.length; ++x) {
            DriverInstance di = (DriverInstance)drivers[x];
            if (di.getJarList() != null) {
                String jarlist = di.getJarList().trim();
                if (fullList.trim().length() > 0) {
                    fullList = fullList + ",";
                }
                fullList = fullList + jarlist + ",";
            }
            if (!fullList.substring(fullList.length() - 1, fullList.length()).equals(",")) continue;
            fullList = fullList.substring(0, fullList.length() - 1);
        }
        if (fullList.trim().length() > 0) {
            String[] paths = this.parseString(fullList, ",");
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < paths.length; ++i) {
                File testFile = new File(paths[i]);
                if (!testFile.exists() || list.contains(paths[i])) continue;
                list.add(paths[i]);
            }
            String newList = "";
            Iterator iter2 = list.iterator();
            while (iter2.hasNext()) {
                newList = newList + iter2.next() + ",";
            }
            if (newList.length() > 0 && newList.substring(newList.length() - 1, newList.length()).equals(",")) {
                newList = newList.substring(0, newList.length() - 1);
            }
            return newList;
        }
        return null;
    }

    public String[] getFullJarListAsArray() {
        if (this.getFullJarList() != null) {
            if (this.getFullJarList().length() == 0) {
                return new String[0];
            }
            String[] paths = this.parseString(this.getFullJarList(), ",");
            return paths;
        }
        return null;
    }

    public DriverInstance[] getValidDriverInstances() {
        DriverInstance[] array = new DriverInstance[]{};
        Iterator iter = this.mDriverInstanceMap.values().iterator();
        ArrayList<DriverInstance> list = new ArrayList<DriverInstance>();
        while (iter.hasNext()) {
            DriverInstance di = (DriverInstance)iter.next();
            DriverValidator validator = new DriverValidator(di);
            if (!validator.isValid()) continue;
            list.add(di);
        }
        array = new DriverInstance[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = (DriverInstance)list.get(i);
        }
        return array;
    }

    public DriverInstance[] getAllDriverInstances() {
        return this.mDriverInstanceMap.values().toArray(new DriverInstance[this.mDriverInstanceMap.values().size()]);
    }

    private IPropertySet[] getPropertySetsFromMap() {
        Iterator iter = this.mDriverInstanceMap.values().iterator();
        ArrayList<IPropertySet> list = new ArrayList<IPropertySet>();
        while (iter.hasNext()) {
            DriverInstance di = (DriverInstance)iter.next();
            list.add(di.getPropertySet());
        }
        return list.toArray(new IPropertySet[list.size()]);
    }

    public DriverInstance createNewDriverInstance(String templateID, String name, String jarList) {
        if (templateID == null) {
            return null;
        }
        if (name == null) {
            return null;
        }
        if (jarList == null) {
            return null;
        }
        IPropertySet pset = this.createDefaultInstance(templateID);
        pset.setName(name);
        String prefix = DriverMgmtMessages.getString("NewDriverDialog.text.id_prefix");
        String id = prefix + name;
        pset.setID(id);
        Properties props = pset.getBaseProperties();
        props.setProperty("jarList", jarList);
        this.addDriverInstance(pset);
        return this.getDriverInstanceByID(pset.getID());
    }

    public boolean removeDriverInstance(String id) {
        boolean rtnFlag = false;
        if (this.getDriverInstanceByID(id) != null) {
            XMLFileManager.setFileName("driverStorage.xml");
            try {
                IPropertySet[] psets = XMLFileManager.loadPropertySets();
                if (psets.length > 0) {
                    IPropertySet[] newPsets = new IPropertySet[psets.length - 1];
                    int counter = 0;
                    for (int i = 0; i < psets.length; ++i) {
                        IPropertySet pset = psets[i];
                        if (pset.getID().equals(id)) {
                            rtnFlag = true;
                            continue;
                        }
                        newPsets[counter] = pset;
                        ++counter;
                    }
                    if (rtnFlag) {
                        XMLFileManager.saveNamedPropertySet(newPsets);
                        this.mDriverInstanceMap = new HashMap();
                        this.loadAllInstances();
                    }
                }
            }
            catch (CoreException e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        return rtnFlag;
    }

    public void addDriverInstance(DriverInstance di) {
        this.mDriverInstanceMap.put(di.getId(), di);
        IPropertySet[] psets = this.getPropertySetsFromMap();
        XMLFileManager.setFileName("driverStorage.xml");
        try {
            XMLFileManager.saveNamedPropertySet(psets);
            this.mDriverInstanceMap = new HashMap();
            this.loadAllInstances();
        }
        catch (CoreException e) {
            ConnectivityPlugin.getDefault().log(e);
        }
    }

    public void addDriverInstance(IPropertySet pset) {
        DriverInstance di = new DriverInstance(pset);
        this.addDriverInstance(di);
    }

    private String[] parseString(String str_list, String token) {
        StringTokenizer tk = new StringTokenizer(str_list, token);
        String[] pieces = new String[tk.countTokens()];
        int index = 0;
        while (tk.hasMoreTokens()) {
            pieces[index++] = tk.nextToken();
        }
        return pieces;
    }

    public void resetDefaultInstances() {
        ArrayList<IPropertySet> psets_list = new ArrayList<IPropertySet>();
        TemplateDescriptor[] types = TemplateDescriptor.getDriverTemplateDescriptors();
        XMLFileManager.setFileName("driverStorage.xml");
        if (this.mDriverInstanceMap == null) {
            this.mDriverInstanceMap = new HashMap();
            this.loadAllInstances();
        }
        IPropertySet[] psets = this.getPropertySetsFromMap();
        for (int i = 0; i < types.length; ++i) {
            TemplateDescriptor type = types[i];
            boolean alreadyExists = false;
            if (psets.length > 0) {
                for (int j = 0; j < psets.length; ++j) {
                    String category;
                    IPropertySet pset = psets[j];
                    if (pset.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType") == null || !(category = pset.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType")).equalsIgnoreCase(type.getId())) continue;
                    alreadyExists = true;
                    psets_list.add(pset);
                }
            }
            if (!type.getCreateDefaultFlag() || alreadyExists) continue;
            IPropertySet newPset = this.createDefaultInstance(type);
            this.addDriverInstance(newPset);
        }
    }

    public IPropertySet createDefaultInstance(String id) {
        TemplateDescriptor template = TemplateDescriptor.getDriverTemplateDescriptor(id);
        IPropertySet pset = this.createInstance(template);
        return pset;
    }

    private IPropertySet createInstance(TemplateDescriptor template) {
        return this.createDefaultInstance(template, true);
    }

    private IPropertySet createDefaultInstance(TemplateDescriptor template) {
        return this.createDefaultInstance(template, false);
    }

    private IPropertySet createDefaultInstance(TemplateDescriptor template, boolean override) {
        if (template != null && (template.getCreateDefaultFlag() || override)) {
            String prefix = DriverMgmtMessages.getString("NewDriverDialog.text.id_prefix");
            String suffix = DriverMgmtMessages.getString("DriverMgmtPlugin.default_instance_suffix");
            String id = prefix + template.getId();
            String name = template.getName() + " " + suffix;
            PropertySetImpl propset = new PropertySetImpl(id, template.getName());
            propset.setID(id);
            propset.setName(name);
            Properties props = new Properties();
            String jarList = this.updatePluginJarList(template);
            props.setProperty("jarList", jarList);
            props.setProperty("org.eclipse.datatools.connectivity.drivers.defnType", template.getId());
            IConfigurationElement[] templateprops = template.getProperties();
            if (props != null && templateprops.length > 0) {
                for (int i = 0; i < templateprops.length; ++i) {
                    String temp;
                    IConfigurationElement prop = templateprops[i];
                    String propid = prop.getAttribute("id");
                    String propvalue = prop.getAttribute("value");
                    OverrideTemplateDescriptor[] otds = OverrideTemplateDescriptor.getByDriverTemplate(template.getId());
                    if (otds != null && otds.length > 0 && (temp = otds[0].getPropertyValueFromId(id)) != null) {
                        propvalue = temp;
                    }
                    props.setProperty(propid, propvalue == null ? new String() : propvalue);
                }
            }
            propset.setBaseProperties(props);
            return propset;
        }
        return null;
    }

    public String updatePluginJarList(TemplateDescriptor template) {
        String jarList = template.getJarList();
        if (jarList.indexOf("[") > -1) {
            int index = jarList.indexOf("[");
            while (index > -1) {
                String toReplace = jarList.substring(index, jarList.indexOf("]", index) + 1);
                String pluginId = null;
                pluginId = toReplace.toUpperCase().equals("[PLUGIN]") ? template.getElement().getContributor().getName() : toReplace.substring(1, toReplace.length() - 1);
                String restOfPath = null;
                restOfPath = jarList.indexOf(",", index) > 0 ? jarList.substring(jarList.indexOf("]", index) + 1, jarList.indexOf(",", index)) : jarList.substring(jarList.indexOf("]", index) + 1, jarList.length());
                if (Platform.getBundle((String)pluginId) != null) {
                    String entry = File.separator + restOfPath + File.separator;
                    URL url = Platform.getBundle((String)pluginId).getEntry(entry);
                    if (url != null) {
                        try {
                            url = FileLocator.toFileURL((URL)url);
                            Path path = new Path(url.getFile());
                            int totalLength = toReplace.length() + restOfPath.length();
                            jarList = jarList.substring(0, index) + path.toOSString() + jarList.substring(index + totalLength, jarList.length());
                        }
                        catch (IOException e) {
                            Object[] strs = new String[]{pluginId + restOfPath};
                            System.err.println(DriverMgmtMessages.format("DriverMgmtPlugin.FileMissing", strs));
                            ConnectivityPlugin.getDefault().log(DriverMgmtMessages.format("DriverMgmtPlugin.FileMissing", strs));
                        }
                    } else {
                        Object[] strs = new String[]{pluginId + restOfPath};
                        String msg = DriverMgmtMessages.format("DriverMgmtPlugin.FileMissing", strs);
                        System.err.println(msg);
                        ConnectivityPlugin.getDefault().log(msg);
                    }
                } else {
                    Object[] strs = new String[]{pluginId};
                    System.err.println(DriverMgmtMessages.format("DriverMgmtPlugin.BundleMissing", strs));
                    ConnectivityPlugin.getDefault().log(DriverMgmtMessages.format("DriverMgmtPlugin.BundleMissing", strs));
                }
                if ((index = jarList.indexOf(",", index)) <= 0) continue;
                ++index;
            }
        }
        return jarList;
    }
}

