/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.dom.TypeBindingVisitor;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.TypeContextChecker;
import org.eclipse.jdt.internal.corext.refactoring.changes.CreateCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CreatePackageChange;
import org.eclipse.jdt.internal.corext.refactoring.structure.BodyUpdater;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeSignatureRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.IDefaultValueAdvisor;
import org.eclipse.jdt.internal.corext.refactoring.structure.IntroduceParameterObjectRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.ParameterObjectFactory;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.TextEdit;

public class IntroduceParameterObjectRefactoring
extends ChangeSignatureRefactoring {
    private static final String PARAMETER_CLASS_APPENDIX = "Parameter";
    private static final String DEFAULT_PARAMETER_OBJECT_NAME = "parameterObject";
    private MethodDeclaration fMethodDeclaration;
    private ICompilationUnit fCompilationUnit;
    private int fOffset;
    private int fLength;
    private ParameterObjectFactory fParameterObjectFactory;
    private boolean fCreateAsTopLevel = true;
    private ParameterInfo fParameterObjectReference;
    static /* synthetic */ Class class$0;

    private boolean isParameter(ParameterInfo pi, ASTNode node, List parameters, String qualifier) {
        if (node instanceof Name) {
            Name name = (Name)node;
            IVariableBinding binding = ASTNodes.getVariableBinding(name);
            if (binding != null && binding.isParameter()) {
                return binding.getName().equals(this.getName(pi, parameters));
            }
            if (node instanceof QualifiedName) {
                QualifiedName qn = (QualifiedName)node;
                return qn.getFullyQualifiedName().endsWith(JavaModelUtil.concatenateName(qualifier, this.getName(pi, parameters)));
            }
        }
        return false;
    }

    public IntroduceParameterObjectRefactoring(IMethod method) throws JavaModelException {
        super(method);
        if (method != null) {
            this.initializeFields(method);
        }
        this.setBodyUpdater(new RewriteParameterBody());
        this.setDefaultValueAdvisor(new RewriteArguments());
        List parameterInfos = this.getParameterInfos();
        Iterator iter = parameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo pi = (ParameterInfo)iter.next();
            if (pi.isAdded()) continue;
            pi.setCreateField(true);
            pi.setNewName(this.getFieldName(pi));
        }
    }

    public Type importBinding(ITypeBinding newTypeBinding, CompilationUnitRewrite cuRewrite) {
        Type type = cuRewrite.getImportRewrite().addImport(newTypeBinding, cuRewrite.getAST());
        cuRewrite.getImportRemover().registerAddedImports(type);
        return type;
    }

    private void initializeFields(IMethod method) throws JavaModelException {
        this.fCompilationUnit = method.getCompilationUnit();
        this.fOffset = method.getNameRange().getOffset();
        this.fLength = method.getNameRange().getLength();
        this.fParameterObjectFactory = new ParameterObjectFactory(this.fCompilationUnit);
        String methodName = method.getElementName();
        String className = String.valueOf(Character.toUpperCase(methodName.charAt(0)));
        if (methodName.length() > 1) {
            className = String.valueOf(className) + methodName.substring(1);
        }
        className = String.valueOf(className) + PARAMETER_CLASS_APPENDIX;
        this.fParameterObjectReference = ParameterInfo.createInfoForAddedParameter(className, this.getParameterName());
        this.fParameterObjectFactory.setClassName(className);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        status.merge(this.fParameterObjectFactory.checkConditions());
        status.merge(Checks.checkIdentifier(this.getParameterName()));
        if (status.hasFatalError()) {
            return status;
        }
        status.merge(super.checkFinalConditions(pm));
        return status;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        List parameterInfos;
        RefactoringStatus status = new RefactoringStatus();
        status.merge(super.checkInitialConditions(pm));
        status.merge(Checks.checkAvailability((IJavaElement)this.fCompilationUnit));
        if (status.hasFatalError()) {
            return status;
        }
        CompilationUnit astRoot = this.getBaseCuRewrite().getRoot();
        ASTNode node = NodeFinder.perform((ASTNode)astRoot, this.fOffset, this.fLength);
        if (node == null) {
            return this.mappingErrorFound(status, node);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fMethodDeclaration = (MethodDeclaration)ASTNodes.getParent(node, clazz);
        if (this.fMethodDeclaration == null) {
            return this.mappingErrorFound(status, node);
        }
        IMethodBinding resolveBinding = this.fMethodDeclaration.resolveBinding();
        if (resolveBinding == null) {
            if (!this.processCompilerError(status, node)) {
                status.addFatalError(RefactoringCoreMessages.SelfEncapsulateField_type_not_resolveable);
            }
            return status;
        }
        ITypeBinding declaringClass = resolveBinding.getDeclaringClass();
        String qualifiedName = declaringClass.getPackage().getName();
        if (this.fParameterObjectFactory.getPackage() == null) {
            this.fParameterObjectFactory.setPackage(qualifiedName);
        }
        if (this.fParameterObjectFactory.getEnclosingType() == null) {
            this.fParameterObjectFactory.setEnclosingType(declaringClass.getQualifiedName());
        }
        if (!(parameterInfos = super.getParameterInfos()).contains(this.fParameterObjectReference)) {
            parameterInfos.add(0, this.fParameterObjectReference);
        }
        List parameters = this.fMethodDeclaration.parameters();
        HashMap<String, IVariableBinding> bindingMap = new HashMap<String, IVariableBinding>();
        Iterator iter = parameters.iterator();
        while (iter.hasNext()) {
            SingleVariableDeclaration sdv = (SingleVariableDeclaration)iter.next();
            bindingMap.put(sdv.getName().getIdentifier(), sdv.resolveBinding());
        }
        iter = parameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo pi = (ParameterInfo)iter.next();
            if (pi == this.fParameterObjectReference) continue;
            pi.setOldBinding((IVariableBinding)bindingMap.get(pi.getOldName()));
        }
        this.fParameterObjectFactory.setVariables(parameterInfos);
        return status;
    }

    protected TypeContextChecker.IProblemVerifier doGetProblemVerifier() {
        return new TypeContextChecker.IProblemVerifier(){

            public boolean isError(IProblem problem, ASTNode node) {
                if (node instanceof Type) {
                    Type type = (Type)node;
                    if (problem.getID() == 0x1000002 && IntroduceParameterObjectRefactoring.this.getClassName().equals(ASTNodes.getTypeName(type))) {
                        return false;
                    }
                }
                if (node instanceof Name) {
                    Name name = (Name)node;
                    if (problem.getID() == 268435846 && IntroduceParameterObjectRefactoring.this.getPackage().indexOf(name.getFullyQualifiedName()) != -1) {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    public Change createChange(IProgressMonitor pm) {
        return super.createChange(pm);
    }

    public String getClassName() {
        String className = this.fParameterObjectFactory.getClassName();
        return className;
    }

    public ITypeBinding getContainingClass() {
        return this.fMethodDeclaration.resolveBinding().getDeclaringClass();
    }

    private String getMappingErrorMessage() {
        return Messages.format(RefactoringCoreMessages.IntroduceParameterObjectRefactoring_cannotalanyzemethod_mappingerror, new String[0]);
    }

    public String getFieldName(ParameterInfo element) {
        String paramName = element.getOldName();
        IJavaProject javaProject = this.fCompilationUnit.getJavaProject();
        String stripped = NamingConventions.removePrefixAndSuffixForArgumentName((IJavaProject)javaProject, (String)paramName);
        int dim = element.getNewTypeBinding() != null ? element.getNewTypeBinding().getDimensions() : 0;
        return StubUtility.getVariableNameSuggestions(2, javaProject, stripped, dim, null, true)[0];
    }

    public IMethodBinding getMethodBinding() {
        return this.fMethodDeclaration.resolveBinding();
    }

    public String getName() {
        return RefactoringCoreMessages.IntroduceParameterObjectRefactoring_refactoring_name;
    }

    protected String doGetRefactoringChangeName() {
        return this.getName();
    }

    public String getParameterName() {
        if (this.fParameterObjectReference == null) {
            return DEFAULT_PARAMETER_OBJECT_NAME;
        }
        return this.fParameterObjectReference.getNewName();
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        refactoringStatus.merge(super.initialize(arguments));
        return refactoringStatus;
    }

    public boolean isCreateGetter() {
        return this.fParameterObjectFactory.isCreateGetter();
    }

    public boolean isCreateSetter() {
        return this.fParameterObjectFactory.isCreateSetter();
    }

    public boolean isCreateAsTopLevel() {
        return this.fCreateAsTopLevel;
    }

    private boolean isValidField(ParameterInfo pi) {
        return pi.isCreateField() & !pi.isAdded();
    }

    private RefactoringStatus mappingErrorFound(RefactoringStatus result, ASTNode node) {
        if (node != null && (node.getFlags() & 1) != 0 && this.processCompilerError(result, node)) {
            return result;
        }
        result.addFatalError(this.getMappingErrorMessage());
        return result;
    }

    public void moveFieldDown(ParameterInfo selected) {
        this.fParameterObjectFactory.moveDown(selected);
    }

    public void moveFieldUp(ParameterInfo selected) {
        this.fParameterObjectFactory.moveUp(selected);
    }

    private boolean processCompilerError(RefactoringStatus result, ASTNode node) {
        Message[] messages = ASTNodes.getMessages(node, 2);
        if (messages.length == 0) {
            return false;
        }
        result.addFatalError(Messages.format(RefactoringCoreMessages.IntroduceParameterObjectRefactoring_cannotanalysemethod_compilererror, new String[]{messages[0].getMessage()}));
        return true;
    }

    public void setClassName(String className) {
        this.fParameterObjectFactory.setClassName(className);
        Assert.isTrue((this.fParameterObjectReference != null ? 1 : 0) != 0);
        this.fParameterObjectReference.setNewTypeName(className);
    }

    public void setCreateComments(boolean selection) {
        this.fParameterObjectFactory.setCreateComments(selection);
    }

    public void setCreateGetter(boolean createGetter) {
        this.fParameterObjectFactory.setCreateGetter(createGetter);
    }

    public void setCreateSetter(boolean createSetter) {
        this.fParameterObjectFactory.setCreateSetter(createSetter);
    }

    public void setPackageName(String packageName) {
        this.fParameterObjectFactory.setPackage(packageName);
    }

    public void setParameterName(String paramName) {
        Assert.isTrue((this.fParameterObjectReference != null ? 1 : 0) != 0);
        this.fParameterObjectReference.setNewName(paramName);
    }

    public void setCreateAsTopLevel(boolean topLevel) {
        this.fCreateAsTopLevel = topLevel;
    }

    public void updateParameterPosition() {
        this.fParameterObjectFactory.updateParameterPosition(this.fParameterObjectReference);
    }

    private void createParameterClass(MethodDeclaration methodDeclaration, TypeDeclaration parent, CompilationUnitRewrite cuRewrite) throws CoreException {
        if (this.fCreateAsTopLevel) {
            IJavaProject javaProject = this.fCompilationUnit.getJavaProject();
            IPackageFragmentRoot fragment = this.getPackageFragmentRoot();
            IPackageFragment packageFragment = fragment.getPackageFragment(this.fParameterObjectFactory.getPackage());
            if (!packageFragment.exists()) {
                this.fOtherChanges.add(new CreatePackageChange(packageFragment));
            }
            ICompilationUnit unit = packageFragment.getCompilationUnit(String.valueOf(this.fParameterObjectFactory.getClassName()) + ".java");
            ICompilationUnit workingCopy = null;
            workingCopy = unit.getWorkingCopy(null);
            try {
                String lineDelimiter = StubUtility.getLineDelimiterUsed(javaProject);
                String fileComment = this.getFileComment(workingCopy, lineDelimiter);
                String typeComment = this.getTypeComment(workingCopy, lineDelimiter);
                String content = CodeGeneration.getCompilationUnitContent(workingCopy, fileComment, typeComment, "class " + this.getClassName() + "{}", lineDelimiter);
                workingCopy.getBuffer().setContents(content);
                cuRewrite = new CompilationUnitRewrite(workingCopy);
                ASTRewrite rewriter = cuRewrite.getASTRewrite();
                CompilationUnit root = cuRewrite.getRoot();
                AST ast = cuRewrite.getAST();
                ImportRewrite importRewrite = cuRewrite.getImportRewrite();
                ListRewrite types = rewriter.getListRewrite((ASTNode)root, CompilationUnit.TYPES_PROPERTY);
                ASTNode oldType = (ASTNode)types.getOriginalList().get(0);
                TypeDeclaration classDeclaration = this.fParameterObjectFactory.createClassDeclaration(workingCopy, JavaModelUtil.concatenateName(this.fParameterObjectFactory.getPackage(), this.fParameterObjectFactory.getClassName()), cuRewrite);
                classDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
                Javadoc javadoc = (Javadoc)oldType.getStructuralProperty((StructuralPropertyDescriptor)TypeDeclaration.JAVADOC_PROPERTY);
                rewriter.set((ASTNode)classDeclaration, (StructuralPropertyDescriptor)TypeDeclaration.JAVADOC_PROPERTY, (Object)javadoc, null);
                types.replace(oldType, (ASTNode)classDeclaration, null);
                String charset = ResourceUtil.getFile(this.fCompilationUnit).getCharset(false);
                Document document = new Document(content);
                try {
                    rewriter.rewriteAST().apply((IDocument)document);
                    TextEdit rewriteImports = importRewrite.rewriteImports(null);
                    rewriteImports.apply((IDocument)document);
                }
                catch (BadLocationException e) {
                    throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), RefactoringCoreMessages.IntroduceParameterObjectRefactoring_parameter_object_creation_error, (Throwable)e));
                }
                String docContent = document.get();
                CreateCompilationUnitChange compilationUnitChange = new CreateCompilationUnitChange(unit, docContent, charset);
                this.fOtherChanges.add(compilationUnitChange);
            }
            finally {
                workingCopy.discardWorkingCopy();
            }
        }
        ASTRewrite rewriter = cuRewrite.getASTRewrite();
        ListRewrite bodyRewrite = rewriter.getListRewrite((ASTNode)parent, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
        TypeDeclaration classDeclaration = this.fParameterObjectFactory.createClassDeclaration(this.fCompilationUnit, parent.getName().getFullyQualifiedName(), cuRewrite);
        classDeclaration.modifiers().add(rewriter.getAST().newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        classDeclaration.modifiers().add(rewriter.getAST().newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        bodyRewrite.insertBefore((ASTNode)classDeclaration, (ASTNode)methodDeclaration, null);
    }

    public IPackageFragmentRoot getPackageFragmentRoot() {
        return (IPackageFragmentRoot)this.fCompilationUnit.getAncestor(3);
    }

    protected String getFileComment(ICompilationUnit parentCU, String lineDelimiter) throws CoreException {
        if (this.fParameterObjectFactory.isCreateComments()) {
            return CodeGeneration.getFileComment(parentCU, lineDelimiter);
        }
        return null;
    }

    protected String getTypeComment(ICompilationUnit parentCU, String lineDelimiter) throws CoreException {
        if (this.fParameterObjectFactory.isCreateComments()) {
            StringBuffer typeName = new StringBuffer();
            typeName.append(this.fParameterObjectFactory.getClassName());
            String[] typeParamNames = new String[]{};
            String comment = CodeGeneration.getTypeComment(parentCU, typeName.toString(), typeParamNames, lineDelimiter);
            if (comment != null && this.isValidComment(comment)) {
                return comment;
            }
        }
        return null;
    }

    private boolean isValidComment(String template) {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(template.toCharArray());
        try {
            int next = scanner.getNextToken();
            while (TokenScanner.isComment(next)) {
                next = scanner.getNextToken();
            }
            return next == 158;
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
    }

    public String getEnclosingType() {
        return this.fParameterObjectFactory.getEnclosingType();
    }

    public String getPackage() {
        return this.fParameterObjectFactory.getPackage();
    }

    public void setEnclosingType(String enclosingType) {
        this.fParameterObjectFactory.setEnclosingType(enclosingType);
    }

    public void setPackage(String typeQualifier) {
        this.fParameterObjectFactory.setPackage(typeQualifier);
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public IPackageFragment getPackageFragment() throws JavaModelException {
        return (IPackageFragment)this.fCompilationUnit.getAncestor(4);
    }

    public String getEnclosingPackage() {
        return this.fMethodDeclaration.resolveBinding().getDeclaringClass().getPackage().getName();
    }

    private Expression updateSimpleName(ASTRewrite rewriter, ParameterInfo pi, SimpleName node, boolean replaceNode, List parameters) {
        AST ast = rewriter.getAST();
        IBinding binding = node.resolveBinding();
        Expression replacementNode = this.fParameterObjectFactory.createFieldReadAccess(pi, this.getParameterName(), ast);
        if (binding instanceof IVariableBinding) {
            IVariableBinding variable = (IVariableBinding)binding;
            if (variable.isParameter() && variable.getName().equals(this.getName(pi, parameters))) {
                if (replaceNode) {
                    rewriter.replace((ASTNode)node, (ASTNode)replacementNode, null);
                }
                return replacementNode;
            }
        } else {
            ASTNode parent = node.getParent();
            if (!(parent instanceof QualifiedName) && !(parent instanceof FieldAccess) && !(parent instanceof SuperFieldAccess) && node.getIdentifier().equals(this.getName(pi, parameters))) {
                if (replaceNode) {
                    rewriter.replace((ASTNode)node, (ASTNode)replacementNode, null);
                }
                return replacementNode;
            }
        }
        return null;
    }

    private String getName(ParameterInfo pi, List parameters) {
        if (parameters != null && pi.getOldIndex() < parameters.size()) {
            SingleVariableDeclaration svd = (SingleVariableDeclaration)parameters.get(pi.getOldIndex());
            return svd.getName().getIdentifier();
        }
        return pi.getOldName();
    }

    static /* synthetic */ Expression access$6(IntroduceParameterObjectRefactoring introduceParameterObjectRefactoring, ASTRewrite aSTRewrite, ParameterInfo parameterInfo, SimpleName simpleName, boolean bl, List list) {
        return introduceParameterObjectRefactoring.updateSimpleName(aSTRewrite, parameterInfo, simpleName, bl, list);
    }

    private final class RewriteArguments
    implements IDefaultValueAdvisor {
        private RewriteArguments() {
        }

        public Expression createDefaultExpression(CompilationUnitRewrite cuRewrite, ParameterInfo info, List parameterInfos, List nodes, boolean isRecursive, MethodDeclaration caller) {
            AST ast = cuRewrite.getAST();
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            boolean allInlined = isRecursive;
            List parameters = caller == null ? null : caller.parameters();
            ArrayList<ParameterInfo> validParamters = new ArrayList<ParameterInfo>();
            ListIterator iter = parameterInfos.listIterator();
            while (iter.hasNext()) {
                ParameterInfo pi = (ParameterInfo)iter.next();
                if (!IntroduceParameterObjectRefactoring.this.isValidField(pi)) continue;
                validParamters.add(pi);
                if (pi.isInlined() && allInlined) {
                    ASTNode node = (ASTNode)nodes.get(pi.getOldIndex());
                    if (IntroduceParameterObjectRefactoring.this.isParameter(pi, node, parameters, info.getNewName())) continue;
                    allInlined = false;
                    continue;
                }
                allInlined = false;
            }
            if (allInlined) {
                return ast.newSimpleName(info.getNewName());
            }
            ClassInstanceCreation invocation = ast.newClassInstanceCreation();
            invocation.setType(IntroduceParameterObjectRefactoring.this.fParameterObjectFactory.createType(IntroduceParameterObjectRefactoring.this.fCreateAsTopLevel, cuRewrite));
            List arguments = invocation.arguments();
            Iterator iter2 = validParamters.iterator();
            while (iter2.hasNext()) {
                ParameterInfo pi = (ParameterInfo)iter2.next();
                if (pi.isOldVarargs()) {
                    this.handleVarargs(cuRewrite, nodes, ast, rewrite, arguments, iter2, pi);
                    continue;
                }
                Expression exp = (Expression)nodes.get(pi.getOldIndex());
                this.importNodeTypes((ASTNode)exp, cuRewrite);
                arguments.add(IntroduceParameterObjectRefactoring.this.moveNode((ASTNode)exp, rewrite));
            }
            return invocation;
        }

        private void handleVarargs(CompilationUnitRewrite cuRewrite, List nodes, AST ast, ASTRewrite rewrite, List arguments, Iterator iter, ParameterInfo pi) {
            ArrayCreation creation;
            ITypeBinding binding;
            ASTNode lastNode;
            boolean isEmptyVarArg = pi.getOldIndex() >= nodes.size();
            ASTNode aSTNode = lastNode = isEmptyVarArg ? null : (ASTNode)nodes.get(pi.getOldIndex());
            if (lastNode instanceof ArrayCreation && (binding = (creation = (ArrayCreation)lastNode).resolveTypeBinding()) != null && binding.isAssignmentCompatible(pi.getNewTypeBinding())) {
                arguments.add(IntroduceParameterObjectRefactoring.this.moveNode((ASTNode)creation, rewrite));
                return;
            }
            if (iter.hasNext()) {
                if (lastNode instanceof NullLiteral) {
                    NullLiteral nullLiteral = (NullLiteral)lastNode;
                    arguments.add(IntroduceParameterObjectRefactoring.this.moveNode((ASTNode)nullLiteral, rewrite));
                } else {
                    creation = ast.newArrayCreation();
                    creation.setType((ArrayType)IntroduceParameterObjectRefactoring.this.importBinding(pi.getNewTypeBinding(), cuRewrite));
                    ArrayInitializer initializer = ast.newArrayInitializer();
                    List expressions = initializer.expressions();
                    int i = pi.getOldIndex();
                    while (i < nodes.size()) {
                        ASTNode node = (ASTNode)nodes.get(i);
                        this.importNodeTypes(node, cuRewrite);
                        expressions.add(IntroduceParameterObjectRefactoring.this.moveNode(node, rewrite));
                        ++i;
                    }
                    if (expressions.size() != 0) {
                        creation.setInitializer(initializer);
                    } else {
                        creation.dimensions().add(ast.newNumberLiteral("0"));
                    }
                    arguments.add(creation);
                }
            } else {
                int i = pi.getOldIndex();
                while (i < nodes.size()) {
                    ASTNode node = (ASTNode)nodes.get(i);
                    this.importNodeTypes(node, cuRewrite);
                    arguments.add(IntroduceParameterObjectRefactoring.this.moveNode(node, rewrite));
                    ++i;
                }
            }
        }

        private void importNodeTypes(ASTNode node, CompilationUnitRewrite cuRewrite) {
            ASTResolving.visitAllBindings(node, new TypeBindingVisitor(this, cuRewrite){
                final /* synthetic */ RewriteArguments this$1;
                private final /* synthetic */ CompilationUnitRewrite val$cuRewrite;
                {
                    this.this$1 = rewriteArguments;
                    this.val$cuRewrite = compilationUnitRewrite;
                }

                public boolean visit(ITypeBinding nodeBinding) {
                    Type type = this.val$cuRewrite.getImportRewrite().addImport(nodeBinding, this.val$cuRewrite.getAST());
                    this.val$cuRewrite.getImportRemover().registerAddedImports(type);
                    return false;
                }
            });
        }
    }

    private final class RewriteParameterBody
    extends BodyUpdater {
        private boolean fParameterClassCreated = false;

        private RewriteParameterBody() {
        }

        private boolean isReadOnly(ParameterInfo pi, Block block, List parameters, String qualifier) {
            class NotWrittenDetector
            extends ASTVisitor {
                boolean notWritten;
                final /* synthetic */ RewriteParameterBody this$1;
                private final /* synthetic */ ParameterInfo val$pi;
                private final /* synthetic */ List val$parameters;
                private final /* synthetic */ String val$qualifier;

                NotWrittenDetector(RewriteParameterBody rewriteParameterBody, ParameterInfo parameterInfo, List list, String string) {
                    this.this$1 = rewriteParameterBody;
                    this.val$pi = parameterInfo;
                    this.val$parameters = list;
                    this.val$qualifier = string;
                    this.notWritten = true;
                }

                public boolean visit(SimpleName node) {
                    if (IntroduceParameterObjectRefactoring.access$1(RewriteParameterBody.access$1(this.this$1), this.val$pi, (ASTNode)node, this.val$parameters, this.val$qualifier) && ASTResolving.isWriteAccess((Name)node)) {
                        this.notWritten = false;
                    }
                    return false;
                }

                public boolean visit(SuperFieldAccess node) {
                    return false;
                }
            }
            NotWrittenDetector visitor = new NotWrittenDetector(this, pi, parameters, qualifier);
            block.accept((ASTVisitor)visitor);
            return visitor.notWritten;
        }

        public boolean needsParameterUsedCheck() {
            return false;
        }

        public void updateBody(MethodDeclaration methodDeclaration, CompilationUnitRewrite cuRewrite, RefactoringStatus result) throws CoreException {
            ASTRewrite rewriter = cuRewrite.getASTRewrite();
            IntroduceParameterObjectRefactoring.this.fParameterObjectFactory.createType(IntroduceParameterObjectRefactoring.this.fCreateAsTopLevel, cuRewrite);
            TypeDeclaration parent = (TypeDeclaration)methodDeclaration.getParent();
            if (cuRewrite.getCu().equals(IntroduceParameterObjectRefactoring.this.fCompilationUnit) && !this.fParameterClassCreated) {
                IntroduceParameterObjectRefactoring.this.createParameterClass(methodDeclaration, parent, cuRewrite);
                this.fParameterClassCreated = true;
            }
            Block body = methodDeclaration.getBody();
            List parameters = methodDeclaration.parameters();
            if (body != null) {
                ListRewrite block = rewriter.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY);
                List managedParams = IntroduceParameterObjectRefactoring.this.getParameterInfos();
                Iterator iter = managedParams.iterator();
                while (iter.hasNext()) {
                    ParameterInfo pi = (ParameterInfo)iter.next();
                    if (!IntroduceParameterObjectRefactoring.this.isValidField(pi)) continue;
                    if (this.isReadOnly(pi, body, parameters, null)) {
                        body.accept(new ASTVisitor(this, false, rewriter, pi, parameters){
                            final /* synthetic */ RewriteParameterBody this$1;
                            private final /* synthetic */ ASTRewrite val$rewriter;
                            private final /* synthetic */ ParameterInfo val$pi;
                            private final /* synthetic */ List val$parameters;
                            {
                                this.this$1 = rewriteParameterBody;
                                this.val$rewriter = aSTRewrite;
                                this.val$pi = parameterInfo;
                                this.val$parameters = list;
                            }

                            public boolean visit(SimpleName node) {
                                IntroduceParameterObjectRefactoring.access$6(RewriteParameterBody.access$1(this.this$1), this.val$rewriter, this.val$pi, node, true, this.val$parameters);
                                return false;
                            }
                        });
                        pi.setInlined(true);
                        continue;
                    }
                    ExpressionStatement initializer = IntroduceParameterObjectRefactoring.this.fParameterObjectFactory.createInitializer(pi, IntroduceParameterObjectRefactoring.this.getParameterName(), cuRewrite);
                    block.insertFirst((ASTNode)initializer, null);
                }
            }
        }

        static /* synthetic */ IntroduceParameterObjectRefactoring access$1(RewriteParameterBody rewriteParameterBody) {
            return rewriteParameterBody.IntroduceParameterObjectRefactoring.this;
        }
    }
}

