/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;

public class IntroduceParameterObjectAction
extends SelectionDispatchAction {
    public static final String ACTION_ID = "org.eclipse.jdt.ui.actions.IntroduceParameterObject";
    public static final String ACTION_DEFINITION_ID = "org.eclipse.jdt.ui.refactoring.introduceparamobject";
    private JavaEditor fEditor;

    public IntroduceParameterObjectAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(true);
    }

    public IntroduceParameterObjectAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.IntroduceParameterObjectAction_action_text);
    }

    public void selectionChanged(IStructuredSelection selection) {
        block2: {
            try {
                this.setEnabled(RefactoringAvailabilityTester.isIntroduceParameterObjectAvailable(selection));
            }
            catch (JavaModelException e) {
                if (!JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) break block2;
                JavaPlugin.log(e);
            }
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isIntroduceParameterObjectAvailable(selection));
        }
        catch (Exception exception) {
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection selection) {
        try {
            Assert.isTrue((boolean)RefactoringAvailabilityTester.isIntroduceParameterObjectAvailable(selection));
            Object first = selection.getFirstElement();
            Assert.isTrue((boolean)(first instanceof IMethod));
            this.run((IMethod)first);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, ActionMessages.IntroduceParameterObjectAction_exceptiondialog_title, ActionMessages.IntroduceParameterObjectAction_unexpected_exception);
        }
    }

    public void run(ITextSelection selection) {
        try {
            IJavaElement editorInput = SelectionConverter.getInput(this.fEditor);
            if (editorInput instanceof ICompilationUnit) {
                this.run(selection.getOffset(), selection.getLength(), (ICompilationUnit)editorInput);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.IntroduceParameterObjectAction_exceptiondialog_title, ActionMessages.IntroduceParameterObjectAction_unexpected_exception);
        }
    }

    private void run(int offset, int length, ICompilationUnit unit) throws CoreException {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)unit)) {
            return;
        }
        RefactoringExecutionStarter.startIntroduceParameterObject(unit, offset, length, this.getShell());
    }

    private void run(IMethod method) throws CoreException {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)method)) {
            return;
        }
        RefactoringExecutionStarter.startIntroduceParameterObject(method, this.getShell());
    }
}

