/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.celleditor.FeatureEditorDialog;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.edit.ui.provider.InputDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class PropertyDescriptor
implements IPropertyDescriptor {
    protected Object object;
    protected IItemPropertyDescriptor itemPropertyDescriptor;
    protected static final EcorePackage ecorePackage = EcorePackage.eINSTANCE;

    public PropertyDescriptor(Object object, IItemPropertyDescriptor itemPropertyDescriptor) {
        this.object = object;
        this.itemPropertyDescriptor = itemPropertyDescriptor;
    }

    public String getCategory() {
        return this.itemPropertyDescriptor.getCategory(this.object);
    }

    public String getDescription() {
        return this.itemPropertyDescriptor.getDescription(this.object);
    }

    public String getDisplayName() {
        return this.itemPropertyDescriptor.getDisplayName(this.object);
    }

    public String[] getFilterFlags() {
        return this.itemPropertyDescriptor.getFilterFlags(this.object);
    }

    public Object getHelpContextIds() {
        return this.itemPropertyDescriptor.getHelpContextIds(this.object);
    }

    public Object getId() {
        return this.itemPropertyDescriptor.getId(this.object);
    }

    public ILabelProvider getLabelProvider() {
        final IItemLabelProvider itemLabelProvider = this.itemPropertyDescriptor.getLabelProvider(this.object);
        return new LabelProvider(){

            public String getText(Object object) {
                return itemLabelProvider.getText(object);
            }

            public Image getImage(Object object) {
                return ExtendedImageRegistry.getInstance().getImage(itemLabelProvider.getImage(object));
            }
        };
    }

    protected ILabelProvider getEditLabelProvider() {
        return this.getLabelProvider();
    }

    public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
        return false;
    }

    protected CellEditor createEDataTypeCellEditor(EDataType eDataType, Composite composite) {
        if (this.itemPropertyDescriptor.isMultiLine(this.object)) {
            return new ExtendedDialogCellEditor(composite, this.getEditLabelProvider(), eDataType){
                protected EDataTypeValueHandler valueHandler;
                {
                    this.valueHandler = new EDataTypeValueHandler(eDataType);
                }

                protected Object openDialogBox(Control cellEditorWindow) {
                    MultiLineInputDialog dialog = new MultiLineInputDialog(cellEditorWindow.getShell(), EMFEditUIPlugin.INSTANCE.getString("_UI_FeatureEditorDialog_title", new Object[]{PropertyDescriptor.this.getDisplayName(), PropertyDescriptor.this.getEditLabelProvider().getText(PropertyDescriptor.this.object)}), EMFEditUIPlugin.INSTANCE.getString("_UI_MultiLineInputDialog_message"), this.valueHandler.toString(this.getValue()), this.valueHandler);
                    return dialog.open() == 0 ? this.valueHandler.toValue(dialog.getValue()) : null;
                }
            };
        }
        return new EDataTypeCellEditor(eDataType, composite);
    }

    public CellEditor createPropertyEditor(Composite composite) {
        if (!this.itemPropertyDescriptor.canSetProperty(this.object)) {
            return null;
        }
        Object result = null;
        Object genericFeature = this.itemPropertyDescriptor.getFeature(this.object);
        if (genericFeature instanceof EReference[]) {
            result = new ExtendedComboBoxCellEditor(composite, new ArrayList(this.itemPropertyDescriptor.getChoiceOfValues(this.object)), this.getEditLabelProvider(), this.itemPropertyDescriptor.isSortChoices(this.object));
        } else if (genericFeature instanceof EStructuralFeature) {
            EDataType eDataType;
            final EStructuralFeature feature = (EStructuralFeature)genericFeature;
            EClassifier eType = feature.getEType();
            final Collection choiceOfValues = this.itemPropertyDescriptor.getChoiceOfValues(this.object);
            if (choiceOfValues != null) {
                if (this.itemPropertyDescriptor.isMany(this.object)) {
                    boolean valid = true;
                    for (Object choice : choiceOfValues) {
                        if (eType.isInstance(choice)) continue;
                        valid = false;
                        break;
                    }
                    if (valid) {
                        result = new ExtendedDialogCellEditor(composite, this.getEditLabelProvider()){

                            protected Object openDialogBox(Control cellEditorWindow) {
                                FeatureEditorDialog dialog = new FeatureEditorDialog(cellEditorWindow.getShell(), PropertyDescriptor.this.getEditLabelProvider(), PropertyDescriptor.this.object, feature.getEType(), (List)((IItemPropertySource)PropertyDescriptor.this.itemPropertyDescriptor.getPropertyValue(PropertyDescriptor.this.object)).getEditableValue(PropertyDescriptor.this.object), PropertyDescriptor.this.getDisplayName(), new ArrayList(choiceOfValues), false, PropertyDescriptor.this.itemPropertyDescriptor.isSortChoices(PropertyDescriptor.this.object));
                                dialog.open();
                                return dialog.getResult();
                            }
                        };
                    }
                }
                if (result == null) {
                    result = new ExtendedComboBoxCellEditor(composite, new ArrayList(choiceOfValues), this.getEditLabelProvider(), this.itemPropertyDescriptor.isSortChoices(this.object));
                }
            } else if (eType instanceof EDataType && (eDataType = (EDataType)eType).isSerializable()) {
                result = this.itemPropertyDescriptor.isMany(this.object) ? new ExtendedDialogCellEditor(composite, this.getEditLabelProvider()){

                    protected Object openDialogBox(Control cellEditorWindow) {
                        FeatureEditorDialog dialog = new FeatureEditorDialog(cellEditorWindow.getShell(), PropertyDescriptor.this.getEditLabelProvider(), PropertyDescriptor.this.object, feature.getEType(), (List)((IItemPropertySource)PropertyDescriptor.this.itemPropertyDescriptor.getPropertyValue(PropertyDescriptor.this.object)).getEditableValue(PropertyDescriptor.this.object), PropertyDescriptor.this.getDisplayName(), null, PropertyDescriptor.this.itemPropertyDescriptor.isMultiLine(PropertyDescriptor.this.object), false);
                        dialog.open();
                        return dialog.getResult();
                    }
                } : (eDataType.getInstanceClass() == Boolean.class || eDataType.getInstanceClass() == Boolean.TYPE ? new ExtendedComboBoxCellEditor(composite, Arrays.asList(Boolean.FALSE, Boolean.TRUE), this.getEditLabelProvider(), this.itemPropertyDescriptor.isSortChoices(this.object)) : this.createEDataTypeCellEditor(eDataType, composite));
            }
        }
        return result;
    }

    protected static class EDataTypeValueHandler
    implements ICellEditorValidator,
    IInputValidator {
        protected EDataType eDataType;

        public EDataTypeValueHandler(EDataType eDataType) {
            this.eDataType = eDataType;
        }

        public String isValid(Object object) {
            Object value;
            try {
                value = this.eDataType.getEPackage().getEFactoryInstance().createFromString(this.eDataType, (String)object);
            }
            catch (Exception exception) {
                String message = exception.getClass().getName();
                int index = message.lastIndexOf(46);
                if (index >= 0) {
                    message = message.substring(index + 1);
                }
                if (exception.getLocalizedMessage() != null) {
                    message = String.valueOf(message) + ": " + exception.getLocalizedMessage();
                }
                return message;
            }
            Diagnostic diagnostic = Diagnostician.INSTANCE.validate(this.eDataType, value);
            if (diagnostic.getSeverity() == 0) {
                return null;
            }
            return ((Diagnostic)diagnostic.getChildren().get(0)).getMessage().replaceAll("'", "''").replaceAll("\\{", "'{'");
        }

        public String isValid(String text) {
            return this.isValid((Object)text);
        }

        public Object toValue(String string) {
            return EcoreUtil.createFromString((EDataType)this.eDataType, (String)string);
        }

        public String toString(Object value) {
            String result = EcoreUtil.convertToString((EDataType)this.eDataType, (Object)value);
            return result == null ? "" : result;
        }
    }

    public static class EDataTypeCellEditor
    extends TextCellEditor {
        protected EDataType eDataType;
        protected EDataTypeValueHandler valueHandler;
        protected boolean validateAsValue = true;

        public EDataTypeCellEditor(EDataType eDataType, Composite parent) {
            super(parent);
            this.eDataType = eDataType;
            this.valueHandler = new EDataTypeValueHandler(eDataType);
            this.setValidator(this.valueHandler);
        }

        public Object doGetValue() {
            return this.valueHandler.toValue((String)super.doGetValue());
        }

        public void doSetValue(Object value) {
            value = this.valueHandler.toString(value);
            super.doSetValue(value);
        }

        protected void editOccured(ModifyEvent e) {
            this.validateAsValue = false;
            super.editOccured(e);
            this.validateAsValue = true;
        }

        protected boolean isCorrect(Object value) {
            if (this.validateAsValue) {
                value = this.valueHandler.toString(value);
            }
            return super.isCorrect(value);
        }
    }

    private static class MultiLineInputDialog
    extends InputDialog {
        public MultiLineInputDialog(Shell parentShell, String title, String message, String initialValue, IInputValidator validator) {
            super(parentShell, title, message, initialValue, validator);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        protected Text createText(Composite composite) {
            Text text = new Text(composite, 2818);
            GridData data = new GridData(1808);
            data.heightHint = 5 * text.getLineHeight();
            data.widthHint = this.convertHorizontalDLUsToPixels(200);
            text.setLayoutData((Object)data);
            return text;
        }
    }

    @Deprecated
    public static class IntegerCellEditor
    extends TextCellEditor {
        public IntegerCellEditor(Composite composite) {
            super(composite);
            this.setValidator(new ICellEditorValidator(){

                public String isValid(Object object) {
                    if (object instanceof Integer) {
                        return null;
                    }
                    String string = (String)object;
                    try {
                        Integer.parseInt(string);
                        return null;
                    }
                    catch (NumberFormatException exception) {
                        return exception.getMessage();
                    }
                }
            });
        }

        public Object doGetValue() {
            return new Integer(Integer.parseInt((String)super.doGetValue()));
        }

        public void doSetValue(Object value) {
            super.doSetValue((Object)value.toString());
        }
    }

    @Deprecated
    public static class FloatCellEditor
    extends TextCellEditor {
        public FloatCellEditor(Composite composite) {
            super(composite);
            this.setValidator(new ICellEditorValidator(){

                public String isValid(Object object) {
                    if (object instanceof Float) {
                        return null;
                    }
                    String string = (String)object;
                    try {
                        Float.parseFloat(string);
                        return null;
                    }
                    catch (NumberFormatException exception) {
                        return exception.getMessage();
                    }
                }
            });
        }

        public Object doGetValue() {
            return new Float(Float.parseFloat((String)super.doGetValue()));
        }

        public void doSetValue(Object value) {
            super.doSetValue((Object)value.toString());
        }
    }
}

