/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers.content.impl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentService;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.services.IVirtualNodeServiceFactory;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.virtual.IKnownConnectionNode;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObjectListener;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.providers.content.virtual.VirtualNode;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import org.eclipse.datatools.connectivity.sqm.core.ui.services.IDataToolsUIServiceManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.ServerExplorerViewer;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.content.ServerExplorerInitializer;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers.ServerExplorerManager;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers.content.layout.IServerExplorerLayoutProviderNav;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers.content.layout.hierar.ServerExplorerHierarchicalLayoutNav;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers.content.layout.vnode.ServerExplorerVirtualNodeLayoutNav;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.layout.IServerExplorerLayoutExtensionProvider;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServerExplorerContentService;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServerExplorerLayoutService;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServerExplorerNavigationService;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.util.TransientEObjectUtil;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.util.resources.ResourceLoader;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.TreeItem;

public class ServerExplorerContentProviderNav
implements IServerExplorerContentService,
IServerExplorerLayoutService,
IServerExplorerNavigationService,
ICatalogObjectListener {
    private static final ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
    private static final ResourceLoader resourceLoader = ResourceLoader.INSTANCE;
    private static final Object[] EMPTY_ELEMENT_ARRAY = new Object[0];
    private static final String KNOWN_SERVERS = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.KNOWN_SERVERS");
    private static final IVirtualNodeServiceFactory virtualNodeFactory = IDataToolsUIServiceManager.INSTANCE.getVirtualNodeServiceFactory();
    private IKnownConnectionNode knownServer;
    private IServerExplorerLayoutProviderNav layoutProvider = new ServerExplorerVirtualNodeLayoutNav(this);
    private TreeViewer viewer;
    private List layoutProvidersExtensionList = new LinkedList();

    private void initializeServerExplorer() {
        this.knownServer = virtualNodeFactory.makeKnownConnectionNode(KNOWN_SERVERS, KNOWN_SERVERS, null);
        ServerExplorerManager.INSTANCE.setRootKnownServerNode(this.knownServer);
        ServerExplorerManager.INSTANCE.setServerExplorerService(this);
        new ServerExplorerInitializer().loadLocalRegisteredDatabases();
        this.layoutProvider.initializeKnownServers(this.knownServer);
    }

    private void initializeLayoutExtensionProviders() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.datatools.connectivity.sqm.server.ui", "serverExplorerLayoutExtension");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                try {
                    IServerExplorerLayoutExtensionProvider layout = (IServerExplorerLayoutExtensionProvider)configElements[j].createExecutableExtension("class");
                    layout.enableLayout(this.isVirtualNodeLayoutSelected() ? IServerExplorerLayoutExtensionProvider.Layout.VNODE : IServerExplorerLayoutExtensionProvider.Layout.HIERARCHICAL);
                    this.layoutProvidersExtensionList.add(layout);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
    }

    private void removeServerConnection(IConnectionNode server) {
        server.shouldDisconnect(true);
    }

    private IConnectionNode[] getServers(boolean connected) {
        LinkedList<IConnectionNode> connectedServers = new LinkedList<IConnectionNode>();
        int i = 0;
        int n = this.knownServer.getChildrenArray().length;
        while (i < n) {
            IConnectionNode server = (IConnectionNode)this.knownServer.getChildrenArray()[i];
            if (server.isConnected() == connected) {
                connectedServers.add(server);
            }
            ++i;
        }
        return connectedServers.toArray(new IConnectionNode[connectedServers.size()]);
    }

    private TreeViewer getViewer() {
        return this.viewer;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof TreeViewer && this.viewer == null) {
            this.viewer = (TreeViewer)viewer;
            this.enableVirtualNodeLayout();
            RefreshManager.getInstance().AddListener(null, (ICatalogObjectListener)this);
        }
    }

    public void notifyChanged(final ICatalogObject dmElement, int eventType) {
        if (eventType == 0 && this.viewer != null) {
            this.viewer.getControl().getDisplay().syncExec(new Runnable(){

                public void run() {
                    ServerExplorerContentProviderNav.this.viewer.refresh((Object)dmElement, true);
                }
            });
        }
    }

    public boolean isServerExplorerViewer() {
        return this.viewer != null;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ConnectionInfo) {
            return new Object[]{((ConnectionInfo)parentElement).getSharedDatabase()};
        }
        if (parentElement instanceof VirtualNode && ((IVirtualNode)parentElement).hasChildren()) {
            if (parentElement instanceof IConnectionNode && ((IConnectionNode)parentElement).shouldDisconnect()) {
                ((IConnectionNode)parentElement).setConnected(false);
                return EMPTY_ELEMENT_ARRAY;
            }
            return ((IVirtualNode)parentElement).getChildrenArray();
        }
        Object[] children = this.layoutProvider.getChildren(parentElement);
        return children;
    }

    public Object getParent(Object element) {
        if (this.isServerExplorerViewer()) {
            if (element instanceof IWorkspaceRoot) {
                return this.knownServer;
            }
            Object result = null;
            Object object = result != null ? result : (result = element instanceof IVirtualNode ? ((IVirtualNode)element).getParent() : null);
            result = result != null ? result : (element instanceof EObject ? containmentService.getContainer((EObject)element) : null);
            return result;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IConnectionProfile) {
            return ((IConnectionProfile)element).getConnectionState() != 0;
        }
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        RefreshManager.getInstance().removeListener(null, (ICatalogObjectListener)this);
    }

    public void addNode(Object newNode) {
        this.addNode(ResourcesPlugin.getWorkspace().getRoot(), newNode);
    }

    public void addNode(Object parentNode, Object newNode) {
    }

    public void addKnownServer(Object server) {
        IConnectionNode serverNode = (IConnectionNode)server;
        serverNode.setConnected(true);
        this.knownServer.addChildren((Object)serverNode);
        this.addNode(this.getKnownServerNode(), serverNode);
    }

    public void addProxyNode(Object parentNode) {
    }

    private boolean isSupported(Object parent, Object child) {
        if (parent instanceof IVirtualNode && child instanceof EObject) {
            String groupID = containmentService.getGroupId((EObject)child);
            return groupID != null && groupID.equals(((IVirtualNode)parent).getGroupID());
        }
        if (parent instanceof EObject) {
            boolean cfr_ignored_0 = child instanceof IVirtualNode;
        }
        return false;
    }

    private void loadChilds(ServerExplorerViewer viewer, Object parent) {
    }

    private Object getVirtualNode(ServerExplorerViewer viewer, Object parent, String groupID) {
        if (parent != null) {
            if (parent instanceof IConnectionNode) {
                return parent;
            }
            TreeItem[] items = viewer.getServerExplorerChildren(parent);
            if (items.length != 0) {
                int i = 0;
                int n = items.length;
                while (i < n) {
                    TreeItem child = items[i];
                    Object childNode = child.getData();
                    if (childNode instanceof IVirtualNode && ((IVirtualNode)childNode).getGroupID().equals(groupID)) {
                        return (IVirtualNode)child.getData();
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private Object getEObjectNode(ServerExplorerViewer viewer, Object parent, String name) {
        TreeItem[] items;
        if (parent != null && (items = viewer.getServerExplorerChildren(parent)).length != 0) {
            int i = 0;
            int n = items.length;
            while (i < n) {
                TreeItem child = items[i];
                Object childNode = child.getData();
                if (childNode instanceof ENamedElement && ((ENamedElement)childNode).getName().equals(name)) {
                    return childNode;
                }
                ++i;
            }
        }
        return null;
    }

    public void expandNode(EObject eObject) {
        try {
            this.expandNode(TransientEObjectUtil.getEObjectId(eObject));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void selectAndReveal(ISelection selection) {
    }

    public void expandNode(String pathToNavigate) {
    }

    public IServerExplorerLayoutService getServerExplorerLayoutService() {
        return this;
    }

    public void refreshServerExplorer() {
    }

    public void updateLayout() {
    }

    public void refreshNode(Object node) {
    }

    public void collapseAll() {
    }

    public IConnectionNode[] getAllConnectedServers() {
        return this.getServers(true);
    }

    public IConnectionNode[] getAllDisconnectedServers() {
        return this.getServers(false);
    }

    public void disconnectServers(IConnectionNode[] servers) {
        int i = 0;
        int n = servers.length;
        while (i < n) {
            this.removeServerConnection(servers[i]);
            this.refreshNode(servers[i]);
            ++i;
        }
    }

    public void connectServer(Object server) {
        IConnectionNode serverNode = (IConnectionNode)server;
        this.refreshNode(serverNode);
    }

    public void enableVirtualNodeLayout() {
        this.layoutProvider = new ServerExplorerVirtualNodeLayoutNav(this);
        Iterator iterator = this.layoutProvidersExtensionList.iterator();
        while (iterator.hasNext()) {
            ((IServerExplorerLayoutExtensionProvider)iterator.next()).enableLayout(IServerExplorerLayoutExtensionProvider.Layout.VNODE);
        }
    }

    public void enableHierarchicalLayout() {
        this.layoutProvider = new ServerExplorerHierarchicalLayoutNav(this);
        Iterator iterator = this.layoutProvidersExtensionList.iterator();
        while (iterator.hasNext()) {
            ((IServerExplorerLayoutExtensionProvider)iterator.next()).enableLayout(IServerExplorerLayoutExtensionProvider.Layout.HIERARCHICAL);
        }
    }

    public boolean isVirtualNodeLayoutSelected() {
        return this.layoutProvider instanceof ServerExplorerVirtualNodeLayoutNav;
    }

    public boolean isHierarchicalLayoutSelected() {
        return this.layoutProvider instanceof ServerExplorerHierarchicalLayoutNav;
    }

    public IKnownConnectionNode getKnownServerNode() {
        return this.knownServer;
    }

    public void deleteServer(IConnectionNode[] servers) {
    }

    public void reconnectServer(IConnectionNode[] servers) {
    }

    public void removeNode(Object removedChild) {
    }

    public void removeNode(Object parent, Object removedChild) {
    }

    public Object[] getServerExplorerObjectsByType(ConnectionInfo info, Class type) {
        Database database = info.getSharedDatabase();
        return this.getServerExplorerObjectsByType(database, type);
    }

    public Object[] getServerExplorerObjectsByType(Object parent, Class type) {
        return new Object[0];
    }

    public void expandNode(Object node, int depth) {
    }

    public void updateSelection(ISelection selection) {
        this.viewer.setSelection(selection, true);
    }

    public void init(Object oldInput, Object newInput) {
    }
}

