/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.net;

import java.net.Authenticator;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.internal.net.Activator;
import org.eclipse.core.internal.net.ProxyChangeEvent;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.internal.net.ProxyType;
import org.eclipse.core.internal.net.StringMatcher;
import org.eclipse.core.net.proxy.IProxyChangeEvent;
import org.eclipse.core.net.proxy.IProxyChangeListener;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ProxyManager
implements IProxyService,
IEclipsePreferences.IPreferenceChangeListener {
    private static final String PREF_HAS_MIGRATED = "org.eclipse.core.net.hasMigrated";
    private static String HTTP_PROXY_HOST = "org.eclipse.update.core.proxy.host";
    private static String HTTP_PROXY_PORT = "org.eclipse.update.core.proxy.port";
    private static String HTTP_PROXY_ENABLE = "org.eclipse.update.core.proxy.enable";
    private static final String PREF_NON_PROXIED_HOSTS = "nonProxiedHosts";
    private static final String PREF_ENABLED = "proxiesEnabled";
    private static IProxyService proxyManager;
    ListenerList listeners = new ListenerList(1);
    private String[] nonProxiedHosts;
    private final ProxyType[] proxies = new ProxyType[]{new ProxyType("HTTP"), new ProxyType("HTTPS"), new ProxyType("SOCKS")};

    public static synchronized IProxyService getProxyManager() {
        if (proxyManager == null) {
            proxyManager = new ProxyManager();
        }
        return proxyManager;
    }

    public void addProxyChangeListener(IProxyChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeProxyChangeListener(IProxyChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void fireChange(final IProxyChangeEvent event) {
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            final IProxyChangeListener listener = (IProxyChangeListener)l[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.proxyInfoChanged(event);
                }

                public void handleException(Throwable exception) {
                }
            });
            ++i;
        }
    }

    public synchronized String[] getNonProxiedHosts() {
        if (this.nonProxiedHosts == null) {
            String prop = Activator.getInstance().getInstancePreferences().get(PREF_NON_PROXIED_HOSTS, "localhost|127.0.0.1");
            this.nonProxiedHosts = ProxyType.convertPropertyStringToHosts(prop);
        }
        if (this.nonProxiedHosts.length == 0) {
            return this.nonProxiedHosts;
        }
        String[] result = new String[this.nonProxiedHosts.length];
        System.arraycopy(this.nonProxiedHosts, 0, result, 0, this.nonProxiedHosts.length);
        return result;
    }

    public void setNonProxiedHosts(String[] hosts) {
        Assert.isNotNull((Object)hosts);
        int i = 0;
        while (i < hosts.length) {
            String host = hosts[i];
            Assert.isNotNull((Object)host);
            Assert.isTrue((host.length() > 0 ? 1 : 0) != 0);
            ++i;
        }
        String[] oldHosts = this.nonProxiedHosts;
        this.nonProxiedHosts = hosts;
        Activator.getInstance().getInstancePreferences().put(PREF_NON_PROXIED_HOSTS, ProxyType.convertHostsToPropertyString(this.nonProxiedHosts));
        try {
            Activator.getInstance().getInstancePreferences().flush();
        }
        catch (BackingStoreException e) {
            Activator.logError("An error occurred while writing out the non-proxied hosts list", e);
        }
        IProxyData[] data = this.getProxyData();
        ProxyChangeEvent event = new ProxyChangeEvent(1, oldHosts, this.getNonProxiedHosts(), data, new IProxyData[0]);
        this.fireChange(event);
    }

    public IProxyData[] getProxyData() {
        IProxyData[] result = new IProxyData[this.proxies.length];
        int i = 0;
        while (i < this.proxies.length) {
            ProxyType type = this.proxies[i];
            result[i] = type.getProxyData(ProxyType.VERIFY_EQUAL);
            ++i;
        }
        return result;
    }

    public void setProxyData(IProxyData[] proxies) {
        this.doSetProxyData(proxies);
    }

    private void doSetProxyData(IProxyData[] proxyDatas) {
        IProxyData[] oldData = this.getProxyData();
        String[] hosts = this.getNonProxiedHosts();
        IProxyData[] changedProxies = this.internalSetProxyData(proxyDatas);
        if (changedProxies.length > 0) {
            ProxyChangeEvent event = new ProxyChangeEvent(3, hosts, hosts, oldData, changedProxies);
            this.fireChange(event);
        }
    }

    private IProxyData[] internalSetProxyData(IProxyData[] proxyDatas) {
        ArrayList<IProxyData> result = new ArrayList<IProxyData>();
        int i = 0;
        while (i < proxyDatas.length) {
            IProxyData proxyData = proxyDatas[i];
            ProxyType type = this.getType(proxyData);
            if (type != null && type.setProxyData(proxyData, this.isProxiesEnabled())) {
                result.add(proxyData);
            }
            ++i;
        }
        return result.toArray(new IProxyData[result.size()]);
    }

    private ProxyType getType(IProxyData proxyData) {
        int i = 0;
        while (i < this.proxies.length) {
            ProxyType type = this.proxies[i];
            if (type.getName().equals(proxyData.getType())) {
                return type;
            }
            ++i;
        }
        return null;
    }

    public boolean isProxiesEnabled() {
        return Activator.getInstance().getInstancePreferences().getBoolean(PREF_ENABLED, false);
    }

    public void setProxiesEnabled(boolean enabled) {
        boolean current = this.isProxiesEnabled();
        if (current == enabled) {
            return;
        }
        Activator.getInstance().getInstancePreferences().putBoolean(PREF_ENABLED, enabled);
    }

    private void internalSetEnabled(boolean enabled) {
        Properties sysProps = System.getProperties();
        sysProps.put("proxySet", enabled ? "true" : "false");
        this.updateSystemProperties();
        try {
            Activator.getInstance().getInstancePreferences().flush();
        }
        catch (BackingStoreException e) {
            Activator.logError("An error occurred while writing out the enablement state", e);
        }
        String[] hosts = this.getNonProxiedHosts();
        IProxyData[] data = this.getProxyData();
        ProxyChangeEvent event = new ProxyChangeEvent(2, hosts, hosts, data, data);
        this.fireChange(event);
    }

    private void updateSystemProperties() {
        int i = 0;
        while (i < this.proxies.length) {
            ProxyType type = this.proxies[i];
            type.updateSystemProperties(this.internalGetProxyData(type.getName(), ProxyType.DO_NOT_VERIFY), this.isProxiesEnabled());
            ++i;
        }
    }

    public void initialize() {
        this.migrateUpdateHttpProxy((Preferences)new InstanceScope().getNode(""));
        ((IEclipsePreferences)Activator.getInstance().getInstancePreferences()).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        int i = 0;
        while (i < this.proxies.length) {
            ProxyType type = this.proxies[i];
            type.initialize(this.isProxiesEnabled());
            ++i;
        }
        this.registerAuthenticator();
    }

    public IProxyData getProxyData(String type) {
        return this.internalGetProxyData(type, ProxyType.VERIFY_EQUAL);
    }

    private IProxyData internalGetProxyData(String type, int verifySystemProperties) {
        int i = 0;
        while (i < this.proxies.length) {
            ProxyType pt = this.proxies[i];
            if (pt.getName().equals(type)) {
                return pt.getProxyData(verifySystemProperties);
            }
            ++i;
        }
        return null;
    }

    public IProxyData[] getProxyDataForHost(String host) {
        if (this.isHostFiltered(host)) {
            return new IProxyData[0];
        }
        IProxyData[] data = this.getProxyData();
        ArrayList<IProxyData> result = new ArrayList<IProxyData>();
        int i = 0;
        while (i < data.length) {
            IProxyData proxyData = data[i];
            if (proxyData.getHost() != null) {
                result.add(proxyData);
            }
            ++i;
        }
        return result.toArray(new IProxyData[result.size()]);
    }

    private boolean isHostFiltered(String host) {
        String[] filters = this.getNonProxiedHosts();
        int i = 0;
        while (i < filters.length) {
            String filter = filters[i];
            if (this.matchesFilter(host, filter)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean matchesFilter(String host, String filter) {
        StringMatcher matcher = new StringMatcher(filter, false, false);
        return matcher.match(host);
    }

    public IProxyData getProxyDataForHost(String host, String type) {
        IProxyData[] data = this.getProxyDataForHost(host);
        int i = 0;
        while (i < data.length) {
            IProxyData proxyData = data[i];
            if (proxyData.getType().equals(type) && proxyData.getHost() != null) {
                return proxyData;
            }
            ++i;
        }
        return null;
    }

    private void registerAuthenticator() {
        Authenticator a = this.getPluggedInAuthenticator();
        if (a != null) {
            Authenticator.setDefault(a);
        }
    }

    private Authenticator getPluggedInAuthenticator() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.net", "authenticator").getExtensions();
        if (extensions.length == 0) {
            return null;
        }
        IExtension extension = extensions[0];
        IConfigurationElement[] configs = extension.getConfigurationElements();
        if (configs.length == 0) {
            Activator.log(4, NLS.bind((String)"Authenticator {0} is missing required fields", (Object[])new Object[]{extension.getUniqueIdentifier()}), null);
            return null;
        }
        try {
            IConfigurationElement config = configs[0];
            return (Authenticator)config.createExecutableExtension("class");
        }
        catch (CoreException ex) {
            Activator.log(4, NLS.bind((String)"Unable to instantiate authenticator {0}", (Object[])new Object[]{extension.getUniqueIdentifier()}), ex);
            return null;
        }
    }

    void migrateUpdateHttpProxy(Preferences node) {
        Preferences netPrefs = node.node("org.eclipse.core.net");
        if (!netPrefs.getBoolean(PREF_HAS_MIGRATED, false)) {
            netPrefs.putBoolean(PREF_HAS_MIGRATED, true);
            Preferences updatePrefs = node.node("org.eclipse.update.core");
            String httpProxyHost = updatePrefs.get(HTTP_PROXY_HOST, "");
            if ("".equals(httpProxyHost)) {
                httpProxyHost = null;
            }
            updatePrefs.remove(HTTP_PROXY_HOST);
            String httpProxyPort = updatePrefs.get(HTTP_PROXY_PORT, "");
            if ("".equals(httpProxyPort)) {
                httpProxyPort = null;
            }
            int port = -1;
            if (httpProxyPort != null) {
                try {
                    port = Integer.parseInt(httpProxyPort);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            updatePrefs.remove(HTTP_PROXY_PORT);
            boolean httpProxyEnable = updatePrefs.getBoolean(HTTP_PROXY_ENABLE, false);
            updatePrefs.remove(HTTP_PROXY_ENABLE);
            if (httpProxyHost != null) {
                ProxyData proxyData = new ProxyData("HTTP", httpProxyHost, port, false);
                ProxyType type = this.getType(proxyData);
                type.updatePreferencesIfMissing(netPrefs, proxyData);
                if (httpProxyEnable) {
                    netPrefs.putBoolean(PREF_ENABLED, true);
                }
            }
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals(PREF_ENABLED)) {
            this.internalSetEnabled(Activator.getInstance().getInstancePreferences().getBoolean(PREF_ENABLED, false));
        }
    }
}

