/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.contextlaunching;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.contextlaunching.ContextMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationSelectionDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutSelectionDialog;
import org.eclipse.debug.internal.ui.stringsubstitution.SelectedResourceManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public final class ContextRunner {
    private static ContextRunner fgInstance = null;

    public static ContextRunner getDefault() {
        if (fgInstance == null) {
            fgInstance = new ContextRunner();
        }
        return fgInstance;
    }

    public void launch(ILaunchGroup group) {
        IResource resource = SelectedResourceManager.getDefault().getSelectedResource();
        if (resource != null) {
            this.selectAndLaunch(resource, group);
            return;
        }
        if (!this.launchLast(group)) {
            List shortcuts = this.getLaunchShortcutsForEmptySelection();
            if (!shortcuts.isEmpty()) {
                this.showShortcutSelectionDialog(resource, shortcuts, group.getMode());
            } else {
                MessageDialog.openInformation((Shell)DebugUIPlugin.getShell(), (String)ContextMessages.ContextRunner_0, (String)ContextMessages.ContextRunner_7);
            }
        }
    }

    protected boolean launchLast(ILaunchGroup group) {
        ILaunchConfiguration config = null;
        if (group != null) {
            config = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getFilteredLastLaunch(group.getIdentifier());
        }
        if (config != null) {
            DebugUITools.launch(config, group.getMode());
            return true;
        }
        return false;
    }

    public List getLaunchShortcutsForEmptySelection() {
        ArrayList<LaunchShortcutExtension> list = new ArrayList<LaunchShortcutExtension>();
        List sc = this.getLaunchConfigurationManager().getLaunchShortcuts();
        ArrayList ctxt = new ArrayList();
        EvaluationContext context = new EvaluationContext(null, ctxt);
        context.addVariable("selection", ctxt);
        LaunchShortcutExtension ext = null;
        Iterator iter = sc.iterator();
        while (iter.hasNext()) {
            ext = (LaunchShortcutExtension)iter.next();
            try {
                if (!ext.evalEnablementExpression((IEvaluationContext)context, ext.getContextualLaunchEnablementExpression()) || WorkbenchActivityHelper.filterItem((Object)ext) || list.contains(ext)) continue;
                list.add(ext);
            }
            catch (CoreException coreException) {}
        }
        return list;
    }

    protected boolean selectAndLaunch(IResource resource, ILaunchGroup group) {
        if (group == null) {
            return false;
        }
        ILaunchConfiguration config = this.getLaunchConfigurationManager().isSharedConfig(resource);
        if (config != null) {
            DebugUITools.launch(config, group.getMode());
            return true;
        }
        List configs = this.getLaunchConfigurationManager().getApplicableLaunchConfigurations(resource);
        int csize = configs.size();
        if (csize == 1) {
            DebugUITools.launch((ILaunchConfiguration)configs.get(0), group.getMode());
            return true;
        }
        if (csize < 1) {
            List exts = this.getLaunchConfigurationManager().getLaunchShortcuts(resource);
            int esize = exts.size();
            if (esize == 1) {
                LaunchShortcutExtension ext = (LaunchShortcutExtension)exts.get(0);
                ext.launch((ISelection)new StructuredSelection((Object)resource), group.getMode());
                return true;
            }
            if (esize > 1) {
                return this.showShortcutSelectionDialog(resource, null, group.getMode());
            }
            if (esize < 1) {
                if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.LaunchLastIfNotLaunchable")) {
                    if (this.launchLast(group)) {
                        return true;
                    }
                    MessageDialog.openInformation((Shell)DebugUIPlugin.getShell(), (String)ContextMessages.ContextRunner_0, (String)ContextMessages.ContextRunner_7);
                    return false;
                }
                IProject project = resource.getProject();
                if (project != null && !project.equals((Object)resource)) {
                    this.selectAndLaunch((IResource)project, group);
                } else {
                    String msg = ContextMessages.ContextRunner_7;
                    if (!resource.isAccessible()) {
                        msg = MessageFormat.format((String)ContextMessages.ContextRunner_13, (Object[])new String[]{resource.getName()});
                    }
                    MessageDialog.openInformation((Shell)DebugUIPlugin.getShell(), (String)ContextMessages.ContextRunner_0, (String)msg);
                }
            }
        } else if (csize > 1) {
            config = this.getLaunchConfigurationManager().getMRUConfiguration(configs, group, resource);
            if (config != null) {
                DebugUITools.launch(config, group.getMode());
                return true;
            }
            return this.showConfigurationSelectionDialog(configs, group.getMode());
        }
        return false;
    }

    protected boolean showConfigurationSelectionDialog(List configurations, String mode) {
        LaunchConfigurationSelectionDialog lsd = new LaunchConfigurationSelectionDialog(DebugUIPlugin.getShell());
        if (configurations != null) {
            lsd.setInput(configurations);
        }
        if (lsd.open() == 0) {
            ILaunchConfiguration config = (ILaunchConfiguration)lsd.getResult()[0];
            DebugUITools.launch(config, mode);
            return true;
        }
        return false;
    }

    protected boolean showShortcutSelectionDialog(IResource resource, List shortcuts, String mode) {
        LaunchShortcutExtension method;
        Object[] result;
        LaunchShortcutSelectionDialog dialog = new LaunchShortcutSelectionDialog(resource, mode);
        if (shortcuts != null) {
            dialog.setInput(shortcuts);
        }
        if (dialog.open() == 0 && (result = dialog.getResult()).length > 0 && (method = (LaunchShortcutExtension)result[0]) != null) {
            method.launch((ISelection)(resource == null ? new StructuredSelection() : new StructuredSelection((Object)resource)), mode);
            return true;
        }
        return false;
    }

    protected LaunchConfigurationManager getLaunchConfigurationManager() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager();
    }
}

