/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.soap;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.datatools.enablement.oda.ws.soap.SOAPParameter;
import org.eclipse.datatools.enablement.oda.ws.util.WSUtil;

public class SOAPRequest {
    private static final String RE_PARAMETER = "\\Q&?\\E.*\\Q?&\\E";
    private String[] template;
    private String queryText = "";
    private SOAPParameter[] parameters;

    public SOAPRequest(String queryText) {
        this.queryText = queryText;
        this.init();
    }

    public SOAPRequest() {
    }

    public void init() {
        if (WSUtil.isNull(this.queryText)) {
            return;
        }
        this.generateTemplate();
        this.generateParameters();
    }

    public void generateTemplate() {
        if (!WSUtil.isNull(this.queryText)) {
            this.template = this.queryText.split(RE_PARAMETER);
        }
    }

    public void generateParameters() {
        if (!WSUtil.isNull(this.template) && this.template.length > 1) {
            this.parameters = new SOAPParameter[this.template.length - 1];
            int paramId = -1;
            Pattern pattern = Pattern.compile(RE_PARAMETER);
            Matcher matcher = pattern.matcher(this.queryText);
            while (matcher.find()) {
                String paramName = this.queryText.substring(matcher.start() + 2, matcher.end() - 2);
                this.parameters[++paramId] = new SOAPParameter(paramId + 1, paramName);
            }
        }
    }

    public void setQueryText(String queryText) {
        this.queryText = queryText;
    }

    public String getQueryText() {
        return this.queryText;
    }

    public String[] getTemplate() {
        return this.template;
    }

    public void setTemplate(String[] template) {
        this.template = template;
    }

    public void setParameters(SOAPParameter[] parameters) {
        this.parameters = parameters;
    }

    public SOAPParameter[] getParameters() {
        return this.parameters;
    }

    public void setParameterValue(int parameterId, String value) {
        if (!WSUtil.isNull(this.parameters) && this.parameters.length >= parameterId) {
            this.parameters[parameterId - 1].setDefaultValue(value);
        }
    }

    public void setParameterValue(String name, String value) {
        if (!WSUtil.isNull(this.parameters) && !WSUtil.isNull(name)) {
            int i = 0;
            while (i < this.parameters.length) {
                if (this.parameters[i].getName().equals(name)) {
                    this.parameters[i].setDefaultValue(value);
                }
                ++i;
            }
        }
    }

    public String toXML() {
        if (this.template == null) {
            return "";
        }
        if (this.parameters == null) {
            return this.template[this.template.length - 1];
        }
        String soapRequest = "";
        int i = 0;
        while (i < this.parameters.length) {
            soapRequest = String.valueOf(soapRequest) + this.template[i];
            soapRequest = String.valueOf(soapRequest) + this.parameters[i].getDefaultValue();
            ++i;
        }
        soapRequest = String.valueOf(soapRequest) + this.template[this.template.length - 1];
        return soapRequest;
    }
}

