/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.UAContentFilter;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpEvaluationContext;
import org.eclipse.help.internal.base.remote.RemoteHelp;
import org.eclipse.help.internal.webapp.data.ActivitiesData;
import org.eclipse.help.internal.webapp.data.ServletResources;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.data.WebappPreferences;

public class TocData
extends ActivitiesData {
    private static int loadBookAtOnceLimit;
    private static int dynamicLoadDepths;
    private static int honorLevelsLimit;
    private String tocParameter;
    private String topicHref;
    private String topicHelpHref;
    private int selectedToc;
    private int[] rootPath = null;
    private ITopic[] topicPath = null;
    private int topicsGenerated = 0;
    private IToc[] tocs;
    private String imagesDirectory;

    public TocData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
        String pathStr;
        if (dynamicLoadDepths < 1) {
            WebappPreferences pref = new WebappPreferences();
            loadBookAtOnceLimit = pref.getBookAtOnceLimit();
            dynamicLoadDepths = pref.getLoadDepth();
            honorLevelsLimit = loadBookAtOnceLimit / 4;
        }
        this.tocParameter = request.getParameter("toc");
        this.topicHref = request.getParameter("topic");
        if (this.tocParameter != null && this.tocParameter.length() == 0) {
            this.tocParameter = null;
        }
        if (this.topicHref != null && this.topicHref.length() == 0) {
            this.topicHref = null;
        }
        String anchor = request.getParameter("anchor");
        if (this.topicHref != null && anchor != null) {
            this.topicHref = String.valueOf(this.topicHref) + '#' + anchor;
        }
        if ((pathStr = request.getParameter("path")) != null && pathStr.length() > 0) {
            String[] paths = pathStr.split("_", -1);
            int[] indexes = new int[paths.length];
            boolean indexesOK = true;
            int i = 0;
            while (i < paths.length) {
                try {
                    indexes[i] = Integer.parseInt(paths[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    indexesOK = false;
                    break;
                }
                if (indexesOK) {
                    this.rootPath = indexes;
                }
                ++i;
            }
        }
        this.imagesDirectory = this.preferences.getImagesDirectory();
        this.loadTocs();
    }

    private static int countTopics(IToc toc) {
        return TocData.countTopics(toc.getTopics()) + 1;
    }

    private static int countTopics(ITopic[] topics) {
        int count = topics.length;
        int i = 0;
        while (i < topics.length) {
            ITopic[] subtopics = topics[i].getSubtopics();
            if (subtopics != null && subtopics.length > 0) {
                count += TocData.countTopics(subtopics);
            }
            ++i;
        }
        return count;
    }

    public boolean isRemoteHelpError() {
        boolean isError;
        boolean bl = isError = RemoteHelp.getError() != null;
        if (isError) {
            RemoteHelp.clearError();
        }
        return isError;
    }

    public int getTocCount() {
        return this.tocs.length;
    }

    public String getTocLabel(int i) {
        return this.tocs[i].getLabel();
    }

    public String getTocHref(int i) {
        return this.tocs[i].getHref();
    }

    public String getTocDescriptionTopic(int i) {
        return UrlUtil.getHelpURL(this.tocs[i].getTopic(null).getHref());
    }

    private static ITopic[] getTopicPathInToc(ITopic topicToFind, IToc toc) {
        if (topicToFind.getLabel().equals(toc.getLabel())) {
            return new ITopic[0];
        }
        ITopic[] topics = toc.getTopics();
        if (topics != null) {
            int i = 0;
            while (i < topics.length) {
                List reversePath = TocData.getTopicPathInToc(topicToFind, topics[i]);
                if (reversePath != null) {
                    ITopic[] path = new ITopic[reversePath.size()];
                    int j = 0;
                    while (j < path.length) {
                        path[j] = (ITopic)reversePath.get(path.length - 1 - j);
                        ++j;
                    }
                    return path;
                }
                ++i;
            }
        }
        return null;
    }

    private static List getTopicPathInToc(ITopic topicToFind, ITopic topic) {
        if (topic.getLabel().equals(topicToFind.getLabel())) {
            ArrayList<ITopic> path = new ArrayList<ITopic>();
            path.add(topic);
            return path;
        }
        ITopic[] subtopics = topic.getSubtopics();
        int i = 0;
        while (i < subtopics.length) {
            List path = TocData.getTopicPathInToc(topicToFind, subtopics[i]);
            if (path != null) {
                path.add(topic);
                return path;
            }
            ++i;
        }
        return null;
    }

    public int getSelectedToc() {
        return this.selectedToc;
    }

    public String getSelectedTopic() {
        if (this.topicHref != null && this.topicHref.length() > 0) {
            return UrlUtil.getHelpURL(this.topicHref);
        }
        if (this.selectedToc == -1) {
            return null;
        }
        IToc toc = this.tocs[this.selectedToc];
        ITopic tocDescription = toc.getTopic(null);
        if (tocDescription != null) {
            return UrlUtil.getHelpURL(tocDescription.getHref());
        }
        return UrlUtil.getHelpURL(null);
    }

    public IToc[] getTocs() {
        return this.tocs;
    }

    public boolean isEnabled(int toc) {
        if (!this.isEnabled(this.tocs[toc])) {
            return false;
        }
        return this.getEnabledSubtopicList(this.tocs[toc]).size() > 0;
    }

    private boolean isEnabled(IToc toc) {
        if (!this.isAdvancedUI()) {
            return true;
        }
        return HelpBasePlugin.getActivitySupport().isEnabled(toc.getHref()) && !UAContentFilter.isFiltered((Object)toc, (IEvaluationContext)HelpEvaluationContext.getContext());
    }

    private void loadTocs() {
        this.tocs = HelpPlugin.getTocManager().getTocs(this.getLocale());
        this.selectedToc = -1;
        if (this.tocParameter != null && this.tocParameter.length() > 0) {
            this.tocs = this.getTocs();
            int i = 0;
            while (this.selectedToc == -1 && i < this.tocs.length) {
                if (this.tocParameter.equals(this.tocs[i].getHref())) {
                    this.selectedToc = i;
                }
                ++i;
            }
        } else {
            this.selectedToc = this.findTocContainingTopic(this.topicHref);
            ITopic topic = this.findTopic();
            if (topic != null && this.selectedToc >= 0) {
                this.topicPath = TocData.getTopicPathInToc(topic, this.tocs[this.selectedToc]);
            }
        }
    }

    private int findTocContainingTopic(String topic) {
        if (topic == null || topic.equals("")) {
            return -1;
        }
        int index = topic.indexOf("/topic/");
        if (index != -1) {
            topic = topic.substring(index + 6);
        } else {
            index = topic.indexOf("/nav/");
            if (index != -1) {
                String nav = topic.substring(index + 5);
                String book = (index = nav.indexOf(95)) == -1 ? nav : nav.substring(0, index);
                try {
                    return Integer.parseInt(book);
                }
                catch (Exception exception) {}
            }
        }
        index = topic.indexOf(63);
        if (index != -1) {
            topic = topic.substring(0, index);
        }
        if (topic == null || topic.equals("")) {
            return -1;
        }
        this.tocs = this.getTocs();
        int i = 0;
        while (i < this.tocs.length) {
            if (this.isEnabled(i) && this.tocs[i].getTopic(topic) != null) {
                return i;
            }
            ++i;
        }
        i = 0;
        while (i < this.tocs.length) {
            if (!this.isEnabled(i) && this.tocs[i].getTopic(topic) != null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private ITopic findTopic() {
        String topic = this.getSelectedTopic();
        if (topic == null || topic.equals("")) {
            return null;
        }
        int index = topic.indexOf("/topic/");
        if (index != -1) {
            topic = topic.substring(index + 6);
        } else {
            index = topic.indexOf("/nav/");
            if (index != -1) {
                String nav = topic.substring(index + 5);
                StringTokenizer tok = new StringTokenizer(nav, "_");
                try {
                    index = Integer.parseInt(tok.nextToken());
                    ITopic current = this.getTocs()[index].getTopic(null);
                    while (tok.hasMoreTokens()) {
                        index = Integer.parseInt(tok.nextToken());
                        current = current.getSubtopics()[index];
                    }
                    return current;
                }
                catch (Exception exception) {}
            }
        }
        index = topic.indexOf(63);
        if (index != -1) {
            topic = topic.substring(0, index);
        }
        if (topic == null || topic.equals("")) {
            return null;
        }
        if (this.getSelectedToc() < 0) {
            return null;
        }
        IToc selectedToc = this.getTocs()[this.getSelectedToc()];
        if (selectedToc == null) {
            return null;
        }
        return selectedToc.getTopic(topic);
    }

    public void generateToc(int toc, Writer out) throws IOException {
        ITopic[] topics = this.getEnabledSubtopics(this.tocs[toc]);
        if (topics.length <= 0) {
            return;
        }
        int maxLevels = dynamicLoadDepths;
        if (TocData.countTopics(this.tocs[toc]) <= loadBookAtOnceLimit) {
            maxLevels = -1;
        }
        StringBuffer id = new StringBuffer();
        if (this.rootPath != null) {
            int p = 0;
            while (p < this.rootPath.length) {
                if (id.length() > 0) {
                    id.append('_');
                }
                topics = this.getEnabledSubtopics(topics[this.rootPath[p]]);
                id.append(this.rootPath[p]);
                ++p;
            }
            out.write("<ul class='expanded' id=\"" + id.toString() + "\">\n");
        }
        int i = 0;
        while (i < topics.length) {
            String idPrefix = id.toString();
            idPrefix = idPrefix.length() > 0 ? String.valueOf(idPrefix) + "_" + Integer.toString(i) : Integer.toString(i);
            this.generateTopic(topics[i], out, idPrefix, maxLevels, this.rootPath == null ? 0 : this.rootPath.length);
            ++i;
        }
        if (this.rootPath != null) {
            out.write("</ul>\n");
        }
    }

    private void generateTopic(ITopic topic, Writer out, String id, int maxLevels, int currentLevel) throws IOException {
        ITopic[] topics;
        boolean hasNodes;
        if (maxLevels == 0) {
            return;
        }
        ++this.topicsGenerated;
        if (maxLevels > 1 && this.topicsGenerated > honorLevelsLimit) {
            maxLevels = 1;
        }
        boolean bl = hasNodes = (topics = this.getEnabledSubtopics(topic)).length > 0;
        if (hasNodes) {
            boolean isAncestor;
            out.write("<li>");
            out.write("<img src='");
            out.write(this.imagesDirectory);
            out.write("/plus.gif' class='collapsed' alt=\"" + ServletResources.getString("topicClosed", this.request) + "\" title=\"" + ServletResources.getString("topicClosed", this.request) + "\">");
            out.write("<a href=\"" + UrlUtil.getHelpURL(topic.getHref()) + "\"" + ">");
            out.write("<img src='");
            out.write(this.imagesDirectory);
            out.write("/container_obj.gif' alt=\"\">");
            out.write(UrlUtil.htmlEncode(topic.getLabel()));
            out.write("</a>");
            boolean bl2 = isAncestor = this.topicPath != null && this.topicPath.length > currentLevel + 1 && this.topicPath[currentLevel] == topic;
            if (maxLevels != 1 || isAncestor) {
                out.write("<ul class='collapsed'>\n");
            } else {
                out.write("<ul class='collapsed' id=\"" + id + "\">\n");
            }
            if (1 <= maxLevels && maxLevels <= dynamicLoadDepths && isAncestor) {
                int i = 0;
                while (i < topics.length) {
                    this.generateTopic(topics[i], out, String.valueOf(id) + "_" + i, dynamicLoadDepths, currentLevel + 1);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < topics.length) {
                    this.generateTopic(topics[i], out, String.valueOf(id) + "_" + i, maxLevels - 1, currentLevel + 1);
                    ++i;
                }
            }
            out.write("</ul>\n");
        } else {
            out.write("<li>");
            out.write("<img src='");
            out.write(this.imagesDirectory);
            out.write("/plus.gif' class='h' alt=\"\">");
            out.write("<a href=\"" + UrlUtil.getHelpURL(topic.getHref()) + "\"" + ">");
            out.write("<img src='");
            out.write(this.imagesDirectory);
            out.write("/topic.gif' alt=\"\">");
            out.write(UrlUtil.htmlEncode(topic.getLabel()));
            out.write("</a>");
        }
        out.write("</li>\n");
    }

    public void generateBasicToc(int toc, Writer out) throws IOException {
        ITopic[] topics = this.getEnabledSubtopics(this.tocs[toc]);
        int i = 0;
        while (i < topics.length) {
            this.generateBasicTopic(topics[i], out);
            ++i;
        }
    }

    private void generateBasicTopic(ITopic topic, Writer out) throws IOException {
        boolean hasNodes;
        out.write("<li>");
        ITopic[] topics = this.getEnabledSubtopics(topic);
        boolean bl = hasNodes = topics.length > 0;
        if (hasNodes) {
            out.write("<nobr>");
            out.write("<a ");
            if (this.getSelectedTopicHelpHref().equals(topic.getHref())) {
                out.write("name=\"selectedItem\" ");
            }
            out.write("href=\"" + UrlUtil.getHelpURL(topic.getHref()) + "\"" + ">");
            out.write("<img src='");
            out.write(this.imagesDirectory);
            out.write("/container_obj.gif' alt=\"\" border=0>&nbsp;");
            out.write(UrlUtil.htmlEncode(topic.getLabel()));
            out.write("</a>");
            out.write("</nobr>");
            out.write("<ul>\n");
            int i = 0;
            while (i < topics.length) {
                this.generateBasicTopic(topics[i], out);
                ++i;
            }
            out.write("</ul>\n");
        } else {
            out.write("<nobr>");
            out.write("<a ");
            if (this.getSelectedTopicHelpHref().equals(topic.getHref())) {
                out.write("name=\"selectedItem\" ");
            }
            out.write("href=\"" + UrlUtil.getHelpURL(topic.getHref()) + "\"" + ">");
            out.write("<img src='");
            out.write(this.imagesDirectory);
            out.write("/topic.gif' alt=\"\" border=0>&nbsp;");
            out.write(UrlUtil.htmlEncode(topic.getLabel()));
            out.write("</a>");
            out.write("</nobr>");
        }
        out.write("</li>\n");
    }

    private String getSelectedTopicHelpHref() {
        if (this.topicHelpHref == null) {
            String topic = this.getSelectedTopic();
            if (topic == null || topic.length() == 0) {
                this.topicHelpHref = "";
                return this.topicHelpHref;
            }
            int index = topic.indexOf("/topic/");
            if (index != -1) {
                topic = topic.substring(index + 6);
            }
            if ((index = topic.indexOf(63)) != -1) {
                topic = topic.substring(0, index);
            }
            this.topicHelpHref = topic;
            if (topic == null) {
                this.topicHelpHref = "";
            }
        }
        return this.topicHelpHref;
    }

    public ITopic[] getEnabledSubtopics(Object element) {
        List topics = this.getEnabledSubtopicList(element);
        return topics.toArray(new ITopic[topics.size()]);
    }

    private List getEnabledSubtopicList(Object element) {
        List<ITopic> children;
        if (element instanceof IToc && !this.isEnabled((IToc)element)) {
            return Collections.EMPTY_LIST;
        }
        if (element instanceof IToc) {
            children = Arrays.asList(((IToc)element).getTopics());
        } else if (element instanceof ITopic) {
            children = Arrays.asList(((ITopic)element).getSubtopics());
        } else {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ITopic> childTopics = new ArrayList<ITopic>(children.size());
        Iterator<ITopic> childrenIt = children.iterator();
        while (childrenIt.hasNext()) {
            ITopic c = childrenIt.next();
            if (c instanceof ITopic) {
                if ((c.getHref() == null || c.getHref().length() <= 0) && this.getEnabledSubtopicList(c).size() <= 0 || UAContentFilter.isFiltered((Object)c, (IEvaluationContext)HelpEvaluationContext.getContext())) continue;
                childTopics.add(c);
                continue;
            }
            childTopics.addAll(this.getEnabledSubtopicList(c));
        }
        return childTopics;
    }

    private void generateTopicLinks(ITopic topic, Writer w, int indent) {
        String topicHref = topic.getHref();
        try {
            if (indent == 0) {
                w.write("<b>");
            }
            int tab = 0;
            while (tab < indent) {
                w.write("&nbsp;&nbsp;");
                ++tab;
            }
            if (topicHref != null && topicHref.length() > 0) {
                w.write("<a href=\"");
                if ('/' == topicHref.charAt(0)) {
                    w.write("topic");
                }
                w.write(topicHref);
                w.write("\">");
                w.write(UrlUtil.htmlEncode(topic.getLabel()));
                w.write("</a>");
            } else {
                w.write(UrlUtil.htmlEncode(topic.getLabel()));
            }
            w.write("<br>\n");
            if (indent == 0) {
                w.write("</b>");
            }
        }
        catch (IOException iOException) {}
        ITopic[] topics = topic.getSubtopics();
        int i = 0;
        while (i < topics.length) {
            this.generateTopicLinks(topics[i], w, indent + 1);
            ++i;
        }
    }

    public void generateLinks(Writer out) {
        int i = 0;
        while (i < this.tocs.length) {
            IToc toc = this.tocs[i];
            ITopic tocTopic = toc.getTopic(null);
            this.generateTopicLinks(tocTopic, out, 0);
            ITopic[] topics = toc.getTopics();
            int t = 0;
            while (t < topics.length) {
                this.generateTopicLinks(topics[t], out, 1);
                ++t;
            }
            ++i;
        }
    }

    public ITopic[] getTopicPath() {
        return this.topicPath;
    }

    public int[] getRootPath() {
        return this.rootPath;
    }

    public String getTopicHref() {
        return this.topicHref;
    }
}

