/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.IJpaModel;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.core.internal.JpaModelManager;
import org.eclipse.jpt.core.internal.content.orm.OrmInit;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceInit;
import org.osgi.framework.BundleContext;

public class JptCorePlugin
extends Plugin {
    private static JptCorePlugin INSTANCE;
    public static final String PLUGIN_ID = "org.eclipse.jpt.core";
    public static final String FACET_ID = "jpt.jpa";
    public static final String ORM_XML_CONTENT_TYPE = "org.eclipse.jpt.core.content.orm";
    public static final String PERSISTENCE_XML_CONTENT_TYPE = "org.eclipse.jpt.core.content.persistence";
    public static final String JAVA_CONTENT_TYPE = "org.eclipse.jdt.core.javaSource";

    public static IJpaModel getJpaModel() {
        return JpaModelManager.instance().getJpaModel();
    }

    public static IJpaProject getJpaProject(IProject project) {
        return JpaModelManager.instance().getJpaProject(project);
    }

    public static IJpaFile getJpaFile(IFile file) {
        return JpaModelManager.instance().getJpaFile(file);
    }

    public static JptCorePlugin getPlugin() {
        return INSTANCE;
    }

    public static void log(IStatus status) {
        INSTANCE.getLog().log(status);
    }

    public static void log(String msg) {
        JptCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, msg, null));
    }

    public static void log(Throwable throwable) {
        JptCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, throwable.getLocalizedMessage(), throwable));
    }

    public JptCorePlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        JpaModelManager.instance().startup();
        OrmInit.init();
        PersistenceInit.init();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            JpaModelManager.instance().shutdown();
        }
        finally {
            super.stop(context);
        }
    }
}

