/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java.mappings;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.core.internal.content.java.JavaEObject;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsPackage;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.Member;
import org.eclipse.jpt.core.internal.jdtutility.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.IMultiRelationshipMapping;
import org.eclipse.jpt.core.internal.mappings.IOrderBy;
import org.eclipse.jpt.core.internal.mappings.OrderingType;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaOrderBy
extends JavaEObject
implements IOrderBy {
    protected static final String VALUE_EDEFAULT = null;
    protected String value = VALUE_EDEFAULT;
    protected static final OrderingType TYPE_EDEFAULT = OrderingType.NONE;
    protected OrderingType type = TYPE_EDEFAULT;
    private final Member member;
    private final AnnotationAdapter annotationAdapter;
    private final AnnotationElementAdapter<String> valueAdapter;
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.OrderBy");
    private static final DeclarationAnnotationElementAdapter<String> VALUE_ADAPTER = JavaOrderBy.buildValueAdapter();

    protected JavaOrderBy() {
        throw new UnsupportedOperationException("User JavaOrderBy(Member) instead");
    }

    protected JavaOrderBy(Member member) {
        this.member = member;
        this.annotationAdapter = this.buildOrderByAnnotationAdapter();
        this.valueAdapter = new ShortCircuitAnnotationElementAdapter<String>(this.member, VALUE_ADAPTER);
    }

    private AnnotationAdapter buildOrderByAnnotationAdapter() {
        return new MemberAnnotationAdapter(this.member, DECLARATION_ANNOTATION_ADAPTER);
    }

    @Override
    protected void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        switch (notification.getFeatureID(IOrderBy.class)) {
            case 0: {
                if (this.getType() != OrderingType.CUSTOM) break;
                this.valueAdapter.setValue((String)notification.getNewValue());
                break;
            }
            case 1: {
                OrderingType newOrderingType = (OrderingType)((Object)notification.getNewValue());
                if (newOrderingType == OrderingType.NONE) {
                    if (this.annotationAdapter.getAnnotation() == null) break;
                    this.annotationAdapter.removeAnnotation();
                    break;
                }
                if (newOrderingType == OrderingType.PRIMARY_KEY) {
                    Annotation annotation = this.annotationAdapter.getAnnotation();
                    if (annotation == null) {
                        this.annotationAdapter.newMarkerAnnotation();
                        break;
                    }
                    if (annotation.isNormalAnnotation()) {
                        if (((NormalAnnotation)annotation).values().size() == 0) break;
                        this.annotationAdapter.removeAnnotation();
                        this.annotationAdapter.newMarkerAnnotation();
                        break;
                    }
                    if (annotation.isMarkerAnnotation()) break;
                    this.annotationAdapter.removeAnnotation();
                    this.annotationAdapter.newMarkerAnnotation();
                    break;
                }
                if (newOrderingType == OrderingType.CUSTOM) {
                    Annotation annotation = this.annotationAdapter.getAnnotation();
                    if (annotation == null) {
                        this.annotationAdapter.newSingleMemberAnnotation();
                        this.valueAdapter.setValue(this.getValue());
                        break;
                    }
                    if (annotation.isSingleMemberAnnotation()) break;
                    this.annotationAdapter.removeAnnotation();
                    this.annotationAdapter.newSingleMemberAnnotation();
                    this.valueAdapter.setValue(this.getValue());
                    break;
                }
                throw new IllegalStateException("unknown 'orderBy' type: " + (Object)((Object)newOrderingType));
            }
        }
    }

    @Override
    protected EClass eStaticClass() {
        return JpaJavaMappingsPackage.Literals.JAVA_ORDER_BY;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String newValue) {
        String oldValue = this.value;
        this.value = newValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldValue, (Object)this.value));
        }
    }

    @Override
    public OrderingType getType() {
        return this.type;
    }

    @Override
    public void setType(OrderingType newType) {
        OrderingType oldType = this.type;
        OrderingType orderingType = this.type = newType == null ? TYPE_EDEFAULT : newType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldType, (Object)this.type));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getValue();
            }
            case 1: {
                return this.getType();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setValue((String)newValue);
                return;
            }
            case 1: {
                this.setType((OrderingType)((Object)newValue));
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setValue(VALUE_EDEFAULT);
                return;
            }
            case 1: {
                this.setType(TYPE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return VALUE_EDEFAULT == null ? this.value != null : !VALUE_EDEFAULT.equals(this.value);
            }
            case 1: {
                return this.type != TYPE_EDEFAULT;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IOrderBy.class) {
            switch (derivedFeatureID) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IOrderBy.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (value: ");
        result.append(this.value);
        result.append(", type: ");
        result.append((Object)this.type);
        result.append(')');
        return result.toString();
    }

    private IMultiRelationshipMapping multiRelationshipMapping() {
        return (IMultiRelationshipMapping)this.eContainer();
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext) {
        if (this.getType() == OrderingType.PRIMARY_KEY) {
            this.refreshValue(defaultsContext);
        }
    }

    protected void refreshValue(DefaultsContext defaultsContext) {
        IEntity targetEntity = this.multiRelationshipMapping().getResolvedTargetEntity();
        if (targetEntity != null) {
            this.setValue(String.valueOf(targetEntity.primaryKeyAttributeName()) + " ASC");
        }
    }

    public void updateFromJava(CompilationUnit astRoot) {
        Annotation annotation = this.annotation(astRoot);
        if (annotation == null) {
            this.setType(OrderingType.NONE);
        } else if (annotation.isMarkerAnnotation()) {
            this.setType(OrderingType.PRIMARY_KEY);
        } else if (annotation.isSingleMemberAnnotation()) {
            this.setType(OrderingType.CUSTOM);
        } else if (annotation.isNormalAnnotation()) {
            if (((NormalAnnotation)annotation).values().size() == 0) {
                this.setType(OrderingType.PRIMARY_KEY);
            } else {
                this.setType(OrderingType.CUSTOM);
            }
        } else {
            throw new IllegalStateException("unknown annotation type: " + annotation);
        }
        this.setValue(this.valueAdapter.getValue(astRoot));
    }

    public Annotation annotation(CompilationUnit astRoot) {
        return this.annotationAdapter.getAnnotation(astRoot);
    }

    @Override
    public ITextRange validationTextRange() {
        return this.member.annotationTextRange(DECLARATION_ANNOTATION_ADAPTER);
    }

    private static DeclarationAnnotationElementAdapter<String> buildValueAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(DECLARATION_ANNOTATION_ADAPTER, "value", false);
    }
}

