/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.List;
import org.eclipse.jpt.core.internal.IPersistentType;
import org.eclipse.jpt.core.internal.ITypeMapping;
import org.eclipse.jpt.core.internal.mappings.IAttributeOverride;
import org.eclipse.jpt.core.internal.mappings.IColumn;
import org.eclipse.jpt.core.internal.mappings.IColumnMapping;
import org.eclipse.jpt.core.internal.platform.BaseContext;
import org.eclipse.jpt.core.internal.platform.ColumnContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeOverrideContext
extends BaseContext {
    IAttributeOverride attributeOverride;
    ColumnContext columnContext;

    public AttributeOverrideContext(IContext parentContext, IAttributeOverride attributeOverride) {
        super(parentContext);
        this.attributeOverride = attributeOverride;
        this.columnContext = this.buildColumnContext();
    }

    @Override
    protected void initialize() {
    }

    protected ColumnContext buildColumnContext() {
        return new ColumnContext(this, this.attributeOverride.getColumn());
    }

    public DefaultsContext wrapDefaultsContext(final DefaultsContext defaultsContext) {
        return new DefaultsContext(){

            public IPersistentType persistentType(String fullyQualifiedTypeName) {
                return defaultsContext.persistentType(fullyQualifiedTypeName);
            }

            public Object getDefault(String key) {
                if (key.equals("column.name")) {
                    IColumnMapping columnMapping = (IColumnMapping)((Object)AttributeOverrideContext.this.attributeOverride.getOwner().attributeMapping(AttributeOverrideContext.this.attributeOverride.getName()));
                    if (columnMapping == null) {
                        return null;
                    }
                    return columnMapping.getColumn().getName();
                }
                if (key.equals("column.table")) {
                    IColumnMapping columnMapping = (IColumnMapping)((Object)AttributeOverrideContext.this.attributeOverride.getOwner().attributeMapping(AttributeOverrideContext.this.attributeOverride.getName()));
                    if (columnMapping == null) {
                        return null;
                    }
                    String specifiedTable = columnMapping.getColumn().getSpecifiedTable();
                    if (specifiedTable != null) {
                        return specifiedTable;
                    }
                }
                return defaultsContext.getDefault(key);
            }
        };
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext) {
        this.columnContext.refreshDefaults(this.wrapDefaultsContext(defaultsContext));
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.addColumnMessages(messages);
    }

    protected void addColumnMessages(List<IMessage> messages) {
        ITypeMapping typeMapping = this.attributeOverride.getOwner().getTypeMapping();
        IColumn column = this.attributeOverride.getColumn();
        String table = column.getTable();
        boolean doContinue = column.isConnected();
        if (doContinue && typeMapping.tableNameIsInvalid(table)) {
            if (this.attributeOverride.isVirtual()) {
                messages.add(JpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_TABLE", new String[]{this.attributeOverride.getName(), table, column.getName()}, column, column.tableTextRange()));
            } else {
                messages.add(JpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_TABLE", new String[]{table, column.getName()}, column, column.tableTextRange()));
            }
            doContinue = false;
        }
        if (doContinue && !column.isResolved()) {
            if (this.attributeOverride.isVirtual()) {
                messages.add(JpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME", new String[]{this.attributeOverride.getName(), column.getName()}, column, column.nameTextRange()));
            } else {
                messages.add(JpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName()}, column, column.nameTextRange()));
            }
        }
    }
}

