/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.IJpaPlatform;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.core.internal.IMappingKeys;
import org.eclipse.jpt.core.internal.IPersistentType;
import org.eclipse.jpt.core.internal.content.java.JavaPersistentType;
import org.eclipse.jpt.core.internal.content.java.JpaCompilationUnit;
import org.eclipse.jpt.core.internal.content.persistence.Persistence;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceXmlRootContentNode;
import org.eclipse.jpt.core.internal.platform.BaseContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.PersistenceUnitContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.jpt.db.internal.Connection;
import org.eclipse.jpt.db.internal.ConnectionProfile;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseJpaProjectContext
extends BaseContext {
    private IJpaProject project;
    private List<IJpaFile> validPersistenceXmlFiles;
    private List<IJpaFile> invalidPersistenceXmlFiles;
    private Collection<PersistenceUnitContext> persistenceUnitContexts;
    private boolean okToContinueValidation = true;
    protected boolean okToProceedForConnectionValidation = true;

    public BaseJpaProjectContext(IJpaProject jpaProject) {
        super(null);
        this.project = jpaProject;
        this.validPersistenceXmlFiles = new ArrayList<IJpaFile>();
        this.invalidPersistenceXmlFiles = new ArrayList<IJpaFile>();
        this.persistenceUnitContexts = new ArrayList<PersistenceUnitContext>();
    }

    @Override
    protected void initialize() {
        this.sortPersistenceXmlFiles();
        this.buildPersistenceUnitContexts();
    }

    private void sortPersistenceXmlFiles() {
        for (IJpaFile jpaFile : this.persistenceXmlFiles()) {
            if (this.isValidPersistenceXmlLocation(jpaFile)) {
                this.validPersistenceXmlFiles.add(jpaFile);
                continue;
            }
            this.invalidPersistenceXmlFiles.add(jpaFile);
        }
    }

    private Collection<IJpaFile> persistenceXmlFiles() {
        return this.project.jpaFiles("org.eclipse.jpt.core.content.persistence");
    }

    private boolean isValidPersistenceXmlLocation(IJpaFile jpaFile) {
        IFile file = jpaFile.getFile();
        IContainer folder = file.getParent();
        if (folder.getType() != 2 || !folder.getName().equals("META-INF")) {
            return false;
        }
        IJavaElement sourceFolder = JavaCore.create((IResource)((IFolder)folder).getParent());
        if (sourceFolder == null || sourceFolder.getElementType() != 3) {
            return false;
        }
        try {
            return ((IPackageFragmentRoot)sourceFolder).getKind() == 1;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected void buildPersistenceUnitContexts() {
        if (this.validPersistenceXmlFiles.size() == 1) {
            IJpaFile file = this.validPersistenceXmlFiles.get(0);
            this.buildPersistenceUnitContexts(this.getPersistence(file));
        }
    }

    protected void buildPersistenceUnitContexts(Persistence persistence) {
        if (persistence != null) {
            for (PersistenceUnit persistenceUnit : persistence.getPersistenceUnits()) {
                PersistenceUnitContext persistenceUnitContext = new PersistenceUnitContext(this, persistenceUnit);
                this.persistenceUnitContexts.add(persistenceUnitContext);
            }
        }
    }

    protected Persistence getPersistence(IJpaFile persistenceXmlFile) {
        return ((PersistenceXmlRootContentNode)persistenceXmlFile.getContent()).getPersistence();
    }

    @Override
    public IJpaPlatform getPlatform() {
        return this.project.getPlatform();
    }

    protected Iterator<IJpaFile> validPersistenceXmlFiles() {
        return this.validPersistenceXmlFiles.iterator();
    }

    public void refreshDefaults() {
        this.refreshDefaults(null);
    }

    @Override
    public void refreshDefaults(DefaultsContext parentDefaults) {
        super.refreshDefaults(parentDefaults);
        DefaultsContext defaultsContext = this.buildDefaultsContext();
        for (PersistenceUnitContext context : this.persistenceUnitContexts) {
            context.refreshDefaults(defaultsContext);
        }
    }

    private DefaultsContext buildDefaultsContext() {
        return new DefaultsContext(){

            public Object getDefault(String key) {
                if (key.equals("table.schema") || key.equals("tableGenerator.schema")) {
                    return BaseJpaProjectContext.this.getProjectUserSchema();
                }
                if (key.equals("table.catalog")) {
                    return BaseJpaProjectContext.this.getProjectUserCatalog();
                }
                return null;
            }

            public IPersistentType persistentType(String fullyQualifiedTypeName) {
                return null;
            }
        };
    }

    protected ConnectionProfile getProjectConnectionProfile() {
        return this.project.connectionProfile();
    }

    private String getProjectUserSchema() {
        ConnectionProfile profile = this.getProjectConnectionProfile();
        return profile.getUserName();
    }

    private String getProjectUserCatalog() {
        ConnectionProfile profile = this.getProjectConnectionProfile();
        return profile.getCatalogName();
    }

    public boolean contains(IPersistentType persistentType) {
        for (PersistenceUnitContext context : this.persistenceUnitContexts) {
            if (!context.contains(persistentType)) continue;
            return true;
        }
        return false;
    }

    private Iterator<PersistenceUnitContext> persistenceUnitContexts() {
        return this.persistenceUnitContexts.iterator();
    }

    int persistenceUnitContextsSize() {
        return this.persistenceUnitContexts.size();
    }

    PersistenceUnitContext persistenceUnitContext(String persistenceUnitName) {
        Iterator<PersistenceUnitContext> stream = this.persistenceUnitContexts();
        while (stream.hasNext()) {
            PersistenceUnitContext puContext = stream.next();
            if (!puContext.persistenceUnit().getName().equals(persistenceUnitName)) continue;
            return puContext;
        }
        return null;
    }

    Iterator<PersistenceUnit> persistenceUnits() {
        return new TransformationIterator<PersistenceUnitContext, PersistenceUnit>(this.persistenceUnitContexts()){

            protected PersistenceUnit transform(PersistenceUnitContext next) {
                return next.persistenceUnit();
            }
        };
    }

    public boolean containsPersistenceUnitNamed(String name) {
        return this.persistenceUnitNamed(name) != null;
    }

    PersistenceUnit persistenceUnitNamed(String name) {
        for (PersistenceUnitContext context : this.persistenceUnitContexts) {
            if (!context.persistenceUnit().getName().equals(name)) continue;
            return context.persistenceUnit();
        }
        return null;
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.addProjectLevelMessages(messages);
        if (this.okToContinueValidation) {
            for (PersistenceUnitContext context : this.persistenceUnitContexts) {
                context.addToMessages(messages);
            }
        }
        this.addOrphanedJavaClassMessages(messages);
    }

    protected void addProjectLevelMessages(List<IMessage> messages) {
        this.addConnectionMessages(messages);
        this.addNoPersistenceXmlMessage(messages);
        this.addMultiplePersistenceXmlMessage(messages);
        this.addInvalidPersistenceXmlContentMessage(messages);
        this.addNoPersistenceUnitMessage(messages);
        this.addMultiplePersistenceUnitMessage(messages);
    }

    protected void addConnectionMessages(List<IMessage> messages) {
        this.addNoConnectionMessage(messages);
        this.addInactiveConnectionMessage(messages);
    }

    protected void addNoConnectionMessage(List<IMessage> messages) {
        Connection connection = this.project.getDataSource().getConnection();
        if (connection == null) {
            messages.add(JpaValidationMessages.buildMessage(2, "PROJECT_NO_CONNECTION", this.project));
            this.okToProceedForConnectionValidation = false;
        }
    }

    protected void addInactiveConnectionMessage(List<IMessage> messages) {
        Connection connection = this.project.getDataSource().getConnection();
        if (this.okToProceedForConnectionValidation && !connection.isConnected()) {
            messages.add(JpaValidationMessages.buildMessage(2, "PROJECT_INACTIVE_CONNECTION", new String[]{this.project.getDataSource().getConnectionProfileName()}, this.project));
        }
        this.okToProceedForConnectionValidation = true;
    }

    protected void addNoPersistenceXmlMessage(List<IMessage> messages) {
        if (this.validPersistenceXmlFiles.isEmpty()) {
            messages.add(JpaValidationMessages.buildMessage(1, "PROJECT_NO_PERSISTENCE_XML", this.project));
            this.okToContinueValidation = false;
        }
    }

    protected void addMultiplePersistenceXmlMessage(List<IMessage> messages) {
        if (this.validPersistenceXmlFiles.size() > 1) {
            messages.add(JpaValidationMessages.buildMessage(1, "PROJECT_MULTIPLE_PERSISTENCE_XML", this.project));
            this.okToContinueValidation = false;
        }
    }

    protected void addInvalidPersistenceXmlContentMessage(List<IMessage> messages) {
        IJpaFile persistenceXmlFile;
        if (this.validPersistenceXmlFiles.size() == 1 && this.getPersistence(persistenceXmlFile = this.validPersistenceXmlFiles.get(0)) == null) {
            PersistenceXmlRootContentNode root = (PersistenceXmlRootContentNode)persistenceXmlFile.getContent();
            messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENCE_XML_INVALID_CONTENT", root, root.validationTextRange()));
            this.okToContinueValidation = false;
        }
    }

    protected void addNoPersistenceUnitMessage(List<IMessage> messages) {
        if (this.okToContinueValidation && this.persistenceUnitContexts.size() == 0) {
            IJpaFile validPersistenceXml = this.validPersistenceXmlFiles.get(0);
            Persistence persistence = this.getPersistence(validPersistenceXml);
            messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENCE_NO_PERSISTENCE_UNIT", persistence, persistence.validationTextRange()));
            this.okToContinueValidation = false;
        }
    }

    protected void addMultiplePersistenceUnitMessage(List<IMessage> messages) {
        if (this.okToContinueValidation && this.persistenceUnitContexts.size() > 1) {
            IJpaFile validPersistenceXml = this.validPersistenceXmlFiles.get(0);
            Persistence persistence = this.getPersistence(validPersistenceXml);
            messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENCE_MULTIPLE_PERSISTENCE_UNITS", persistence, persistence.validationTextRange()));
            this.okToContinueValidation = false;
        }
    }

    protected void addOrphanedJavaClassMessages(List<IMessage> messages) {
        for (IJpaFile jpaFile : this.project.jpaFiles("org.eclipse.jdt.core.javaSource")) {
            for (JavaPersistentType jpType : ((JpaCompilationUnit)jpaFile.getContent()).getTypes()) {
                if (jpType.getMappingKey() == IMappingKeys.NULL_TYPE_MAPPING_KEY || this.contains(jpType)) continue;
                messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENT_TYPE_UNSPECIFIED_CONTEXT", jpType.getMapping(), jpType.getMapping().validationTextRange()));
            }
        }
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.project.getJavaProject().getProject().getName());
    }
}

