/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.sdo.action;

import commonj.sdo.DataObject;
import commonj.sdo.Sequence;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.sdo.EDataObject;
import org.eclipse.emf.ecore.sdo.SDOPackage;
import org.eclipse.emf.ecore.sdo.presentation.SDOEditorPlugin;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;

public class EvaluatePathAction
extends ActionDelegate
implements IActionDelegate {
    protected EDataObject eDataObject;

    public void run(IAction action) {
        EvaluationDialog dialog = new EvaluationDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.eDataObject);
        dialog.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object object;
        if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof EDataObject) {
            this.eDataObject = (EDataObject)object;
            action.setEnabled(true);
            return;
        }
        this.eDataObject = null;
        action.setEnabled(false);
    }

    public static class EvaluationDialog
    extends Dialog {
        protected static final Object[][] TYPE_DATA = new Object[][]{{"BigDecimal", Boolean.FALSE, BigDecimal.class, EcorePackage.eINSTANCE.getEBigDecimal()}, {"BigInteger", Boolean.FALSE, BigInteger.class, EcorePackage.eINSTANCE.getEBigInteger()}, {"Boolean", Boolean.FALSE, Boolean.TYPE, EcorePackage.eINSTANCE.getEBoolean()}, {"Byte", Boolean.FALSE, Byte.TYPE, EcorePackage.eINSTANCE.getEByte()}, {"Bytes", Boolean.FALSE, byte[].class, EcorePackage.eINSTANCE.getEByteArray()}, {"Char", Boolean.FALSE, Character.TYPE, EcorePackage.eINSTANCE.getEChar()}, {"DataObject", Boolean.FALSE, DataObject.class, SDOPackage.eINSTANCE.getDataObject()}, {"Date", Boolean.FALSE, Date.class, EcorePackage.eINSTANCE.getEDate()}, {"Double", Boolean.FALSE, Double.TYPE, EcorePackage.eINSTANCE.getEDouble()}, {"Float", Boolean.FALSE, Float.TYPE, EcorePackage.eINSTANCE.getEFloat()}, {"Int", Boolean.FALSE, Integer.TYPE, EcorePackage.eINSTANCE.getEInt()}, {"List", Boolean.FALSE, List.class, EcorePackage.eINSTANCE.getEJavaObject()}, {"Long", Boolean.FALSE, Long.TYPE, EcorePackage.eINSTANCE.getELong()}, {"Object", Boolean.TRUE, Object.class, EcorePackage.eINSTANCE.getEJavaObject()}, {"Sequence", Boolean.FALSE, Sequence.class, SDOPackage.eINSTANCE.getSequence()}, {"Short", Boolean.FALSE, Short.TYPE, EcorePackage.eINSTANCE.getEShort()}, {"String", Boolean.FALSE, String.class, EcorePackage.eINSTANCE.getEString()}};
        protected Method[][] methods = null;
        protected EDataObject eDataObject;
        protected Text pathText;
        protected Text resultText;
        protected Combo valueText;
        protected Combo operationChoice;
        protected Combo typeChoice;

        public EvaluationDialog(Shell shell, EDataObject eDataObject) {
            super(shell);
            this.setShellStyle(67696);
            this.eDataObject = eDataObject;
            try {
                this.methods = new Method[TYPE_DATA.length][];
                int i = 0;
                while (i < TYPE_DATA.length) {
                    this.methods[i] = new Method[]{EDataObject.class.getMethod("get" + (TYPE_DATA[i][1] == Boolean.TRUE ? "" : TYPE_DATA[i][0]), String.class), "Sequence".equals(TYPE_DATA[i][0]) ? null : EDataObject.class.getMethod("set" + (TYPE_DATA[i][1] == Boolean.TRUE ? "" : TYPE_DATA[i][0]), String.class, (Class)TYPE_DATA[i][2])};
                    ++i;
                }
            }
            catch (NoSuchMethodException exception) {
                exception.printStackTrace();
            }
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(SDOEditorPlugin.INSTANCE.getString("_UI_PathEvaluation_title", new Object[]{EcoreUtil.getURI((EObject)this.eDataObject).toString()}));
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            composite.setLayoutData((Object)data);
            Label pathLabel = new Label(composite, 16384);
            pathLabel.setText(SDOEditorPlugin.INSTANCE.getString("_UI_Path_label"));
            data = new GridData();
            data.horizontalAlignment = 4;
            pathLabel.setLayoutData((Object)data);
            this.pathText = new Text(composite, 2052);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.pathText.setLayoutData((Object)data);
            this.pathText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    EvaluationDialog.this.resultText.setText("");
                }
            });
            Label operationLabel = new Label(composite, 16384);
            operationLabel.setText(SDOEditorPlugin.INSTANCE.getString("_UI_Operation_label"));
            GridData data2 = new GridData();
            data2.horizontalAlignment = 4;
            operationLabel.setLayoutData((Object)data2);
            this.operationChoice = new Combo(composite, 2060);
            data2 = new GridData();
            data2.horizontalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            this.operationChoice.setLayoutData((Object)data2);
            this.operationChoice.add("get");
            this.operationChoice.add("set");
            this.operationChoice.add("isSet");
            this.operationChoice.add("unset");
            this.operationChoice.select(0);
            this.operationChoice.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    EvaluationDialog.this.resultText.setText("");
                    EvaluationDialog.this.typeChoice.setEnabled(EvaluationDialog.this.operationChoice.getSelectionIndex() == 0 || EvaluationDialog.this.operationChoice.getSelectionIndex() == 1);
                    EvaluationDialog.this.valueText.setEnabled(EvaluationDialog.this.operationChoice.getSelectionIndex() == 1);
                }
            });
            Label typeLabel = new Label(composite, 16384);
            typeLabel.setText(SDOEditorPlugin.INSTANCE.getString("_UI_Type_label"));
            GridData data3 = new GridData();
            data3.horizontalAlignment = 4;
            typeLabel.setLayoutData((Object)data3);
            this.typeChoice = new Combo(composite, 2060);
            data3 = new GridData();
            data3.horizontalAlignment = 4;
            data3.grabExcessHorizontalSpace = true;
            this.typeChoice.setLayoutData((Object)data3);
            int i = 0;
            while (i < TYPE_DATA.length) {
                this.typeChoice.add((String)TYPE_DATA[i][0]);
                if (TYPE_DATA[i][1] == Boolean.TRUE) {
                    this.typeChoice.select(i);
                }
                ++i;
            }
            this.typeChoice.select(13);
            Label valueLabel = new Label(composite, 16384);
            valueLabel.setText(SDOEditorPlugin.INSTANCE.getString("_UI_Value_label"));
            GridData data4 = new GridData();
            data4.horizontalAlignment = 4;
            valueLabel.setLayoutData((Object)data4);
            this.valueText = new Combo(composite, 2052);
            this.valueText.setEnabled(false);
            data4 = new GridData();
            data4.horizontalAlignment = 4;
            data4.grabExcessHorizontalSpace = true;
            this.valueText.setLayoutData((Object)data4);
            Label resultLabel = new Label(composite, 16384);
            resultLabel.setText(SDOEditorPlugin.INSTANCE.getString("_UI_Result_label"));
            GridData data5 = new GridData();
            data5.horizontalAlignment = 4;
            resultLabel.setLayoutData((Object)data5);
            this.resultText = new Text(composite, 2818);
            data5 = new GridData();
            data5.heightHint = 200;
            data5.horizontalAlignment = 4;
            data5.grabExcessHorizontalSpace = true;
            data5.widthHint = 500;
            data5.verticalAlignment = 4;
            data5.grabExcessVerticalSpace = true;
            this.resultText.setLayoutData((Object)data5);
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 1025, "Evaluate", true);
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        protected void buttonPressed(int buttonID) {
            super.buttonPressed(buttonID);
            if (buttonID == 1025) {
                this.pathText.setFocus();
                this.evaluate();
            }
        }

        protected void evaluate() {
            try {
                EDataType eDataType;
                Object result = null;
                switch (this.operationChoice.getSelectionIndex()) {
                    case 0: {
                        result = this.methods[this.typeChoice.getSelectionIndex()][0].invoke((Object)this.eDataObject, this.pathText.getText());
                        break;
                    }
                    case 1: {
                        if (TYPE_DATA[this.typeChoice.getSelectionIndex()][3] instanceof EDataType) {
                            eDataType = (EDataType)TYPE_DATA[this.typeChoice.getSelectionIndex()][3];
                            result = eDataType.isSerializable() ? EcoreUtil.createFromString((EDataType)eDataType, (String)this.valueText.getText()) : this.valueText.getText();
                        }
                        this.methods[this.typeChoice.getSelectionIndex()][1].invoke((Object)this.eDataObject, this.pathText.getText(), result);
                        break;
                    }
                    case 2: {
                        result = this.eDataObject.isSet(this.pathText.getText()) ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    case 3: {
                        this.eDataObject.unset(this.pathText.getText());
                    }
                }
                if (result == null) {
                    this.resultText.setText("null");
                } else if (TYPE_DATA[this.typeChoice.getSelectionIndex()][3] instanceof EDataType) {
                    eDataType = (EDataType)TYPE_DATA[this.typeChoice.getSelectionIndex()][3];
                    if (eDataType.isSerializable()) {
                        this.resultText.setText(EcoreUtil.convertToString((EDataType)eDataType, (Object)result));
                    } else if (result instanceof List) {
                        StringBuffer text = new StringBuffer();
                        for (Object object : (List)result) {
                            text.append(object);
                            text.append("\n");
                        }
                        this.resultText.setText(text.toString());
                    } else {
                        this.resultText.setText(result.toString());
                    }
                } else {
                    this.resultText.setText(result.toString());
                }
            }
            catch (InvocationTargetException exception) {
                StringWriter writer = new StringWriter();
                exception.getTargetException().printStackTrace(new PrintWriter(writer));
                this.resultText.setText(writer.getBuffer().toString());
            }
            catch (Exception exception) {
                StringWriter writer = new StringWriter();
                exception.printStackTrace(new PrintWriter(writer));
                this.resultText.setText(writer.getBuffer().toString());
            }
        }
    }
}

