/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.spelling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilableModel;
import org.eclipse.jface.text.reconciler.IReconcileResult;
import org.eclipse.jface.text.reconciler.IReconcileStep;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.ui.texteditor.spelling.SpellingEngineDescriptor;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.eclipse.ui.texteditor.spelling.SpellingService;
import org.eclipse.wst.sse.core.internal.parser.ForeignRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.reconcile.DocumentAdapter;
import org.eclipse.wst.sse.ui.internal.reconcile.ReconcileAnnotationKey;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredReconcileStep;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredTextReconcilingStrategy;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.eclipse.wst.sse.ui.internal.spelling.SpellingQuickAssistProcessor;

public class SpellcheckStrategy
extends StructuredTextReconcilingStrategy {
    static final boolean _DEBUG_SPELLING = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/debug/reconcilerSpelling"));
    static final String ANNOTATION_TYPE = "org.eclipse.wst.sse.ui.temp.spelling";
    private static final String EXTENDED_BUILDER_TYPE_PARTITIONS = "spellingpartitions";
    private static final String EXTENDED_BUILDER_TYPE_CONTEXTS = "spellingregions";
    static final String KEY_CONTENT_TYPE = "org.eclipse.wst.sse.ui.temp.spelling";
    private String fContentTypeId = null;
    private String fDocumentPartitioning;
    SpellingProblemCollector fProblemCollector = new SpellingProblemCollector();
    ReconcileAnnotationKey fReconcileAnnotationKey;
    private IPropertyChangeListener fSpellCheckPreferenceListener;
    SpellingContext fSpellingContext;
    IReconcileStep fSpellingStep;
    String[] fSupportedPartitionTypes;
    String[] fSupportedTextRegionContexts;

    public SpellcheckStrategy(ISourceViewer viewer, String contentTypeId) {
        super(viewer);
        this.fContentTypeId = contentTypeId;
        this.fSpellingContext = new SpellingContext();
        this.fSpellingContext.setContentType(Platform.getContentTypeManager().getContentType(this.fContentTypeId));
        this.fReconcileAnnotationKey = new ReconcileAnnotationKey(this.fSpellingStep, "org.eclipse.wst.sse.ui.temp.spelling", 1);
        String[] definitions = ExtendedConfigurationBuilder.getInstance().getDefinitions(EXTENDED_BUILDER_TYPE_PARTITIONS, this.fContentTypeId);
        ArrayList<String> defs = new ArrayList<String>();
        int i = 0;
        while (i < definitions.length) {
            defs.addAll(Arrays.asList(StringUtils.unpack((String)definitions[i])));
            ++i;
        }
        this.fSupportedPartitionTypes = defs.toArray(new String[defs.size()]);
        String[] textRegionContexts = ExtendedConfigurationBuilder.getInstance().getDefinitions(EXTENDED_BUILDER_TYPE_CONTEXTS, this.fContentTypeId);
        ArrayList<String> contexts = new ArrayList<String>();
        int i2 = 0;
        while (i2 < textRegionContexts.length) {
            contexts.addAll(Arrays.asList(StringUtils.unpack((String)textRegionContexts[i2])));
            ++i2;
        }
        this.fSupportedTextRegionContexts = contexts.toArray(new String[contexts.size()]);
        this.fSpellCheckPreferenceListener = new SpellCheckPreferenceListener();
    }

    protected boolean containsStep(IReconcileStep step) {
        return this.fSpellingStep.equals(step);
    }

    public void createReconcileSteps() {
        this.fSpellingStep = new SpellingStep();
    }

    String getDocumentPartitioning() {
        return this.fDocumentPartitioning == null ? "__dftl_partitioning" : this.fDocumentPartitioning;
    }

    private TemporaryAnnotation[] getSpellingAnnotationsToRemove(IRegion region) {
        ArrayList<TemporaryAnnotation> toRemove = new ArrayList<TemporaryAnnotation>();
        IAnnotationModel annotationModel = this.getAnnotationModel();
        if (this.getAnnotationModel() != null) {
            Iterator i = annotationModel.getAnnotationIterator();
            while (i.hasNext()) {
                TemporaryAnnotation annotation;
                ReconcileAnnotationKey key;
                Object obj = i.next();
                if (!(obj instanceof TemporaryAnnotation) || (key = (ReconcileAnnotationKey)(annotation = (TemporaryAnnotation)obj).getKey()) == null || !key.equals(this.fReconcileAnnotationKey)) continue;
                Position position = annotation.getPosition();
                if (key.getScope() == 1 && position.overlapsWith(region.getOffset(), region.getLength())) {
                    toRemove.add(annotation);
                    continue;
                }
                if (key.getScope() != 0) continue;
                toRemove.add(annotation);
            }
        }
        return toRemove.toArray(new TemporaryAnnotation[toRemove.size()]);
    }

    SpellingService getSpellingService(String engineID) {
        SpellingService defaultService;
        SpellingService preferredService = defaultService = EditorsUI.getSpellingService();
        if (engineID != null) {
            SpellingEngineDescriptor[] descriptors = defaultService.getSpellingEngineDescriptors();
            int i = 0;
            while (i < descriptors.length) {
                if (engineID.equals(descriptors[i].getId())) {
                    ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), SSEUIPlugin.getDefault().getBundle().getSymbolicName());
                    store.setValue("spellingEngine", engineID);
                    preferredService = new SpellingService((IPreferenceStore)store);
                    break;
                }
                ++i;
            }
        }
        return preferredService;
    }

    private boolean isSupportedPartitionType(String type) {
        boolean supported = false;
        if (this.fSupportedPartitionTypes == null || this.fSupportedPartitionTypes.length == 0) {
            supported = true;
        } else {
            int i = 0;
            while (i < this.fSupportedPartitionTypes.length) {
                if (type.equals(this.fSupportedPartitionTypes[i])) {
                    supported = true;
                    break;
                }
                ++i;
            }
        }
        return supported;
    }

    private boolean isSupportedContext(String type) {
        boolean isSupported = false;
        if (this.fSupportedTextRegionContexts != null) {
            int i = 0;
            while (i < this.fSupportedTextRegionContexts.length) {
                if (type.equals(this.fSupportedTextRegionContexts[i])) {
                    isSupported = true;
                    break;
                }
                ++i;
            }
        }
        return isSupported;
    }

    void reconcile() {
        IDocument document = this.getDocument();
        if (document != null) {
            Region documentRegion = new Region(0, document.getLength());
            this.reconcile((IRegion)documentRegion);
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        if (this.isCanceled()) {
            return;
        }
        Annotation[] annotationsToRemove = null;
        IReconcileResult[] annotationsToAdd = null;
        StructuredReconcileStep structuredStep = (StructuredReconcileStep)this.fSpellingStep;
        IAnnotationModel annotationModel = this.getAnnotationModel();
        IDocument document = this.getDocument();
        if (document != null) {
            try {
                ITypedRegion[] partitions = TextUtilities.computePartitioning((IDocument)document, (String)this.getDocumentPartitioning(), (int)dirtyRegion.getOffset(), (int)dirtyRegion.getLength(), (boolean)true);
                int i = 0;
                while (i < partitions.length) {
                    if (this.isSupportedPartitionType(partitions[i].getType())) {
                        annotationsToRemove = this.getSpellingAnnotationsToRemove((IRegion)partitions[i]);
                        annotationsToAdd = structuredStep.reconcile(dirtyRegion, (IRegion)partitions[i]);
                        if (annotationModel instanceof IAnnotationModelExtension) {
                            IAnnotationModelExtension modelExtension = (IAnnotationModelExtension)annotationModel;
                            HashMap<IReconcileResult, Position> annotationsToAddMap = new HashMap<IReconcileResult, Position>();
                            int j = 0;
                            while (j < annotationsToAdd.length) {
                                annotationsToAddMap.put(annotationsToAdd[j], ((TemporaryAnnotation)annotationsToAdd[j]).getPosition());
                                ++j;
                            }
                            modelExtension.replaceAnnotations(annotationsToRemove, annotationsToAddMap);
                        } else {
                            int j = 0;
                            while (j < annotationsToAdd.length) {
                                annotationModel.addAnnotation((Annotation)((TemporaryAnnotation)annotationsToAdd[j]), ((TemporaryAnnotation)annotationsToAdd[j]).getPosition());
                                ++j;
                            }
                            j = 0;
                            while (j < annotationsToRemove.length) {
                                annotationModel.removeAnnotation(annotationsToRemove[j]);
                                ++j;
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public void reconcile(IRegion partition) {
        DirtyRegion region = null;
        IDocument document = this.getDocument();
        if (document != null) {
            try {
                region = new DirtyRegion(partition.getOffset(), partition.getLength(), "__insert", document.get(partition.getOffset(), partition.getLength()));
                this.reconcile(region, (IRegion)region);
            }
            catch (BadLocationException e) {
                Logger.logException(e);
            }
        }
    }

    public void setDocument(IDocument document) {
        if (this.getDocument() != null) {
            EditorsUI.getPreferenceStore().removePropertyChangeListener(this.fSpellCheckPreferenceListener);
        }
        super.setDocument(document);
        if (document != null) {
            if (this.fSpellingStep == null) {
                this.createReconcileSteps();
            }
            this.fSpellingStep.setInputModel((IReconcilableModel)new DocumentAdapter(document));
        }
        if (this.getDocument() != null) {
            EditorsUI.getPreferenceStore().addPropertyChangeListener(this.fSpellCheckPreferenceListener);
        }
    }

    public void setDocumentPartitioning(String partitioning) {
        this.fDocumentPartitioning = partitioning;
    }

    class SpellCheckPreferenceListener
    implements IPropertyChangeListener {
        SpellCheckPreferenceListener() {
        }

        private boolean isInterestingProperty(Object property) {
            return "spellingEnabled".equals(property) || "spellingEngine".equals(property);
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (this.isInterestingProperty(event.getProperty()) && (event.getOldValue() == null || event.getNewValue() == null || !event.getNewValue().equals(event.getOldValue()))) {
                SpellcheckStrategy.this.reconcile();
            }
        }
    }

    private class SpellingProblemCollector
    implements ISpellingProblemCollector {
        List annotations = new ArrayList();

        private SpellingProblemCollector() {
        }

        public void accept(SpellingProblem problem) {
            if (!this.isInterestingProblem(problem)) {
                return;
            }
            TemporaryAnnotation annotation = new TemporaryAnnotation(new Position(problem.getOffset(), problem.getLength()), "org.eclipse.wst.sse.ui.temp.warning", problem.getMessage(), SpellcheckStrategy.this.fReconcileAnnotationKey);
            SpellingQuickAssistProcessor quickAssistProcessor = new SpellingQuickAssistProcessor();
            quickAssistProcessor.setSpellingProblem(problem);
            annotation.setAdditionalFixInfo(quickAssistProcessor);
            this.annotations.add(annotation);
            if (_DEBUG_SPELLING) {
                Logger.log(201, problem.getMessage());
            }
        }

        private boolean isInterestingProblem(SpellingProblem problem) {
            IStructuredDocumentRegion documentRegion;
            if (SpellcheckStrategy.this.getDocument() instanceof IStructuredDocument && (documentRegion = ((IStructuredDocument)SpellcheckStrategy.this.getDocument()).getRegionAtCharacterOffset(problem.getOffset())) != null) {
                ITextRegion textRegion = documentRegion.getRegionAtCharacterOffset(problem.getOffset());
                if (textRegion != null && SpellcheckStrategy.this.isSupportedContext(textRegion.getType())) {
                    return true;
                }
                if (documentRegion.getFirstRegion() instanceof ForeignRegion) {
                    return false;
                }
                return documentRegion.getRegions().size() == 1;
            }
            return true;
        }

        public void beginCollecting() {
        }

        void clear() {
            this.annotations.clear();
        }

        public void endCollecting() {
        }

        IReconcileResult[] getResults() {
            return this.annotations.toArray(new IReconcileResult[this.annotations.size()]);
        }
    }

    private class SpellingStep
    extends StructuredReconcileStep {
        private SpellingStep() {
        }

        protected IReconcileResult[] reconcileModel(DirtyRegion dirtyRegion, IRegion subRegion) {
            SpellingService service = SpellcheckStrategy.this.getSpellingService(String.valueOf(SpellcheckStrategy.this.fContentTypeId) + "." + "spellingEngine");
            if (_DEBUG_SPELLING) {
                Logger.log(201, "Spell checking [" + subRegion.getOffset() + "-" + (subRegion.getOffset() + subRegion.getLength()) + "]");
            }
            if (this.getDocument() != null) {
                service.check(this.getDocument(), new IRegion[]{dirtyRegion}, SpellcheckStrategy.this.fSpellingContext, (ISpellingProblemCollector)SpellcheckStrategy.this.fProblemCollector, this.getProgressMonitor());
            }
            IReconcileResult[] results = SpellcheckStrategy.this.fProblemCollector.getResults();
            SpellcheckStrategy.this.fProblemCollector.clear();
            return results;
        }
    }
}

