/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.java.builder;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.merge.java.facade.JAbstractType;
import org.eclipse.emf.codegen.merge.java.facade.JCompilationUnit;
import org.eclipse.emf.codegen.merge.java.facade.JEnum;
import org.eclipse.emf.codegen.merge.java.facade.JEnumConstant;
import org.eclipse.emf.codegen.merge.java.facade.JField;
import org.eclipse.emf.codegen.merge.java.facade.JImport;
import org.eclipse.emf.codegen.merge.java.facade.JMember;
import org.eclipse.emf.codegen.merge.java.facade.JMethod;
import org.eclipse.emf.codegen.merge.java.facade.JNode;
import org.eclipse.emf.codegen.merge.java.facade.JPackage;
import org.eclipse.emf.codegen.merge.java.facade.JType;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.namespace.XMLNamespacePackage;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.java.JavaImporterPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEcoreBuilder {
    protected static FacadeHelper facadeHelper = CodeGenUtil.instantiateFacadeHelper((String)JMerger.DEFAULT_FACADE_HELPER_CLASS);
    protected IFile genModelFile;
    protected GenModel genModel;
    protected Map<String, EPackage> externalPackageNameToEPackageMap = new LinkedHashMap<String, EPackage>();
    protected Map<String, EPackage> packageNameToEPackageMap = new LinkedHashMap<String, EPackage>();
    protected Map<EPackage, Map<Object, Integer>> ePackageToOrderingMap = new LinkedHashMap<EPackage, Map<Object, Integer>>();
    protected Map<EPackage, String> ePackageToPrefixMap = new LinkedHashMap<EPackage, String>();
    protected Map<EModelElement, JNode> eModelElementToJNodeMap = new LinkedHashMap<EModelElement, JNode>();
    protected Map<ETypedElement, String> eTypedElementToTypeNameMap = new LinkedHashMap<ETypedElement, String>();
    protected Map<ETypedElement, String> eTypedElementToInstanceTypeNameMap = new LinkedHashMap<ETypedElement, String>();
    protected Set<EDataType> demandCreatedEDataTypes = new HashSet<EDataType>();
    protected Map<EClass, String[]> eClassToSuperTypeNamesMap = new LinkedHashMap<EClass, String[]>();
    protected Map<EOperation, String[]> eOperationToExceptionTypeNamesMap = new LinkedHashMap<EOperation, String[]>();
    protected Map<EReference, String> eReferenceToOppositeNameMap = new LinkedHashMap<EReference, String>();
    protected Collection<GenModel> externalGenModels = new UniqueEList();
    protected Collection<GenPackage> usedGenPackages = new ArrayList<GenPackage>();
    protected BasicDiagnostic basicDiagnostic;
    protected boolean foundJava = false;
    protected GenModel oldGenModelVersion;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static Pattern modelDocExpression = Pattern.compile("<!--\\s*begin-model-doc\\s*-->[ \\f\\n\\r\\t]*\\*\\s?(.*?)<!--\\s*end-model-doc\\s*-->", 40);
    protected static Pattern modelAnnotationExpression = Pattern.compile("@[ \\f\\n\\r\\t*]*model[ \\f\\n\\r\\t*]*((\\w*\\s*=\\s*(['\"])(?>\\\\.|.)*?\\3[ \\f\\n\\r\\t*]*)*)", 8);
    protected static Pattern extendsAnnotationExpression = Pattern.compile("@\\s*extends\\s*(([.\\w]*\\s*,*\\s*)+)", 8);
    protected static Pattern implementsAnnotationExpression = Pattern.compile("@\\s*implements\\s*(([.\\w]*\\s*,*\\s*)+)", 8);
    protected static Pattern eAnnotationExpression = Pattern.compile("\\G\\s*((?>\\\\.|\\S)+)((?:\\s+(?>\\\\.|\\S)+\\s*+=\\s*(['\"])((?>\\\\.|.)*?)\\3)*)");
    protected static Pattern eAnnotationDetailExpression = Pattern.compile("\\s+((?>\\\\.|\\S)+)\\s*+=\\s*((['\"])((?>\\\\.|.)*?)\\3)");

    public JavaEcoreBuilder(IFile genModelFile) {
        this.genModelFile = genModelFile;
        this.basicDiagnostic = new BasicDiagnostic(JavaImporterPlugin.getPlugin().getBundle().getSymbolicName(), 0, CodeGenEcorePlugin.INSTANCE.getString("_UI_ErrorsWereDetectedJava_message"), null);
    }

    public JavaEcoreBuilder(IFile genModelFile, GenModel oldGenModelVersion) {
        this(genModelFile);
        this.oldGenModelVersion = oldGenModelVersion;
    }

    public JavaEcoreBuilder(IFile genModelFile, GenModel oldGenModelVersion, GenModel genModel) {
        this(genModelFile, oldGenModelVersion);
        this.genModel = genModel;
    }

    protected ResourceSet createResourceSet() {
        ResourceSetImpl result = new ResourceSetImpl();
        result.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
        return result;
    }

    /*
     * WARNING - void declaration
     */
    protected IPath analyseProject(IProject project) throws Exception {
        void var5_14;
        void var5_6;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IPackageFragmentRoot[] packageFragmentRoots = javaProject.getPackageFragmentRoots();
        HashSet<IResource> visited = new HashSet<IResource>();
        boolean bl = false;
        while (var5_6 < packageFragmentRoots.length) {
            if (packageFragmentRoots[var5_6].getKind() == 1) {
                this.traverse((IContainer)packageFragmentRoots[var5_6].getUnderlyingResource(), visited);
            }
            ++var5_6;
        }
        for (Map.Entry<ETypedElement, String> entry : this.eTypedElementToTypeNameMap.entrySet()) {
            EClass container;
            String typeName;
            ETypedElement eTypedElement = entry.getKey();
            EClassifier eClassifier = this.resolve((EModelElement)eTypedElement, typeName = entry.getValue());
            if (eClassifier instanceof EClass && eTypedElement instanceof EAttribute) {
                EAttribute eAttribute = (EAttribute)eTypedElement;
                container = eAttribute.getEContainingClass();
                EReference eReference = EcoreFactory.eINSTANCE.createEReference();
                eReference.setChangeable(eAttribute.isChangeable());
                eReference.setVolatile(eAttribute.isVolatile());
                eReference.setTransient(eAttribute.isTransient());
                eReference.setLowerBound(eAttribute.getLowerBound());
                eReference.setUpperBound(eAttribute.getUpperBound());
                eReference.setName(eTypedElement.getName());
                eReference.getEAnnotations().addAll((Collection)eTypedElement.getEAnnotations());
                container.getEStructuralFeatures().add(container.getEStructuralFeatures().indexOf((Object)eTypedElement), (Object)eReference);
                container.getEStructuralFeatures().remove((Object)eTypedElement);
                eTypedElement = eReference;
            } else if (eClassifier instanceof EDataType && eTypedElement instanceof EReference) {
                EReference eReference = (EReference)eTypedElement;
                container = eReference.getEContainingClass();
                EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
                eAttribute.setChangeable(eReference.isChangeable());
                eAttribute.setVolatile(eReference.isVolatile());
                eAttribute.setTransient(eReference.isTransient());
                eAttribute.setLowerBound(eReference.getLowerBound());
                eAttribute.setUpperBound(eReference.getUpperBound());
                eAttribute.setName(eTypedElement.getName());
                eAttribute.getEAnnotations().addAll((Collection)eTypedElement.getEAnnotations());
                container.getEStructuralFeatures().remove((Object)eTypedElement);
                eTypedElement = eAttribute;
                this.eReferenceToOppositeNameMap.remove(eReference);
            }
            String instanceClassName = this.eTypedElementToInstanceTypeNameMap.get(eTypedElement);
            if (instanceClassName != null && this.demandCreatedEDataTypes.contains(eClassifier)) {
                this.demandCreatedEDataTypes.remove(eClassifier);
                EClassifier resolvedInstanceClassName = this.resolve((EModelElement)eTypedElement, instanceClassName, false);
                ((EDataType)eClassifier).setInstanceClassName(resolvedInstanceClassName.getInstanceClassName());
            }
            if (eClassifier == null) {
                this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_TheTypeDoesNotResolveCorrectly_message", new Object[]{typeName}));
                eClassifier = EcorePackage.Literals.EOBJECT;
            }
            eTypedElement.setEType(eClassifier);
            this.used((EModelElement)eClassifier);
        }
        for (Map.Entry<ETypedElement, String> entry : this.eClassToSuperTypeNamesMap.entrySet()) {
            EClass eClass = (EClass)entry.getKey();
            String[] superTypeNames = (String[])entry.getValue();
            if (superTypeNames == null) continue;
            int j = 0;
            while (j < superTypeNames.length) {
                EClassifier eClassifier = this.resolve((EModelElement)eClass, superTypeNames[j], false);
                if (eClassifier.getEPackage() == null) {
                    EPackage ePackage = (EPackage)EcoreUtil.getRootContainer((EObject)eClass);
                    EClass superEClass = EcoreFactory.eINSTANCE.createEClass();
                    superEClass.setInstanceClassName(eClassifier.getInstanceClassName());
                    superEClass.setName(eClassifier.getName());
                    superEClass.setAbstract(true);
                    superEClass.setInterface(true);
                    ePackage.getEClassifiers().add((Object)superEClass);
                    eClassifier = superEClass;
                }
                if (eClassifier instanceof EClass) {
                    if (eClassifier != EcorePackage.Literals.EOBJECT) {
                        eClass.getESuperTypes().add((Object)((EClass)eClassifier));
                        this.used((EModelElement)eClassifier);
                    }
                } else {
                    this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_TheSuperTypeDoesNotResolveCorrectly_message", new Object[]{superTypeNames[j]}));
                }
                ++j;
            }
        }
        for (Map.Entry<ETypedElement, String> entry : this.eOperationToExceptionTypeNamesMap.entrySet()) {
            EOperation eOperation = (EOperation)entry.getKey();
            String[] exceptionTypeNames = (String[])entry.getValue();
            if (exceptionTypeNames == null) continue;
            int j = 0;
            while (j < exceptionTypeNames.length) {
                String compositeName = exceptionTypeNames[j];
                int index = compositeName.indexOf(":");
                String typeName = index == -1 ? compositeName : compositeName.substring(0, index);
                EClassifier eClassifier = this.resolve((EModelElement)eOperation, typeName, true);
                if (index != -1 && this.demandCreatedEDataTypes.contains(eClassifier)) {
                    this.demandCreatedEDataTypes.remove(eClassifier);
                    EClassifier resolvedInstanceClassName = this.resolve((EModelElement)eOperation, compositeName.substring(index + 1), false);
                    ((EDataType)eClassifier).setInstanceClassName(resolvedInstanceClassName.getInstanceClassName());
                }
                if (eClassifier != null) {
                    eOperation.getEExceptions().add((Object)eClassifier);
                    this.used((EModelElement)eClassifier);
                } else {
                    this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_TheTypeDoesNotResolveCorrectly_message", new Object[]{exceptionTypeNames[j]}));
                }
                ++j;
            }
        }
        for (Map.Entry<ETypedElement, String> entry : this.eReferenceToOppositeNameMap.entrySet()) {
            EReference eReference = (EReference)entry.getKey();
            String oppositeName = entry.getValue();
            EClass eClass = (EClass)eReference.getEType();
            EReference eOpposite = (EReference)eClass.getEStructuralFeature(oppositeName);
            if (eOpposite == null) {
                this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_TheAttributeIsNotAMemberOf_message", new Object[]{oppositeName, eClass.getName()}));
                continue;
            }
            if (eOpposite.getEOpposite() != eReference && eOpposite.getEOpposite() != null) {
                this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_TheOppositeAlreadyHasOpposite_message", new Object[]{oppositeName, eOpposite.getEOpposite().getName(), eOpposite.getEOpposite().getEContainingClass().getName()}));
                continue;
            }
            eReference.setEOpposite(eOpposite);
            eOpposite.setEOpposite(eReference);
            this.used((EModelElement)eOpposite);
            if (!eOpposite.isContainment()) continue;
            eReference.setTransient(true);
        }
        for (Map.Entry<Object, Object> entry : this.ePackageToOrderingMap.entrySet()) {
            EPackage ePackage = (EPackage)entry.getKey();
            Map nameToIDMap = (Map)entry.getValue();
            this.sort(ePackage.getEClassifiers(), nameToIDMap);
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                if (!(eClassifier instanceof EClass)) continue;
                EClass eClass = (EClass)eClassifier;
                this.sort(eClass.getEStructuralFeatures(), nameToIDMap);
            }
        }
        IPath iPath = project.getFullPath();
        int i2 = 0;
        while (i2 < packageFragmentRoots.length) {
            IPath path;
            if (packageFragmentRoots[i2].getKind() == 1 && iPath.isPrefixOf(path = packageFragmentRoots[i2].getUnderlyingResource().getFullPath())) {
                IPath iPath2 = path;
                break;
            }
            ++i2;
        }
        facadeHelper.reset();
        return var5_14;
    }

    public void computeEPackages(Monitor monitor, ModelImporter modelImporter) throws Exception {
        IProject project = this.genModelFile.getProject();
        project.open(BasicMonitor.toIProgressMonitor((Monitor)monitor));
        ArrayList<IFile> allGenModelFiles = new ArrayList<IFile>();
        ArrayList<IProject> allReferencedProjects = new ArrayList<IProject>();
        this.getAllReferencedProjects(allReferencedProjects, project.getDescription().getReferencedProjects());
        this.getAllReferencedProjects(allReferencedProjects, project.getDescription().getDynamicReferences());
        for (IProject referencedProject : allReferencedProjects) {
            this.getAllGenModelFiles(allGenModelFiles, (IContainer)referencedProject);
        }
        ResourceSet resourceSet = modelImporter.createResourceSet();
        for (IFile file : allGenModelFiles) {
            Resource resource = resourceSet.getResource(modelImporter.createFileURI(file.getFullPath().toString()), true);
            GenModel genModel = (GenModel)resource.getContents().get(0);
            this.externalGenModels.add(genModel);
            for (GenPackage genPackage : genModel.getGenPackages()) {
                this.determineExternalPackages(genPackage, modelImporter);
            }
        }
        UniqueEList allReferencedPluginIDs = new UniqueEList();
        allReferencedProjects.add(project);
        for (IProject referencedProject : allReferencedProjects) {
            try {
                URI manifestURI = URI.createURI((String)(referencedProject.getFullPath() + "/META-INF/MANIFEST.MF"));
                Manifest manifest = new Manifest(resourceSet.getURIConverter().createInputStream(manifestURI));
                String requires = manifest.getMainAttributes().getValue("Require-Bundle");
                if (requires == null) continue;
                ManifestElement[] elements = ManifestElement.parseHeader((String)"Require-Bundle", (String)requires);
                int j = 0;
                while (j < elements.length) {
                    ManifestElement element = elements[j];
                    if (project == referencedProject || "reexport".equals(element.getDirective("visibility"))) {
                        String pluginID = element.getValue();
                        allReferencedPluginIDs.add(pluginID);
                    }
                    ++j;
                }
            }
            catch (IOException iOException) {}
        }
        int i = 0;
        while (i < allReferencedPluginIDs.size()) {
            String requires;
            String string = (String)allReferencedPluginIDs.get(i);
            Bundle bundle = Platform.getBundle((String)string);
            if (bundle != null && (requires = (String)bundle.getHeaders().get("Require-Bundle")) != null) {
                ManifestElement[] elements = ManifestElement.parseHeader((String)"Require-Bundle", (String)requires);
                int j = 0;
                while (j < elements.length) {
                    ManifestElement element = elements[j];
                    String value = element.getValue();
                    if ("reexport".equals(element.getDirective("visibility"))) {
                        allReferencedPluginIDs.add(value);
                    }
                    ++j;
                }
            }
            ++i;
        }
        HashMap<String, Object> allPluginsWithGenModels = new HashMap<String, Object>();
        for (Map.Entry entry : EcorePlugin.getEPackageNsURIToGenModelLocationMap().entrySet()) {
            URI genModelLocation = (URI)entry.getValue();
            if (!genModelLocation.isPlatformPlugin()) continue;
            Object uris = (List)allPluginsWithGenModels.get(genModelLocation.segment(1));
            if (uris == null) {
                uris = new UniqueEList();
            }
            uris.add(genModelLocation);
            allPluginsWithGenModels.put(genModelLocation.segment(1), uris);
        }
        allReferencedPluginIDs.retainAll(allPluginsWithGenModels.keySet());
        for (String string : allReferencedPluginIDs) {
            for (URI uri : (List)allPluginsWithGenModels.get(string)) {
                Resource resource = resourceSet.getResource(uri, true);
                GenModel genModel = (GenModel)resource.getContents().get(0);
                if (!this.externalGenModels.add(genModel)) continue;
                for (GenPackage genPackage : genModel.getGenPackages()) {
                    this.determineExternalPackages(genPackage, modelImporter);
                }
            }
        }
        IPath iPath = this.analyseProject(project);
        modelImporter.setModelPluginDirectory(iPath.toString());
        if (this.packageNameToEPackageMap.isEmpty()) {
            this.error(JavaImporterPlugin.INSTANCE.getString(this.foundJava ? "_UI_NoModelElementsInJava_message" : "_UI_NoModelElements_message"));
        }
        block13: for (EPackage ePackage : this.packageNameToEPackageMap.values()) {
            modelImporter.getEPackages().add(ePackage);
            ModelImporter.EPackageImportInfo ePackageInfo = modelImporter.getEPackageImportInfo(ePackage);
            ePackageInfo.setPrefix(this.ePackageToPrefixMap.get(ePackage));
            for (Map.Entry<String, EPackage> entry : this.packageNameToEPackageMap.entrySet()) {
                int index;
                if (entry.getValue() != ePackage) continue;
                String qualifiedPackageName = entry.getKey();
                if (qualifiedPackageName == null || (index = qualifiedPackageName.lastIndexOf(".")) == -1) continue block13;
                ePackageInfo.setBasePackage(qualifiedPackageName.substring(0, index));
                continue block13;
            }
        }
    }

    public void used(EModelElement modelElement) {
        EPackage ePackage = (EPackage)EcoreUtil.getRootContainer((EObject)modelElement);
        if (ePackage != EcorePackage.eINSTANCE) {
            for (GenModel genModel : this.externalGenModels) {
                GenPackage genPackage = genModel.findGenPackage(ePackage);
                if (genPackage == null) continue;
                if (this.getUsedGenPackages().contains(genPackage) || genPackage.eResource() == null) break;
                this.getUsedGenPackages().add(genPackage);
                TreeIterator j = ePackage.eAllContents();
                while (j.hasNext()) {
                    for (EObject o : ((EObject)j.next()).eCrossReferences()) {
                        if (!(o instanceof EModelElement)) continue;
                        this.used((EModelElement)o);
                    }
                }
                break block0;
            }
        }
    }

    public void determineExternalPackages(GenPackage genPackage) {
        this.determineExternalPackages(genPackage, null);
    }

    protected void determineExternalPackages(GenPackage genPackage, ModelImporter modelImporter) {
        if (modelImporter != null) {
            modelImporter.getReferencedGenPackages().add(genPackage);
        }
        EPackage ePackage = genPackage.getEcorePackage();
        this.externalPackageNameToEPackageMap.put(genPackage.getInterfacePackageName(), ePackage);
        for (GenPackage nestedGenPackage : genPackage.getNestedGenPackages()) {
            this.determineExternalPackages(nestedGenPackage);
        }
    }

    public void getAllReferencedProjects(Collection<IProject> result, IProject[] projects) throws CoreException {
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (!result.contains(project) && project.exists() && project.isOpen()) {
                result.add(project);
                this.getAllReferencedProjects(result, project.getDescription().getReferencedProjects());
                this.getAllReferencedProjects(result, project.getDescription().getDynamicReferences());
            }
            ++i;
        }
    }

    public void getAllGenModelFiles(Collection<IFile> result, IContainer container) throws CoreException {
        IResource[] contents = container.members();
        int i = 0;
        while (i < contents.length) {
            IResource resource = contents[i];
            if (resource.getType() == 1) {
                this.getAllGenModelFiles(result, (IFile)resource);
            } else {
                this.getAllGenModelFiles(result, (IContainer)resource);
            }
            ++i;
        }
    }

    public void getAllGenModelFiles(Collection<IFile> result, IFile file) throws CoreException {
        if (file.getName().endsWith(".genmodel")) {
            IProject project = file.getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                IPath outputLocation = javaProject.getOutputLocation();
                if (project == project.getWorkspace().getRoot().findMember(javaProject.getOutputLocation()) || !outputLocation.isPrefixOf(file.getFullPath())) {
                    result.add(file);
                }
            }
            catch (JavaModelException exception) {
                JavaImporterPlugin.INSTANCE.log((Object)exception);
            }
        }
    }

    public void traverse(IContainer container, Set<IResource> visited) throws CoreException {
        IResource[] contents = container.members();
        int i = 0;
        while (i < contents.length) {
            IResource resource = contents[i];
            if (visited.add(resource)) {
                if (resource.getType() == 1) {
                    this.traverse((IFile)resource);
                } else {
                    this.traverse((IContainer)resource, visited);
                }
            }
            ++i;
        }
    }

    public void traverse(IFile file) throws CoreException {
        if ("java".equalsIgnoreCase(file.getProjectRelativePath().getFileExtension())) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(file.getContents(true));
                byte[] input = new byte[bufferedInputStream.available()];
                bufferedInputStream.read(input);
                bufferedInputStream.close();
                String encoding = null;
                try {
                    encoding = file.getCharset();
                }
                catch (CoreException coreException) {}
                String contents = encoding == null ? new String(input) : new String(input, encoding);
                JCompilationUnit compilationUnit = facadeHelper.createCompilationUnit("NAME", contents);
                this.analyzeCompilationUnit(compilationUnit);
            }
            catch (IOException exception) {
                JavaImporterPlugin.INSTANCE.log(exception);
            }
        }
    }

    protected void analyzeCompilationUnit(JCompilationUnit compilationUnit) {
        block2: {
            this.foundJava = true;
            Iterator iterator = facadeHelper.getChildren((JNode)compilationUnit, JAbstractType.class).iterator();
            if (!iterator.hasNext()) break block2;
            JAbstractType abstractType = (JAbstractType)iterator.next();
            if (abstractType instanceof JEnum) {
                this.analyzeEnum((JEnum)abstractType);
            } else {
                this.analyzeType((JType)abstractType);
            }
        }
    }

    protected void analyzeEnum(JEnum enumeration) {
        EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
        this.eModelElementToJNodeMap.put((EModelElement)eEnum, (JNode)enumeration);
        eEnum.setName(enumeration.getName());
        this.getEPackage((JNode)enumeration).getEClassifiers().add((Object)eEnum);
        eEnum.getEAnnotations().addAll(this.extractEAnnotations(this.getModelAnnotation(enumeration.getComment())));
        EcoreUtil.setDocumentation((EModelElement)eEnum, (String)this.getModelDocumentation(enumeration.getComment()));
        for (JEnumConstant enumConstant : facadeHelper.getChildren((JNode)enumeration, JEnumConstant.class)) {
            this.analyzeEnumLiteral(eEnum, (JMember)enumConstant);
        }
    }

    protected EPackage getEPackage(JNode node) {
        JPackage jPackage = facadeHelper.getPackage(node);
        String qualifiedPackageName = jPackage != null ? jPackage.getQualifiedName() : null;
        EPackage ePackage = this.packageNameToEPackageMap.get(qualifiedPackageName);
        if (ePackage == null) {
            ePackage = EcoreFactory.eINSTANCE.createEPackage();
            int index = qualifiedPackageName == null ? -1 : qualifiedPackageName.lastIndexOf(".");
            String packageName = index == -1 ? qualifiedPackageName : qualifiedPackageName.substring(index + 1);
            ePackage.setName(packageName);
            ePackage.setNsURI("http:///" + (qualifiedPackageName == null ? "null" : qualifiedPackageName.replace('.', '/')) + ".ecore");
            ePackage.setNsPrefix(qualifiedPackageName == null ? "null" : qualifiedPackageName);
            this.packageNameToEPackageMap.put(qualifiedPackageName, ePackage);
            if (packageName != null) {
                String prefix = String.valueOf(Character.toUpperCase(packageName.charAt(0))) + packageName.substring(1);
                this.ePackageToPrefixMap.put(ePackage, prefix);
            }
        }
        return ePackage;
    }

    protected void analyzeType(JType type) {
        String modelAnnotation = this.getModelAnnotation(type.getComment());
        boolean isEClassifier = false;
        String kind = null;
        if (modelAnnotation != null) {
            kind = this.getModelAnnotationAttribute(modelAnnotation, "kind");
            boolean bl = isEClassifier = !"package".equals(kind);
        }
        if (isEClassifier) {
            EPackage ePackage = this.getEPackage((JNode)type);
            if ((type.getFlags() & 0x200) != 0 || "class".equals(kind)) {
                EClass eClass = EcoreFactory.eINSTANCE.createEClass();
                this.eModelElementToJNodeMap.put((EModelElement)eClass, (JNode)type);
                eClass.setName(type.getName());
                ePackage.getEClassifiers().add((Object)eClass);
                eClass.getEAnnotations().addAll(this.extractEAnnotations(modelAnnotation));
                EcoreUtil.setDocumentation((EModelElement)eClass, (String)this.getModelDocumentation(type.getComment()));
                String[] superInterfaces = type.getSuperInterfaces();
                String extend = this.getExtendsAnnotation(type.getComment());
                if (extend != null && superInterfaces != null) {
                    ArrayList superInterfaceList = new ArrayList(Arrays.asList(superInterfaces));
                    StringTokenizer stringTokenizer = new StringTokenizer(extend, " ,\t\n\r\f");
                    while (stringTokenizer.hasMoreTokens()) {
                        superInterfaceList.remove(stringTokenizer.nextToken());
                    }
                    superInterfaces = new String[superInterfaceList.size()];
                    superInterfaceList.toArray(superInterfaces);
                }
                this.eClassToSuperTypeNamesMap.put(eClass, superInterfaces);
                String isInterface = this.getModelAnnotationAttribute(modelAnnotation, "interface");
                eClass.setInterface("true".equals(isInterface));
                String isAbstract = this.getModelAnnotationAttribute(modelAnnotation, "abstract");
                eClass.setAbstract("true".equals(isAbstract) || isAbstract == null && eClass.isInterface());
                for (JMethod method : facadeHelper.getChildren((JNode)type, JMethod.class)) {
                    this.analyzeMethod(eClass, method);
                }
                String features = this.getModelAnnotationAttribute(modelAnnotation, "features");
                if (features != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(features, " ");
                    while (stringTokenizer.hasMoreTokens()) {
                        String feature = stringTokenizer.nextToken();
                        if (eClass.getEStructuralFeature(feature) == null) {
                            this.analyzeMethod(eClass, this.getFilteredModelAnnotations(modelAnnotation, feature), "get" + Character.toUpperCase(feature.charAt(0)) + feature.substring(1), "java.lang.Object", EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY);
                            continue;
                        }
                        this.warning(CodeGenEcorePlugin.INSTANCE.getString("_UI_DuplicateFeature_message", new Object[]{feature, eClass.getName()}));
                    }
                }
            } else {
                EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
                this.eModelElementToJNodeMap.put((EModelElement)eEnum, (JNode)type);
                eEnum.setName(type.getName());
                ePackage.getEClassifiers().add((Object)eEnum);
                eEnum.getEAnnotations().addAll(this.extractEAnnotations(modelAnnotation));
                EcoreUtil.setDocumentation((EModelElement)eEnum, (String)this.getModelDocumentation(type.getComment()));
                for (JField field : facadeHelper.getChildren((JNode)type, JField.class)) {
                    this.analyzeEnumLiteral(eEnum, (JMember)field);
                }
            }
        } else {
            JPackage jPackage = facadeHelper.getPackage((JNode)type);
            String qualifiedPackageName = jPackage != null ? jPackage.getQualifiedName() : null;
            String typeName = type.getName();
            boolean isEPackage = false;
            if (typeName.endsWith("Package") && typeName.length() > 7) {
                String packagePrefix = typeName.substring(0, typeName.length() - 7);
                if ("package".equals(kind)) {
                    isEPackage = true;
                }
                int index = qualifiedPackageName == null ? -1 : qualifiedPackageName.lastIndexOf(".");
                String name = index == -1 ? qualifiedPackageName : qualifiedPackageName.substring(index + 1);
                String nsURI = "http:///" + (qualifiedPackageName == null ? "null" : qualifiedPackageName.replace('.', '/')) + ".ecore";
                String nsPrefix = qualifiedPackageName == null ? "null" : qualifiedPackageName;
                ArrayList<EClass> eClasses = new ArrayList<EClass>();
                ArrayList<EDataType> eDataTypes = new ArrayList<EDataType>();
                HashMap<String, Integer> ordering = new HashMap<String, Integer>();
                for (JNode node : type.getChildren()) {
                    String returnType;
                    JMethod method;
                    String methodAnnotation;
                    if (node instanceof JField) {
                        JField field = (JField)node;
                        String fieldName = field.getName();
                        String fieldType = field.getType();
                        if ("eNAME".equals(fieldName)) {
                            isEPackage = true;
                            name = field.getInitializer();
                            name = name.substring(1, name.length() - 1);
                            continue;
                        }
                        if ("eNS_URI".equals(fieldName)) {
                            isEPackage = true;
                            nsURI = field.getInitializer();
                            nsURI = nsURI.substring(1, nsURI.length() - 1);
                            continue;
                        }
                        if ("eNS_PREFIX".equals(fieldName)) {
                            isEPackage = true;
                            nsPrefix = field.getInitializer();
                            nsPrefix = nsPrefix.substring(1, nsPrefix.length() - 1);
                            continue;
                        }
                        if (!"int".equals(fieldType) || fieldName.endsWith("FEATURE_COUNT")) continue;
                        try {
                            String initializer = field.getInitializer();
                            int plusIndex = initializer.lastIndexOf("+");
                            if (plusIndex != -1) {
                                initializer = initializer.substring(plusIndex + 1);
                            }
                            initializer = initializer.trim();
                            int value = Integer.parseInt(initializer);
                            ordering.put(fieldName, value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (!(node instanceof JMethod) || (methodAnnotation = this.getModelAnnotation((method = (JMethod)node).getComment())) == null || (returnType = method.getReturnType()) == null) continue;
                    if (returnType.endsWith("EDataType")) {
                        EDataType eDataType = EcoreFactory.eINSTANCE.createEDataType();
                        eDataType.setInstanceClassName(this.getModelAnnotationAttribute(methodAnnotation, "instanceClass"));
                        eDataType.setName(method.getName().substring(3));
                        String isSerializable = this.getModelAnnotationAttribute(methodAnnotation, "serializable");
                        if ("false".equals(isSerializable)) {
                            eDataType.setSerializable(false);
                        }
                        eDataTypes.add(eDataType);
                        eDataType.getEAnnotations().addAll(this.extractEAnnotations(methodAnnotation));
                        EcoreUtil.setDocumentation((EModelElement)eDataType, (String)this.getModelDocumentation(method.getComment()));
                        continue;
                    }
                    if (!returnType.endsWith("EClass")) continue;
                    EClass eClass = EcoreFactory.eINSTANCE.createEClass();
                    String instanceClass = this.getModelAnnotationAttribute(methodAnnotation, "instanceClass");
                    if (instanceClass != null) {
                        eClass.setInterface(true);
                        eClass.setAbstract(true);
                        eClass.setInstanceClassName(instanceClass);
                        eClass.setName(method.getName().substring(3));
                        eClasses.add(eClass);
                    } else {
                        eClass.setInstanceClassName("java.util.Map$Entry");
                        eClass.setName(method.getName().substring(3));
                        eClasses.add(eClass);
                        String features = this.getModelAnnotationAttribute(methodAnnotation, "features");
                        if (features != null) {
                            StringTokenizer stringTokenizer = new StringTokenizer(features, " ");
                            while (stringTokenizer.hasMoreTokens()) {
                                String feature = stringTokenizer.nextToken();
                                this.analyzeMethod(eClass, this.getFilteredModelAnnotations(methodAnnotation, feature), "get" + Character.toUpperCase(feature.charAt(0)) + feature.substring(1), "java.lang.Object", EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY);
                            }
                        } else {
                            this.analyzeMethod(eClass, this.getFilteredModelAnnotations(methodAnnotation, "key"), "getKey", "java.lang.Object", EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY);
                            this.analyzeMethod(eClass, this.getFilteredModelAnnotations(methodAnnotation, "value"), "getValue", "java.lang.Object", EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY);
                        }
                    }
                    eClass.getEAnnotations().addAll(this.extractEAnnotations(methodAnnotation));
                    EcoreUtil.setDocumentation((EModelElement)eClass, (String)this.getModelDocumentation(method.getComment()));
                }
                if (isEPackage || !eClasses.isEmpty() || !eDataTypes.isEmpty()) {
                    EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
                    this.ePackageToOrderingMap.put(ePackage, ordering);
                    this.eModelElementToJNodeMap.put((EModelElement)ePackage, (JNode)type);
                    ePackage.setNsURI(nsURI);
                    ePackage.setNsPrefix(nsPrefix);
                    ePackage.setName(name);
                    ePackage.getEClassifiers().addAll(eClasses);
                    ePackage.getEClassifiers().addAll(eDataTypes);
                    if (modelAnnotation != null) {
                        ePackage.getEAnnotations().addAll(this.extractEAnnotations(modelAnnotation));
                    }
                    EcoreUtil.setDocumentation((EModelElement)ePackage, (String)this.getModelDocumentation(type.getComment()));
                    this.ePackageToPrefixMap.put(ePackage, packagePrefix);
                    EPackage existingEPackage = this.packageNameToEPackageMap.get(qualifiedPackageName);
                    if (existingEPackage != null) {
                        ePackage.getEClassifiers().addAll((Collection)existingEPackage.getEClassifiers());
                    }
                    this.packageNameToEPackageMap.put(qualifiedPackageName, ePackage);
                }
            }
        }
    }

    protected void analyzeMethod(EClass eClass, JMethod method) {
        String modelAnnotation = this.getModelAnnotation(method.getComment());
        if (modelAnnotation != null && method.getName() != null) {
            String[] exceptionTypes;
            String[] parameterTypes;
            String[] parameterNames;
            String returnType;
            String methodName = method.getName();
            ETypedElement eTypedElement = this.analyzeMethod(eClass, modelAnnotation, methodName, returnType = method.getReturnType(), parameterNames = method.getParameterNames(), parameterTypes = method.getParameterTypes(), exceptionTypes = method.getExceptions());
            if (eTypedElement != null) {
                EcoreUtil.setDocumentation((EModelElement)eTypedElement, (String)this.getModelDocumentation(method.getComment()));
            }
            this.eModelElementToJNodeMap.put((EModelElement)eTypedElement, (JNode)method);
            if (eTypedElement instanceof EOperation) {
                EOperation eOperation = (EOperation)eTypedElement;
                for (EParameter eParameter : eOperation.getEParameters()) {
                    this.eModelElementToJNodeMap.put((EModelElement)eParameter, (JNode)method);
                }
            }
        }
    }

    protected ETypedElement analyzeMethod(EClass eClass, String modelAnnotation, String methodName, String returnType, String[] parameterNames, String[] parameterTypes, String[] exceptionTypes) {
        boolean declaredEOperation;
        EOperation eTypedElement = null;
        String featureName = methodName;
        String parameters = this.getModelAnnotationAttribute(modelAnnotation, "parameters");
        String kind = this.getModelAnnotationAttribute(modelAnnotation, "kind");
        boolean bl = declaredEOperation = "operation".equals(kind) || parameters != null && !"attribute".equals(kind) && !"reference".equals(kind);
        if (parameterNames.length == 0 && !declaredEOperation && methodName.startsWith("get") && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3)) && !"boolean".equals(returnType) && !"void".equals(returnType)) {
            featureName = CodeGenUtil.uncapName((String)methodName.substring(3));
        } else if (parameterNames.length == 0 && !declaredEOperation && methodName.startsWith("is") && methodName.length() > 2 && Character.isUpperCase(methodName.charAt(2)) && "boolean".equals(returnType)) {
            featureName = CodeGenUtil.uncapName((String)methodName.substring(2));
        } else {
            EOperation eOperation;
            eTypedElement = eOperation = EcoreFactory.eINSTANCE.createEOperation();
            eClass.getEOperations().add((Object)eOperation);
            this.handleETypedElement((ETypedElement)eOperation, methodName, returnType, modelAnnotation, String.valueOf(eClass.getName()) + "." + methodName);
            if (parameterTypes.length > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(parameters == null ? "" : parameters);
                int i = 0;
                while (i < parameterNames.length) {
                    String dataType;
                    EParameter eParameter = EcoreFactory.eINSTANCE.createEParameter();
                    eOperation.getEParameters().add((Object)eParameter);
                    String parameterName = parameterNames[i];
                    String parameterType = parameterTypes[i];
                    String parameterModelAnnotation = this.getFilteredModelAnnotations(modelAnnotation, parameterName);
                    if (stringTokenizer.hasMoreTokens() && !"-".equals(dataType = stringTokenizer.nextToken())) {
                        StringBuilder sb = new StringBuilder(parameterModelAnnotation);
                        sb.append("dataType=\"");
                        sb.append(dataType);
                        sb.append("\" ");
                        parameterModelAnnotation = sb.toString();
                    }
                    StringBuilder identifierName = new StringBuilder(eClass.getName());
                    identifierName.append('.');
                    identifierName.append(methodName);
                    identifierName.append('(');
                    identifierName.append(parameterName);
                    identifierName.append(')');
                    this.handleETypedElement((ETypedElement)eParameter, parameterName, parameterType, parameterModelAnnotation, identifierName.toString());
                    eParameter.getEAnnotations().addAll(this.extractEAnnotations(parameterModelAnnotation));
                    ++i;
                }
            }
            if (exceptionTypes.length > 0) {
                String exceptions = this.getModelAnnotationAttribute(modelAnnotation, "exceptions");
                StringTokenizer stringTokenizer = new StringTokenizer(exceptions == null ? "" : exceptions);
                String[] exceptionTypeNames = new String[exceptionTypes.length];
                int i = 0;
                while (i < exceptionTypes.length) {
                    String dataType;
                    exceptionTypeNames[i] = exceptionTypes[i];
                    if (stringTokenizer.hasMoreTokens() && !"-".equals(dataType = stringTokenizer.nextToken())) {
                        exceptionTypeNames[i] = String.valueOf(dataType) + ":" + exceptionTypeNames[i];
                    }
                    this.eOperationToExceptionTypeNamesMap.put(eOperation, exceptionTypeNames);
                    ++i;
                }
            }
        }
        if (eTypedElement == null) {
            EReference eStructuralFeature = null;
            String opposite = this.getModelAnnotationAttribute(modelAnnotation, "opposite");
            String containment = this.getModelAnnotationAttribute(modelAnnotation, "containment");
            String resolveProxies = this.getModelAnnotationAttribute(modelAnnotation, "resolveProxies");
            String mapType = this.getModelAnnotationAttribute(modelAnnotation, "mapType");
            String keyType = this.getModelAnnotationAttribute(modelAnnotation, "keyType");
            String valueType = this.getModelAnnotationAttribute(modelAnnotation, "valueType");
            if (opposite != null || containment != null || resolveProxies != null || mapType != null || keyType != null && valueType != null) {
                EReference eReference;
                eStructuralFeature = eReference = EcoreFactory.eINSTANCE.createEReference();
                eTypedElement = eStructuralFeature;
                eClass.getEStructuralFeatures().add((Object)eReference);
                eReference.setContainment("true".equals(containment) || mapType != null && !this.separateTypeArgument(returnType)[0].endsWith("Entry") || keyType != null && valueType != null);
                eReference.setResolveProxies(eReference.isContainment() ? "true".equals(resolveProxies) : !"false".equals(resolveProxies));
                eReference.setUnsettable("true".equals(this.getModelAnnotationAttribute(modelAnnotation, "unsettable")));
                if (opposite != null) {
                    this.eReferenceToOppositeNameMap.put(eReference, opposite);
                }
            } else {
                EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
                eStructuralFeature = eAttribute;
                eTypedElement = eStructuralFeature;
                eClass.getEStructuralFeatures().add((Object)eAttribute);
                eAttribute.setUnsettable("true".equals(this.getModelAnnotationAttribute(modelAnnotation, "unsettable")));
                eAttribute.setID("true".equals(this.getModelAnnotationAttribute(modelAnnotation, "id")));
                String defaultValueLiteral = this.getModelAnnotationAttribute(modelAnnotation, "defaultValue");
                if (defaultValueLiteral == null) {
                    defaultValueLiteral = this.getModelAnnotationAttribute(modelAnnotation, "default");
                }
                eStructuralFeature.setDefaultValueLiteral(defaultValueLiteral);
            }
            this.handleETypedElement((ETypedElement)eStructuralFeature, featureName, returnType, modelAnnotation, String.valueOf(eClass.getName()) + "." + methodName);
            eStructuralFeature.setChangeable(!"false".equals(this.getModelAnnotationAttribute(modelAnnotation, "changeable")));
            eStructuralFeature.setDerived("true".equals(this.getModelAnnotationAttribute(modelAnnotation, "derived")));
            eStructuralFeature.setVolatile("true".equals(this.getModelAnnotationAttribute(modelAnnotation, "volatile")));
            eStructuralFeature.setTransient("true".equals(this.getModelAnnotationAttribute(modelAnnotation, "transient")));
            EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)0, (boolean)"true".equals(this.getModelAnnotationAttribute(modelAnnotation, "suppressedGetVisibility")));
            EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)1, (boolean)"true".equals(this.getModelAnnotationAttribute(modelAnnotation, "suppressedSetVisibility")));
            EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)2, (boolean)"true".equals(this.getModelAnnotationAttribute(modelAnnotation, "suppressedIsSetVisibility")));
            EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)3, (boolean)"true".equals(this.getModelAnnotationAttribute(modelAnnotation, "suppressedUnsetVisibility")));
        }
        if (eTypedElement != null) {
            eTypedElement.getEAnnotations().addAll(this.extractEAnnotations(modelAnnotation));
        }
        return eTypedElement;
    }

    protected boolean isListType(String type) {
        return "EList".equals(type) || "org.eclipse.emf.common.util.EList".equals(type) || "List".equals(type) || "java.util.List".equals(type);
    }

    protected void handleETypedElement(ETypedElement eTypedElement, String name, String type, String modelAnnotation, String identifierName) {
        String upperBound;
        eTypedElement.setName(name);
        if ("void".equals(type)) {
            return;
        }
        String mapType = this.getModelAnnotationAttribute(modelAnnotation, "mapType");
        String dataType = this.getModelAnnotationAttribute(modelAnnotation, "dataType");
        String modelType = this.getModelAnnotationAttribute(modelAnnotation, "type");
        String keyType = this.getModelAnnotationAttribute(modelAnnotation, "keyType");
        String valueType = this.getModelAnnotationAttribute(modelAnnotation, "valueType");
        String many = this.getModelAnnotationAttribute(modelAnnotation, "many");
        String[] ret = this.separateTypeArgument(type);
        if (this.isListType(type = ret[0]) && (dataType == null || modelType != null && !this.isListType(modelType))) {
            eTypedElement.setUpperBound(-1);
            if (modelType == null && !"false".equals(many)) {
                this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_TheTypeMustBeSpecifiedFor_message", new Object[]{identifierName}));
                modelType = "java.lang.Object";
            }
        } else if (mapType != null || keyType != null && valueType != null || "FeatureMap".equals(type) || "org.eclipse.emf.common.util.FeatureMap".equals(type)) {
            eTypedElement.setUpperBound(-1);
        }
        if (many != null) {
            eTypedElement.setUpperBound("true".equals(many) ? -1 : 1);
        }
        eTypedElement.setLowerBound("true".equals(this.getModelAnnotationAttribute(modelAnnotation, "required")) ? 1 : 0);
        String lowerBound = this.getModelAnnotationAttribute(modelAnnotation, "lowerBound");
        if (lowerBound == null) {
            lowerBound = this.getModelAnnotationAttribute(modelAnnotation, "lower");
        }
        if (lowerBound != null) {
            try {
                eTypedElement.setLowerBound(Integer.parseInt(lowerBound));
            }
            catch (NumberFormatException numberFormatException) {
                this.warning(JavaImporterPlugin.INSTANCE.getString("_UI_ValueOfPropertyIsBad_message", new Object[]{lowerBound, "lower", identifierName}));
            }
        }
        if ((upperBound = this.getModelAnnotationAttribute(modelAnnotation, "upperBound")) == null) {
            upperBound = this.getModelAnnotationAttribute(modelAnnotation, "upper");
        }
        if (upperBound != null) {
            try {
                eTypedElement.setUpperBound(Integer.parseInt(upperBound));
            }
            catch (NumberFormatException numberFormatException) {
                this.warning(JavaImporterPlugin.INSTANCE.getString("_UI_ValueOfPropertyIsBad_message", new Object[]{upperBound, "upper", identifierName}));
            }
        }
        if (modelType != null) {
            type = modelType;
        }
        if (mapType != null) {
            type = keyType != null && valueType != null ? String.valueOf(mapType) + "@" + keyType + "/" + valueType : mapType;
        } else if (dataType != null) {
            this.eTypedElementToInstanceTypeNameMap.put(eTypedElement, type);
            type = dataType;
        } else if (keyType != null && valueType != null) {
            type = String.valueOf(keyType) + "/" + valueType;
        }
        this.eTypedElementToTypeNameMap.put(eTypedElement, type);
        eTypedElement.setUnique(!"false".equals(this.getModelAnnotationAttribute(modelAnnotation, "unique")));
        eTypedElement.setOrdered(!"false".equals(this.getModelAnnotationAttribute(modelAnnotation, "ordered")));
    }

    protected String[] separateTypeArgument(String type) {
        int gtIndex;
        String typeArgument = null;
        int ltIndex = type.indexOf(60);
        if (ltIndex > 0 && (gtIndex = type.lastIndexOf(62)) > ltIndex + 1) {
            typeArgument = type.substring(ltIndex + 1, gtIndex).trim();
            type = type.substring(0, ltIndex).trim();
        }
        return new String[]{type, typeArgument};
    }

    protected EStructuralFeature createFeature(EClass eClass, String name, EClassifier eType) {
        if (eType instanceof EClass) {
            EReference eReference = EcoreFactory.eINSTANCE.createEReference();
            eReference.setName(name);
            eReference.setEType(eType);
            eClass.getEStructuralFeatures().add((Object)eReference);
            return eReference;
        }
        EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
        eAttribute.setName(name);
        eAttribute.setEType(eType);
        eClass.getEStructuralFeatures().add((Object)eAttribute);
        return eAttribute;
    }

    protected void analyzeEnumLiteral(EEnum eEnum, JMember member) {
        String modelAnnotation = this.getModelAnnotation(member.getComment());
        if (modelAnnotation != null) {
            String fieldName = member.getName();
            EEnumLiteral eEnumLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
            this.eModelElementToJNodeMap.put((EModelElement)eEnumLiteral, (JNode)member);
            eEnumLiteral.getEAnnotations().addAll(this.extractEAnnotations(modelAnnotation));
            EcoreUtil.setDocumentation((EModelElement)eEnumLiteral, (String)this.getModelDocumentation(member.getComment()));
            String value = this.getModelAnnotationAttribute(modelAnnotation, "value");
            if (value == null && member instanceof JField) {
                value = ((JField)member).getInitializer().trim();
            }
            if (value != null) {
                try {
                    int intValue = Integer.parseInt(value);
                    eEnumLiteral.setValue(intValue);
                }
                catch (NumberFormatException numberFormatException) {
                    this.warning(JavaImporterPlugin.INSTANCE.getString("_UI_InvalidLiteralValueForField", new Object[]{value, String.valueOf(eEnum.getName()) + "." + fieldName}));
                    eEnumLiteral.setValue(eEnum.getELiterals().size());
                }
            } else {
                eEnumLiteral.setValue(eEnum.getELiterals().size());
            }
            String name = this.getModelAnnotationAttribute(modelAnnotation, "name");
            if (name == null || !CodeGenUtil.format((String)name, (char)'_', null, (boolean)false, (boolean)true).toUpperCase().equals(fieldName)) {
                if (name != null) {
                    this.warning(JavaImporterPlugin.INSTANCE.getString("_UI_InvalidLiteralNameForField", new Object[]{name, String.valueOf(eEnum.getName()) + "." + fieldName}));
                }
                name = fieldName;
            }
            eEnumLiteral.setName(name);
            String literal = this.getModelAnnotationAttribute(modelAnnotation, "literal");
            if (literal != null) {
                eEnumLiteral.setLiteral(literal);
            }
            eEnum.getELiterals().add((Object)eEnumLiteral);
        }
    }

    protected String getModelDocumentation(String comment) {
        Matcher matcher;
        if (comment != null && (matcher = modelDocExpression.matcher(comment)).find()) {
            return comment.substring(matcher.start(1), matcher.end(1)).replaceAll("[\\n\\r]*\\s*\\*[\\s]?", "\n").replaceAll("\\s*$", "");
        }
        return null;
    }

    protected String getModelAnnotation(String comment) {
        Matcher matcher;
        if (comment != null && (matcher = modelAnnotationExpression.matcher(comment)).find()) {
            return comment.substring(matcher.start(1), matcher.end(1));
        }
        return null;
    }

    protected String getExtendsAnnotation(String comment) {
        if (comment != null) {
            StringBuilder result = new StringBuilder();
            Matcher extendsMatcher = extendsAnnotationExpression.matcher(comment);
            while (extendsMatcher.find()) {
                result.append(comment.substring(extendsMatcher.start(1), extendsMatcher.end(1)));
                result.append(' ');
            }
            Matcher implementsMatcher = implementsAnnotationExpression.matcher(comment);
            while (implementsMatcher.find()) {
                result.append(comment.substring(implementsMatcher.start(1), implementsMatcher.end(1)));
                result.append(' ');
            }
            return result.length() == 0 ? null : result.toString();
        }
        return null;
    }

    protected String getModelAnnotationAttribute(String modelAnnotation, String attributeName) {
        Pattern modelAnnotationAttributeExpressionDoubleQuote = Pattern.compile("\\b" + attributeName + "\\s*=\\s*([\"'])((?>\\\\.|.)*?)\\1", 8);
        Matcher matcher = modelAnnotationAttributeExpressionDoubleQuote.matcher(modelAnnotation);
        if (matcher.find()) {
            return modelAnnotation.substring(matcher.start(2), matcher.end(2));
        }
        return null;
    }

    protected String getModelAnnotationAttributes(String modelAnnotation, String attributeName) {
        StringBuilder result = null;
        Pattern modelAnnotationAttributeExpressionDoubleQuote = Pattern.compile("\\b" + attributeName + "\\s*=\\s*([\"'])((?>\\\\.|.)*?)\\1", 8);
        Matcher matcher = modelAnnotationAttributeExpressionDoubleQuote.matcher(modelAnnotation);
        while (matcher.find()) {
            if (result == null) {
                result = new StringBuilder();
            } else {
                result.append(' ');
            }
            result.append(modelAnnotation.subSequence(matcher.start(2), matcher.end(2)));
        }
        return result == null ? null : result.toString();
    }

    protected List<EAnnotation> extractEAnnotations(String modelAnnotation) {
        String extendedMetaDataAnnotations;
        Matcher detailMatcher;
        EMap details;
        EAnnotation eAnnotation;
        List<EAnnotation> result = Collections.emptyList();
        String annotations = this.getModelAnnotationAttributes(modelAnnotation, "annotation");
        if (annotations != null) {
            Matcher matcher = eAnnotationExpression.matcher(annotations);
            while (matcher.find()) {
                if (result == Collections.EMPTY_LIST) {
                    result = new ArrayList<EAnnotation>();
                }
                eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                result.add(eAnnotation);
                eAnnotation.setSource(JavaEcoreBuilder.parseString(matcher.group(1)));
                details = eAnnotation.getDetails();
                detailMatcher = eAnnotationDetailExpression.matcher(matcher.group(2));
                while (detailMatcher.find()) {
                    details.put((Object)JavaEcoreBuilder.parseString(detailMatcher.group(1)), (Object)JavaEcoreBuilder.parseString(detailMatcher.group(4)));
                }
            }
        }
        if ((extendedMetaDataAnnotations = this.getModelAnnotationAttributes(modelAnnotation, "extendedMetaData")) != null) {
            if (result == Collections.EMPTY_LIST) {
                result = new ArrayList<EAnnotation>();
            }
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            result.add(eAnnotation);
            eAnnotation.setSource("http:///org/eclipse/emf/ecore/util/ExtendedMetaData");
            details = eAnnotation.getDetails();
            detailMatcher = eAnnotationDetailExpression.matcher(" " + extendedMetaDataAnnotations);
            while (detailMatcher.find()) {
                details.put((Object)JavaEcoreBuilder.parseString(detailMatcher.group(1)), (Object)JavaEcoreBuilder.parseString(detailMatcher.group(4)));
            }
        }
        return result;
    }

    private static String parseString(String stringLiteralBody) {
        return CodeGenUtil.parseString((String)stringLiteralBody);
    }

    protected String getFilteredModelAnnotations(String modelAnnotation, String filter) {
        Matcher matcher;
        StringBuilder result = new StringBuilder();
        Pattern modelAnnotationAttributeExpressionDoubleQuote = Pattern.compile("\\b" + filter + "([A-Z]\\w*\\s*=\\s*([\"'])((?>\\\\.|.)*?)\\2)", 8);
        int start = 0;
        int end = modelAnnotation.length();
        while ((matcher = modelAnnotationAttributeExpressionDoubleQuote.matcher(modelAnnotation.subSequence(start, end))).find()) {
            result.append(modelAnnotation.substring(start + matcher.start(1), start + matcher.start(1) + 1).toLowerCase());
            result.append(modelAnnotation.substring(start + matcher.start(1) + 1, start + matcher.end(1)));
            result.append(' ');
            start += matcher.end(0);
        }
        return result.toString();
    }

    protected EClassifier resolve(EModelElement eModelElement, String typeName) {
        return this.resolve(eModelElement, typeName, true);
    }

    protected EClassifier resolve(EModelElement eModelElement, String typeName, boolean recordDemandCreatedEDataType) {
        EPackage ePackage = (EPackage)EcoreUtil.getRootContainer((EObject)eModelElement);
        EClassifier eClassifier = null;
        int indexOfSlash = typeName.indexOf("/");
        if (indexOfSlash != -1) {
            String mapType = null;
            String keyType = typeName.substring(0, indexOfSlash);
            int indexOfAt = keyType.indexOf("@");
            if (indexOfAt != -1) {
                mapType = keyType.substring(0, indexOfAt);
                keyType = keyType.substring(indexOfAt + 1);
            }
            EModelElement container = (EModelElement)eModelElement.eContainer();
            EClassifier keyEClassifier = this.resolve(container, keyType);
            String valueType = typeName.substring(indexOfSlash + 1);
            EClassifier valueEClassifier = this.resolve(container, valueType);
            if (mapType == null) {
                eClassifier = this.resolveMapEntry(ePackage, keyEClassifier, valueEClassifier);
                if (eClassifier == null) {
                    eClassifier = this.resolveMapEntry((EPackage)EcorePackage.eINSTANCE, keyEClassifier, valueEClassifier);
                }
            } else {
                eClassifier = this.resolve(eModelElement, mapType, false);
            }
            if (eClassifier == null) {
                String baseName;
                EClass eClass = EcoreFactory.eINSTANCE.createEClass();
                eClass.setInstanceClassName("java.util.Map$Entry");
                String name = baseName = mapType != null ? mapType : String.valueOf(keyEClassifier.getName()) + "To" + valueEClassifier.getName() + "MapEntry";
                int j = 1;
                while (ePackage.getEClassifier(name) != null) {
                    name = String.valueOf(baseName) + "_" + j;
                    ++j;
                }
                eClass.setName(name);
                this.createFeature(eClass, "key", keyEClassifier);
                this.createFeature(eClass, "value", valueEClassifier);
                ePackage.getEClassifiers().add((Object)eClass);
                eClassifier = eClass;
            }
            return eClassifier;
        }
        String baseName = typeName;
        String packageName = "";
        int index = typeName.lastIndexOf(".");
        if (index == -1) {
            JNode node = this.eModelElementToJNodeMap.get(eModelElement);
            while (node != null) {
                if (node instanceof JCompilationUnit) {
                    boolean firstWildcard = true;
                    for (JImport jImport : facadeHelper.getChildren(node, JImport.class)) {
                        int importIndex;
                        String importName = jImport.getName();
                        if (importName.endsWith("." + baseName)) {
                            importIndex = importName.lastIndexOf(".");
                            packageName = importName.substring(0, importIndex);
                            typeName = String.valueOf(packageName) + "." + baseName;
                            break;
                        }
                        if (!firstWildcard || !importName.endsWith(".*")) continue;
                        importIndex = importName.lastIndexOf(".");
                        packageName = importName.substring(0, importIndex);
                        typeName = String.valueOf(packageName) + "." + baseName;
                        firstWildcard = false;
                    }
                    EPackage otherEPackage = this.packageNameToEPackageMap.get(packageName);
                    if (otherEPackage == null) {
                        otherEPackage = this.externalPackageNameToEPackageMap.get(packageName);
                    }
                    if (otherEPackage == null) break;
                    eClassifier = otherEPackage.getEClassifier(baseName);
                    break;
                }
                node = node.getParent();
            }
            if (eClassifier == null && "".equals(packageName)) {
                eClassifier = ePackage.getEClassifier(typeName);
            }
        } else {
            packageName = typeName.substring(0, index);
            baseName = typeName.substring(index + 1);
            EPackage otherEPackage = this.packageNameToEPackageMap.get(packageName);
            if (otherEPackage == null && (otherEPackage = this.externalPackageNameToEPackageMap.get(packageName)) == null) {
                if ("org.eclipse.emf.ecore".equals(packageName)) {
                    otherEPackage = EcorePackage.eINSTANCE;
                } else if ("org.eclipse.emf.ecore.xml.type".equals(packageName)) {
                    otherEPackage = XMLTypePackage.eINSTANCE;
                } else if ("org.eclipse.emf.ecore.xml.namespace".equals(packageName)) {
                    otherEPackage = XMLNamespacePackage.eINSTANCE;
                }
            }
            if (otherEPackage != null) {
                eClassifier = otherEPackage.getEClassifier(baseName);
            }
        }
        if (eClassifier == null) {
            for (EClassifier ePackageClassifier : ePackage.getEClassifiers()) {
                String name = ePackageClassifier.getInstanceClassName();
                if (name == null || !name.replace('$', '.').equals(typeName.replace('$', '.'))) continue;
                eClassifier = ePackageClassifier;
                break;
            }
        }
        if (EcorePackage.Literals.EOBJECT.getInstanceClassName().equals(typeName)) {
            eClassifier = EcorePackage.Literals.EOBJECT;
        }
        if (eClassifier == null && recordDemandCreatedEDataType && EcorePackage.Literals.EFEATURE_MAP.getInstanceClassName().equals(typeName)) {
            eClassifier = EcorePackage.Literals.EFEATURE_MAP_ENTRY;
        }
        if (eClassifier == null && (packageName.length() == 0 || packageName.equals("java.lang") || packageName.equals("java.math") || packageName.equals("java.util"))) {
            for (EClassifier ecoreEClassifier : EcorePackage.eINSTANCE.getEClassifiers()) {
                String instanceClassName;
                if (!(ecoreEClassifier instanceof EDataType) || !(instanceClassName = ecoreEClassifier.getInstanceClassName()).equals(typeName) && !instanceClassName.equals("java.lang." + typeName)) continue;
                eClassifier = ecoreEClassifier;
                break;
            }
        }
        if (eClassifier == null && !(eModelElement instanceof EReference)) {
            EDataType eDataType = EcoreFactory.eINSTANCE.createEDataType();
            boolean primitive = false;
            if (packageName.length() == 0) {
                String elementTypeName;
                int i = typeName.indexOf(91);
                String string = elementTypeName = i == -1 ? typeName : typeName.substring(0, i);
                if (CodeGenUtil.isJavaPrimitiveType((String)elementTypeName)) {
                    primitive = true;
                } else if (CodeGenUtil.isJavaLangType((String)elementTypeName)) {
                    packageName = "java.lang";
                    typeName = String.valueOf(packageName) + "." + typeName;
                } else {
                    packageName = ePackage.getNsPrefix();
                    typeName = String.valueOf(packageName) + '.' + typeName;
                }
            }
            eDataType.setInstanceClassName(typeName);
            String name = baseName;
            if (primitive && name.length() > 0) {
                name = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
            }
            while (name.endsWith("[]")) {
                name = String.valueOf(name.substring(0, name.length() - 2)) + "Array";
            }
            int j = 1;
            while (ePackage.getEClassifier(name) != null) {
                name = String.valueOf(baseName) + "_" + j;
                ++j;
            }
            eDataType.setName(name);
            if (recordDemandCreatedEDataType) {
                this.demandCreatedEDataTypes.add(eDataType);
                ePackage.getEClassifiers().add((Object)eDataType);
            }
            eClassifier = eDataType;
        }
        return eClassifier;
    }

    protected EClass resolveMapEntry(EPackage ePackage, EClassifier keyEClassifier, EClassifier valueEClassifier) {
        for (EClassifier ePackageClassifier : ePackage.getEClassifiers()) {
            EStructuralFeature valueFeature;
            EClass mapEntryInterface;
            EStructuralFeature keyFeature;
            if (!(ePackageClassifier instanceof EClass) || !"java.util.Map.Entry".equals(ePackageClassifier.getInstanceClassName()) && !"java.util.Map$Entry".equals(ePackageClassifier.getInstanceClassName()) || (keyFeature = (mapEntryInterface = (EClass)ePackageClassifier).getEStructuralFeature("key")) == null || this.resolveType((ETypedElement)keyFeature) != keyEClassifier || keyFeature.isMany() || (valueFeature = mapEntryInterface.getEStructuralFeature("value")) == null || this.resolveType((ETypedElement)valueFeature) != valueEClassifier || valueFeature.isMany()) continue;
            return mapEntryInterface;
        }
        return null;
    }

    protected EClassifier resolveType(ETypedElement eTypedElement) {
        String typeName;
        EClassifier type = eTypedElement.getEType();
        if (type == null && (typeName = this.eTypedElementToTypeNameMap.get(eTypedElement)) != null) {
            type = this.resolve((EModelElement)eTypedElement, typeName);
        }
        return type;
    }

    protected <T extends ENamedElement> void sort(EList<T> namedElements, final Map<Object, Integer> nameToIDMap) {
        TreeSet<T> ordered = new TreeSet<T>(new Comparator<T>(){

            @Override
            public boolean equals(Object object) {
                return object == this;
            }

            @Override
            public int compare(T firstObject, T secondObject) {
                int firstValue = JavaEcoreBuilder.this.getOrderingValue((ENamedElement)firstObject, nameToIDMap);
                int secondValue = JavaEcoreBuilder.this.getOrderingValue((ENamedElement)secondObject, nameToIDMap);
                return firstValue - secondValue;
            }
        });
        ordered.addAll((Collection<T>)namedElements);
        int index = 0;
        for (ENamedElement eNamedElement : ordered) {
            namedElements.move(index++, (Object)eNamedElement);
        }
    }

    protected int getOrderingValue(ENamedElement eNamedElement, Map<Object, Integer> nameToIDMap) {
        Integer result = nameToIDMap.get(eNamedElement);
        if (result == null) {
            if (eNamedElement instanceof EClassifier) {
                String prefix = this.ePackageToPrefixMap.get(eNamedElement.eContainer());
                String name = eNamedElement.getName();
                String id = CodeGenUtil.format((String)name, (char)'_', (String)prefix, (boolean)true, (boolean)true).toUpperCase();
                result = nameToIDMap.get(id);
            } else {
                String prefix = this.ePackageToPrefixMap.get(eNamedElement.eContainer().eContainer());
                String eClassName = ((ENamedElement)eNamedElement.eContainer()).getName();
                String eFeatureName = eNamedElement.getName();
                String id = String.valueOf(CodeGenUtil.format((String)eClassName, (char)'_', (String)prefix, (boolean)true, (boolean)true).toUpperCase()) + "__" + CodeGenUtil.format((String)eFeatureName, (char)'_', (String)prefix, (boolean)true, (boolean)false).toUpperCase();
                result = nameToIDMap.get(id);
            }
            if (result != null) {
                nameToIDMap.put(eNamedElement, result);
            }
        }
        if (result != null) {
            return result;
        }
        return Integer.MAX_VALUE;
    }

    public Diagnostic getDiagnostic() {
        return this.basicDiagnostic;
    }

    public GenModel getGenModel() {
        return this.genModel;
    }

    public Collection<GenPackage> getUsedGenPackages() {
        return this.usedGenPackages;
    }

    protected void error(String message) {
        System.err.println("-->Error: " + message);
        this.basicDiagnostic.add((Diagnostic)new BasicDiagnostic(4, JavaImporterPlugin.getPlugin().getBundle().getSymbolicName(), 0, message, null));
    }

    protected void warning(String message) {
        System.err.println("-->Warning: " + message);
        this.basicDiagnostic.add((Diagnostic)new BasicDiagnostic(2, JavaImporterPlugin.getPlugin().getBundle().getSymbolicName(), 0, message, null));
    }
}

