/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.axis2.creation.core.command;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.axis2.consumption.core.utils.DefaultCodegenUtil;
import org.eclipse.jst.ws.axis2.core.context.ServiceContext;
import org.eclipse.jst.ws.axis2.core.plugin.messages.Axis2CoreUIMessages;
import org.eclipse.jst.ws.axis2.core.utils.Axis2CoreUtils;
import org.eclipse.jst.ws.axis2.core.utils.FacetContainerUtils;
import org.eclipse.jst.ws.axis2.creation.core.data.DataModel;
import org.eclipse.jst.ws.axis2.creation.core.utils.CommonUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.wsrt.IWebService;

public class Axis2DefaultingCommand
extends AbstractDataModelOperation {
    private DataModel model;
    private IWebService ws;
    private int scenario;
    IStatus status;

    public Axis2DefaultingCommand(DataModel model, IWebService ws, int scenario) {
        this.model = model;
        this.ws = ws;
        this.scenario = scenario;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(Axis2CoreUtils.tempRuntimeStatusFileLocation()));
            if (properties.containsKey("status")) {
                this.status = Status.OK_STATUS;
                this.model.setServerStatus(true);
            } else {
                this.status = StatusUtils.errorStatus((String)Axis2CoreUIMessages.ERROR_SERVER_IS_NOT_SET);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.status = StatusUtils.errorStatus((String)(String.valueOf(Axis2CoreUIMessages.ERROR_INVALID_FILE_READ_WRITEL) + Axis2CoreUIMessages.ERROR_SERVER_IS_NOT_SET));
        }
        catch (IOException iOException) {
            this.status = StatusUtils.errorStatus((String)(String.valueOf(Axis2CoreUIMessages.ERROR_INVALID_FILE_READ_WRITEL) + Axis2CoreUIMessages.ERROR_SERVER_IS_NOT_SET));
        }
        if (this.scenario == 1) {
            this.model.setWsdlURI(this.ws.getWebServiceInfo().getWsdlURL());
            this.model.setDatabindingType("ADB");
            DefaultCodegenUtil defaultCodegenUtil = new DefaultCodegenUtil(this.model);
            defaultCodegenUtil.populateModelParamsFromWSDL();
            this.model.setServicesXML(true);
            this.model.setServerXMLCheck(true);
            ServiceContext.getInstance().setServiceName(this.model.getServiceName());
        } else if (this.scenario == 0) {
            this.model.setServiceClass(this.ws.getWebServiceInfo().getImplURL());
            ServiceContext.getInstance().setServiceName(CommonUtils.classNameFromQualifiedName(this.ws.getWebServiceInfo().getImplURL()));
            this.model.setGenerateServicesXML(true);
        }
        String deployedWSDLURL = FacetContainerUtils.getDeployedWSDLURL((String)this.model.getWebProjectName(), (String)ServiceContext.getInstance().getServiceName());
        this.ws.getWebServiceInfo().setWsdlURL(deployedWSDLURL);
        return this.status;
    }

    public DataModel getWebServiceDataModel() {
        return this.model;
    }
}

