/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Iterator;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jpt.core.internal.mappings.DefaultTrueBoolean;
import org.eclipse.jpt.core.internal.mappings.IJoinColumn;
import org.eclipse.jpt.db.internal.Schema;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.AbstractJoinColumnDialog;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JoinColumnDialog
extends AbstractJoinColumnDialog<IJoinColumn> {
    private Combo tableCombo;
    private ComboViewer insertableComboViewer;
    private ComboViewer updatableComboViewer;
    private boolean defaultTableSelected;
    private String selectedTable;
    private DefaultTrueBoolean insertable;
    private DefaultTrueBoolean updatable;

    JoinColumnDialog(Shell parent) {
        super(parent);
    }

    JoinColumnDialog(Shell parent, IJoinColumn joinColumn) {
        super(parent, joinColumn);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        Composite composite = (Composite)super.createDialogArea(parent);
        Label tableLabel = new Label(composite, 16384);
        tableLabel.setText(JptUiMappingsMessages.JoinColumnDialog_table);
        GridData gridData = new GridData();
        tableLabel.setLayoutData((Object)gridData);
        this.tableCombo = new Combo(composite, 16384);
        this.tableCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JoinColumnDialog.this.populateNameCombo();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                JoinColumnDialog.this.populateNameCombo();
            }
        });
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.tableCombo.setLayoutData((Object)gridData);
        this.populateTableCombo();
        Label insertableLabel = new Label(composite, 16384);
        insertableLabel.setText(JptUiMappingsMessages.JoinColumnDialog_insertable);
        insertableLabel.setLayoutData((Object)new GridData());
        this.insertableComboViewer = this.buildInsertableComboViewer(composite);
        this.insertableComboViewer.getCombo().setLayoutData((Object)new GridData(768));
        helpSystem.setHelp((Control)this.insertableComboViewer.getCombo(), "org.eclipse.jpt.ui.mapping_columnInsertable");
        Label updatableLabel = new Label(composite, 16384);
        updatableLabel.setText(JptUiMappingsMessages.JoinColumnDialog_updatable);
        updatableLabel.setLayoutData((Object)new GridData());
        this.updatableComboViewer = this.buildUpdatableComboViewer(composite);
        this.updatableComboViewer.getCombo().setLayoutData((Object)new GridData(768));
        helpSystem.setHelp((Control)this.updatableComboViewer.getCombo(), "org.eclipse.jpt.ui.mapping_columnUpdatable");
        return composite;
    }

    private ComboViewer buildInsertableComboViewer(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(DefaultTrueBoolean.VALUES.toArray());
        DefaultTrueBoolean sel = this.joinColumn() == null ? DefaultTrueBoolean.DEFAULT : this.joinColumn().getInsertable();
        viewer.setSelection((ISelection)new StructuredSelection((Object)sel));
        return viewer;
    }

    private ComboViewer buildUpdatableComboViewer(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(DefaultTrueBoolean.VALUES.toArray());
        DefaultTrueBoolean sel = this.joinColumn() == null ? DefaultTrueBoolean.DEFAULT : this.joinColumn().getUpdatable();
        viewer.setSelection((ISelection)new StructuredSelection((Object)sel));
        return viewer;
    }

    protected void populateTableCombo() {
        this.tableCombo.add(NLS.bind((String)JptUiMappingsMessages.JoinColumnDialog_defaultWithOneParam, (Object)this.defaultTableName()));
        Schema schema = this.getSchema();
        if (schema != null) {
            Iterator tables = schema.tableNames();
            Iterator stream = CollectionTools.sort((Iterator)tables);
            while (stream.hasNext()) {
                this.tableCombo.add((String)stream.next());
            }
        }
        if (this.specifiedTableName() != null) {
            this.tableCombo.setText(this.specifiedTableName());
        } else {
            this.tableCombo.select(0);
        }
    }

    protected abstract String defaultTableName();

    protected String specifiedTableName() {
        if (this.getJoinColumn() != null) {
            return ((IJoinColumn)this.getJoinColumn()).getSpecifiedTable();
        }
        return null;
    }

    protected String tableName() {
        if (this.tableCombo != null) {
            if (this.tableCombo.getSelectionIndex() == 0) {
                return this.defaultTableName();
            }
            return this.tableCombo.getText();
        }
        return this.specifiedTableName() == null ? this.defaultTableName() : this.specifiedTableName();
    }

    protected abstract Schema getSchema();

    private IJoinColumn joinColumn() {
        return (IJoinColumn)this.getJoinColumn();
    }

    protected boolean isDefaultTableSelected() {
        return this.defaultTableSelected;
    }

    public String getSelectedTable() {
        return this.selectedTable;
    }

    public DefaultTrueBoolean getInsertable() {
        return this.insertable;
    }

    public DefaultTrueBoolean getUpdatable() {
        return this.updatable;
    }

    @Override
    public boolean close() {
        this.defaultTableSelected = this.tableCombo.getSelectionIndex() == 0;
        this.selectedTable = this.tableCombo.getText();
        ISelection selection = this.insertableComboViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.insertable = (DefaultTrueBoolean)((IStructuredSelection)selection).getFirstElement();
        }
        if ((selection = this.updatableComboViewer.getSelection()) instanceof IStructuredSelection) {
            this.updatable = (DefaultTrueBoolean)((IStructuredSelection)selection).getFirstElement();
        }
        return super.close();
    }
}

