/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.jpt.core.internal.mappings.DefaultTrueBoolean;
import org.eclipse.jpt.core.internal.mappings.IManyToOne;
import org.eclipse.jpt.core.internal.mappings.ISingleRelationshipMapping;
import org.eclipse.jpt.ui.internal.details.BaseJpaComposite;
import org.eclipse.jpt.ui.internal.mappings.details.CascadeComposite;
import org.eclipse.jpt.ui.internal.mappings.details.CommonWidgets;
import org.eclipse.jpt.ui.internal.mappings.details.EnumComboViewer;
import org.eclipse.jpt.ui.internal.mappings.details.JoinColumnComposite;
import org.eclipse.jpt.ui.internal.mappings.details.OrderByComposite;
import org.eclipse.jpt.ui.internal.mappings.details.TargetEntityChooser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ManyToOneComposite
extends BaseJpaComposite {
    private IManyToOne manyToOne;
    private TargetEntityChooser targetEntityChooser;
    private EnumComboViewer fetchTypeComboViewer;
    private EnumComboViewer optionalComboViewer;
    private OrderByComposite orderByComposite;
    private CascadeComposite cascadeComposite;
    private JoinColumnComposite joinColumnComposite;

    public ManyToOneComposite(Composite parent, CommandStack commandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, 0, commandStack, widgetFactory);
    }

    protected void initializeLayout(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Control generalControl = this.buildGeneralComposite(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        generalControl.setLayoutData((Object)gridData);
    }

    private Control buildGeneralComposite(Composite composite) {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        Composite generalComposite = this.getWidgetFactory().createComposite(composite);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        generalComposite.setLayout((Layout)layout);
        this.targetEntityChooser = CommonWidgets.buildTargetEntityChooser(generalComposite, this.commandStack, this.getWidgetFactory());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.targetEntityChooser.getControl().setLayoutData((Object)gridData);
        helpSystem.setHelp(this.targetEntityChooser.getControl(), "org.eclipse.jpt.ui.mapping_targetEntity");
        CommonWidgets.buildFetchLabel(generalComposite, this.getWidgetFactory());
        this.fetchTypeComboViewer = CommonWidgets.buildFetchTypeComboViewer(generalComposite, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.fetchTypeComboViewer.getControl().setLayoutData((Object)gridData);
        helpSystem.setHelp(this.fetchTypeComboViewer.getControl(), "org.eclipse.jpt.ui.mapping_fetchType");
        CommonWidgets.buildOptionalLabel(generalComposite, this.getWidgetFactory());
        this.optionalComboViewer = CommonWidgets.buildEnumComboViewer(generalComposite, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.optionalComboViewer.getControl().setLayoutData((Object)gridData);
        this.cascadeComposite = new CascadeComposite(generalComposite, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cascadeComposite.getControl().setLayoutData((Object)gridData);
        this.joinColumnComposite = new JoinColumnComposite(generalComposite, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        this.joinColumnComposite.getControl().setLayoutData((Object)gridData);
        return generalComposite;
    }

    public void doPopulate(EObject obj) {
        this.manyToOne = (IManyToOne)obj;
        this.targetEntityChooser.populate((EObject)this.manyToOne);
        this.fetchTypeComboViewer.populate(CommonWidgets.buildSingleRelationshipMappingFetchEnumHolder((ISingleRelationshipMapping)this.manyToOne));
        this.optionalComboViewer.populate(new OptionalHolder(this.manyToOne));
        this.cascadeComposite.populate((EObject)this.manyToOne);
        this.joinColumnComposite.populate((EObject)this.manyToOne);
    }

    public void doPopulate() {
        this.targetEntityChooser.populate();
        this.fetchTypeComboViewer.populate();
        this.optionalComboViewer.populate();
        this.cascadeComposite.populate();
        this.joinColumnComposite.populate();
    }

    protected void engageListeners() {
    }

    protected void disengageListeners() {
    }

    public void dispose() {
        this.targetEntityChooser.dispose();
        this.fetchTypeComboViewer.dispose();
        this.optionalComboViewer.dispose();
        this.cascadeComposite.dispose();
        this.joinColumnComposite.dispose();
        super.dispose();
    }

    private class OptionalHolder
    extends EObjectImpl
    implements EnumComboViewer.EnumHolder {
        private IManyToOne manyToOne;

        OptionalHolder(IManyToOne manyToOne) {
            this.manyToOne = manyToOne;
        }

        public Object get() {
            return this.manyToOne.getOptional();
        }

        public void set(Object enumSetting) {
            this.manyToOne.setOptional((DefaultTrueBoolean)enumSetting);
        }

        public Class featureClass() {
            return IManyToOne.class;
        }

        public int featureId() {
            return 9;
        }

        public EObject wrappedObject() {
            return this.manyToOne;
        }

        public Object[] enumValues() {
            return DefaultTrueBoolean.VALUES.toArray();
        }
    }
}

