/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.jpt.core.internal.mappings.IBasic;
import org.eclipse.jpt.core.internal.mappings.IVersion;
import org.eclipse.jpt.core.internal.mappings.TemporalType;
import org.eclipse.jpt.ui.internal.details.BaseJpaComposite;
import org.eclipse.jpt.ui.internal.mappings.details.ColumnComposite;
import org.eclipse.jpt.ui.internal.mappings.details.CommonWidgets;
import org.eclipse.jpt.ui.internal.mappings.details.EnumComboViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class VersionComposite
extends BaseJpaComposite {
    private IVersion version;
    private ColumnComposite columnComposite;
    private EnumComboViewer temporalTypeViewer;

    public VersionComposite(Composite parent, CommandStack commandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, 0, commandStack, widgetFactory);
    }

    protected void initializeLayout(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Control generalControl = this.buildGeneralComposite(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        generalControl.setLayoutData((Object)gridData);
    }

    private Control buildGeneralComposite(Composite composite) {
        Composite generalComposite = this.getWidgetFactory().createComposite(composite);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        generalComposite.setLayout((Layout)layout);
        this.columnComposite = new ColumnComposite(generalComposite, this.commandStack, this.getWidgetFactory());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.columnComposite.getControl().setLayoutData((Object)gridData);
        CommonWidgets.buildTemporalLabel(generalComposite, this.getWidgetFactory());
        this.temporalTypeViewer = CommonWidgets.buildEnumComboViewer(generalComposite, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.temporalTypeViewer.getControl().setLayoutData((Object)gridData);
        return generalComposite;
    }

    public void doPopulate(EObject obj) {
        this.version = (IVersion)obj;
        if (this.version != null) {
            this.columnComposite.populate((EObject)this.version.getColumn());
        } else {
            this.columnComposite.populate(null);
        }
        this.temporalTypeViewer.populate(new TemporalTypeHolder(this.version));
    }

    public void doPopulate() {
        this.columnComposite.populate();
        this.temporalTypeViewer.populate();
    }

    protected void engageListeners() {
    }

    protected void disengageListeners() {
    }

    public void dispose() {
        this.columnComposite.dispose();
        this.temporalTypeViewer.dispose();
        super.dispose();
    }

    protected IVersion getVersion() {
        return this.version;
    }

    private class TemporalTypeHolder
    extends EObjectImpl
    implements EnumComboViewer.EnumHolder {
        private IVersion version;

        TemporalTypeHolder(IVersion version) {
            this.version = version;
        }

        public Object get() {
            return this.version.getTemporal();
        }

        public void set(Object enumSetting) {
            this.version.setTemporal((TemporalType)enumSetting);
        }

        public Class featureClass() {
            return IBasic.class;
        }

        public int featureId() {
            return 1;
        }

        public EObject wrappedObject() {
            return this.version;
        }

        public Object[] enumValues() {
            return TemporalType.VALUES.toArray();
        }
    }
}

