/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.xml.details;

import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jpt.core.internal.AccessType;
import org.eclipse.jpt.ui.internal.details.BaseJpaController;
import org.eclipse.jpt.ui.internal.widgets.CComboViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class AccessTypeComboViewer
extends BaseJpaController {
    private AccessHolder accessHolder;
    private Adapter accessHolderListener;
    private CComboViewer comboViewer;

    public AccessTypeComboViewer(Composite parent, CommandStack theCommandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, theCommandStack, widgetFactory);
        this.buildAccessHolderListener();
    }

    private void buildAccessHolderListener() {
        this.accessHolderListener = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                AccessTypeComboViewer.this.accessHolderChanged(notification);
            }
        };
    }

    protected void buildWidget(Composite parent) {
        CCombo combo = this.getWidgetFactory().createCCombo(parent);
        this.comboViewer = new CComboViewer(combo);
        this.comboViewer.add(AccessType.VALUES.toArray());
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AccessTypeComboViewer.this.accessTypeSelectionChanged(event.getSelection());
            }
        });
    }

    void accessTypeSelectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            AccessType access = (AccessType)((IStructuredSelection)selection).getFirstElement();
            if (!this.accessHolder.getAccess().equals((Object)access)) {
                this.accessHolder.setAccess(access);
            }
        }
    }

    private void accessHolderChanged(Notification notification) {
        if (notification.getFeatureID(this.accessHolder.featureClass()) == this.accessHolder.featureId()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    AccessTypeComboViewer.this.populate();
                }
            });
        }
    }

    protected void engageListeners() {
        if (this.accessHolder != null && this.accessHolder.wrappedObject() != null) {
            this.accessHolder.wrappedObject().eAdapters().add((Object)this.accessHolderListener);
        }
    }

    protected void disengageListeners() {
        if (this.accessHolder != null && this.accessHolder.wrappedObject() != null) {
            this.accessHolder.wrappedObject().eAdapters().remove((Object)this.accessHolderListener);
        }
    }

    public final void populate(AccessHolder accessHolder) {
        super.populate(accessHolder);
    }

    public void doPopulate(EObject obj) {
        this.accessHolder = (AccessHolder)obj;
        this.populateCombo();
    }

    protected void doPopulate() {
        this.populateCombo();
    }

    private void populateCombo() {
        if (this.accessHolder.wrappedObject() == null) {
            return;
        }
        AccessType access = this.accessHolder.getAccess();
        if (((IStructuredSelection)this.comboViewer.getSelection()).getFirstElement() != access) {
            this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)access));
        }
    }

    public Control getControl() {
        return this.comboViewer.getCombo();
    }

    public static interface AccessHolder
    extends EObject {
        public AccessType getAccess();

        public void setAccess(AccessType var1);

        public Class featureClass();

        public int featureId();

        public EObject wrappedObject();
    }
}

