/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.converter.ModelConverter;
import org.eclipse.emf.converter.util.ConverterUtil;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.importer.ImporterPlugin;
import org.eclipse.emf.importer.util.ImporterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelImporter
extends ModelConverter {
    public static final String GENANNOTATION_SOURCE_PREFIX = "http://www.eclipse.org/emf/2002/GenModel/importer/";
    protected List<String> fileExtensions;
    protected IPath originalGenModelPath;
    protected GenModel originalGenModel;
    protected IPath genModelProjectLocation;
    protected IPath genModelContainerPath;
    protected String genModelFileName;
    protected IPath genModelPath;
    protected List<URI> modelLocationURIs;
    protected String modelLocation;
    protected String modelPluginID;
    protected String modelPluginDirectory;
    protected String projectName;
    protected boolean usePlatformURI = true;
    protected IWorkspaceRoot workspaceRoot;

    public void dispose() {
        this.originalGenModel = null;
        this.workspaceRoot = null;
        super.dispose();
    }

    protected String getConverterGenAnnotationSource() {
        return GENANNOTATION_SOURCE_PREFIX + this.getID();
    }

    public List<String> getFileExtensions() {
        if (this.fileExtensions == null) {
            this.fileExtensions = new ArrayList<String>();
        }
        return this.fileExtensions;
    }

    public boolean usePlatformURI() {
        return this.usePlatformURI;
    }

    public void setUsePlatformURI(boolean usePlatformURI) {
        this.usePlatformURI = usePlatformURI;
    }

    public void defineOriginalGenModelPath(IPath path) throws DiagnosticException {
        if (this.getOriginalGenModelPath() == null) {
            this.originalGenModelPath = path;
            if (this.getOriginalGenModelPath() != null) {
                URI genModelURI = this.createFileURI(this.getOriginalGenModelPath().toString());
                this.loadOriginalGenModel(genModelURI);
            }
        }
    }

    public IPath getOriginalGenModelPath() {
        return this.originalGenModelPath;
    }

    protected List<EPackage> computeEPackagesBeingReloaded() {
        if (this.getOriginalGenModel() != null) {
            ConverterUtil.EPackageList ePackages = new ConverterUtil.EPackageList();
            block0: for (GenPackage genPackage : this.getOriginalGenModel().getGenPackages()) {
                EPackage originalEPackage = genPackage.getEcorePackage();
                String nsURI = originalEPackage.getNsURI();
                if (nsURI == null) continue;
                for (EPackage ePackage : this.getEPackages()) {
                    if (!nsURI.equals(ePackage.getNsURI())) continue;
                    ePackages.add(ePackage);
                    continue block0;
                }
            }
            return ePackages;
        }
        return Collections.emptyList();
    }

    public void setGenModelFileName(String name) {
        this.genModelFileName = name == null || name.trim().length() == 0 ? null : name;
        this.genModelPath = null;
    }

    public String getGenModelFileName() {
        return this.genModelFileName;
    }

    public String computeDefaultGenModelFileName() {
        URI modelURI;
        String name;
        List<URI> modelLocationURIs = this.getModelLocationURIs();
        if (!modelLocationURIs.isEmpty() && (name = URI.decode((String)(modelURI = modelLocationURIs.get(0)).lastSegment())) != null) {
            int index = name.lastIndexOf(46);
            return String.valueOf(index >= 0 ? name.substring(0, index) : name) + ".genmodel";
        }
        return this.genModelFileName;
    }

    public Diagnostic checkGenModelFileName() {
        String message = null;
        String name = this.getGenModelFileName();
        if (name == null || name.trim().length() == 0) {
            message = ImporterPlugin.INSTANCE.getString("_UI_GeneratorModelFileNameCannotBeEmpty_message");
        } else if (!name.endsWith(".genmodel")) {
            message = ImporterPlugin.INSTANCE.getString("_UI_GeneratorModelFileNameMustEndWithGenModel_message");
        }
        if (message == null) {
            return Diagnostic.OK_INSTANCE;
        }
        return new BasicDiagnostic(4, "org.eclipse.emf.converter", 0, message, null);
    }

    public Diagnostic checkEcoreModelFileName(String fileName, String packageName) {
        String message = null;
        if (fileName == null || fileName.equals("")) {
            message = packageName == null ? ImporterPlugin.INSTANCE.getString("_UI_EcoreModelFileNameCannotBeEmpty_message") : ImporterPlugin.INSTANCE.getString("_UI_EcoreModelFileNameForPackageCannotBeEmpty_message", new Object[]{packageName});
        } else if (!fileName.endsWith(".ecore")) {
            String string = message = packageName == null ? ImporterPlugin.INSTANCE.getString("_UI_EcoreModelFileNameMustEndWithEcore_message") : ImporterPlugin.INSTANCE.getString("_UI_EcoreModelFileNameForPackageMustEndWithEcore_message", new Object[]{packageName});
        }
        if (message == null) {
            return Diagnostic.OK_INSTANCE;
        }
        return new BasicDiagnostic(4, "org.eclipse.emf.converter", 0, message, null);
    }

    public void setGenModelProjectLocation(IPath genModelProjectLocation) {
        this.genModelProjectLocation = genModelProjectLocation;
    }

    public IPath getGenModelProjectLocation() {
        return this.genModelProjectLocation;
    }

    public void setGenModelContainerPath(IPath path) {
        this.genModelContainerPath = path;
        this.genModelPath = null;
    }

    public IPath getGenModelContainerPath() {
        return this.genModelContainerPath;
    }

    public IPath computeGenModelContainerPath(IPath projectPath) {
        return projectPath == null ? null : projectPath.append(this.getGenModelDefaultFolderPath());
    }

    protected IPath getGenModelDefaultFolderPath() {
        return new Path("model");
    }

    public IPath getGenModelPath() {
        if (this.genModelPath == null && this.getGenModelFileName() != null && this.getGenModelContainerPath() != null) {
            this.genModelPath = this.getGenModelContainerPath().append(this.getGenModelFileName());
        }
        return this.genModelPath;
    }

    public GenModel getGenModel() {
        if (this.genModel == null) {
            this.genModel = this.getOriginalGenModel() == null ? GenModelFactory.eINSTANCE.createGenModel() : this.getOriginalGenModel().createGenModel();
            this.genModel.setImporterID(this.getID());
        }
        return this.genModel;
    }

    public boolean addGenModelToResource(boolean replace) {
        IPath genModelPath;
        GenModel genModel = this.getGenModel();
        if ((replace || genModel.eResource() == null) && (genModelPath = this.getGenModelPath()) != null) {
            URI genModelURI = this.createFileURI(genModelPath.toString());
            Resource genModelResource = this.createResourceSet().createResource(genModelURI);
            genModelResource.getContents().add((Object)genModel);
            return true;
        }
        return false;
    }

    public ResourceSet getGenModelResourceSet() {
        Resource resource = this.getGenModel().eResource();
        if (resource == null && this.addGenModelToResource(false)) {
            resource = this.getGenModel().eResource();
        }
        if (resource != null) {
            return resource.getResourceSet();
        }
        return null;
    }

    public GenModel getOriginalGenModel() {
        return this.originalGenModel;
    }

    public EPackageImportInfo getEPackageImportInfo(EPackage ePackage) {
        return (EPackageImportInfo)this.getEPackageConvertInfo(ePackage);
    }

    protected ModelConverter.EPackageConvertInfo createEPackageInfo(EPackage ePackage) {
        return new EPackageImportInfo();
    }

    protected GenPackage getGenPackage(EPackage ePackage) {
        if (this.getOriginalGenModel() != null && !this.getOriginalGenModel().getGenPackages().isEmpty()) {
            for (GenPackage referencedGenPackage : this.getOriginalGenModel().getGenPackages()) {
                if (referencedGenPackage.getEcorePackage() == null || !referencedGenPackage.getEcorePackage().getNsURI().equals(ePackage.getNsURI())) continue;
                return referencedGenPackage;
            }
        }
        return null;
    }

    public void setModelLocation(String location) {
        this.modelLocation = location == null || location.trim().length() == 0 ? null : location;
        this.modelLocationURIs = null;
    }

    public String getModelLocation() {
        return this.modelLocation;
    }

    public List<URI> getModelLocationURIs() {
        if (this.getModelLocation() == null) {
            return Collections.emptyList();
        }
        if (this.modelLocationURIs == null) {
            this.modelLocationURIs = new ArrayList<URI>();
            StringTokenizer stringTokenizer = new StringTokenizer(this.getModelLocation());
            while (stringTokenizer.hasMoreTokens()) {
                String uri = stringTokenizer.nextToken();
                this.modelLocationURIs.add(URI.createURI((String)uri));
            }
        }
        return this.modelLocationURIs;
    }

    public URI getFirstModelLocationURI(boolean resolve) {
        List<URI> modelLocationURIs = this.getModelLocationURIs();
        if (!modelLocationURIs.isEmpty()) {
            URI modelLocationURI = modelLocationURIs.get(0);
            return resolve ? CommonPlugin.resolve((URI)modelLocationURI) : modelLocationURI;
        }
        return null;
    }

    public void setModelFile(IFile file) {
        if (file != null) {
            URI modelURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            this.setModelLocation(modelURI.toString());
        } else {
            this.setModelLocation(null);
        }
    }

    protected ResourceSet createExternalGenModelResourceSet() {
        return this.getOriginalGenModel() != null ? this.getOriginalGenModel().eResource().getResourceSet() : super.createExternalGenModelResourceSet();
    }

    protected void loadOriginalGenModel(URI genModelURI) throws DiagnosticException {
        RuntimeException runtimeException = null;
        ResourceSet resourceSet = this.createResourceSet();
        Resource resource = null;
        try {
            resource = resourceSet.getResource(genModelURI, true);
        }
        catch (RuntimeException exception) {
            runtimeException = exception;
            resource = resourceSet.getResource(genModelURI, false);
        }
        if (resource != null && !resource.getContents().isEmpty() && resource.getContents().get(0) instanceof GenModel) {
            this.originalGenModel = (GenModel)resource.getContents().get(0);
            this.setGenModelFileName(this.getOriginalGenModelPath().lastSegment());
            this.setGenModelContainerPath(this.getOriginalGenModelPath().removeLastSegments(1));
            this.genModelPath = this.getOriginalGenModelPath();
            this.getOriginalGenModel().reconcile();
            for (GenPackage referencedGenPackage : this.getOriginalGenModel().getUsedGenPackages()) {
                if (referencedGenPackage.eIsProxy()) continue;
                this.getReferencedGenPackages().add(referencedGenPackage);
            }
            this.handleOriginalGenModel();
            Diagnostic diagnostic = this.getOriginalGenModel().diagnose();
            if (diagnostic.getSeverity() != 0) {
                throw new DiagnosticException(diagnostic);
            }
        } else {
            Diagnostic diagnostic = runtimeException != null ? BasicDiagnostic.toDiagnostic((Throwable)runtimeException) : new BasicDiagnostic(4, "org.eclipse.emf.importer", 0, ImporterPlugin.INSTANCE.getString("_UI_LoadProblem_title"), null);
            throw new DiagnosticException(diagnostic);
        }
    }

    protected void handleOriginalGenModel() throws DiagnosticException {
    }

    public Diagnostic computeEPackages(Monitor monitor) throws Exception {
        this.clearEPackagesCollections();
        Diagnostic diagnostic = this.doComputeEPackages(monitor);
        this.presetEPackagesToGenerate();
        return diagnostic;
    }

    protected void presetEPackagesToGenerate() {
        int size = this.getEPackages().size();
        if (size == 1) {
            this.getEPackageImportInfo((EPackage)this.getEPackages().get(0)).setConvert(true);
        } else if (size > 1) {
            List<EPackage> ePackagesBeingReloaded = this.computeEPackagesBeingReloaded();
            for (EPackage ePackage : ePackagesBeingReloaded) {
                this.getEPackageImportInfo(ePackage).setConvert(true);
            }
        }
    }

    protected Diagnostic doComputeEPackages(Monitor monitor) throws Exception {
        return Diagnostic.OK_INSTANCE;
    }

    public void adjustEPackages(Monitor monitor) {
        AbstractTreeIterator<EPackage> ePackagesIterator = new AbstractTreeIterator<EPackage>((Object)this.getEPackages(), false){
            private static final long serialVersionUID = 1L;

            protected Iterator<EPackage> getChildren(Object object) {
                return object instanceof Collection ? ((Collection)object).iterator() : ((EPackage)object).getESubpackages().iterator();
            }
        };
        while (ePackagesIterator.hasNext()) {
            EPackage ePackage = (EPackage)ePackagesIterator.next();
            this.adjustEPackage(monitor, ePackage);
        }
        this.makeEPackageConvertDataUnique();
    }

    protected void adjustEPackage(Monitor monitor, EPackage ePackage) {
        EPackageImportInfo ePackageInfo = this.getEPackageImportInfo(ePackage);
        String name = ePackage.getName();
        int index = name.lastIndexOf(".");
        if (index != -1) {
            String basePackage = ePackageInfo.getBasePackage();
            String namePackage = name.substring(0, index);
            name = name.substring(index + 1);
            if (basePackage != null && !namePackage.startsWith(basePackage)) {
                namePackage = String.valueOf(basePackage) + "." + namePackage;
            }
            StringBuffer basePackageName = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(namePackage, ".");
            while (stringTokenizer.hasMoreTokens()) {
                String packageName = stringTokenizer.nextToken();
                basePackageName.append(CodeGenUtil.safeName((String)packageName));
                if (!stringTokenizer.hasMoreTokens()) continue;
                basePackageName.append('.');
            }
            ePackageInfo.setBasePackage(basePackageName.toString());
            ePackage.setName(name);
        }
        if (ePackageInfo.getPrefix() == null) {
            ePackageInfo.setPrefix(CodeGenUtil.capName((String)name));
        }
        if (ePackageInfo.getEcoreFileName() == null) {
            String ecoreFileName = null;
            GenPackage genPackage = this.getGenPackage(ePackage);
            if (genPackage != null) {
                String ePackagePath = genPackage.getEcorePackage().eResource().getURI().lastSegment();
                ecoreFileName = URI.decode((String)ePackagePath);
            } else {
                ecoreFileName = ePackage.eResource() == null ? String.valueOf(name) + ".ecore" : ePackage.eResource().getURI().lastSegment();
            }
            ePackageInfo.setEcoreFileName(ecoreFileName);
        }
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        if (this.workspaceRoot == null) {
            this.workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        }
        return this.workspaceRoot;
    }

    public void prepareGenModelAndEPackages(Monitor monitor) {
        ResourceSet resourceSet = this.getGenModelResourceSet();
        resourceSet.getURIConverter().getURIMap().remove(URI.createPlatformResourceURI((String)(String.valueOf(this.getModelProjectName()) + "/"), (boolean)false));
        List ePackages = this.computeEPackagesToConvert();
        for (EPackage ePackage : ePackages) {
            this.addToResource(ePackage, resourceSet);
        }
        List referencedGenPackages = this.computeValidReferencedGenPackages();
        LinkedHashMap<GenPackage, EPackage> genPackageToReferredEPackage = new LinkedHashMap<GenPackage, EPackage>();
        HashMap<String, GenPackage> referredEPackageNSURIToGenPackage = new HashMap<String, GenPackage>();
        for (GenPackage genPackage : referencedGenPackages) {
            EPackage referredEPackage = this.getReferredEPackage(genPackage);
            if (referredEPackage == null) continue;
            genPackageToReferredEPackage.put(genPackage, referredEPackage);
            referredEPackageNSURIToGenPackage.put(referredEPackage.getNsURI(), genPackage);
        }
        for (Map.Entry entry : genPackageToReferredEPackage.entrySet()) {
            EPackage realEPackage;
            GenPackage genPackage = (GenPackage)entry.getKey();
            EPackage referredEPackage = (EPackage)entry.getValue();
            if (referredEPackage == (realEPackage = genPackage.getEcorePackage())) continue;
            EPackage eSuperPackage = realEPackage.getESuperPackage();
            if (eSuperPackage == null) {
                URI ecoreURI = realEPackage.eResource().getURI();
                Resource resource = resourceSet.createResource(ecoreURI);
                resource.getContents().add((Object)referredEPackage);
                continue;
            }
            GenPackage genSuperPackage = (GenPackage)referredEPackageNSURIToGenPackage.get(eSuperPackage.getNsURI());
            if (genSuperPackage == null) continue;
            EPackage referredESuperPackage = this.getReferredEPackage(genSuperPackage);
            referredESuperPackage.getESubpackages().add((Object)referredEPackage);
            referencedGenPackages.remove(genPackage);
        }
        this.getGenModel().initialize((Collection)ePackages);
        this.getGenModel().getUsedGenPackages().addAll((Collection)referencedGenPackages);
        this.traverseGenPackages((List<GenPackage>)this.getGenModel().getGenPackages());
        this.adjustGenModel(monitor);
        this.adjustUsedGenPackages();
        this.getGenModel().reconcile(this.getOriginalGenModel());
    }

    public void addToResource(EPackage ePackage, ResourceSet resourceSet) {
        EPackageImportInfo ePackageInfo;
        String fileName;
        if (ePackage.eResource() == null && (fileName = (ePackageInfo = this.getEPackageImportInfo(ePackage)).getEcoreFileName()) != null) {
            String baseLocation = String.valueOf(this.getGenModelPath().removeLastSegments(1).toString()) + "/";
            String ecoreFileName = String.valueOf(baseLocation) + fileName;
            URI ecoreURI = this.createFileURI(ecoreFileName);
            Resource resource = resourceSet.getResource(ecoreURI, false);
            if (resource == null) {
                resource = resourceSet.createResource(ecoreURI);
            }
            resource.getContents().add((Object)ePackage);
        }
    }

    public void saveGenModelAndEPackages(Monitor monitor) throws Exception {
        List<Resource> resources;
        String readOnlyFiles;
        String projectName = this.getModelProjectName();
        IProject project = this.getWorkspaceRoot().getProject(projectName);
        if (!project.exists()) {
            HashSet<GenModel> referencedGenModels = new HashSet<GenModel>();
            for (GenPackage genPackage : this.getGenModel().getUsedGenPackages()) {
                referencedGenModels.add(genPackage.getGenModel());
            }
            this.createProject(monitor, project, referencedGenModels);
        }
        if ((readOnlyFiles = ConverterUtil.WorkspaceResourceValidator.validate(resources = this.computeResourcesToBeSaved())) != null) {
            throw new Exception(ImporterPlugin.INSTANCE.getString("_UI_ReadOnlyFiles_error", new String[]{readOnlyFiles}));
        }
        for (Resource resource : resources) {
            resource.save(this.getGenModelSaveOptions());
        }
    }

    protected List<Resource> computeResourcesToBeSaved() {
        UniqueEList.FastCompare resources = new UniqueEList.FastCompare();
        Resource genModelResource = this.getGenModel().eResource();
        resources.add(genModelResource);
        for (GenPackage genPackage : this.getGenModel().getGenPackages()) {
            resources.add(genPackage.getEcorePackage().eResource());
        }
        for (GenPackage genPackage : this.getGenModel().getUsedGenPackages()) {
            if (genPackage.eResource() != genModelResource) continue;
            resources.add(genPackage.getEcorePackage().eResource());
        }
        return resources;
    }

    protected void createProject(Monitor monitor, IProject project, Collection<GenModel> referencedGenModels) {
        char firstChar;
        IWorkspaceRoot workspaceRoot = this.getWorkspaceRoot();
        ArrayList<IProject> referencedModelProjects = new ArrayList<IProject>();
        ArrayList<IProject> referencedEditProjects = new ArrayList<IProject>();
        for (GenModel referencedGenModel : referencedGenModels) {
            String modelDirectory = referencedGenModel.getModelDirectory();
            if (modelDirectory == null) continue;
            referencedModelProjects.add(workspaceRoot.getProject(new Path(modelDirectory).segment(0)));
            String editDirectory = referencedGenModel.getEditDirectory();
            if (editDirectory == null || modelDirectory.equals(editDirectory) || "".equals(editDirectory)) continue;
            referencedEditProjects.add(workspaceRoot.getProject(new Path(editDirectory).segment(0)));
        }
        String projectName = project.getName();
        String path = this.getGenModel().getModelDirectory();
        int index = path.indexOf(projectName);
        if (index >= 0) {
            path = path.substring(index);
        }
        if ((firstChar = path.charAt(0)) != '/' && firstChar != '\\') {
            path = "/" + path;
        }
        ArrayList referencedProjects = new ArrayList(referencedModelProjects);
        Generator.createEMFProject((IPath)new Path(path), (IPath)this.getGenModelProjectLocation(), referencedProjects, (Monitor)monitor, (int)(Generator.EMF_MODEL_PROJECT_STYLE | Generator.EMF_EMPTY_PROJECT_STYLE));
    }

    protected void adjustGenModel(Monitor monitor) {
        URI genModelURI;
        String modelName = URI.decode((String)this.getGenModelPath().removeFileExtension().lastSegment());
        int index = modelName.lastIndexOf(46);
        if (index != -1) {
            modelName = modelName.substring(0, index);
        }
        modelName = CodeGenUtil.capName((String)modelName);
        GenModel genModel = this.getGenModel();
        genModel.setModelName(modelName);
        genModel.setModelPluginID(this.getModelPluginID());
        genModel.setModelDirectory(this.getModelPluginDirectory());
        genModel.getUsedGenPackages().addAll((Collection)genModel.computeMissingUsedGenPackages());
        if (this.getOriginalGenModel() == null && (genModelURI = genModel.eResource().getURI()).isPlatformResource()) {
            IFile genModelFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(genModelURI.toPlatformString(true)));
            IProject project = genModelFile.getProject();
            String complianceLevel = CodeGenUtil.EclipseUtil.getJavaComplianceLevel((IProject)project);
            if ("1.5".equals(complianceLevel)) {
                genModel.setComplianceLevel(GenJDKLevel.JDK50_LITERAL);
            } else if ("1.6".equals(complianceLevel)) {
                genModel.setComplianceLevel(GenJDKLevel.JDK60_LITERAL);
            } else if ("1.4".equals(complianceLevel)) {
                genModel.setComplianceLevel(GenJDKLevel.JDK14_LITERAL);
            }
        }
    }

    protected void adjustUsedGenPackages() {
        if (this.getOriginalGenModel() != null && !this.getOriginalGenModel().getUsedGenPackages().isEmpty()) {
            GenModel genModel = this.getGenModel();
            ArrayList usedGenPackages = new ArrayList(genModel.getUsedGenPackages());
            usedGenPackages.removeAll((Collection<?>)this.getOriginalGenModel().getUsedGenPackages());
            if (!usedGenPackages.isEmpty()) {
                HashMap<String, GenPackage> nsURIOriginalUsedGenPackageMap = new HashMap<String, GenPackage>();
                for (GenPackage genPackage : this.getOriginalGenModel().getUsedGenPackages()) {
                    nsURIOriginalUsedGenPackageMap.put(genPackage.getNSURI(), genPackage);
                }
                for (GenPackage genPackage : usedGenPackages) {
                    GenPackage originalUsedGenPackage = (GenPackage)nsURIOriginalUsedGenPackageMap.get(genPackage.getNSURI());
                    if (originalUsedGenPackage == null) continue;
                    genModel.getUsedGenPackages().remove((Object)originalUsedGenPackage);
                }
            }
        }
    }

    protected boolean canConvert(EPackage ePackage) {
        return super.canConvert(ePackage) && this.getEPackageImportInfo(ePackage).getEcoreFileName() != null;
    }

    public void traverseGenPackages(List<GenPackage> genPackages) {
        for (GenPackage genPackage : genPackages) {
            EPackage ePackage = genPackage.getEcorePackage();
            EPackageImportInfo ePackageInfo = this.getEPackageImportInfo(ePackage);
            genPackage.setBasePackage(ePackageInfo.getBasePackage());
            genPackage.setPrefix(ePackageInfo.getPrefix());
            this.adjustGenPackageDuringTraverse(genPackage);
            this.traverseGenPackages((List<GenPackage>)genPackage.getNestedGenPackages());
        }
    }

    protected void adjustGenPackageDuringTraverse(GenPackage genPackage) {
    }

    protected URI makeRelative(URI uri, URI relativeTo) {
        URI platformURI;
        URI result;
        IFile file;
        if ("file".equals(uri.scheme()) && (file = this.getWorkspaceRoot().getFileForLocation((IPath)new Path(uri.toFileString()))) != null && (result = (platformURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true)).deresolve(relativeTo, false, true, false)).isRelative()) {
            return result;
        }
        URI result2 = uri.deresolve(relativeTo, true, true, false);
        if (result2.isRelative()) {
            return result2;
        }
        return uri;
    }

    protected URI makeAbsolute(URI uri, URI relativeTo) {
        if (uri.isRelative()) {
            return uri.resolve(relativeTo);
        }
        return uri;
    }

    public URI createFileURI(String pathName) {
        return this.usePlatformURI() ? URI.createPlatformResourceURI((String)pathName, (boolean)true) : URI.createFileURI((String)pathName);
    }

    public String getModelPluginID() {
        return this.modelPluginID == null ? ImporterUtil.validPluginID(this.getModelProjectName()) : this.modelPluginID;
    }

    public void setModelPluginID(String modelPluginID) {
        this.modelPluginID = modelPluginID;
    }

    public String getModelPluginDirectory() {
        String result;
        if (this.modelPluginDirectory == null && (result = this.getModelProjectName()) != null) {
            if (result.charAt(0) != '/') {
                result = "/" + result;
            }
            return String.valueOf(result) + "/src";
        }
        return this.modelPluginDirectory;
    }

    public void setModelPluginDirectory(String modelPluginDirectory) {
        this.modelPluginDirectory = modelPluginDirectory;
    }

    public void setModelProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getModelProjectName() {
        return this.projectName != null ? this.projectName : this.computeModelProjectName();
    }

    protected String computeModelProjectName() {
        IPath path = this.getGenModelProjectLocation();
        if (path != null) {
            return URI.decode((String)path.lastSegment().toString());
        }
        IPath genModelPath = this.getGenModelPath();
        if (genModelPath != null) {
            return URI.decode((String)genModelPath.segment(0).toString());
        }
        return null;
    }

    protected Map<?, ?> getEcoreSaveOptions() {
        return Collections.emptyMap();
    }

    public static class EPackageImportInfo
    extends ModelConverter.EPackageConvertInfo {
        protected String basePackage;
        protected String prefix;

        public String getBasePackage() {
            return this.basePackage;
        }

        public void setBasePackage(String basePackage) {
            this.basePackage = basePackage;
        }

        public String getEcoreFileName() {
            return this.getConvertData();
        }

        public void setEcoreFileName(String ecoreFileName) {
            this.setConvertData(ecoreFileName);
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }
    }
}

