/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.ui.contribution.base;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.converter.ModelConverter;
import org.eclipse.emf.converter.ui.contribution.base.ModelConverterURIPage;
import org.eclipse.emf.converter.util.ConverterUtil;
import org.eclipse.emf.importer.ImporterPlugin;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.ui.contribution.base.IModelImporterPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ModelImporterDetailPage
extends ModelConverterURIPage
implements IModelImporterPage {
    protected Button loadButton;
    protected Text genModelNameText;
    protected String[] filterExtensions;
    protected boolean showGenModel = this.getModelImporter().getGenModelFileName() == null;
    protected boolean usingInternalSetName = true;

    public ModelImporterDetailPage(ModelImporter modelImporter, String pageName) {
        super((ModelConverter)modelImporter, pageName);
    }

    public ModelImporter getModelImporter() {
        return (ModelImporter)this.getModelConverter();
    }

    public void dispose() {
        if (this.loadButton != null) {
            this.loadButton.removeListener(13, (Listener)this);
            this.loadButton = null;
        }
        if (this.genModelNameText != null) {
            this.genModelNameText.removeListener(24, (Listener)this);
            this.genModelNameText = null;
        }
        super.dispose();
    }

    public boolean showGenModel() {
        return this.showGenModel;
    }

    protected void pageActivated(boolean firstTime, int cause) {
        if (firstTime && this.getModelImporter().getOriginalGenModelPath() != null) {
            this.getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ModelImporterDetailPage.this.handleOriginalModelFile();
                }
            });
        }
    }

    protected void handleOriginalModelFile() {
        this.refreshModel();
    }

    protected void addControl(Composite parent) {
        this.addDetailControl(parent);
        if (this.showGenModel()) {
            this.createGenModelNameControl(parent);
        }
        this.adjustLoadButton();
    }

    protected void addDetailControl(Composite parent) {
    }

    protected String getURITextInitialValue() {
        String uri = this.getModelImporter().getModelLocation();
        return uri != null ? uri : super.getURITextInitialValue();
    }

    protected void addURIControl(Composite parent) {
        this.loadButton = new Button(parent, 8);
        this.loadButton.setText(ImporterPlugin.INSTANCE.getString("_UI_Load_label"));
        this.loadButton.setLayoutData((Object)new GridData(3));
        this.loadButton.addListener(13, (Listener)this);
    }

    protected void createGenModelNameControl(Composite parent) {
        Label genModelNameLabel = new Label(parent, 16384);
        genModelNameLabel.setText(ImporterPlugin.INSTANCE.getString("_UI_GeneratorModelName_label"));
        this.genModelNameText = new Text(parent, 2052);
        this.genModelNameText.setLayoutData((Object)new GridData(768));
        this.genModelNameText.addListener(24, (Listener)this);
    }

    protected void doHandleEvent(Event event) {
        if (event.type == 13 && event.widget == this.loadButton) {
            this.refreshModel();
            this.getContainer().updateButtons();
        } else if (event.type == 24 && event.widget == this.genModelNameText) {
            this.usingInternalSetName = false;
            this.getModelImporter().setGenModelFileName(this.genModelNameText.getText());
            Diagnostic diagnostic = this.getModelImporter().checkGenModelFileName();
            this.handleDiagnostic(diagnostic);
            this.getContainer().updateButtons();
        } else {
            super.doHandleEvent(event);
        }
    }

    protected void uriTextModified(String text) {
        super.uriTextModified(text);
        this.getModelImporter().setModelLocation(null);
        this.getModelImporter().clearEPackagesCollections();
        this.adjustLoadButton();
    }

    protected void adjustLoadButton() {
        if (this.loadButton != null) {
            String text = this.uriText.getText();
            this.loadButton.setEnabled(text != null && text.trim().length() > 0);
        }
    }

    protected String getURITextLabel() {
        return this.supportMultipleURIs() ? ImporterPlugin.INSTANCE.getString("_UI_ModelURIs_label") : ImporterPlugin.INSTANCE.getString("_UI_ModelURI_label");
    }

    protected String getSelectModelLabel() {
        return ImporterPlugin.INSTANCE.getString("_UI_SelectModel_label");
    }

    protected boolean supportMultipleURIs() {
        return true;
    }

    protected String[] getFilterExtensions() {
        if (this.filterExtensions == null) {
            List<String> fileExtensions = this.getModelImporter().getFileExtensions();
            if (fileExtensions.isEmpty()) {
                this.filterExtensions = new String[]{"*.*"};
            } else if (fileExtensions.size() == 1) {
                this.filterExtensions = new String[]{"*." + fileExtensions.get(0)};
            } else {
                StringBuffer allFilterExtensions = new StringBuffer();
                String[] extensions = new String[fileExtensions.size() + 1];
                int i = 1;
                int lenght = extensions.length;
                while (i < lenght) {
                    extensions[i] = "*." + fileExtensions.get(i - 1);
                    allFilterExtensions.append(";").append(extensions[i]);
                    ++i;
                }
                allFilterExtensions.deleteCharAt(0);
                extensions[0] = allFilterExtensions.toString();
                this.filterExtensions = extensions;
            }
        }
        return this.filterExtensions;
    }

    protected boolean isValidWorkspaceResource(IResource resource) {
        String[] filterExtensions;
        if (resource.getType() == 1 && (filterExtensions = this.getFilterExtensions()).length > 0) {
            int i = 0;
            while (i < filterExtensions.length) {
                if (filterExtensions[i].endsWith(".*") || filterExtensions[i].endsWith("." + resource.getFileExtension())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected boolean browseFileSystem() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 0x1000 | (this.supportMultipleURIs() ? 2 : 4));
        fileDialog.setFilterExtensions(this.getFilterExtensions());
        URI modelURI = this.getModelImporter().getFirstModelLocationURI(true);
        if (modelURI != null) {
            fileDialog.setFileName(modelURI.toFileString());
        }
        if (fileDialog.open() != null && fileDialog.getFileNames().length > 0) {
            String[] fileNames = fileDialog.getFileNames();
            StringBuffer text = new StringBuffer();
            int i = 0;
            while (i < fileNames.length) {
                String filePath = String.valueOf(fileDialog.getFilterPath()) + File.separator + fileNames[i];
                text.append(URI.createFileURI((String)filePath).toString());
                text.append(" ");
                ++i;
            }
            this.setURIText(text.toString());
            this.refreshModel();
            return true;
        }
        return false;
    }

    protected boolean browseWorkspace() {
        IFile[] files;
        ViewerFilter extensionFilter = null;
        if (!this.getModelImporter().getFileExtensions().isEmpty()) {
            extensionFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return !(element instanceof IFile) || ModelImporterDetailPage.this.getModelImporter().getFileExtensions().contains(((IFile)element).getFileExtension());
                }
            };
        }
        if ((files = WorkspaceResourceDialog.openFileSelection((Shell)this.getShell(), null, null, (boolean)this.supportMultipleURIs(), null, extensionFilter == null ? null : Collections.singletonList(extensionFilter))).length > 0) {
            StringBuffer text = new StringBuffer();
            int i = 0;
            while (i < files.length) {
                if (this.isValidWorkspaceResource((IResource)files[i])) {
                    text.append(URI.createPlatformResourceURI((String)files[i].getFullPath().toString(), (boolean)true));
                    text.append("  ");
                }
                ++i;
            }
            this.setURIText(text.toString());
            this.refreshModel();
            return true;
        }
        return false;
    }

    protected void refreshModel() {
        WorkspaceModifyOperation initializeOperation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) throws CoreException {
                Diagnostic errorDiagnostic = null;
                ModelImporterDetailPage.this.setErrorMessage(null);
                ModelImporterDetailPage.this.setMessage(null);
                Monitor monitor = BasicMonitor.toMonitor((IProgressMonitor)progressMonitor);
                try {
                    try {
                        ModelImporterDetailPage.this.refreshModel(monitor);
                    }
                    catch (Exception exception) {
                        ImporterPlugin.INSTANCE.log(exception);
                        errorDiagnostic = ConverterUtil.createErrorDiagnostic((Throwable)exception, (boolean)true);
                    }
                }
                finally {
                    monitor.done();
                }
                if (errorDiagnostic != null) {
                    ModelImporterDetailPage.this.handleDiagnostic(errorDiagnostic, errorDiagnostic.getMessage(), ImporterPlugin.INSTANCE.getString("_UI_LoadProblem_title"), ImporterPlugin.INSTANCE.getString("_UI_ProblemsEncounteredProcessing_message"));
                }
            }
        };
        this.getModelImporter().setModelLocation(this.uriText.getText());
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)initializeOperation);
        }
        catch (Exception exception) {
            ImporterPlugin.INSTANCE.log(exception);
        }
        if (this.isPageComplete()) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
            this.uriText.selectAll();
            this.uriText.setFocus();
        }
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && !this.getModelImporter().getEPackages().isEmpty() && !this.getModelImporter().getModelLocationURIs().isEmpty();
    }

    protected void refreshModel(Monitor monitor) throws Exception {
        Diagnostic diagnostic = null;
        try {
            diagnostic = this.getModelImporter().computeEPackages(monitor);
            if (diagnostic.getSeverity() == 0) {
                this.getModelImporter().adjustEPackages(monitor);
            }
        }
        catch (WrappedException wrappedException) {
            if (wrappedException.exception() instanceof FileNotFoundException) {
                this.setMessage(null);
                this.setErrorMessage(ImporterPlugin.INSTANCE.getString("_UI_SpecifyAValidModel_message"));
                return;
            }
            throw wrappedException.exception();
        }
        this.internalSetGenModelFileName(this.getDefaultGenModelFileName());
        Diagnostic nameDiagnostic = this.getModelImporter().checkGenModelFileName();
        if (nameDiagnostic.getSeverity() != 0) {
            diagnostic = diagnostic.getSeverity() == 0 ? nameDiagnostic : ConverterUtil.mergeDiagnostic((Diagnostic)diagnostic, (Diagnostic)nameDiagnostic);
        }
        this.handleDiagnostic(diagnostic);
    }

    protected String getDefaultGenModelFileName() {
        return this.getModelImporter().computeDefaultGenModelFileName();
    }

    protected void internalSetGenModelFileName(String name) {
        if (this.usingInternalSetName && this.showGenModel() && name != null) {
            this.getModelImporter().setGenModelFileName(name);
            this.setHandlingEvent(false);
            this.genModelNameText.setText(this.getModelImporter().getGenModelFileName());
            this.setHandlingEvent(true);
        }
    }
}

