/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.memory;

import java.io.IOException;
import org.apache.coyote.Adapter;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.tomcat.util.buf.ByteChunk;

public class MemoryProtocolHandler
implements ProtocolHandler {
    protected Adapter adapter = null;
    protected static MemoryProtocolHandler protocolHandler = null;

    public void setAttribute(String name, Object value) {
    }

    public Object getAttribute(String name) {
        return null;
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public static MemoryProtocolHandler getProtocolHandler() {
        return protocolHandler;
    }

    public void init() throws Exception {
        protocolHandler = this;
    }

    public void start() throws Exception {
    }

    public void destroy() throws Exception {
        protocolHandler = null;
    }

    public void process(Request request, ByteChunk input, Response response, ByteChunk output) throws Exception {
        ByteChunkInputBuffer inputBuffer = new ByteChunkInputBuffer(input);
        ByteChunkOutputBuffer outputBuffer = new ByteChunkOutputBuffer(output);
        request.setInputBuffer(inputBuffer);
        response.setOutputBuffer(outputBuffer);
        this.adapter.service(request, response);
    }

    protected class ByteChunkInputBuffer
    implements InputBuffer {
        protected ByteChunk input = null;

        public ByteChunkInputBuffer(ByteChunk input) {
            this.input = input;
        }

        public int doRead(ByteChunk chunk, Request request) throws IOException {
            return this.input.substract(chunk);
        }
    }

    protected class ByteChunkOutputBuffer
    implements OutputBuffer {
        protected ByteChunk output = null;

        public ByteChunkOutputBuffer(ByteChunk output) {
            this.output = output;
        }

        public int doWrite(ByteChunk chunk, Response response) throws IOException {
            this.output.append(chunk);
            return chunk.getLength();
        }
    }
}

