/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.index.IResultHistoryIndex;
import org.eclipse.datatools.sqltools.result.internal.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.internal.utils.ILogger;

public class ResultHistoryLuceneIndex
implements IResultHistoryIndex {
    private static ILogger _log = ResultsViewPlugin.getLogger(null);
    private static final String FIELD_OPERATION = "operation";
    private static final String FIELD_ACTION = "action";
    private static final String FIELD_CONSUMER = "consumer";
    private static final String FIELD_FREQ = "frequency";
    private static final String FIELD_IDENTIFIER = "identifier";
    private static int ID = 10000;
    private Map _id2result;
    private Map _result2id;
    private Directory _ramDir = new RAMDirectory();
    private IndexWriter _writer;
    private Analyzer _analyzer = new WhitespaceAnalyzer();
    private List _instances;

    public ResultHistoryLuceneIndex() {
        this._id2result = new HashMap();
        this._result2id = new HashMap();
        this._instances = new ArrayList();
        try {
            this._writer = new IndexWriter(this._ramDir, this._analyzer, true);
            this._writer.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void addResult(IResultInstance instance) {
        this.addResults(new IResultInstance[]{instance});
    }

    private String getCombinedDisplayString(IResultInstance instance) {
        StringBuffer sb = new StringBuffer("");
        sb.append(instance.getOperationCommand().getDisplayString()).append(" ");
        Iterator iter = instance.getSubResults().iterator();
        while (iter.hasNext()) {
            IResultInstance ins = (IResultInstance)iter.next();
            sb.append(this.getCombinedDisplayString(ins));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResults(IResultInstance[] instances) {
        ResultHistoryLuceneIndex resultHistoryLuceneIndex = this;
        synchronized (resultHistoryLuceneIndex) {
            if (instances != null) {
                try {
                    this._writer = new IndexWriter(this._ramDir, this._analyzer, false);
                    for (int i = 0; i < instances.length; ++i) {
                        IResultInstance instance = instances[i];
                        if (this._instances.contains(instance) || instance == null) continue;
                        this._instances.add(instance);
                        Document doc = new Document();
                        doc.add(Field.Text((String)FIELD_OPERATION, (String)this.getCombinedDisplayString(instance)));
                        doc.add(Field.Text((String)FIELD_ACTION, (String)OperationCommand.getActionString(instance.getOperationCommand().getActionType())));
                        doc.add(Field.Text((String)FIELD_CONSUMER, (String)instance.getOperationCommand().getConsumerName()));
                        doc.add(Field.Text((String)FIELD_FREQ, (String)Integer.toString(instance.getFrequency())));
                        doc.add(Field.Keyword((String)FIELD_IDENTIFIER, (String)Integer.toString(ID)));
                        this._id2result.put(Integer.toString(ID), instance);
                        this._result2id.put(instance, Integer.toString(ID));
                        ++ID;
                        try {
                            this._writer.addDocument(doc);
                            continue;
                        }
                        catch (IOException ioe) {
                            _log.error("ResultHistoryLuceneIndex_io_error", (Throwable)ioe);
                        }
                    }
                    this._writer.close();
                }
                catch (IOException ioe) {
                    _log.error("ResultHistoryLuceneIndex_io_error", (Throwable)ioe);
                }
            }
        }
    }

    public void removeResult(IResultInstance instance) {
        this.removeResults(new IResultInstance[]{instance});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResults(IResultInstance[] instances) {
        ResultHistoryLuceneIndex resultHistoryLuceneIndex = this;
        synchronized (resultHistoryLuceneIndex) {
            try {
                IndexReader reader = IndexReader.open((Directory)this._ramDir);
                if (instances != null) {
                    IResultInstance instance = null;
                    for (int i = 0; i < instances.length; ++i) {
                        instance = instances[i];
                        if (instance == null) continue;
                        String id = (String)this._result2id.get(instance);
                        this._result2id.remove(instance);
                        this._id2result.remove(id);
                        if (id == null) continue;
                        try {
                            reader.delete(new Term(FIELD_IDENTIFIER, id));
                            continue;
                        }
                        catch (IOException ioe) {
                            _log.error("ResultHistoryLuceneIndex_io_error", (Throwable)ioe);
                        }
                    }
                    reader.close();
                }
            }
            catch (IOException ioe) {
                _log.error("ResultHistoryLuceneIndex_io_error", (Throwable)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResultInstance[] search(String expression) {
        if (expression == null) {
            return new IResultInstance[0];
        }
        ResultHistoryLuceneIndex resultHistoryLuceneIndex = this;
        synchronized (resultHistoryLuceneIndex) {
            QueryParser parser = new QueryParser(FIELD_OPERATION, this._analyzer);
            try {
                Query query = parser.parse(expression);
                IndexSearcher searcher = new IndexSearcher(this._ramDir);
                Hits hits = searcher.search(query);
                int count = hits.length();
                IResultInstance[] instances = new IResultInstance[count];
                for (int i = 0; i < count; ++i) {
                    Document doc = hits.doc(i);
                    instances[i] = (IResultInstance)this._id2result.get(doc.getField(FIELD_IDENTIFIER).stringValue());
                }
                return instances;
            }
            catch (ParseException pe) {
            }
            catch (IOException ioe) {
                _log.error("ResultHistoryLuceneIndex_io_error", (Throwable)ioe);
            }
            return new IResultInstance[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshResult(IResultInstance instance) {
        IResultInstance iResultInstance = instance;
        synchronized (iResultInstance) {
            this.removeResult(instance);
            this.addResult(instance);
        }
    }
}

