/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.view;

import java.util.ArrayList;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.internal.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.internal.model.ResultItem;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.ExportAllResultSetsAction;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.PrintResultSetAction;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.SaveAllResultSetsAction;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ColumnAlignedResultItem;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultsView;
import org.eclipse.datatools.sqltools.result.internal.ui.view.SingleWindowModeSection;
import org.eclipse.datatools.sqltools.result.internal.ui.viewer.TextResultViewer;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class SingleWindowTextSection
extends SingleWindowModeSection {
    private TextResultViewer _textViewer;

    public SingleWindowTextSection(Composite composite, ResultsView view) {
        super(composite, view);
    }

    public SingleWindowTextSection(Composite composite, IResultInstance instance, ResultsView view) {
        super(composite, instance, view);
    }

    protected void createViewerForResultInstance(IResultInstance instance) {
        this._textViewer.getViewer().getTextWidget().dispose();
        ArrayList<Object> actions = new ArrayList<Object>();
        if (this._resultInstance != null) {
            SaveAllResultSetsAction saveAll = new SaveAllResultSetsAction(this._composite.getShell(), this._resultInstance);
            saveAll.setText(Messages.SaveAllResultSetAction_Title);
            actions.add((Object)saveAll);
            ExportAllResultSetsAction exportAll = new ExportAllResultSetsAction(this._composite.getShell(), this._resultInstance);
            exportAll.setText(Messages.ExportAllResultSetAction_Title);
            actions.add((Object)exportAll);
            actions.add(new Separator());
            PrintResultSetAction printAll = new PrintResultSetAction(this._resultInstance, this._composite);
            printAll.setText(Messages.PrintAllResultSetAction_Title);
            actions.add((Object)printAll);
        }
        this._textViewer = new TextResultViewer(this._composite, 770, actions);
        GridData gd = new GridData(1808);
        this._textViewer.getViewer().getTextWidget().setLayoutData((Object)gd);
        this._textViewer.getViewer().getTextWidget().setEditable(true);
        this._textViewer.getViewer().getTextWidget().setEnabled(true);
        int count = instance.getItemCount();
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < count; ++i) {
            IResultSetObject result;
            ResultItem item = instance.getItem(i);
            if (item.getResultType() == 3 && !(result = (IResultSetObject)item.getResultObject()).isAllResultLoaded()) {
                this._isResultHid = true;
            }
            sb.append(ColumnAlignedResultItem.getResultItemDisplayString(item, this._nullValue, this._showHeadings, this._showRowCountMsg));
        }
        Document document = new Document();
        document.set(sb.toString());
        this._textViewer.getViewer().setDocument((IDocument)document);
        this.onInstanceFinished();
        this._composite.layout(true);
    }

    public void onNewItemAppended(ResultItem item, int index) {
        IResultSetObject result;
        if (this._resultInstance == null || this._displayedItems.contains(item)) {
            return;
        }
        this._displayedItems.add(item);
        StringBuffer sb = new StringBuffer("");
        if (item.getResultType() == 3 && !(result = (IResultSetObject)item.getResultObject()).isAllResultLoaded()) {
            this._isResultHid = true;
        }
        sb.append(this._textViewer.getViewer().getTextWidget().getText()).append(ColumnAlignedResultItem.getResultItemDisplayString(item, this._nullValue, this._showHeadings, this._showRowCountMsg));
        this._textViewer.getViewer().getTextWidget().setVisible(false);
        this._textViewer.getViewer().getTextWidget().setText(sb.toString());
        this._textViewer.getViewer().getTextWidget().invokeAction(17039368);
        this._textViewer.getViewer().getTextWidget().setVisible(true);
        this._textViewer.resetUndoMgr();
    }

    public void createInitialControl(Composite composite) {
        super.createInitialControl(composite);
        this._textViewer = new TextResultViewer(this._composite, 770, null);
        GridData gd = new GridData(1808);
        this._textViewer.getViewer().getTextWidget().setLayoutData((Object)gd);
        this._textViewer.getViewer().setDocument((IDocument)new Document(""));
        this._textViewer.getViewer().getTextWidget().setEditable(false);
        this._textViewer.getViewer().getTextWidget().setEnabled(false);
    }

    public void onInstanceFinished() {
        super.onInstanceFinished();
        if (this._resultInstance.getParameters() == null) {
            return;
        }
    }

    public void onInstanceReseted() {
        this._textViewer.getViewer().getTextWidget().setText("");
    }
}

