/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifierImpl;

public class DBHelper {
    public String calculateTriggerTableName(ProcIdentifier procid) {
        return procid.getTableName();
    }

    public boolean isAdHocProc(ProcIdentifier procid) {
        if ("ADHOC".equals(procid.getProcName()) && "".equals(procid.getOwnerName())) {
            return true;
        }
        return "".equals(procid.getProcName());
    }

    public ProcIdentifier getProcIdentifier(DatabaseIdentifier databaseIdentifier, String dbObjectName, int dbObjectType, String tableName, String ownerName) {
        String tableOwnerName = null;
        if (dbObjectType == 3) {
            tableOwnerName = ownerName;
        }
        return this.getProcIdentifier(databaseIdentifier, dbObjectName, dbObjectType, tableName, ownerName, tableOwnerName);
    }

    public ProcIdentifier getProcIdentifier(DatabaseIdentifier databaseIdentifier, String dbObjectName, int dbObjectType, String tableName, String ownerName, String tableOwnerName) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (ownerName != null) {
            map.put("OWNER", ownerName);
        }
        if (dbObjectName != null) {
            map.put("NAME", dbObjectName);
        }
        if (tableName != null) {
            map.put("TABLENAME", tableName);
        }
        if (tableOwnerName != null) {
            map.put("TABLEOWNERNAME", tableOwnerName);
        }
        return new ProcIdentifierImpl(dbObjectType, databaseIdentifier, map);
    }

    public ProcIdentifier getProcIdentifier(DatabaseIdentifier databaseIdentifier, int dbObjectType, Map map) {
        return new ProcIdentifierImpl(dbObjectType, databaseIdentifier, map);
    }

    public boolean justWarnings(SQLException sqlexception) {
        do {
            if (sqlexception instanceof SQLWarning) continue;
            return false;
        } while ((sqlexception = sqlexception.getNextException()) != null);
        return true;
    }

    public String[] getSysOwnerNames() {
        return new String[0];
    }

    public int getCorrectParamType(int jdbcType) {
        return jdbcType;
    }

    public boolean supportsPlan(int procType) {
        return false;
    }

    public String preprocessSQLScript(String sqlScript) {
        return sqlScript;
    }

    public String[] getSysDatabaseNames(DatabaseIdentifier identifier) {
        if (identifier != null) {
            return new String[]{identifier.getDBname()};
        }
        return null;
    }

    public String switchDatabase(DatabaseIdentifier databaseIdentifier, Connection conn) {
        return null;
    }
}

