/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.util.CompilationUnitSorter;
import org.eclipse.jdt.internal.corext.codemanipulation.SortMembersOperation;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class SortMembersFix
implements IFix {
    private final ICompilationUnit fCompilationUnit;
    private final TextChange fChange;

    public static IFix createCleanUp(CompilationUnit compilationUnit, boolean sortMembers, boolean sortFields) throws CoreException {
        String label;
        CategorizedTextEditGroup group;
        if (!sortMembers && !sortFields) {
            return null;
        }
        ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
        TextEdit edit = CompilationUnitSorter.sort((CompilationUnit)compilationUnit, (Comparator)new SortMembersOperation.DefaultJavaElementComparator(!sortFields), (int)0, (TextEditGroup)(group = new CategorizedTextEditGroup(label = FixMessages.SortMembersFix_Change_description, new GroupCategorySet(new GroupCategory(label, label, label)))), null);
        if (edit == null) {
            return null;
        }
        CompilationUnitChange change = new CompilationUnitChange(label, cu);
        change.setEdit(edit);
        change.addTextEditGroup((TextEditGroup)group);
        return new SortMembersFix((TextChange)change, cu);
    }

    public SortMembersFix(TextChange change, ICompilationUnit compilationUnit) {
        this.fChange = change;
        this.fCompilationUnit = compilationUnit;
    }

    public TextChange createChange() throws CoreException {
        return this.fChange;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public String getDescription() {
        return FixMessages.SortMembersFix_Fix_description;
    }

    public IStatus getStatus() {
        return StatusInfo.OK_STATUS;
    }
}

