/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.ExpressionsFix;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class ExpressionsCleanUp
extends AbstractCleanUp {
    public ExpressionsCleanUp(Map options) {
        super(options);
    }

    public ExpressionsCleanUp() {
    }

    public boolean requireAST(ICompilationUnit unit) throws CoreException {
        boolean usePrentheses = this.isEnabled("cleanup.use_parentheses_in_expressions");
        if (!usePrentheses) {
            return false;
        }
        return this.isEnabled("cleanup.always_use_parentheses_in_expressions") || this.isEnabled("cleanup.never_use_parentheses_in_expressions");
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        boolean usePrentheses = this.isEnabled("cleanup.use_parentheses_in_expressions");
        if (!usePrentheses) {
            return null;
        }
        return ExpressionsFix.createCleanUp(compilationUnit, this.isEnabled("cleanup.always_use_parentheses_in_expressions"), this.isEnabled("cleanup.never_use_parentheses_in_expressions"));
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        return this.createFix(compilationUnit);
    }

    public Map getRequiredOptions() {
        return null;
    }

    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.use_parentheses_in_expressions") && this.isEnabled("cleanup.always_use_parentheses_in_expressions")) {
            result.add(MultiFixMessages.ExpressionsCleanUp_addParanoiac_description);
        }
        if (this.isEnabled("cleanup.use_parentheses_in_expressions") && this.isEnabled("cleanup.never_use_parentheses_in_expressions")) {
            result.add(MultiFixMessages.ExpressionsCleanUp_removeUnnecessary_description);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        if (this.isEnabled("cleanup.use_parentheses_in_expressions") && this.isEnabled("cleanup.always_use_parentheses_in_expressions")) {
            buf.append("boolean b= (((i > 0) && (i < 10)) || (i == 50));\n");
        } else if (this.isEnabled("cleanup.use_parentheses_in_expressions") && this.isEnabled("cleanup.never_use_parentheses_in_expressions")) {
            buf.append("boolean b= i > 0 && i < 10 || i == 50;\n");
        } else {
            buf.append("boolean b= (i > 0 && i < 10 || i == 50);\n");
        }
        return buf.toString();
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        IFix fix;
        if (this.isEnabled("cleanup.use_parentheses_in_expressions") && this.isEnabled("cleanup.always_use_parentheses_in_expressions") && (fix = ExpressionsFix.createAddParanoidalParenthesisFix(compilationUnit, new ASTNode[]{problem.getCoveredNode(compilationUnit)})) != null) {
            return true;
        }
        return this.isEnabled("cleanup.use_parentheses_in_expressions") && this.isEnabled("cleanup.never_use_parentheses_in_expressions") && (fix = ExpressionsFix.createRemoveUnnecessaryParenthesisFix(compilationUnit, new ASTNode[]{problem.getCoveredNode(compilationUnit)})) != null;
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        return -1;
    }
}

