/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IClassLoaderProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IImageDescriptorProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataLocator;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataSourceModelProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IResourceBundleProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IStandardMetaDataSourceInfo;
import org.eclipse.jst.jsf.common.metadata.internal.PluginRelativeStandardMetaDataSourceFileLocator;
import org.eclipse.jst.jsf.common.metadata.internal.StandardMetaDataFileRegistryReader;
import org.eclipse.jst.jsf.common.metadata.internal.StandardMetaDataSourceFileLocator;
import org.eclipse.jst.jsf.common.metadata.internal.StandardModelFactory;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.MetaDataQueryHelper;
import org.osgi.framework.Bundle;

public final class StandardMetaDataFileRegistry {
    private Map mdFilesMap = new HashMap(1);
    private List EMPTY_LIST = new ArrayList(0);
    private static StandardMetaDataFileRegistry reg;

    public static StandardMetaDataFileRegistry getInstance() {
        if (reg == null) {
            reg = new StandardMetaDataFileRegistry();
        }
        return reg;
    }

    private StandardMetaDataFileRegistry() {
        new StandardMetaDataFileRegistryReader(this).readRegistry();
    }

    public synchronized List getStandardMetaDataModelProviders(String uri) {
        List theList = (List)this.mdFilesMap.get(uri);
        return theList != null ? theList : this.EMPTY_LIST;
    }

    public synchronized void addStandardMetaDataFileInfo(String uri, IStandardMetaDataSourceInfo fileInfo) {
        ArrayList<StandardMetaDataFilesProvider> providers = (ArrayList<StandardMetaDataFilesProvider>)this.mdFilesMap.get(uri);
        if (providers == null) {
            providers = new ArrayList<StandardMetaDataFilesProvider>();
            this.mdFilesMap.put(uri, providers);
        }
        providers.add(new StandardMetaDataFilesProvider(fileInfo, uri));
    }

    class StandardMetaDataFilesProvider
    implements IMetaDataSourceModelProvider {
        private IStandardMetaDataSourceInfo info;
        private Object model;
        private IMetaDataLocator locator;
        private StandardMetaDataSourceFileLocator fileLocator = null;

        StandardMetaDataFilesProvider(IStandardMetaDataSourceInfo info, String uri) {
            this.info = info;
        }

        private StandardMetaDataSourceFileLocator getFileLocator() {
            if (this.fileLocator == null) {
                if (this.info.getLocatorClassname() == null) {
                    this.fileLocator = new PluginRelativeStandardMetaDataSourceFileLocator();
                } else {
                    Class klass = JSFCommonPlugin.loadClass(this.info.getLocatorClassname(), this.info.getBundleId());
                    try {
                        this.fileLocator = (StandardMetaDataSourceFileLocator)klass.newInstance();
                    }
                    catch (InstantiationException e) {
                        JSFCommonPlugin.log(4, "InstantiationException: StandardMetaDataFilesProvider.getFileLocator()", e);
                    }
                    catch (IllegalAccessException e) {
                        JSFCommonPlugin.log(4, "IllegalAccessException: StandardMetaDataFilesProvider.getFileLocator()", e);
                    }
                }
                if (this.fileLocator != null) {
                    this.fileLocator.setFileInfo(this.info);
                }
            }
            return this.fileLocator;
        }

        private InputStream getInputStream() throws IOException {
            if (this.getFileLocator() != null) {
                return this.getFileLocator().getInputStream();
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object getSourceModel() {
            if (this.model != null) {
                return this.model;
            }
            InputStream inputStream = null;
            try {
                try {
                    EList contents;
                    inputStream = this.getInputStream();
                    if (inputStream == null || (contents = StandardModelFactory.getInstance().loadStandardFileResource(inputStream, this)) == null || !(contents.get(0) instanceof Model)) return this.model;
                    this.model = contents.get(0);
                    ((Model)this.model).setSourceModelProvider(this);
                    return this.model;
                }
                catch (FileNotFoundException e) {
                    JSFCommonPlugin.log(4, e.getLocalizedMessage());
                    if (inputStream == null) return this.model;
                    try {
                        inputStream.close();
                        return this.model;
                    }
                    catch (IOException e2) {
                        JSFCommonPlugin.log(4, "IOException (2): StandardMetaDataFilesProvider.getSourceModel()", e2);
                    }
                    return this.model;
                }
                catch (IOException e) {
                    JSFCommonPlugin.log(4, "IOException(1): StandardMetaDataFilesProvider.getSourceModel()", e);
                    if (inputStream == null) return this.model;
                    try {
                        inputStream.close();
                        return this.model;
                    }
                    catch (IOException e3) {
                        JSFCommonPlugin.log(4, "IOException (2): StandardMetaDataFilesProvider.getSourceModel()", e3);
                    }
                    return this.model;
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        JSFCommonPlugin.log(4, "IOException (2): StandardMetaDataFilesProvider.getSourceModel()", e);
                    }
                }
            }
        }

        public IMetaDataLocator getLocator() {
            return this.locator;
        }

        public void setLocator(IMetaDataLocator locator) {
            this.locator = locator;
        }

        private ResourceBundle internalGetResourceBundle() {
            if (this.getFileLocator() != null) {
                try {
                    return this.fileLocator.getResourceBundle();
                }
                catch (MissingResourceException missingResourceException) {
                }
                catch (IOException iOException) {}
            }
            return null;
        }

        public Object getAdapter(Class klass) {
            final StandardMetaDataFilesProvider mdp = this;
            if (klass == IImageDescriptorProvider.class) {
                return new IImageDescriptorProvider(){
                    String imageBase;

                    public ImageDescriptor getImageDescriptor(String imagePath) {
                        imagePath = this.appendImageBase(imagePath);
                        String bundleID = mdp.getFileLocator().getFileInfo().getBundleId();
                        URL url = FileLocator.find((Bundle)Platform.getBundle((String)bundleID), (IPath)new Path(imagePath), null);
                        return ImageDescriptor.createFromURL((URL)url);
                    }

                    private String appendImageBase(String imagePath) {
                        return String.valueOf(this.getImageBase()) + imagePath;
                    }

                    private String getImageBase() {
                        if (this.imageBase == null) {
                            Model aModel = (Model)StandardMetaDataFilesProvider.this.getSourceModel();
                            Trait t = MetaDataQueryHelper.getTrait(aModel, "images-base-path");
                            if (t == null) {
                                this.imageBase = "";
                            } else {
                                this.imageBase = TraitValueHelper.getValueAsString(t);
                                if (this.imageBase != null && this.imageBase.length() > 0) {
                                    this.imageBase = String.valueOf(this.imageBase) + "/";
                                }
                            }
                        }
                        return this.imageBase;
                    }
                };
            }
            if (klass == IResourceBundleProvider.class) {
                return new IResourceBundleProvider(){

                    public ResourceBundle getResourceBundle() {
                        return mdp.internalGetResourceBundle();
                    }
                };
            }
            if (klass == IClassLoaderProvider.class) {
                return new IClassLoaderProvider(){

                    public Class loadClass(String className) {
                        String bundleID = mdp.getFileLocator().getFileInfo().getBundleId();
                        try {
                            return Platform.getBundle((String)bundleID).loadClass(className);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            return null;
                        }
                    }
                };
            }
            return null;
        }
    }
}

