/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.query;

import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.MetaDataModel;
import org.eclipse.jst.jsf.common.metadata.internal.MetaDataModelContextImpl;
import org.eclipse.jst.jsf.common.metadata.internal.MetaDataModelManager;
import org.eclipse.jst.jsf.common.metadata.query.IEntityQueryVisitor;
import org.eclipse.jst.jsf.common.metadata.query.IMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.IResultSet;
import org.eclipse.jst.jsf.common.metadata.query.ITraitQueryVisitor;
import org.eclipse.jst.jsf.common.metadata.query.MetaDataException;
import org.eclipse.jst.jsf.common.metadata.query.internal.HierarchicalSearchControl;
import org.eclipse.jst.jsf.common.metadata.query.internal.SimpleEntityQueryVisitorImpl;
import org.eclipse.jst.jsf.common.metadata.query.internal.SimpleTraitQueryVisitorImpl;

public final class MetaDataQueryHelper {
    public static final String TAGLIB_DOMAIN = "TagLibraryDomain";

    private MetaDataQueryHelper() {
    }

    public static IMetaDataModelContext createMetaDataModelContext(IProject project, String domain, String uri) {
        return new MetaDataModelContextImpl(project, domain, uri);
    }

    public static IMetaDataModelContext createTagLibraryDomainMetaDataModelContext(IProject project, String uri) {
        return new MetaDataModelContextImpl(project, TAGLIB_DOMAIN, uri);
    }

    public static Model getModel(IMetaDataModelContext modelContext) {
        MetaDataModel model = MetaDataQueryHelper.getMDModel(modelContext);
        if (model != null && !model.isEmpty()) {
            return (Model)model.getRoot();
        }
        return null;
    }

    public static Entity getEntity(IMetaDataModelContext modelContext, String entityKey) {
        SimpleEntityQueryVisitorImpl visitor = new SimpleEntityQueryVisitorImpl(new HierarchicalSearchControl(1, 2));
        IResultSet rs = MetaDataQueryHelper.getEntities(modelContext, entityKey, (IEntityQueryVisitor)visitor);
        Entity e = null;
        try {
            if (rs.getSize() > 0) {
                e = (Entity)rs.next();
            }
            rs.close();
        }
        catch (MetaDataException metaDataException) {}
        return e;
    }

    public static IResultSet getEntities(IMetaDataModelContext modelContext, String entityKey, IEntityQueryVisitor visitor) {
        Model model = MetaDataQueryHelper.getModel(modelContext);
        return MetaDataQueryHelper.getEntities(model, entityKey, visitor);
    }

    public static Trait getTrait(Entity entity, String traitKey) {
        SimpleTraitQueryVisitorImpl visitor = new SimpleTraitQueryVisitorImpl();
        Trait t = null;
        IResultSet rs = MetaDataQueryHelper.getTraits(entity, traitKey, visitor);
        try {
            if (rs.getSize() > 0) {
                t = (Trait)rs.next();
            }
            rs.close();
        }
        catch (MetaDataException metaDataException) {}
        return t;
    }

    public static IResultSet getTraits(Entity entity, String traitKey, ITraitQueryVisitor traitQueryVisitor) {
        IResultSet rs = traitQueryVisitor.findTraits(entity, traitKey);
        return rs;
    }

    public static Entity getEntity(Entity initialEntityContext, String entityKey) {
        SimpleEntityQueryVisitorImpl visitor = new SimpleEntityQueryVisitorImpl(new HierarchicalSearchControl(1, 2));
        Entity e = null;
        IResultSet rs = MetaDataQueryHelper.getEntities(initialEntityContext, entityKey, (IEntityQueryVisitor)visitor);
        try {
            if (rs.getSize() > 0) {
                e = (Entity)rs.next();
            }
            rs.close();
        }
        catch (MetaDataException metaDataException) {}
        return e;
    }

    public static IResultSet getEntities(Entity initialEntityContext, String entityQuery, IEntityQueryVisitor entityKeyQueryVisitor) {
        return entityKeyQueryVisitor.findEntities(initialEntityContext, entityQuery);
    }

    private static MetaDataModel getMDModel(IMetaDataModelContext modelContext) {
        MetaDataModelManager mgr = null;
        mgr = modelContext.getProject() != null ? MetaDataModelManager.getInstance(modelContext.getProject()) : MetaDataModelManager.getSharedInstance();
        return mgr.getModel(modelContext);
    }

    public static Trait getTrait(IMetaDataModelContext modelContext, String entityKey, String traitKey) {
        Entity entity = MetaDataQueryHelper.getEntity(modelContext, entityKey);
        Trait t = null;
        if (entity != null) {
            t = MetaDataQueryHelper.getTrait(entity, traitKey);
        }
        return t;
    }
}

