/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.preview.adapter.internal.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.preview.adapter.internal.core.PreviewRuntime;
import org.eclipse.wst.server.preview.adapter.internal.core.PreviewServerBehaviour;
import org.eclipse.wst.server.preview.adapter.internal.core.Trace;
import org.osgi.framework.Bundle;

public class PreviewLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    private static final String[] REQUIRED_BUNDLE_IDS = new String[]{"org.eclipse.core.runtime", "org.apache.commons.logging", "javax.servlet", "javax.servlet.jsp", "org.mortbay.jetty", "org.eclipse.wst.server.preview"};
    private static final String[] fgCandidateJavaFiles = new String[]{"javaw", "javaw.exe", "java", "java.exe", "j9w", "j9w.exe", "j9", "j9.exe"};
    private static final String[] fgCandidateJavaLocations = new String[]{"bin" + File.separatorChar, "jre" + File.separatorChar + "bin" + File.separatorChar};
    private static final String MAIN_CLASS = "org.eclipse.wst.server.preview.internal.PreviewStarter";
    static /* synthetic */ Class class$0;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        if (server == null) {
            Trace.trace(Trace.FINEST, "Launch configuration could not find server");
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.preview.adapter.internal.core.PreviewServerBehaviour");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PreviewServerBehaviour previewServer = (PreviewServerBehaviour)((Object)server.loadAdapter((Class)clazz, null));
        int size = REQUIRED_BUNDLE_IDS.length;
        StringBuffer cp = new StringBuffer();
        int i = 0;
        while (i < size) {
            Bundle b = Platform.getBundle((String)REQUIRED_BUNDLE_IDS[i]);
            IPath path = null;
            if (b != null) {
                path = PreviewRuntime.getJarredPluginPath(b);
            }
            if (path == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.preview.adapter", "Could not find required bundle " + REQUIRED_BUNDLE_IDS[i]));
            }
            if (i == 5 && path.append("bin").toFile().exists()) {
                path = path.append("bin");
            }
            if (i > 0) {
                cp.append(File.pathSeparator);
            }
            cp.append(path.toOSString());
            ++i;
        }
        ArrayList<String> cmds = new ArrayList<String>();
        File java = PreviewLaunchConfigurationDelegate.getJavaExecutable();
        if (java == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.preview.adapter", "Could not find JRE executable"));
        }
        cmds.add(java.getAbsolutePath());
        cmds.add("-classpath");
        cmds.add(cp.toString());
        cmds.add(MAIN_CLASS);
        cmds.add(previewServer.getTempDirectory().append("preview.xml").toOSString());
        previewServer.setupLaunch(launch, mode, monitor);
        try {
            IProcess pr;
            String[] cmdLine = new String[cmds.size()];
            cmds.toArray(cmdLine);
            Process p = DebugPlugin.exec((String[])cmdLine, null);
            if (p != null && (pr = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)"Preview!")) != null) {
                launch.addProcess(pr);
            }
            previewServer.setProcess(launch.getProcesses()[0]);
        }
        catch (Exception exception) {
            Trace.trace(Trace.SEVERE, "Problem creating preview process");
        }
    }

    protected static File getJavaExecutable() {
        File javaHome;
        if (Platform.getOS().equals("macosx")) {
            return null;
        }
        try {
            javaHome = new File(System.getProperty("java.home")).getCanonicalFile();
        }
        catch (IOException iOException) {
            return null;
        }
        if (!javaHome.exists()) {
            return null;
        }
        return PreviewLaunchConfigurationDelegate.findJavaExecutable(javaHome);
    }

    protected static File findJavaExecutable(File vmInstallLocation) {
        int i = 0;
        while (i < fgCandidateJavaFiles.length) {
            int j = 0;
            while (j < fgCandidateJavaLocations.length) {
                File javaFile = new File(vmInstallLocation, String.valueOf(fgCandidateJavaLocations[j]) + fgCandidateJavaFiles[i]);
                if (javaFile.isFile()) {
                    return javaFile;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }
}

