/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jst.servlet.ui.internal.navigator.CompressedJavaLibraries;
import org.eclipse.jst.servlet.ui.internal.navigator.ICompressedNode;
import org.eclipse.jst.servlet.ui.internal.plugin.ServletUIPlugin;
import org.eclipse.jst.servlet.ui.internal.plugin.WEBUIMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class CompressedJavaProject
implements ICompressedNode,
IAdaptable {
    private IJavaProject project;
    private CompressedJavaLibraries compressedLibraries;
    private Image image;

    public CompressedJavaProject(StructuredViewer viewer, IJavaProject project) {
        this.project = project;
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.packagefolder_obj.gif");
        }
        return this.image;
    }

    public String getLabel() {
        return this.determineLabel();
    }

    public boolean isFlatteningSourceFolder() {
        return this.getNonExternalSourceFolders().size() == 1;
    }

    private String determineLabel() {
        List nonextSourceFolders = this.getNonExternalSourceFolders();
        IPackageFragmentRoot singleRoot = null;
        if (nonextSourceFolders.size() == 1) {
            singleRoot = (IPackageFragmentRoot)nonextSourceFolders.get(0);
        }
        return NLS.bind((String)WEBUIMessages.Compressed_JavaResources, (Object)(singleRoot != null ? ": " + singleRoot.getElementName() : ""));
    }

    public IJavaProject getProject() {
        return this.project;
    }

    public Object[] getChildren(ITreeContentProvider delegateContentProvider) {
        List nonExternalSourceFolders = this.getNonExternalSourceFolders();
        if (nonExternalSourceFolders.size() == 1) {
            Object[] sourceFolderChildren = delegateContentProvider.getChildren(nonExternalSourceFolders.get(0));
            nonExternalSourceFolders.clear();
            nonExternalSourceFolders.addAll((Collection)Arrays.asList(sourceFolderChildren));
        }
        nonExternalSourceFolders.add(this.getCompressedJavaLibraries());
        return nonExternalSourceFolders.toArray();
    }

    public List getNonExternalSourceFolders() {
        ArrayList nonExternalSourceFolders = null;
        try {
            IPackageFragmentRoot[] sourceFolders = this.project.getPackageFragmentRoots();
            nonExternalSourceFolders = new ArrayList(Arrays.asList(sourceFolders));
            Iterator iter = nonExternalSourceFolders.iterator();
            while (iter.hasNext()) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)iter.next();
                if (!root.isExternal() && !root.isArchive() && root.getKind() != 2) continue;
                iter.remove();
            }
        }
        catch (JavaModelException e) {
            ServletUIPlugin.log((Exception)((Object)e));
        }
        return nonExternalSourceFolders != null ? nonExternalSourceFolders : Collections.EMPTY_LIST;
    }

    public CompressedJavaLibraries getCompressedJavaLibraries() {
        if (this.compressedLibraries == null) {
            this.compressedLibraries = new CompressedJavaLibraries(this);
        }
        return this.compressedLibraries;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IJavaElement getJavaElement() {
        List nonExternalSourceFolders = this.getNonExternalSourceFolders();
        if (nonExternalSourceFolders.size() == 1) {
            return (IJavaElement)nonExternalSourceFolders.get(0);
        }
        return this.getProject();
    }
}

