/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.rte.jdbc;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.core.util.CatalogLoaderOverrideManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCUDTAttributeLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCUDTSuperTypeLoader;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataTypesFactory;
import org.eclipse.datatools.modelbase.sql.datatypes.StructuredUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.impl.StructuredUserDefinedTypeImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class JDBCStructuredUDT
extends StructuredUserDefinedTypeImpl
implements ICatalogObject {
    private static final long serialVersionUID = -8270619856243796282L;
    private Boolean attributesLoaded = Boolean.FALSE;
    private SoftReference paremeterLoaderRef;
    private Boolean superLoaded = Boolean.FALSE;
    private SoftReference superLoaderRef;

    public Database getCatalogDatabase() {
        return this.getSchema().getCatalog().getDatabase();
    }

    public Connection getConnection() {
        Database db = this.getCatalogDatabase();
        if (db instanceof ICatalogObject) {
            return ((ICatalogObject)db).getConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.attributesLoaded;
        synchronized (bl) {
            if (this.attributesLoaded.booleanValue()) {
                this.attributesLoaded = Boolean.FALSE;
                this.getParameterLoader().clearAttributeDefinitions((List)super.getAttributes());
            }
        }
        bl = this.superLoaded;
        synchronized (bl) {
            if (this.superLoaded.booleanValue()) {
                this.superLoaded = Boolean.FALSE;
                this.setSuper(null);
            }
        }
        RefreshManager.getInstance().referesh(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getAttributes() {
        Boolean bl = this.attributesLoaded;
        synchronized (bl) {
            if (!this.attributesLoaded.booleanValue()) {
                this.loadAttributes();
            }
        }
        return super.getAttributes();
    }

    protected JDBCUDTAttributeLoader createParameterLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLDataTypesFactory.eINSTANCE.getSQLDataTypesPackage().getAttributeDefinition().getInstanceClassName());
        if (loader != null) {
            JDBCUDTAttributeLoader parameterLoader = (JDBCUDTAttributeLoader)loader;
            parameterLoader.setCatalogObject(this);
            return parameterLoader;
        }
        return new JDBCUDTAttributeLoader(this);
    }

    protected final JDBCUDTAttributeLoader getParameterLoader() {
        if (this.paremeterLoaderRef == null || this.paremeterLoaderRef.get() == null) {
            this.paremeterLoaderRef = new SoftReference<JDBCUDTAttributeLoader>(this.createParameterLoader());
        }
        return (JDBCUDTAttributeLoader)this.paremeterLoaderRef.get();
    }

    private void loadAttributes() {
        try {
            super.getAttributes().addAll((Collection)this.getParameterLoader().loadAttributeDefinitions());
            this.attributesLoaded = Boolean.TRUE;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructuredUserDefinedType getSuper() {
        Boolean bl = this.superLoaded;
        synchronized (bl) {
            if (!this.superLoaded.booleanValue()) {
                this.loadSuper();
            }
        }
        return super.getSuper();
    }

    protected JDBCUDTSuperTypeLoader createSuperLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLDataTypesFactory.eINSTANCE.getSQLDataTypesPackage().getUserDefinedType().getInstanceClassName());
        if (loader != null) {
            JDBCUDTSuperTypeLoader superTypeLoader = (JDBCUDTSuperTypeLoader)loader;
            superTypeLoader.setCatalogObject(this);
            return superTypeLoader;
        }
        return new JDBCUDTSuperTypeLoader(this);
    }

    protected final JDBCUDTSuperTypeLoader getSuperLoader() {
        if (this.superLoaderRef == null || this.superLoaderRef.get() == null) {
            this.superLoaderRef = new SoftReference<JDBCUDTSuperTypeLoader>(this.createSuperLoader());
        }
        return (JDBCUDTSuperTypeLoader)this.superLoaderRef.get();
    }

    private void loadSuper() {
        try {
            UserDefinedType udt = this.getSuperLoader().loadSuperType();
            if (udt instanceof StructuredUserDefinedType) {
                this.setSuper((StructuredUserDefinedType)udt);
            }
            this.superLoaded = Boolean.TRUE;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 12: {
                this.getAttributes();
                break;
            }
            case 10: {
                this.getSuper();
            }
        }
        return super.eIsSet(eFeature);
    }
}

