/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.transport;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.wst.ws.internal.explorer.platform.util.XMLUtils;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.util.SoapHelper;
import org.eclipse.wst.ws.internal.explorer.transport.IDeserializer;
import org.eclipse.wst.ws.internal.explorer.transport.ISOAPMessage;
import org.eclipse.wst.ws.internal.explorer.transport.ISerializer;
import org.eclipse.wst.ws.internal.explorer.transport.MessageContext;
import org.eclipse.wst.ws.internal.explorer.transport.TransportException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SOAPMessageProcessor
implements ISerializer,
IDeserializer {
    private static final String LITERAL = "literal";
    private static final String DEFAULT_SOAP_ENCODING = "UTF-8";
    private static final String LINE_SEPARATOR = System.getProperties().getProperty("line.separator");

    SOAPMessageProcessor() {
    }

    private String joinEncodingStyles(List list) {
        if (list.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            sb.append(" ").append(iter.next());
        }
        return sb.substring(1).toString();
    }

    private String[] getEncodingInfo(MessageContext context) {
        String[] info = new String[2];
        Iterator iter = context.getBindingOperation().getBindingInput().getExtensibilityElements().iterator();
        while (iter.hasNext()) {
            ExtensibilityElement e = (ExtensibilityElement)iter.next();
            if (!(e instanceof SOAPBody)) continue;
            SOAPBody soapBody = (SOAPBody)e;
            if (LITERAL.equals(soapBody.getUse())) break;
            info[0] = soapBody.getNamespaceURI();
            info[1] = this.joinEncodingStyles(soapBody.getEncodingStyles());
            break;
        }
        if (info[0] == null) {
            info[0] = context.getDefinition().getTargetNamespace();
        }
        return info;
    }

    private Element createRPCWrapper(Document document, MessageContext context, Hashtable namespaceTable) {
        String encodingNamespaceURI = this.getEncodingInfo(context)[0];
        return SoapHelper.createRPCWrapperElement(document, namespaceTable, encodingNamespaceURI, context.getBindingOperation().getOperation().getName(), null);
    }

    void initMessage(ISOAPMessage message) throws TransportException {
        try {
            Document document = XMLUtils.createNewDocument(null);
            Hashtable namespaceTable = new Hashtable();
            SoapHelper.addDefaultSoapEnvelopeNamespaces(namespaceTable);
            message.setEnvelope(SoapHelper.createSoapEnvelopeElement(document, namespaceTable));
            message.setHeader(SoapHelper.createSoapHeaderElement(document));
            Element body = SoapHelper.createSoapBodyElement(document);
            if (!message.getMessageContext().isDocumentStyle()) {
                Element rpcWrapper = this.createRPCWrapper(document, message.getMessageContext(), namespaceTable);
                body.appendChild(rpcWrapper);
            }
            message.setBody(body);
            message.setNamespaceTable(namespaceTable);
        }
        catch (ParserConfigurationException e) {
            throw new TransportException(e);
        }
    }

    private Element getSOAPElement(Element root, String localName, Map namespaceTable) {
        String prefix = (String)namespaceTable.get("http://schemas.xmlsoap.org/soap/envelope/");
        if (prefix == null) {
            return null;
        }
        NodeList list = root.getElementsByTagName(String.valueOf(prefix) + ":" + localName);
        if (list.getLength() == 0) {
            return null;
        }
        return (Element)list.item(0);
    }

    private Element getSOAPElementNS(Element root, String localName) {
        NodeList list = root.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", localName);
        if (list.getLength() == 0) {
            return null;
        }
        return (Element)list.item(0);
    }

    private Vector toElementVector(NodeList nodes) {
        Vector<Node> vector = new Vector<Node>();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof Element) {
                vector.add(node);
            }
            ++i;
        }
        return vector;
    }

    private Element[] toElementArray(NodeList nodes) {
        Vector vector = this.toElementVector(nodes);
        Object[] elements = new Element[vector.size()];
        vector.copyInto(elements);
        return elements;
    }

    private void addEncodingStyle(Element[] elements, String encodingStyle) {
        if (elements == null || encodingStyle == null) {
            return;
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i] != null) {
                elements[i].setAttribute("soapenv:encodingStyle", encodingStyle);
            }
            ++i;
        }
    }

    private String serializeElements(Element[] elements) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < elements.length) {
            String serializedFragment = XMLUtils.serialize(elements[i], true);
            if (serializedFragment == null) {
                elements[i].setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                serializedFragment = XMLUtils.serialize(elements[i], true);
            }
            buffer.append(serializedFragment);
            buffer.append(LINE_SEPARATOR);
            ++i;
        }
        return buffer.toString();
    }

    private boolean isRPCRequest(ISOAPMessage message) {
        return !message.getMessageContext().isDocumentStyle() && !Boolean.TRUE.equals(message.getProperty("prop_read_only"));
    }

    public String serialize(int part, ISOAPMessage message) throws TransportException {
        switch (part) {
            case 0: {
                String xml;
                Element envelope = message.getEnvelope(true);
                if (this.isRPCRequest(message)) {
                    Element body = this.getSOAPElementNS(envelope, "Body");
                    if (body == null) {
                        body = this.getSOAPElement(envelope, "Body", message.getNamespaceTable());
                    }
                    if (body != null) {
                        Element[] bodyContent = this.toElementArray(body.getFirstChild().getChildNodes());
                        this.addEncodingStyle(bodyContent, this.getEncodingInfo(message.getMessageContext())[1]);
                    }
                }
                if ((xml = XMLUtils.serialize(envelope, true)) == null) {
                    xml = new String((byte[])message.getProperty("prop_raw_bytes"));
                }
                return xml;
            }
            case 1: {
                return this.serializeElements(message.getHeaderContent());
            }
            case 2: {
                Element[] bodyContent = message.getBodyContent();
                if (this.isRPCRequest(message)) {
                    this.addEncodingStyle(bodyContent, this.getEncodingInfo(message.getMessageContext())[1]);
                }
                return this.serializeElements(bodyContent);
            }
        }
        return "";
    }

    private void processHeader(Element envelope, ISOAPMessage message) {
        Element header = this.getSOAPElementNS(envelope, "Header");
        if (header == null) {
            return;
        }
        message.setHeader(header);
        message.setHeaderContent(this.toElementArray(header.getChildNodes()));
    }

    private Element[] fixSOAPResponse(NodeList instanceList, MessageContext context) {
        Vector instanceVector = this.toElementVector(instanceList);
        Object[] instanceDocuments = new Element[instanceVector.size()];
        Operation oper = context.getBindingOperation().getOperation();
        Map partsMap = oper.getOutput().getMessage().getParts();
        if (partsMap.size() == 1) {
            Iterator it = partsMap.values().iterator();
            Part part = (Part)it.next();
            String fragName = part.getElementName() != null ? part.getElementName().getLocalPart() : part.getName();
            int i = 0;
            while (i < instanceVector.size()) {
                Element element = (Element)instanceVector.get(i);
                if (!element.getTagName().equals(fragName)) {
                    Document doc = element.getOwnerDocument();
                    NodeList children = element.getChildNodes();
                    NamedNodeMap attributes = element.getAttributes();
                    element = doc.createElement(fragName);
                    int j = 0;
                    while (j < children.getLength()) {
                        if (children.item(j) != null) {
                            element.appendChild(children.item(j));
                            --j;
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < attributes.getLength()) {
                        Node attr = attributes.item(j);
                        if (attr != null && attr instanceof Attr) {
                            Attr attribute = (Attr)attr;
                            element.setAttribute(attribute.getName(), attribute.getValue());
                        }
                        ++j;
                    }
                }
                instanceDocuments[i] = element;
                ++i;
            }
        } else {
            instanceVector.copyInto(instanceDocuments);
        }
        return instanceDocuments;
    }

    private void processBody(Element envelope, ISOAPMessage message) {
        NodeList instanceList;
        Element body = this.getSOAPElementNS(envelope, "Body");
        if (body == null) {
            return;
        }
        message.setBody(body);
        Element fault = this.getSOAPElementNS(body, "Fault");
        if (fault != null) {
            message.setFault(fault);
            return;
        }
        if (message.getMessageContext().isDocumentStyle()) {
            instanceList = body.getChildNodes();
        } else {
            NodeList rpcWrapper = body.getElementsByTagNameNS("*", message.getMessageContext().getBindingOperation().getOperation().getOutput().getMessage().getQName().getLocalPart());
            if (rpcWrapper.getLength() <= 0) {
                rpcWrapper = body.getElementsByTagNameNS("*", "*");
            }
            if (rpcWrapper.getLength() > 0) {
                instanceList = rpcWrapper.item(0).getChildNodes();
            } else {
                return;
            }
        }
        message.setBodyContent(this.fixSOAPResponse(instanceList, message.getMessageContext()));
    }

    void deserialize(int part, byte[] xml, ISOAPMessage message) throws ParserConfigurationException, SAXException, IOException {
        Element root = XMLUtils.byteArrayToElement(xml, true);
        switch (part) {
            case 0: {
                message.setEnvelope(root);
                this.processHeader(root, message);
                this.processBody(root, message);
                break;
            }
            case 1: {
                message.setHeaderContent(this.toElementArray(root.getChildNodes()));
                break;
            }
            case 2: {
                message.setBodyContent(this.toElementArray(root.getChildNodes()));
            }
        }
    }

    private String addRootElement(String xml, Map namespaceTable) {
        StringBuffer sb = new StringBuffer();
        sb.append("<root");
        Iterator iter = namespaceTable.keySet().iterator();
        while (iter.hasNext()) {
            Object uri = iter.next();
            Object prefix = namespaceTable.get(uri);
            sb.append(" ").append("xmlns:").append(prefix).append("=\"").append(uri).append("\"");
        }
        sb.append(">").append(xml).append("</root>");
        return sb.toString();
    }

    public void deserialize(int part, String xml, ISOAPMessage message) throws TransportException {
        if (part != 0) {
            xml = this.addRootElement(xml, message.getNamespaceTable());
        }
        try {
            this.deserialize(part, xml.getBytes(DEFAULT_SOAP_ENCODING), message);
        }
        catch (Exception e) {
            throw new TransportException(e);
        }
    }
}

